/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.persistence.config;

import de.fzi.sissy.persistence.config.DatabaseConfiguration;
import de.fzi.sissy.persistence.config.FileBasedDatabaseConfiguration;
import org.apache.derby.jdbc.EmbeddedDriver;

public class DerbyDatabaseConfiguration
extends DatabaseConfiguration
implements FileBasedDatabaseConfiguration {
    private String derbyDirectoryPath;

    @Override
    public String getDatabaseDriver() {
        return EmbeddedDriver.class.getCanonicalName();
    }

    @Override
    public String getDatabaseEmptyscriptFile() {
        return "/res/sql/empty.dsql";
    }

    @Override
    public String getDatabaseInitscriptFile() {
        return "/res/sql/init.dsql";
    }

    @Override
    public String getDatabaseURL() {
        return "jdbc:derby:directory:" + this.getDirectoryPath() + "/" + this.getDatabaseName() + ";create=true;";
    }

    @Override
    public String toString() {
        String result = super.toString();
        result = String.valueOf(result) + "Derby Directory:    " + this.nullSafeToString(this.getDirectoryPath()) + "\n";
        return result;
    }

    @Override
    public String getDirectoryPath() {
        return this.derbyDirectoryPath.replace('\\', '/');
    }

    @Override
    public void setDirectoryPath(String derbyDirectoryPath) {
        this.derbyDirectoryPath = derbyDirectoryPath;
    }

    @Override
    public String getDatabaseURL(String serverUrl) {
        return this.getDatabaseURL();
    }

    @Override
    public String formatSQLStatement(String sqlstm) {
        int lastIndex = sqlstm.lastIndexOf(";");
        int firstIndex = sqlstm.indexOf(";");
        String result = sqlstm;
        if (lastIndex == firstIndex) {
            result = sqlstm.replaceAll(";", "");
        }
        return result;
    }

    @Override
    public String getErrorMessage() {
        String superMsg = super.getErrorMessage();
        if (!superMsg.equals("")) {
            return superMsg;
        }
        StringBuilder result = new StringBuilder();
        if (this.derbyDirectoryPath == null) {
            result.append("Database path not set\n");
        }
        return result.toString();
    }
}

