/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.persistence.config;

import de.uka.ipd.sdq.workflow.AbstractJobConfiguration;
import de.uka.ipd.sdq.workflow.IJobConfiguration;

public abstract class DatabaseConfiguration
extends AbstractJobConfiguration
implements IJobConfiguration {
    private String databaseServerurl;
    private String databaseName;
    private String databaseUsername;
    private String databasePassword;

    public String getErrorMessage() {
        StringBuilder result = new StringBuilder();
        if (this.isNotSet(this.getDatabaseDriver())) {
            result.append("Database driver not set\n");
        }
        if (this.isNotSet(this.getDatabaseName())) {
            result.append("Database name not set\n");
        }
        if (this.isNotSet(this.getDatabaseUsername())) {
            result.append("Database username not set\n");
        }
        if (this.isNotSet(this.getDatabasePassword())) {
            result.append("Database password not set\n");
        }
        return result.toString();
    }

    private boolean isNotSet(String value) {
        if (value == null) {
            return true;
        }
        return value.length() == 0;
    }

    public void setDefaults() {
        this.databaseServerurl = null;
        this.databaseName = null;
        this.databaseUsername = null;
        this.databasePassword = null;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Database Configuration: \n");
        result.append("DB Name:            " + this.nullSafeToString(this.getDatabaseName()) + "\n");
        result.append("DB Driver:          " + this.nullSafeToString(this.getDatabaseDriver()) + "\n");
        result.append("DB Username:        " + this.nullSafeToString(this.getDatabaseUsername()) + "\n");
        result.append("DB Password:        " + this.nullSafeToString(this.getDatabasePassword()) + "\n");
        result.append("DB URL:             " + this.nullSafeToString(this.getDatabaseURL()) + "\n");
        result.append("DB Emptyscriptfile: " + this.nullSafeToString(this.getDatabaseEmptyscriptFile()) + "\n");
        result.append("DB Initscriptfile:  " + this.nullSafeToString(this.getDatabaseInitscriptFile()) + "\n");
        return result.toString();
    }

    protected String nullSafeToString(String message) {
        if (message == null) {
            return "<not set>";
        }
        return message;
    }

    public String getDatabaseServerurl() {
        return this.databaseServerurl;
    }

    public void setDatabaseServerurl(String databaseServerurl) {
        this.databaseServerurl = databaseServerurl;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseUsername() {
        return this.databaseUsername;
    }

    public void setDatabaseUsername(String databaseUsername) {
        this.databaseUsername = databaseUsername;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public abstract String getDatabaseDriver();

    public abstract String getDatabaseURL();

    public abstract String getDatabaseURL(String var1);

    public abstract String getDatabaseInitscriptFile();

    public abstract String getDatabaseEmptyscriptFile();

    public String formatSQLStatement(String stm) {
        return stm;
    }

    public static enum DatabaseDriver {
        NONE,
        POSTGRESQL,
        DERBY,
        MYSQL,
        SQLITE;

    }
}

