/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.persistence;

import de.fzi.sissy.metamod.Access;
import de.fzi.sissy.metamod.Array;
import de.fzi.sissy.metamod.CatchParameter;
import de.fzi.sissy.metamod.Class;
import de.fzi.sissy.metamod.ClassMetric;
import de.fzi.sissy.metamod.Clone;
import de.fzi.sissy.metamod.CloneInstance;
import de.fzi.sissy.metamod.Comment;
import de.fzi.sissy.metamod.File;
import de.fzi.sissy.metamod.FormalParameter;
import de.fzi.sissy.metamod.Function;
import de.fzi.sissy.metamod.FunctionAccess;
import de.fzi.sissy.metamod.GenericEntity;
import de.fzi.sissy.metamod.InheritanceTypeAccess;
import de.fzi.sissy.metamod.Member;
import de.fzi.sissy.metamod.Metric;
import de.fzi.sissy.metamod.MetricsResult;
import de.fzi.sissy.metamod.ModelAnnotation;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.ModelElementList;
import de.fzi.sissy.metamod.NamedModelElement;
import de.fzi.sissy.metamod.Package;
import de.fzi.sissy.metamod.Position;
import de.fzi.sissy.metamod.Property;
import de.fzi.sissy.metamod.Referenceable;
import de.fzi.sissy.metamod.SourceEntity;
import de.fzi.sissy.metamod.Statement;
import de.fzi.sissy.metamod.StructuralAbstraction;
import de.fzi.sissy.metamod.Type;
import de.fzi.sissy.metamod.TypeAccess;
import de.fzi.sissy.metamod.TypeDecorator;
import de.fzi.sissy.metamod.TypeParameterClass;
import de.fzi.sissy.metamod.Variable;
import de.fzi.sissy.persistence.JDBCError;
import de.fzi.sissy.persistence.SQLExportVisitor;
import de.fzi.sissy.persistence.config.DatabaseConfiguration;
import de.fzi.sissy.utils.Debug;
import de.fzi.sissy.utils.ParsingErrorHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;

public class SQLExportQueryBuilder {
    private Connection jdbcConnection;
    private DatabaseConfiguration databaseConfiguration;
    private PreparedStatement prep_insertAbstraction = null;
    private PreparedStatement prep_insertAbstractionElement = null;
    private PreparedStatement prep_insertAccess = null;
    private PreparedStatement prep_insertAnnotation = null;
    private PreparedStatement prep_insertClassContainments = null;
    private PreparedStatement prep_insertClone = null;
    private PreparedStatement prep_insertCloneInstance = null;
    private PreparedStatement prep_insertCloneInstanceStatement = null;
    private PreparedStatement prep_insertComment = null;
    private PreparedStatement prep_insertFile = null;
    private PreparedStatement prep_insertFriend = null;
    private PreparedStatement prep_insertFunction = null;
    private PreparedStatement prep_insertImport = null;
    private PreparedStatement prep_insertInclude = null;
    private PreparedStatement prep_insertInheritance = null;
    private PreparedStatement prep_insertMember = null;
    private PreparedStatement prep_insertModelElement = null;
    private PreparedStatement prep_insertPackage = null;
    private PreparedStatement prep_insertPackageContainment = null;
    private PreparedStatement prep_insertParsingError = null;
    private PreparedStatement prep_insertSignature = null;
    private PreparedStatement prep_insertSourceEntity = null;
    private PreparedStatement prep_insertType = null;
    private PreparedStatement prep_insertStatement = null;
    private PreparedStatement prep_insertTypeParameter = null;
    private PreparedStatement prep_insertTypeArgument = null;
    private PreparedStatement prep_insertVariable = null;
    private PreparedStatement prep_insertMetrics = null;
    private PreparedStatement prep_insertMetricResults = null;

    public SQLExportQueryBuilder(Connection jdbcConnection, DatabaseConfiguration databaseConfiguration) {
        this.jdbcConnection = jdbcConnection;
        this.databaseConfiguration = databaseConfiguration;
        this.createPrepardStatements();
    }

    private void createPrepardStatements() {
        this.prep_insertAbstraction = this.createPreparedStatement("insert into TAbstractions values (?, ?, ?, ?);");
        this.prep_insertAbstractionElement = this.createPreparedStatement("insert into TAbstractionElements values (?, ?);");
        this.prep_insertAccess = this.createPreparedStatement("insert into TAccesses values (?, ?, ?, ?, ?, ?, ?, ?, ?);");
        this.prep_insertAnnotation = this.createPreparedStatement("insert into TAnnotations values (?, ?);");
        this.prep_insertClassContainments = this.createPreparedStatement("insert into TClassContainmentRelations values (?, ?, ?);");
        this.prep_insertClone = this.createPreparedStatement("insert into TClones values (?, ?, ?);");
        this.prep_insertCloneInstance = this.createPreparedStatement("insert into TCloneInstances values (?, ?, ?);");
        this.prep_insertCloneInstanceStatement = this.createPreparedStatement("insert into TCloneInstanceStatements values (?, ?);");
        this.prep_insertComment = this.createPreparedStatement("insert into TComments values (?, ?, ?, ?, ?);");
        this.prep_insertFile = this.createPreparedStatement("insert into TFiles values (?, ?, ?, ?);");
        this.prep_insertFriend = this.createPreparedStatement("insert into TFriends values (?, ?, ?);");
        this.prep_insertFunction = this.createPreparedStatement("insert into TFunctions values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);");
        this.prep_insertImport = this.createPreparedStatement("insert into TImports values (?, ?, ?, ?, ?);");
        this.prep_insertInclude = this.createPreparedStatement("insert into TIncludes values (?, ?, ?);");
        this.prep_insertInheritance = this.createPreparedStatement("insert into TInheritances values (?, ?, ?);");
        this.prep_insertMember = this.createPreparedStatement("insert into TMembers values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);");
        this.prep_insertModelElement = this.createPreparedStatement("insert into TModelElements values (?, ?, ?, ?, ?, ?);");
        this.prep_insertParsingError = this.createPreparedStatement("insert into TErrors values (?, ?, ?, ?, ?);");
        this.prep_insertPackage = this.createPreparedStatement("insert into TPackages values (?, ?, ?, ?, ?, ?);");
        this.prep_insertPackageContainment = this.createPreparedStatement("insert into TPackageContainmentRelations values (?, ?, ?);");
        this.prep_insertSignature = this.createPreparedStatement("insert into TSignatures values (?, ?);");
        this.prep_insertSourceEntity = this.createPreparedStatement("insert into TSourceEntities values (?, ?, ?, ?, ?, ?, ?);");
        this.prep_insertStatement = this.createPreparedStatement("insert into TStatements values (?, ?, ?, ?, ?);");
        this.prep_insertType = this.createPreparedStatement("insert into TTypes values (?, ?, ?, ?, ?, ?, ?, ?, ?);");
        this.prep_insertTypeArgument = this.createPreparedStatement("insert into TTypeArguments values (?, ?, ?);");
        this.prep_insertTypeParameter = this.createPreparedStatement("insert into TTypeParameters values (?, ?, ?, ?);");
        this.prep_insertVariable = this.createPreparedStatement("insert into TVariables values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);");
        this.prep_insertMetrics = this.createPreparedStatement("insert into TMetrics values (?, ?, ?, ?);");
        this.prep_insertMetricResults = this.createPreparedStatement("insert into TMetricResults(MetricId, ModelElementId, Value) values (?, ?, ?);");
    }

    private PreparedStatement createPreparedStatement(String sql) {
        try {
            return this.jdbcConnection.prepareStatement(this.databaseConfiguration.formatSQLStatement(sql));
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
            throw new JDBCError(e);
        }
    }

    public void executeBatches() {
        try {
            this.prep_insertModelElement.executeBatch();
            this.prep_insertModelElement.clearBatch();
            this.prep_insertAbstraction.executeBatch();
            this.prep_insertAbstraction.clearBatch();
            this.prep_insertAbstractionElement.executeBatch();
            this.prep_insertAbstractionElement.clearBatch();
            this.prep_insertAccess.executeBatch();
            this.prep_insertAccess.clearBatch();
            this.prep_insertAnnotation.executeBatch();
            this.prep_insertAnnotation.clearBatch();
            this.prep_insertComment.executeBatch();
            this.prep_insertComment.clearBatch();
            this.prep_insertFile.executeBatch();
            this.prep_insertFile.clearBatch();
            this.prep_insertImport.executeBatch();
            this.prep_insertImport.clearBatch();
            this.prep_insertInclude.executeBatch();
            this.prep_insertInclude.clearBatch();
            this.prep_insertFunction.executeBatch();
            this.prep_insertFunction.clearBatch();
            this.prep_insertSignature.executeBatch();
            this.prep_insertSignature.clearBatch();
            this.prep_insertMember.executeBatch();
            this.prep_insertMember.clearBatch();
            this.prep_insertParsingError.executeBatch();
            this.prep_insertParsingError.clearBatch();
            this.prep_insertPackage.executeBatch();
            this.prep_insertPackage.clearBatch();
            this.prep_insertPackageContainment.executeBatch();
            this.prep_insertPackageContainment.clearBatch();
            this.prep_insertSourceEntity.executeBatch();
            this.prep_insertSourceEntity.clearBatch();
            this.prep_insertStatement.executeBatch();
            this.prep_insertStatement.clearBatch();
            this.prep_insertClone.executeBatch();
            this.prep_insertClone.clearBatch();
            this.prep_insertCloneInstance.executeBatch();
            this.prep_insertCloneInstance.clearBatch();
            this.prep_insertCloneInstanceStatement.executeBatch();
            this.prep_insertCloneInstanceStatement.clearBatch();
            this.prep_insertType.executeBatch();
            this.prep_insertType.clearBatch();
            this.prep_insertFriend.executeBatch();
            this.prep_insertFriend.clearBatch();
            this.prep_insertTypeArgument.executeBatch();
            this.prep_insertTypeArgument.clearBatch();
            this.prep_insertTypeParameter.executeBatch();
            this.prep_insertTypeParameter.clearBatch();
            this.prep_insertVariable.executeBatch();
            this.prep_insertVariable.clearBatch();
            this.prep_insertClassContainments.executeBatch();
            this.prep_insertClassContainments.clearBatch();
            this.prep_insertInheritance.executeBatch();
            this.prep_insertInheritance.clearBatch();
            this.prep_insertMetrics.executeBatch();
            this.prep_insertMetrics.clearBatch();
            this.prep_insertMetricResults.executeBatch();
            this.prep_insertMetricResults.clearBatch();
        }
        catch (SQLException e) {
            Debug.error((String)"Failed to commit prepared statement batch");
            throw new JDBCError(e);
        }
    }

    private static int booleanToDB(boolean b) {
        if (b) {
            return 1;
        }
        return 0;
    }

    public void addParsingError(ParsingErrorHelper.TErrorElement elem) {
        try {
            this.prep_insertParsingError.setString(1, elem.timestamp);
            this.prep_insertParsingError.setInt(2, elem.kindOfError);
            this.prep_insertParsingError.setString(3, elem.filename.replace("\\", "\\\\"));
            this.prep_insertParsingError.setInt(4, elem.lineNumber);
            this.prep_insertParsingError.setString(5, elem.message.replace("\\", "\\\\"));
            this.prep_insertParsingError.addBatch();
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
        }
    }

    public void addModelElement(ModelElement elem, int kind, int scope) {
        try {
            this.prep_insertModelElement.setInt(1, elem.getUniqueId());
            if (elem instanceof NamedModelElement) {
                this.prep_insertModelElement.setString(2, ((NamedModelElement)elem).getSimpleName());
            } else {
                this.prep_insertModelElement.setString(2, "");
            }
            this.prep_insertModelElement.setInt(3, elem.getStatus());
            this.prep_insertModelElement.setInt(4, kind);
            this.prep_insertModelElement.setInt(5, scope);
            if (elem.getParent() != null) {
                this.prep_insertModelElement.setInt(6, elem.getParent().getUniqueId());
            } else {
                this.prep_insertModelElement.setInt(6, -1);
            }
            this.prep_insertModelElement.addBatch();
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
        }
        this.addAnnotations(elem);
    }

    public void addAnnotations(ModelElement elem) {
        for (ModelAnnotation a : elem.getAnnotations()) {
            if (!(a instanceof ModelElement)) continue;
            try {
                this.prep_insertAnnotation.setInt(1, elem.getUniqueId());
                this.prep_insertAnnotation.setInt(2, ((ModelElement)a).getUniqueId());
                this.prep_insertAnnotation.addBatch();
            }
            catch (SQLException e) {
                Debug.error((String)e.getLocalizedMessage());
            }
        }
    }

    public void addClone(Clone cl) {
        try {
            this.prep_insertClone.setInt(1, cl.getUniqueId());
            CloneInstance inst = (CloneInstance)cl.getInstances().iterator().next();
            this.prep_insertClone.setInt(2, inst.getStatements().size());
            Iterator it = inst.getStatements().iterator();
            int loc = 0;
            while (it.hasNext()) {
                Statement s = (Statement)it.next();
                loc += s.getLinesOfCode();
            }
            this.prep_insertClone.setInt(3, loc);
            this.prep_insertClone.addBatch();
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
        }
    }

    public void addCloneInstance(CloneInstance ci) {
        try {
            this.prep_insertCloneInstance.setInt(1, ci.getUniqueId());
            this.prep_insertCloneInstance.setInt(2, ci.getClone().getUniqueId());
            this.prep_insertCloneInstance.setInt(3, ci.getUniqueId());
            Iterator it = ci.getStatements().iterator();
            Statement s = null;
            if (it.hasNext()) {
                s = (Statement)it.next();
            }
            if (s == null) {
                Debug.warning((String)"ModelExporter: CloneInstance without Statement found!");
                this.prep_insertCloneInstance.setInt(4, -1);
            } else if (s.getSurroundingFunction() == null) {
                Debug.warning((String)"ModelExporter: CloneInstance with Statement but without SurroundingFunction found!");
                this.prep_insertCloneInstance.setInt(4, -1);
            } else {
                this.prep_insertCloneInstance.setInt(4, s.getSurroundingFunction().getUniqueId());
            }
            this.prep_insertCloneInstance.addBatch();
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
        }
    }

    public void addCloneInstanceStatement(CloneInstance ci, Statement st) {
        try {
            this.prep_insertCloneInstanceStatement.setInt(1, st.getUniqueId());
            this.prep_insertCloneInstanceStatement.setInt(2, ci.getUniqueId());
            this.prep_insertCloneInstanceStatement.addBatch();
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
        }
    }

    public void addComment(Comment c, boolean exportCommentTexts) {
        try {
            this.prep_insertComment.setInt(1, c.getUniqueId());
            this.prep_insertComment.setInt(2, SQLExportQueryBuilder.booleanToDB(c.isFormal()));
            this.prep_insertComment.setInt(3, c.getTodoCount());
            this.prep_insertComment.setInt(4, c.getNumberOfCommentLines());
            String text = "";
            if (exportCommentTexts) {
                text = c.getText().replaceAll("'", "''");
                text = text.replaceAll("\\\\", "\\\\\\\\");
                text = text.replaceAll("\n", "\\\\n");
                text = text.replaceAll("\b", "\\\\b");
                text = text.replaceAll("\f", "\\\\f");
                text = text.replaceAll("\r", "\\\\r");
            }
            this.prep_insertComment.setString(5, text);
            this.prep_insertComment.addBatch();
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
        }
    }

    public void addFile(File f) {
        try {
            this.prep_insertFile.setInt(1, f.getUniqueId());
            if (f.isSourceFile()) {
                this.prep_insertFile.setInt(2, 2);
            } else {
                this.prep_insertFile.setInt(2, 3);
            }
            StringBuffer tmp = new StringBuffer();
            if (f.getPathName() != null) {
                tmp.append(f.getPathName());
                int i = 0;
                while (i < tmp.length()) {
                    if (tmp.charAt(i) == '\\') {
                        tmp.insert(i, '\\');
                        ++i;
                    }
                    ++i;
                }
            }
            this.prep_insertFile.setString(3, tmp.toString());
            this.prep_insertFile.setInt(4, f.getLinesOfCode());
            this.prep_insertFile.addBatch();
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
        }
    }

    public void addSourceEntity(SourceEntity se) {
        Position pos = se.getPosition();
        if (pos != null) {
            try {
                this.prep_insertSourceEntity.setInt(1, se.getUniqueId());
                if (pos.getSourceFile() != null) {
                    this.prep_insertSourceEntity.setInt(2, pos.getSourceFile().getUniqueId());
                } else {
                    this.prep_insertSourceEntity.setInt(2, -1);
                }
                this.prep_insertSourceEntity.setInt(3, pos.getStartLine());
                this.prep_insertSourceEntity.setInt(4, pos.getStartColumn());
                this.prep_insertSourceEntity.setInt(5, pos.getEndLine());
                this.prep_insertSourceEntity.setInt(6, pos.getEndColumn());
                if (pos.getAssembly() != null) {
                    this.prep_insertSourceEntity.setInt(7, pos.getAssembly().getUniqueId());
                } else {
                    this.prep_insertSourceEntity.setInt(7, -1);
                }
                this.prep_insertSourceEntity.addBatch();
            }
            catch (SQLException e) {
                Debug.error((String)e.getLocalizedMessage());
            }
        }
    }

    public void addPackage(Package pack, int kind, int aliasId) {
        if (pack.getSurroundingPackage() != null) {
            this.addModelElement((ModelElement)pack, kind, 130);
        } else {
            this.addModelElement((ModelElement)pack, kind, 129);
        }
        try {
            this.prep_insertPackage.setInt(1, pack.getUniqueId());
            this.prep_insertPackage.setInt(2, kind);
            this.prep_insertPackage.setString(3, pack.getSimpleName());
            this.prep_insertPackage.setString(4, pack.getQualifiedName());
            if (pack.getSurroundingPackage() != null) {
                this.prep_insertPackage.setInt(5, pack.getSurroundingPackage().getUniqueId());
            } else {
                this.prep_insertPackage.setInt(5, -1);
            }
            this.prep_insertPackage.setInt(6, aliasId);
            this.prep_insertPackage.addBatch();
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
        }
        if (pack.getSurroundingPackage() != null) {
            this.addPackageContainmentClosure(pack);
        }
    }

    public void addPackageContainmentClosure(Package pack) {
        int depth = 1;
        Package parent = pack.getSurroundingPackage();
        while (parent != null) {
            try {
                this.prep_insertPackageContainment.setInt(1, pack.getUniqueId());
                this.prep_insertPackageContainment.setInt(2, parent.getUniqueId());
                this.prep_insertPackageContainment.setInt(3, depth);
                this.prep_insertPackageContainment.addBatch();
            }
            catch (SQLException e) {
                Debug.error((String)e.getLocalizedMessage());
            }
            parent = parent.getSurroundingPackage();
            ++depth;
        }
    }

    public void addMember(Member m, int kind) {
        try {
            this.prep_insertMember.setInt(1, m.getUniqueId());
            this.prep_insertMember.setInt(2, kind);
            this.prep_insertMember.setString(3, m.getSimpleName());
            if (m.getSurroundingClass() == null) {
                this.prep_insertMember.setInt(4, -1);
            } else {
                this.prep_insertMember.setInt(4, m.getSurroundingClass().getUniqueId());
            }
            if (m.isPrivate()) {
                this.prep_insertMember.setInt(5, 149);
            } else if (m.isProtected()) {
                this.prep_insertMember.setInt(5, 146);
            } else if (m.isStrictProtected()) {
                this.prep_insertMember.setInt(5, 147);
            } else if (m.isPublic()) {
                this.prep_insertMember.setInt(5, 145);
            } else {
                this.prep_insertMember.setInt(5, 148);
            }
            this.prep_insertMember.setInt(6, SQLExportQueryBuilder.booleanToDB(m.isInternal()));
            this.prep_insertMember.setInt(7, SQLExportQueryBuilder.booleanToDB(m.isAbstract()));
            this.prep_insertMember.setInt(8, SQLExportQueryBuilder.booleanToDB(m.isFinal()));
            this.prep_insertMember.setInt(9, SQLExportQueryBuilder.booleanToDB(m.isStatic()));
            this.prep_insertMember.setInt(10, SQLExportQueryBuilder.booleanToDB(m.isVirtual()));
            this.prep_insertMember.setInt(11, SQLExportQueryBuilder.booleanToDB(m.isExtern()));
            this.prep_insertMember.setInt(12, SQLExportQueryBuilder.booleanToDB(m.isNew()));
            this.prep_insertMember.setInt(13, SQLExportQueryBuilder.booleanToDB(m.isOverride()));
            this.prep_insertMember.setInt(14, SQLExportQueryBuilder.booleanToDB(m.isTypeParameterMember()));
            this.prep_insertMember.setInt(15, SQLExportQueryBuilder.booleanToDB(m.isIntrospectable()));
            if (m.getOverridenMember() != null) {
                this.prep_insertMember.setInt(16, m.getOverridenMember().getUniqueId());
            } else {
                this.prep_insertMember.setInt(16, -1);
            }
            this.prep_insertMember.addBatch();
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
        }
    }

    public void addType(Type t, int kind) {
        try {
            this.prep_insertType.setInt(1, t.getUniqueId());
            this.prep_insertType.setInt(2, kind);
            this.prep_insertType.setString(3, t.getSimpleName());
            this.prep_insertType.setString(4, t.getQualifiedName());
            if (t.getSurroundingPackage() != null) {
                this.prep_insertType.setInt(5, t.getSurroundingPackage().getUniqueId());
            } else {
                this.prep_insertType.setInt(5, -1);
            }
            if (t instanceof Member) {
                if (((Member)t).getSurroundingClass() != null) {
                    this.prep_insertType.setInt(6, ((Member)t).getSurroundingClass().getUniqueId());
                } else {
                    this.prep_insertType.setInt(6, -1);
                }
            } else {
                this.prep_insertType.setInt(6, -1);
            }
            if (t instanceof TypeDecorator) {
                this.prep_insertType.setInt(7, ((TypeDecorator)t).getDecoratedType().getUniqueId());
            } else {
                this.prep_insertType.setInt(7, -1);
            }
            if (t instanceof Array) {
                this.prep_insertType.setInt(8, ((Array)t).getDimensions());
            } else {
                this.prep_insertType.setInt(8, -1);
            }
            this.prep_insertType.setInt(9, SQLExportQueryBuilder.booleanToDB(t.isReferenceType()));
            this.prep_insertType.addBatch();
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
        }
    }

    public void addClass(Class ct, int kind) {
        if (ct.isLocalClass()) {
            this.addModelElement((ModelElement)ct, kind, 132);
            this.addType((Type)ct, kind);
        } else if (ct.isInnerClass()) {
            this.addModelElement((ModelElement)ct, kind, 131);
            this.addType((Type)ct, kind);
            this.addInnerClassClosure(ct);
        } else if (kind == 33) {
            this.addModelElement((ModelElement)ct, kind, 129);
            this.addType((Type)ct, kind);
        } else {
            this.addModelElement((ModelElement)ct, kind, 130);
            this.addType((Type)ct, kind);
        }
        this.addSourceEntity((SourceEntity)ct);
        this.addMember((Member)ct, kind);
        this.addFriends(ct);
    }

    public void addInnerClassClosure(Class ct) {
        int depth = 1;
        Class parent = ct.getSurroundingClass();
        while (parent != null) {
            try {
                this.prep_insertClassContainments.setInt(1, ct.getUniqueId());
                this.prep_insertClassContainments.setInt(2, parent.getUniqueId());
                this.prep_insertClassContainments.setInt(3, depth);
                this.prep_insertClassContainments.addBatch();
            }
            catch (SQLException e) {
                Debug.error((String)e.getLocalizedMessage());
            }
            parent = parent.getSurroundingClass();
            ++depth;
        }
    }

    public void addFriends(Class ct) {
        for (Class c : ct.getFriendClasses()) {
            try {
                this.prep_insertFriend.setInt(1, ct.getUniqueId());
                this.prep_insertFriend.setInt(2, SQLExportVisitor.determineKind(c));
                this.prep_insertFriend.setInt(3, c.getUniqueId());
                this.prep_insertFriend.addBatch();
            }
            catch (SQLException e) {
                Debug.error((String)e.getLocalizedMessage());
            }
        }
        for (Function f : ct.getFriendFunctions()) {
            try {
                this.prep_insertFriend.setInt(1, ct.getUniqueId());
                this.prep_insertFriend.setInt(2, SQLExportVisitor.determineKind(f));
                this.prep_insertFriend.setInt(3, f.getUniqueId());
                this.prep_insertFriend.addBatch();
            }
            catch (SQLException e) {
                Debug.error((String)e.getLocalizedMessage());
            }
        }
    }

    public void addStatement(Statement st) {
        try {
            this.prep_insertStatement.setInt(1, st.getUniqueId());
            this.prep_insertStatement.setInt(2, SQLExportVisitor.determineKind(st));
            if (st.getSurroundingFunction() != null) {
                this.prep_insertStatement.setInt(3, st.getSurroundingFunction().getUniqueId());
            } else {
                this.prep_insertStatement.setInt(3, -1);
            }
            if (st.getContainer() != null) {
                this.prep_insertStatement.setInt(4, st.getContainer().getUniqueId());
            } else {
                this.prep_insertStatement.setInt(4, -1);
            }
            this.prep_insertStatement.setInt(5, st.getStatementPosition(st));
            this.prep_insertStatement.addBatch();
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
        }
    }

    public void addTypeParameter(GenericEntity ge, TypeParameterClass tpc, int pos) {
        try {
            this.prep_insertTypeParameter.setInt(1, tpc.getUniqueId());
            this.prep_insertTypeParameter.setInt(2, pos);
            if (ge instanceof Class) {
                this.prep_insertTypeParameter.setInt(3, SQLExportVisitor.determineKind((Class)ge));
            } else {
                this.prep_insertTypeParameter.setInt(3, SQLExportVisitor.determineKind((Function)ge));
            }
            this.prep_insertTypeParameter.setInt(4, ge.getUniqueId());
            this.prep_insertTypeParameter.addBatch();
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
        }
    }

    public void addTypeArguments(Access access) {
        Iterator itParam = null;
        Iterator itArg = null;
        if (access instanceof FunctionAccess) {
            itArg = ((FunctionAccess)access).getTypeArgs().iterator();
        } else if (access instanceof TypeAccess) {
            itArg = ((TypeAccess)access).getTypeArgs().iterator();
        }
        if (itArg != null && itArg.hasNext()) {
            Referenceable ref = access.getAccessedTarget();
            while (ref != null && !(ref instanceof GenericEntity)) {
                ref = ref.getParent();
            }
            if (ref != null) {
                itParam = ((GenericEntity)ref).getTypeParameters().iterator();
            }
            if (itParam != null) {
                while (itArg.hasNext() && itParam.hasNext()) {
                    TypeParameterClass tpc = (TypeParameterClass)itParam.next();
                    Type targ = (Type)itArg.next();
                    try {
                        this.prep_insertTypeArgument.setInt(1, access.getUniqueId());
                        this.prep_insertTypeArgument.setInt(2, tpc.getUniqueId());
                        this.prep_insertTypeArgument.setInt(3, targ.getUniqueId());
                        this.prep_insertTypeArgument.addBatch();
                    }
                    catch (SQLException e) {
                        Debug.error((String)e.getLocalizedMessage());
                    }
                }
            }
        }
    }

    public void addFunction(Function func, int kind, int scope) {
        this.addModelElement((ModelElement)func, kind, scope);
        try {
            this.prep_insertFunction.setInt(1, func.getUniqueId());
            this.prep_insertFunction.setInt(2, kind);
            this.prep_insertFunction.setString(3, func.getSimpleName());
            if (func.getReturnTypeDeclaration() == null) {
                this.prep_insertFunction.setInt(4, -1);
            } else {
                this.prep_insertFunction.setInt(4, func.getReturnTypeDeclaration().getUniqueId());
            }
            Package tmpPack = null;
            Class tmpCls = null;
            Property tmpProp = null;
            ModelElement tmpElem = func.getParent();
            while (tmpElem != null && !(tmpElem instanceof Package)) {
                if (tmpElem instanceof Class && tmpCls == null) {
                    tmpCls = (Class)tmpElem;
                }
                if (tmpElem instanceof Property && tmpProp == null) {
                    tmpProp = (Property)tmpElem;
                }
                tmpElem = tmpElem.getParent();
            }
            if (tmpElem != null && tmpElem instanceof Package) {
                tmpPack = (Package)tmpElem;
            }
            if (tmpPack != null) {
                this.prep_insertFunction.setInt(5, tmpPack.getUniqueId());
            } else {
                this.prep_insertFunction.setInt(5, -1);
            }
            if (tmpCls != null) {
                this.prep_insertFunction.setInt(6, tmpCls.getUniqueId());
            } else {
                this.prep_insertFunction.setInt(6, -1);
            }
            if (tmpProp != null) {
                this.prep_insertFunction.setInt(7, tmpProp.getUniqueId());
            } else {
                this.prep_insertFunction.setInt(7, -1);
            }
            this.prep_insertFunction.setInt(8, SQLExportQueryBuilder.booleanToDB(func.isOperator()));
            this.prep_insertFunction.setInt(9, func.getNumberOfStatements());
            this.prep_insertFunction.setInt(10, func.getLinesOfCode());
            this.prep_insertFunction.setInt(11, func.getLinesOfComments());
            this.prep_insertFunction.setInt(12, func.getThrowTypeAccesses().size());
            this.prep_insertFunction.setInt(13, func.getMaximumNestingLevel());
            this.prep_insertFunction.setInt(14, func.getNumberOfNodesInCFG());
            this.prep_insertFunction.setInt(15, func.getNumberOfEdgesInCFG());
            this.prep_insertFunction.addBatch();
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
        }
        this.addSourceEntity((SourceEntity)func);
        this.addSignature(func);
    }

    public void addSignature(Function func) {
        try {
            this.prep_insertSignature.setInt(1, func.getUniqueId());
            this.prep_insertSignature.setString(2, func.signature().toString());
            this.prep_insertSignature.addBatch();
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
        }
    }

    public void addAccessedTargets(Access acc) {
    }

    public void addVariable(Variable var, int kind, int scope, Package pack, Class cls, Function func, int pos) {
        this.addModelElement((ModelElement)var, kind, scope);
        try {
            this.prep_insertVariable.setInt(1, var.getUniqueId());
            this.prep_insertVariable.setInt(2, kind);
            this.prep_insertVariable.setString(3, var.getSimpleName());
            if (pack != null) {
                this.prep_insertVariable.setInt(4, pack.getUniqueId());
            } else {
                this.prep_insertVariable.setInt(4, -1);
            }
            if (cls != null) {
                this.prep_insertVariable.setInt(5, cls.getUniqueId());
            } else {
                this.prep_insertVariable.setInt(5, -1);
            }
            if (func != null) {
                this.prep_insertVariable.setInt(6, func.getUniqueId());
            } else {
                this.prep_insertVariable.setInt(6, -1);
            }
            if (var.getTypeDeclaration() == null) {
                this.prep_insertVariable.setInt(7, -1);
            } else {
                this.prep_insertVariable.setInt(7, var.getTypeDeclaration().getUniqueId());
            }
            this.prep_insertVariable.setInt(8, pos);
            this.prep_insertVariable.setInt(9, SQLExportQueryBuilder.booleanToDB(var.isConst()));
            if (var instanceof FormalParameter) {
                this.prep_insertVariable.setInt(10, SQLExportQueryBuilder.booleanToDB(((FormalParameter)var).isPassedByReference()));
            } else {
                this.prep_insertVariable.setInt(10, SQLExportQueryBuilder.booleanToDB(false));
            }
            if (var instanceof CatchParameter) {
                this.prep_insertVariable.setInt(11, SQLExportQueryBuilder.booleanToDB(((CatchParameter)var).isRethrown()));
            } else {
                this.prep_insertVariable.setInt(11, SQLExportQueryBuilder.booleanToDB(false));
            }
            if (var instanceof Property) {
                if (((Property)var).getImplementedInterface() != null) {
                    this.prep_insertVariable.setInt(12, ((Property)var).getImplementedInterface().getUniqueId());
                } else {
                    this.prep_insertVariable.setInt(12, -1);
                }
            } else {
                this.prep_insertVariable.setInt(12, -1);
            }
            this.prep_insertVariable.addBatch();
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
        }
        this.addSourceEntity((SourceEntity)var);
    }

    public void addAccess(Access acc, int kind, int scope, int pos) {
        this.addModelElement((ModelElement)acc, kind, scope);
        try {
            this.prep_insertAccess.setInt(1, acc.getUniqueId());
            this.prep_insertAccess.setInt(2, kind);
            this.prep_insertAccess.setInt(3, pos);
            Package tmpPack = null;
            ModelElement tmpElem = acc.getParent();
            while (tmpElem != null && !(tmpElem instanceof Package)) {
                tmpElem = tmpElem.getParent();
            }
            if (tmpElem != null && tmpElem instanceof Package) {
                tmpPack = (Package)tmpElem;
            }
            if (tmpPack != null) {
                this.prep_insertAccess.setInt(4, tmpPack.getUniqueId());
            } else {
                this.prep_insertAccess.setInt(4, -1);
            }
            if (acc.getSurroundingClass() != null) {
                this.prep_insertAccess.setInt(5, acc.getSurroundingClass().getUniqueId());
            } else {
                this.prep_insertAccess.setInt(5, -1);
            }
            if (acc.getSurroundingFunction() != null) {
                this.prep_insertAccess.setInt(6, acc.getSurroundingFunction().getUniqueId());
            } else {
                this.prep_insertAccess.setInt(6, -1);
            }
            if (acc.getSurroundingStatement() != null) {
                this.prep_insertAccess.setInt(7, acc.getSurroundingStatement().getUniqueId());
            } else {
                this.prep_insertAccess.setInt(7, -1);
            }
            if (acc.getParent() != null) {
                this.prep_insertAccess.setInt(8, acc.getParent().getUniqueId());
            } else {
                this.prep_insertAccess.setInt(8, -1);
            }
            if (acc.getAccessedTarget() == null) {
                this.prep_insertAccess.setInt(9, -1);
            } else {
                this.prep_insertAccess.setInt(9, acc.getAccessedTarget().getUniqueId());
            }
            this.prep_insertAccess.addBatch();
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
        }
        this.addSourceEntity((SourceEntity)acc);
        this.addTypeArguments(acc);
        this.addAccessedTargets(acc);
    }

    public void addImport(File file, ModelElement target, int kind, boolean isStaticImport, boolean isMultiImport) {
        try {
            this.prep_insertImport.setInt(1, file.getUniqueId());
            this.prep_insertImport.setInt(2, kind);
            this.prep_insertImport.setInt(3, target.getUniqueId());
            this.prep_insertImport.setInt(4, SQLExportQueryBuilder.booleanToDB(isStaticImport));
            this.prep_insertImport.setInt(5, SQLExportQueryBuilder.booleanToDB(isMultiImport));
            this.prep_insertImport.addBatch();
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
        }
    }

    public void addIncludeClosure(File file, File includedFile, ModelElementList visited, int depth) {
        if (visited.contains((Object)includedFile)) {
            return;
        }
        visited.add((Object)includedFile);
        try {
            this.prep_insertInclude.setInt(1, file.getUniqueId());
            this.prep_insertInclude.setInt(2, includedFile.getUniqueId());
            this.prep_insertInclude.setInt(3, depth);
            this.prep_insertInclude.addBatch();
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
        }
        for (File f : includedFile.getIncludedFiles()) {
            this.addIncludeClosure(file, f, visited, depth + 1);
        }
    }

    public void addInheritanceClosure(Class cls, Class superCls, int dit) {
        if (cls == null) {
            Debug.warning((String)"Class parameter of addInheritanceClosure was null!");
            return;
        }
        if (superCls == null) {
            Debug.warning((String)"superClass parameter of addInheritanceClosure was null!");
            return;
        }
        try {
            this.prep_insertInheritance.setInt(1, cls.getUniqueId());
            this.prep_insertInheritance.setInt(2, superCls.getUniqueId());
            this.prep_insertInheritance.setInt(3, dit);
            this.prep_insertInheritance.addBatch();
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
        }
        for (InheritanceTypeAccess inh : superCls.getInheritanceTypeAccesses()) {
            this.addInheritanceClosure(cls, inh.getAccessedSuperClass(), dit + 1);
        }
    }

    public void addStructuralAbstraction(StructuralAbstraction sa, int kind) {
        this.addModelElement((ModelElement)sa, kind, 129);
        try {
            this.prep_insertAbstraction.setInt(1, sa.getUniqueId());
            this.prep_insertAbstraction.setString(2, sa.getSimpleName());
            this.prep_insertAbstraction.setInt(3, kind);
            this.prep_insertAbstraction.setString(4, sa.getType());
            this.prep_insertAbstraction.addBatch();
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
        }
        for (ModelElement elem : sa.getModelElements()) {
            try {
                this.prep_insertAbstractionElement.setInt(1, sa.getUniqueId());
                this.prep_insertAbstractionElement.setInt(2, elem.getUniqueId());
                this.prep_insertAbstractionElement.addBatch();
            }
            catch (SQLException e) {
                Debug.error((String)e.getLocalizedMessage());
            }
        }
    }

    public void addMetric(Metric metric) {
        try {
            this.prep_insertMetrics.setInt(1, metric.getId());
            String type = "";
            type = metric instanceof ClassMetric ? "classmetric" : "functionmetric";
            this.prep_insertMetrics.setString(2, type);
            this.prep_insertMetrics.setString(3, metric.getType());
            this.prep_insertMetrics.setString(4, metric.getDescription());
            this.prep_insertMetrics.addBatch();
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
        }
    }

    public void addMetricsResult(MetricsResult metricsResult) {
        try {
            this.prep_insertMetricResults.setInt(1, metricsResult.getMetric().getId());
            this.prep_insertMetricResults.setInt(2, metricsResult.getModelElement().getUniqueId());
            this.prep_insertMetricResults.setDouble(3, metricsResult.getValue());
            this.prep_insertMetricResults.addBatch();
        }
        catch (SQLException e) {
            Debug.error((String)e.getLocalizedMessage());
        }
    }
}

