/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.persistence;

import de.fzi.sissy.persistence.JDBCError;
import de.fzi.sissy.persistence.JDBCWrapper;
import de.fzi.sissy.persistence.config.PostgresqlDatabaseConfiguration;
import de.fzi.sissy.utils.Debug;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.PrintWriter;
import java.sql.SQLException;

public final class SQLCommandFileExporter
implements Runnable {
    private PrintWriter outPipe;
    private PipedReader inPipe;
    private JDBCWrapper jdbcWrapper;
    private String inputFileName;

    public SQLCommandFileExporter(String configFile, String dbName, String inputFileName) {
        try {
            PostgresqlDatabaseConfiguration dbConf = new PostgresqlDatabaseConfiguration();
            dbConf.setDatabaseName(dbName);
            this.jdbcWrapper = JDBCWrapper.createJDBCWrapper(dbConf);
            this.jdbcWrapper.runScripts();
            this.inputFileName = inputFileName;
            this.inPipe = new PipedReader();
            this.outPipe = new PrintWriter(new PipedWriter(this.inPipe));
            Thread t = new Thread(this);
            t.start();
            this.export();
            this.outPipe.close();
            t.join();
            this.jdbcWrapper.getConnection().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JDBCError e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void export() {
        try {
            String statement;
            BufferedReader inputFile = new BufferedReader(new FileReader(this.inputFileName));
            Debug.info((String)"SQL statement runner started...");
            int count = 0;
            while ((statement = inputFile.readLine()) != null) {
                if (++count % 5000 == 0) {
                    Debug.println((String)("\tRunning statement: " + count));
                }
                this.outPipe.println(statement);
            }
            Debug.info((String)("SQL statement runner finished inserting " + count + " statements"));
            inputFile.close();
        }
        catch (IOException ex) {
            Debug.error((String)ex.toString());
        }
        catch (JDBCError ex) {
            Debug.error((String)ex.toString());
        }
    }

    @Override
    public void run() {
        this.jdbcWrapper.runStatements(this.inPipe);
    }

    public static void main(String[] args) {
        String inputFileName = null;
        String configFileName = "jdbc.cfg";
        String dbName = null;
        Debug.setDebugLevel((int)6);
        if (args.length < 1) {
            SQLCommandFileExporter.printUsage();
            return;
        }
        inputFileName = args[0];
        int i = 1;
        while (i < args.length) {
            if (args[i].equals("-cfg")) {
                configFileName = args[++i];
                Debug.info((String)("Using alternate config file \"" + configFileName + "\""));
            } else if (args[i].equals("-db")) {
                dbName = args[++i];
                Debug.info((String)("Using alternate database \"" + dbName + "\""));
            } else {
                SQLCommandFileExporter.printUsage();
                return;
            }
            ++i;
        }
        if (args.length > 5) {
            SQLCommandFileExporter.printUsage();
            return;
        }
        if (inputFileName == null && dbName == null) {
            Debug.info((String)"Using default database");
        }
        new SQLCommandFileExporter(configFileName, dbName, inputFileName);
    }

    private static void printUsage() {
        Debug.error((String)"Wrong usage. See below:\n\nSISSy <sql_command_file> [-cfg configfile] [-db dbname]\n\n\t<sql_command_file>: the file containing the SQL commnads\t-cfg configfile: an alternate jdbc config file. If this param is not\n\t\tsupplied the default config file is used.\n\t-db dbname: the result will be stored in the specified database. If\n\t\tthis param is not given the output will be stored in the\n\t\tdefault database.\n");
    }
}

