/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.persistence;

import de.fzi.sissy.metamod.Access;
import de.fzi.sissy.metamod.Array;
import de.fzi.sissy.metamod.BlockStatement;
import de.fzi.sissy.metamod.BranchStatement;
import de.fzi.sissy.metamod.CastTypeAccess;
import de.fzi.sissy.metamod.CatchBlock;
import de.fzi.sissy.metamod.CatchParameter;
import de.fzi.sissy.metamod.Class;
import de.fzi.sissy.metamod.Clone;
import de.fzi.sissy.metamod.CloneInstance;
import de.fzi.sissy.metamod.Comment;
import de.fzi.sissy.metamod.CompositeAccess;
import de.fzi.sissy.metamod.Constructor;
import de.fzi.sissy.metamod.DeclarationTypeAccess;
import de.fzi.sissy.metamod.Delegate;
import de.fzi.sissy.metamod.DelegateAccess;
import de.fzi.sissy.metamod.Destructor;
import de.fzi.sissy.metamod.ExceptionHandler;
import de.fzi.sissy.metamod.Field;
import de.fzi.sissy.metamod.File;
import de.fzi.sissy.metamod.FormalParameter;
import de.fzi.sissy.metamod.Function;
import de.fzi.sissy.metamod.FunctionAccess;
import de.fzi.sissy.metamod.GenericClass;
import de.fzi.sissy.metamod.GenericConstructor;
import de.fzi.sissy.metamod.GenericEntity;
import de.fzi.sissy.metamod.GenericFunction;
import de.fzi.sissy.metamod.GenericMethod;
import de.fzi.sissy.metamod.GlobalFunction;
import de.fzi.sissy.metamod.GlobalVariable;
import de.fzi.sissy.metamod.InheritanceTypeAccess;
import de.fzi.sissy.metamod.JumpStatement;
import de.fzi.sissy.metamod.LocalVariable;
import de.fzi.sissy.metamod.LoopStatement;
import de.fzi.sissy.metamod.Member;
import de.fzi.sissy.metamod.Method;
import de.fzi.sissy.metamod.ModelAnnotation;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.ModelElementRepository;
import de.fzi.sissy.metamod.Package;
import de.fzi.sissy.metamod.PackageAlias;
import de.fzi.sissy.metamod.Position;
import de.fzi.sissy.metamod.Property;
import de.fzi.sissy.metamod.PropertyAccess;
import de.fzi.sissy.metamod.Reference;
import de.fzi.sissy.metamod.Root;
import de.fzi.sissy.metamod.RunTimeTypeAccess;
import de.fzi.sissy.metamod.SelfAccess;
import de.fzi.sissy.metamod.SimpleStatement;
import de.fzi.sissy.metamod.SourceEntity;
import de.fzi.sissy.metamod.StaticTypeAccess;
import de.fzi.sissy.metamod.StructuralAbstraction;
import de.fzi.sissy.metamod.Subsystem;
import de.fzi.sissy.metamod.ThrowTypeAccess;
import de.fzi.sissy.metamod.Type;
import de.fzi.sissy.metamod.TypeAccess;
import de.fzi.sissy.metamod.TypeAlias;
import de.fzi.sissy.metamod.TypeParameterClass;
import de.fzi.sissy.metamod.Variable;
import de.fzi.sissy.metamod.VariableAccess;
import de.fzi.sissy.persistence.JDBCWrapper;
import de.fzi.sissy.persistence.SQLModelConstants;
import de.fzi.sissy.persistence.config.PostgresqlDatabaseConfiguration;
import de.fzi.sissy.utils.Debug;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class ModelImporter
implements SQLModelConstants {
    private Root root;
    private ModelElementRepository repository;
    private JDBCWrapper connectionManager;
    private HashMap idToModelElement;

    public ModelImporter() {
        try {
            this.connectionManager = JDBCWrapper.createJDBCWrapper(new PostgresqlDatabaseConfiguration());
            this.restoreDbTables();
            this.connectionManager.getConnection().close();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }

    public ModelImporter(JDBCWrapper jdbcWrapper) {
        try {
            this.connectionManager = jdbcWrapper;
            this.restoreDbTables();
            this.connectionManager.getConnection().close();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }

    private void restoreDbTables() {
        try {
            this.idToModelElement = new HashMap();
            this.repository = ModelElementRepository.newRepository();
            this.root = this.repository.getRoot();
            this.restorePackages();
            this.restoreFiles();
            this.restoreTypes();
            this.restoreFunctions();
            this.restoreFriends();
            this.restoreTypeParameters();
            this.restoreStatements();
            this.restoreClones();
            this.restoreVariables();
            this.restoreMembers();
            this.restorePropertyAccessors();
            this.restoreFileInclusionsAndImports();
            this.restoreAccesses();
            this.restoreTypeArguments();
            this.restoreStructuralAbstractions();
            this.restoreComments();
            this.restorePositions();
            this.restoreAnnotationsAndStatus();
            Debug.info((String)"Import finished.");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void restorePackages() throws SQLException {
        Connection con = this.connectionManager.getConnection();
        Statement stmt = con.createStatement();
        String query = "SELECT p.*, e.Scope FROM TPackages AS p, TModelElements AS e WHERE p.id = e.id";
        Debug.debug((String)(">>> restorePackages :: query =\n" + query + "\n"));
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            this.loadPackage(rs);
        }
        rs = stmt.executeQuery(query);
        while (rs.next()) {
            this.loadSubPackagesAndAliases(rs);
        }
    }

    private void loadPackage(ResultSet rs) throws SQLException {
        int id = rs.getInt("Id");
        String simpleName = rs.getString("Name");
        Object pack = rs.getInt("KindOfPackage") == 19 ? new PackageAlias(simpleName, this.root, null) : new Package(simpleName, this.root);
        pack.setUniqueId(id);
        this.idToModelElement.put(id, pack);
    }

    private void loadSubPackagesAndAliases(ResultSet rs) throws SQLException {
        int parentid = rs.getInt("ParentPackageId");
        int aliasid = rs.getInt("AliasedPackageId");
        int id = rs.getInt("Id");
        Package currentPackage = (Package)this.idToModelElement.get(id);
        if (rs.getInt("Scope") == 130) {
            Package parent = (Package)this.idToModelElement.get(parentid);
            parent.addSubPackage(currentPackage);
        }
        if (rs.getInt("KindOfPackage") == 19) {
            ((PackageAlias)currentPackage).setAliasedPackage((Package)this.idToModelElement.get(aliasid));
        }
    }

    private void restoreFiles() throws SQLException {
        Connection con = this.connectionManager.getConnection();
        Statement stmt = con.createStatement();
        String query = "SELECT * FROM TFiles";
        Debug.info((String)(">>> restoreFiles :: query =\n" + query + "\n"));
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            File file = this.loadFile(rs);
            this.root.addFile(file);
        }
    }

    private File loadFile(ResultSet rs) throws SQLException {
        File file = new File(rs.getString("pathname"));
        int id = rs.getInt("Id");
        int loc = rs.getInt("LinesOfCode");
        file.setUniqueId(id);
        file.setLinesOfCode(loc);
        if (rs.getInt("KindOfFile") == 3) {
            file.setAssembly();
        } else {
            file.setSourceFile();
        }
        this.idToModelElement.put(id, file);
        return file;
    }

    private void restoreTypes() throws SQLException {
        int id;
        Connection con = this.connectionManager.getConnection();
        Statement stmt = con.createStatement();
        String query = "SELECT * FROM TTypes t ORDER BY t.Id";
        Debug.info((String)(">>> restoreTypes :: query =\n" + query + "\n"));
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            Type dType;
            int decoratedTypeId;
            id = rs.getInt("Id");
            int kindoftype = rs.getInt("KindOfType");
            String name = rs.getString("Name");
            Class c = null;
            if (kindoftype == 35 || kindoftype == 34) {
                c = new Class(name, Class.KindOfClass.NORMALCLASS, false);
            } else if (kindoftype == 43) {
                c = new Class(name, Class.KindOfClass.ENUMTYPE, false);
            } else if (kindoftype == 44) {
                c = new Class(name, Class.KindOfClass.STRUCT, false);
            } else if (kindoftype == 45) {
                c = new Class(name, Class.KindOfClass.UNION, false);
            } else if (kindoftype == 37 || kindoftype == 36) {
                c = new GenericClass(name, false);
            } else if (kindoftype == 38) {
                c = new TypeParameterClass(name, false);
            } else if (kindoftype == 33) {
                c = new Class(name, Class.KindOfClass.NORMALCLASS, false);
                c.setPrimitive();
            }
            if (c != null) {
                c.setUniqueId(id);
                this.root.addType((Type)c);
                int packId = rs.getInt("PackageId");
                if (packId != -1) {
                    Package pack = (Package)this.idToModelElement.get(packId);
                    pack.addClass(c);
                }
                if (kindoftype == 36 || kindoftype == 34) {
                    c.setInterface();
                }
                if (rs.getBoolean("IsReferenceType")) {
                    c.setReferenceType();
                }
                this.idToModelElement.put(id, c);
            }
            if (kindoftype == 49) {
                Delegate d = new Delegate(name);
                this.root.addType((Type)d);
                int packId = rs.getInt("PackageId");
                if (packId != -1) {
                    Package pack = (Package)this.idToModelElement.get(packId);
                    pack.addDelegate(d);
                }
                if (rs.getBoolean("IsReferenceType")) {
                    d.setReferenceType();
                }
                this.idToModelElement.put(id, d);
                continue;
            }
            if (kindoftype == 40) {
                decoratedTypeId = rs.getInt("DecoratedTypeId");
                dType = (Type)this.idToModelElement.get(decoratedTypeId);
                TypeAlias a = new TypeAlias(dType, name);
                this.root.addType((Type)a);
                int packId = rs.getInt("PackageId");
                if (packId != -1) {
                    Package pack = (Package)this.idToModelElement.get(packId);
                    pack.addTypeAlias(a);
                }
                if (rs.getBoolean("IsReferenceType")) {
                    a.setReferenceType();
                }
                this.idToModelElement.put(id, a);
                continue;
            }
            if (kindoftype == 41 || kindoftype == 42) {
                decoratedTypeId = rs.getInt("DecoratedTypeId");
                dType = (Type)this.idToModelElement.get(decoratedTypeId);
                Reference ref = new Reference(dType, name);
                ref.setUniqueId(id);
                if (kindoftype == 41) {
                    ref.setImplicit();
                } else {
                    ref.setExplicit();
                }
                this.root.addType((Type)ref);
                if (rs.getBoolean("IsReferenceType")) {
                    ref.setReferenceType();
                }
                this.idToModelElement.put(id, ref);
                continue;
            }
            if (kindoftype != 39) continue;
            decoratedTypeId = rs.getInt("DecoratedTypeId");
            dType = (Type)this.idToModelElement.get(decoratedTypeId);
            Array array = new Array(dType);
            array.setUniqueId(id);
            this.root.addType((Type)array);
            if (rs.getBoolean("IsReferenceType")) {
                array.setReferenceType();
            }
            this.idToModelElement.put(id, array);
        }
        rs = stmt.executeQuery(query);
        while (rs.next()) {
            id = rs.getInt("Id");
            int classId = rs.getInt("ClassId");
            if (classId == -1) continue;
            Member innerType = (Member)this.idToModelElement.get(id);
            Class parentClass = (Class)this.idToModelElement.get(classId);
            if (innerType instanceof Delegate) {
                parentClass.addInnerDelegate((Delegate)innerType);
                continue;
            }
            if (innerType instanceof TypeAlias) {
                parentClass.addInnerTypeAlias((TypeAlias)innerType);
                continue;
            }
            if (!(innerType instanceof Class)) continue;
            parentClass.addInnerClass((Class)innerType);
        }
    }

    private void restoreFriends() throws SQLException {
        Connection con = this.connectionManager.getConnection();
        Statement stmt = con.createStatement();
        String query = "SELECT * FROM TFriends";
        Debug.debug((String)(">>> restoreFriends: query =\n" + query + "\n"));
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            int typeId = rs.getInt("TypeId");
            rs.getInt("KindOfFriend");
            int friendId = rs.getInt("FriendId");
            Class c = (Class)this.idToModelElement.get(typeId);
            ModelElement elem = (ModelElement)this.idToModelElement.get(friendId);
            if (elem instanceof Class) {
                c.addFriendClass((Class)elem);
                continue;
            }
            c.addFriendFunction((Function)elem);
        }
    }

    private void restoreTypeParameters() throws SQLException {
        Connection con = this.connectionManager.getConnection();
        Statement stmt = con.createStatement();
        String query = "SELECT * FROM TTypeParameters ORDER BY GenericElementId, Position";
        Debug.debug((String)(">>> restoreTypeParameters: query =\n" + query + "\n"));
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            int genElemId = rs.getInt("GenericElementId");
            int typeId = rs.getInt("TypeParameterId");
            GenericEntity ge = (GenericEntity)this.idToModelElement.get(genElemId);
            TypeParameterClass tpc = (TypeParameterClass)this.idToModelElement.get(typeId);
            ge.addTypeParameter(tpc);
        }
    }

    private void restoreFunctions() throws SQLException {
        Connection con = this.connectionManager.getConnection();
        Statement stmt = con.createStatement();
        String query = "SELECT TFunctions.*, TAccesses.Id as AccId, TAccesses.TargetId, TModelElements.ParentId FROM TFunctions INNER JOIN TModelElements ON TFunctions.Id = TModelElements.Id LEFT OUTER JOIN TAccesses ON TFunctions.ReturnTypeDeclarationId = TAccesses.Id";
        Debug.info((String)(">>> restoreFunctions :: query =\n" + query + "\n"));
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            GlobalFunction function;
            int id;
            block20: {
                int kindoffunction;
                block18: {
                    block19: {
                        id = rs.getInt("Id");
                        rs.getInt("Parentid");
                        kindoffunction = rs.getInt("KindOfFunction");
                        function = null;
                        if (kindoffunction != 50 && kindoffunction != 58 && kindoffunction != 59) break block18;
                        function = this.loadGlobalFunction(rs);
                        if (kindoffunction != 58) break block19;
                        function.setKind(2);
                        break block20;
                    }
                    if (kindoffunction != 59) break block20;
                    function.setKind(3);
                    break block20;
                }
                if (kindoffunction == 51) {
                    function = this.loadGenericFunction(rs);
                } else if (kindoffunction == 61) {
                    function = this.loadGenericConstructor(rs);
                } else if (kindoffunction == 60) {
                    function = this.loadGenericMethod(rs);
                } else if (kindoffunction == 52 || kindoffunction == 56 || kindoffunction == 57) {
                    function = this.loadMethod(rs);
                } else if (kindoffunction == 53) {
                    function = this.loadConstructor(rs);
                } else if (kindoffunction == 54) {
                    function = this.loadDestructor(rs);
                } else if (kindoffunction == 55) {
                    function = this.loadInitializer(rs);
                } else if (kindoffunction != 49) {
                    function = (Delegate)this.idToModelElement.get(id);
                } else {
                    Debug.info((String)"Didn't catch this type of function yet.\n");
                    continue;
                }
            }
            function.setOperator(rs.getBoolean("IsOperator"));
            function.setLinesOfComments(rs.getInt("NumberOfComments"));
            function.setNumberOfStatements(rs.getInt("NumberOfStatements"));
            function.setNumberOfEdgesInCFG(rs.getInt("NumberOfEdges"));
            function.setNumberOfNodesInCFG(rs.getInt("NumberOfNodes"));
            function.setMaximumNestingLevel(rs.getInt("MaxNestingLevel"));
            if (rs.getInt("ReturnTypeDeclarationId") != -1) {
                Type type = (Type)this.idToModelElement.get(rs.getInt("TargetId"));
                DeclarationTypeAccess dta = new DeclarationTypeAccess(type);
                dta.setUniqueId(rs.getInt("AccId"));
                function.setReturnTypeDeclaration(dta);
                this.idToModelElement.put(dta.getUniqueId(), dta);
            }
            this.idToModelElement.put(id, function);
        }
    }

    private GlobalFunction loadGlobalFunction(ResultSet rs) throws SQLException {
        int id = rs.getInt("Id");
        int packid = rs.getInt("PackageId");
        String name = rs.getString("Name");
        GlobalFunction globalFunction = new GlobalFunction(name);
        globalFunction.setUniqueId(id);
        this.root.addGlobalFunction(globalFunction);
        Package pack = (Package)this.idToModelElement.get(packid);
        if (pack != null) {
            pack.addGlobalFunction(globalFunction);
        }
        return globalFunction;
    }

    private GenericFunction loadGenericFunction(ResultSet rs) throws SQLException {
        int id = rs.getInt("Id");
        int packid = rs.getInt("PackageId");
        String name = rs.getString("Name");
        GenericFunction genericFunction = new GenericFunction(name);
        genericFunction.setUniqueId(id);
        this.root.addGlobalFunction((GlobalFunction)genericFunction);
        Package pack = (Package)this.idToModelElement.get(packid);
        pack.addGlobalFunction((GlobalFunction)genericFunction);
        return genericFunction;
    }

    private Constructor loadGenericConstructor(ResultSet rs) throws SQLException {
        int id = rs.getInt("Id");
        int classId = rs.getInt("ClassId");
        String name = rs.getString("Name");
        GenericConstructor c = new GenericConstructor(name);
        c.setUniqueId(id);
        Class cls = (Class)this.idToModelElement.get(classId);
        if (cls == null) {
            System.err.println("Error reconstructing constructor: " + name + "(" + classId + ")");
        } else {
            cls.addConstructor((Constructor)c);
        }
        return c;
    }

    private Method loadGenericMethod(ResultSet rs) throws SQLException {
        int id = rs.getInt("Id");
        int classId = rs.getInt("ClassId");
        String name = rs.getString("Name");
        GenericMethod method = new GenericMethod(name);
        method.setUniqueId(id);
        Class cls = (Class)this.idToModelElement.get(classId);
        if (cls != null) {
            cls.addMethod((Method)method);
        } else {
            System.err.println("Error reconstructing method " + name);
        }
        return method;
    }

    private Method loadMethod(ResultSet rs) throws SQLException {
        int id = rs.getInt("Id");
        int classId = rs.getInt("ClassId");
        String name = rs.getString("Name");
        Method method = new Method(name);
        method.setUniqueId(id);
        Class cls = (Class)this.idToModelElement.get(classId);
        if (cls != null) {
            cls.addMethod(method);
        } else {
            System.err.println("Error reconstructing method " + name);
        }
        return method;
    }

    private Constructor loadConstructor(ResultSet rs) throws SQLException {
        int id = rs.getInt("Id");
        int classId = rs.getInt("ClassId");
        String name = rs.getString("Name");
        Constructor c = new Constructor(name);
        c.setUniqueId(id);
        Class cls = (Class)this.idToModelElement.get(classId);
        if (cls == null) {
            System.err.println("Error reconstructing constructor: " + name + "(" + classId + ")");
        } else {
            cls.addConstructor(c);
        }
        return c;
    }

    private Destructor loadDestructor(ResultSet rs) throws SQLException {
        int id = rs.getInt("Id");
        int classId = rs.getInt("ClassId");
        String name = rs.getString("Name");
        Destructor d = new Destructor(name);
        d.setUniqueId(id);
        Class cls = (Class)this.idToModelElement.get(classId);
        cls.addDestructor(d);
        return d;
    }

    private Constructor loadInitializer(ResultSet rs) throws SQLException {
        int id = rs.getInt("Id");
        int classId = rs.getInt("ClassId");
        String name = rs.getString("Name");
        Constructor i = new Constructor(name);
        i.setUniqueId(id);
        i.setInitializer();
        Class cls = (Class)this.idToModelElement.get(classId);
        cls.addConstructor(i);
        return i;
    }

    private void restoreDelegateInvocations() throws SQLException {
        Connection con = this.connectionManager.getConnection();
        Statement stmt = con.createStatement();
        String query = "SELECT * FROM TDelegateInvocations";
        Debug.info((String)(">>> restoreDelegateInvocations :: query =\n" + query + "\n"));
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            int delegateId = rs.getInt("DelegateId");
            int funcId = rs.getInt("FunctionId");
            Delegate d = (Delegate)this.idToModelElement.get(delegateId);
            Function f = (Function)this.idToModelElement.get(funcId);
            d.addInvokedFunction(f);
        }
    }

    private void restoreClones() throws SQLException {
        CloneInstance ci;
        int id;
        Connection con = this.connectionManager.getConnection();
        Statement stmt = con.createStatement();
        String query = "SELECT * FROM TClones";
        Debug.info((String)(">>> restoreClones :: query =\n" + query + "\n"));
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            id = rs.getInt("Id");
            Clone c = new Clone();
            c.setUniqueId(id);
            this.root.addClone(c);
            this.idToModelElement.put(id, c);
        }
        stmt = con.createStatement();
        query = "SELECT * FROM TCloneInstances";
        rs = stmt.executeQuery(query);
        while (rs.next()) {
            id = rs.getInt("Id");
            int cid = rs.getInt("CloneId");
            ci = new CloneInstance();
            ci.setUniqueId(id);
            Clone c = (Clone)this.idToModelElement.get(cid);
            c.addCloneInstance(ci);
            this.idToModelElement.put(id, ci);
        }
        stmt = con.createStatement();
        query = "SELECT * FROM TCloneInstanceStatements";
        rs = stmt.executeQuery(query);
        while (rs.next()) {
            int sid = rs.getInt("StatementId");
            int ciid = rs.getInt("CloneInstanceId");
            ci = (CloneInstance)this.idToModelElement.get(ciid);
            de.fzi.sissy.metamod.Statement s = (de.fzi.sissy.metamod.Statement)this.idToModelElement.get(sid);
            ci.addStatement(s);
        }
    }

    private void restoreStatements() throws SQLException {
        int id;
        Connection con = this.connectionManager.getConnection();
        Statement stmt = con.createStatement();
        String query = "SELECT * FROM TStatements ORDER BY FunctionId, Id";
        Debug.info((String)(">>> restoreStatements :: query =\n" + query + "\n"));
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            id = rs.getInt("Id");
            int kind = rs.getInt("KindOfStatement");
            SimpleStatement st = null;
            if (kind == 71) {
                st = new SimpleStatement();
            } else if (kind == 74) {
                st = new JumpStatement();
                ((JumpStatement)st).setJump();
            } else if (kind == 72) {
                st = new JumpStatement();
                ((JumpStatement)st).setThrow();
            } else if (kind == 73) {
                st = new JumpStatement();
                ((JumpStatement)st).setReturn();
            } else if (kind == 75) {
                st = new LoopStatement(null);
            } else if (kind == 85) {
                st = new LoopStatement(LoopStatement.LoopStatementKind.FOR);
            } else if (kind == 86) {
                st = new LoopStatement(LoopStatement.LoopStatementKind.FOREACH);
            } else if (kind == 87) {
                st = new LoopStatement(LoopStatement.LoopStatementKind.DOWHILE);
            } else if (kind == 88) {
                st = new LoopStatement(LoopStatement.LoopStatementKind.WHILE);
            } else if (kind == 76) {
                st = new BranchStatement();
            } else if (kind == 77) {
                st = new BlockStatement();
            } else if (kind == 79) {
                st = new CatchBlock();
            } else if (kind == 78) {
                st = new ExceptionHandler();
            }
            if (st == null) continue;
            st.setUniqueId(id);
            this.idToModelElement.put(id, st);
        }
        rs = stmt.executeQuery(query);
        while (rs.next()) {
            Function func;
            id = rs.getInt("Id");
            int funcid = rs.getInt("FunctionId");
            int parentid = rs.getInt("ParentStatementId");
            de.fzi.sissy.metamod.Statement st = (de.fzi.sissy.metamod.Statement)this.idToModelElement.get(id);
            if (parentid != -1) {
                de.fzi.sissy.metamod.Statement parentSt = (de.fzi.sissy.metamod.Statement)this.idToModelElement.get(parentid);
                if (parentSt instanceof LoopStatement) {
                    ((LoopStatement)parentSt).setBody(st);
                } else if (parentSt instanceof BranchStatement) {
                    ((BranchStatement)parentSt).addBranch(st);
                } else if (parentSt instanceof CatchBlock) {
                    ((CatchBlock)parentSt).addStatement(st);
                } else if (parentSt instanceof BlockStatement) {
                    ((BlockStatement)parentSt).addStatement(st);
                } else if (parentSt instanceof ExceptionHandler) {
                    ExceptionHandler exHandler = (ExceptionHandler)parentSt;
                    if (exHandler.getGuardedBlock() == null) {
                        exHandler.setGuardedBlock((BlockStatement)st);
                    } else if (st instanceof CatchBlock) {
                        exHandler.addCatchBlock((CatchBlock)st);
                    } else {
                        exHandler.setFinallyBlock((BlockStatement)st);
                    }
                }
                if (st.getParent() != null) continue;
                Debug.warning((String)"Statement parent was not found");
                continue;
            }
            if (!(st instanceof BlockStatement) || (func = (Function)this.idToModelElement.get(funcid)) == null) continue;
            func.setBody((BlockStatement)st);
        }
    }

    private void restoreVariables() throws SQLException {
        Connection con = this.connectionManager.getConnection();
        Statement stmt = con.createStatement();
        String query = "SELECT TVariables.*, TAccesses.Id as AccId, TAccesses.TargetId, TModelElements.ParentId FROM TVariables JOIN TModelElements ON TVariables.Id = TModelElements.Id LEFT OUTER JOIN TAccesses ON TVariables.TypeDeclarationId = TAccesses.Id ORDER BY TVariables.Position";
        Debug.info((String)(">>> restoreVariables :: query =\n" + query + "\n"));
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            GlobalVariable var;
            int id = rs.getInt("Id");
            int kindofvariable = rs.getInt("KindOfVariable");
            if (kindofvariable == 67) {
                var = this.loadGlobalVar(rs);
            } else if (kindofvariable == 66) {
                var = this.loadLocalVar(rs);
            } else if (kindofvariable == 65) {
                var = this.loadFieldVar(rs);
            } else if (kindofvariable == 70) {
                var = this.loadPropertyVar(rs);
            } else if (kindofvariable == 68) {
                var = this.loadFormalParamVar(rs);
            } else if (kindofvariable == 69) {
                var = this.loadCatchParamVar(rs);
            } else {
                Debug.info((String)"Didn't catch this type of variable yet.\n");
                continue;
            }
            var.setConst(rs.getBoolean("IsConst"));
            Type type = (Type)this.idToModelElement.get(rs.getInt("TargetId"));
            if (type != null) {
                DeclarationTypeAccess dta = new DeclarationTypeAccess(type);
                dta.setUniqueId(rs.getInt("AccId"));
                var.setTypeDeclaration(dta);
                this.idToModelElement.put(dta.getUniqueId(), dta);
            }
            this.idToModelElement.put(id, var);
        }
    }

    private GlobalVariable loadGlobalVar(ResultSet rs) throws SQLException {
        int id = rs.getInt("Id");
        int packid = rs.getInt("PackageId");
        String name = rs.getString("Name");
        GlobalVariable globalVar = new GlobalVariable(name);
        globalVar.setUniqueId(id);
        this.root.addGlobalVariable(globalVar);
        Package pack = (Package)this.idToModelElement.get(packid);
        if (pack != null) {
            pack.addGlobalVariable(globalVar);
        }
        return globalVar;
    }

    private LocalVariable loadLocalVar(ResultSet rs) throws SQLException {
        int id = rs.getInt("Id");
        int functionID = rs.getInt("FunctionId");
        String name = rs.getString("Name");
        LocalVariable localVar = new LocalVariable(name);
        localVar.setUniqueId(id);
        Function func = (Function)this.idToModelElement.get(functionID);
        func.addLocalVariable(localVar);
        return localVar;
    }

    private Field loadFieldVar(ResultSet rs) throws SQLException {
        int id = rs.getInt("Id");
        int parentID = rs.getInt("ClassId");
        String name = rs.getString("Name");
        Field field = null;
        if (name.equals("<self>")) {
            field = new Field(name);
            field.setUniqueId(id);
            Class c = (Class)this.idToModelElement.get(parentID);
            c.setSelf(field);
        } else {
            field = new Field(name);
            field.setUniqueId(id);
            Class c = (Class)this.idToModelElement.get(parentID);
            c.addField(field);
        }
        return field;
    }

    private Property loadPropertyVar(ResultSet rs) throws SQLException {
        int id = rs.getInt("Id");
        int parentID = rs.getInt("ClassId");
        int implementedInterfaceId = rs.getInt("ImplementedInterfaceId");
        String name = rs.getString("Name");
        Property p = new Property(name);
        p.setUniqueId(id);
        Class c = (Class)this.idToModelElement.get(parentID);
        if (c != null) {
            c.addProperty(p);
            c = (Class)this.idToModelElement.get(implementedInterfaceId);
            p.setImplementedInterface(c);
        } else {
            System.err.println("Error reconstructing property " + name);
        }
        return p;
    }

    private FormalParameter loadFormalParamVar(ResultSet rs) throws SQLException {
        int id = rs.getInt("Id");
        int parentID = rs.getInt("FunctionId");
        String name = rs.getString("Name");
        FormalParameter formalParam = new FormalParameter(name);
        formalParam.setUniqueId(id);
        if (rs.getBoolean("IsPassedByRef")) {
            formalParam.setPassedByReference();
        } else {
            formalParam.setPassedByValue();
        }
        Function function = (Function)this.idToModelElement.get(parentID);
        function.addFormalParameter(formalParam);
        return formalParam;
    }

    private CatchParameter loadCatchParamVar(ResultSet rs) throws SQLException {
        int id = rs.getInt("Id");
        int parentID = rs.getInt("ParentId");
        String name = rs.getString("Name");
        CatchParameter catchParam = new CatchParameter(name);
        catchParam.setUniqueId(id);
        catchParam.setRethrown(rs.getBoolean("IsRethrown"));
        ModelElement elem = (ModelElement)this.idToModelElement.get(parentID);
        if (elem instanceof CatchBlock) {
            ((CatchBlock)elem).setCatchParameter(catchParam);
        } else if (elem instanceof Function) {
            ((Function)elem).addCatchParameter(catchParam);
        }
        return catchParam;
    }

    private void restoreMembers() throws SQLException {
        Connection con = this.connectionManager.getConnection();
        Statement stmt = con.createStatement();
        String query = "SELECT * FROM TMembers";
        Debug.info((String)(">>> restoreMembers :: query =\n" + query + "\n"));
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            Member m = (Member)this.idToModelElement.get(rs.getInt("Id"));
            if (rs.getBoolean("IsInternal")) {
                m.setInternal(true);
            }
            if (rs.getBoolean("IsAbstract")) {
                m.setAbstract(true);
            }
            if (rs.getBoolean("IsFinal")) {
                m.setFinal(true);
            }
            if (rs.getBoolean("IsStatic")) {
                m.setStatic(true);
            }
            if (rs.getBoolean("IsVirtual")) {
                m.setVirtual(true);
            }
            if (rs.getBoolean("IsExtern")) {
                m.setExtern(true);
            }
            if (rs.getBoolean("IsNew")) {
                m.setNew();
            }
            if (rs.getBoolean("IsOverride")) {
                m.setOverride();
            }
            int omid = rs.getInt("OverridenMemberId");
            Member om = null;
            if (omid != -1) {
                om = (Member)this.idToModelElement.get(omid);
                m.setOverridenMember(om);
            }
            switch (rs.getInt("Visibility")) {
                case 149: {
                    m.setPrivate();
                    break;
                }
                case 146: {
                    m.setProtected();
                    break;
                }
                case 147: {
                    m.setStrictProtected();
                    break;
                }
                case 145: {
                    m.setPublic();
                    break;
                }
                case 148: {
                    m.setPackage();
                }
            }
            if (!rs.getBoolean("IsIntrospectable")) continue;
            m.setIntrospectable(true);
        }
    }

    private void restorePropertyAccessors() throws SQLException {
        Connection con = this.connectionManager.getConnection();
        Statement stmt = con.createStatement();
        String query = "SELECT TModelElements.* FROM TModelElements, TConstants WHERE TModelElements.KindOfElement = TConstants.Value AND TConstants.Name LIKE 'FUNC_PROP%'";
        Debug.info((String)(">>> restorePropertyAccessors :: query =\n" + query + "\n"));
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            int id = rs.getInt("Id");
            int propId = rs.getInt("ParentId");
            int kind = rs.getInt("KindOfElement");
            Method m = (Method)this.idToModelElement.get(id);
            Property prop = (Property)this.idToModelElement.get(propId);
            if (kind == 56) {
                prop.setGetter(m);
                continue;
            }
            prop.setSetter(m);
        }
    }

    private void restoreFileInclusionsAndImports() throws SQLException {
        Connection con = this.connectionManager.getConnection();
        Statement stmt = con.createStatement();
        String query = "SELECT * FROM TImports";
        Debug.info((String)(">>> restoreFileInclusionsAndImports :: query =\n" + query + "\n"));
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            int fileid = rs.getInt("FileId");
            int targetid = rs.getInt("TargetId");
            File file = (File)this.idToModelElement.get(fileid);
            ModelElement target = (ModelElement)this.idToModelElement.get(targetid);
            if (target instanceof File) {
                file.addIncludedFile((File)target);
                continue;
            }
            if (target instanceof Package) {
                file.addImportedPackage((Package)target);
                continue;
            }
            if (target instanceof Type) {
                file.addImportedType((Type)target);
                continue;
            }
            if (target instanceof GlobalFunction) {
                file.addImportedGlobalFunction((GlobalFunction)target);
                continue;
            }
            if (!(target instanceof GlobalVariable)) continue;
            file.addGlobalVariable((GlobalVariable)target);
        }
    }

    private void restoreAccesses() throws SQLException {
        Connection con = this.connectionManager.getConnection();
        Statement stmt = con.createStatement();
        String query = "SELECT a.* FROM TAccesses a join TConstants c on a.kindOfAccess = c.value and c.name != 'TYPEACCESS_DECLARATION' ORDER BY a.SourceId, a.Position";
        Debug.info((String)(">>> restoreAccesses :: query =\n" + query + "\n"));
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            VariableAccess acc;
            Variable target;
            FunctionAccess acc2;
            int id = rs.getInt("Id");
            int kindofaccess = rs.getInt("KindOfAccess");
            int targetId = rs.getInt("TargetId");
            int sourceId = rs.getInt("SourceId");
            int funcId = rs.getInt("FunctionId");
            ModelElement elem = (ModelElement)this.idToModelElement.get(sourceId);
            if (elem == null) {
                elem = (ModelElement)this.idToModelElement.get(funcId);
            }
            if (kindofaccess == 97) {
                Function target2 = (Function)this.idToModelElement.get(targetId);
                acc2 = new FunctionAccess(target2);
                acc2.setUniqueId(id);
                if (elem instanceof CompositeAccess) {
                    ((CompositeAccess)elem).addAccess((Access)acc2);
                } else if (elem instanceof de.fzi.sissy.metamod.Statement) {
                    ((de.fzi.sissy.metamod.Statement)elem).addAccess((Access)acc2);
                } else if (elem instanceof Function) {
                    ((Function)elem).addAccess((Access)acc2);
                }
                this.idToModelElement.put(id, acc2);
                continue;
            }
            if (kindofaccess == 98) {
                Delegate target3 = (Delegate)this.idToModelElement.get(targetId);
                acc2 = new DelegateAccess(target3);
                acc2.setUniqueId(id);
                if (elem instanceof CompositeAccess) {
                    ((CompositeAccess)elem).addAccess((Access)acc2);
                } else if (elem instanceof de.fzi.sissy.metamod.Statement) {
                    ((de.fzi.sissy.metamod.Statement)elem).addAccess((Access)acc2);
                } else if (elem instanceof Function) {
                    ((Function)elem).addAccess((Access)acc2);
                }
                this.idToModelElement.put(id, acc2);
                continue;
            }
            if (kindofaccess == 82 || kindofaccess == 81) {
                boolean pWrite = false;
                if (kindofaccess == 82) {
                    pWrite = true;
                }
                target = (Variable)this.idToModelElement.get(targetId);
                acc = new VariableAccess(target, pWrite);
                acc.setUniqueId(id);
                if (elem instanceof CompositeAccess) {
                    ((CompositeAccess)elem).addAccess((Access)acc);
                } else if (elem instanceof de.fzi.sissy.metamod.Statement) {
                    ((de.fzi.sissy.metamod.Statement)elem).addAccess((Access)acc);
                } else if (elem instanceof Function) {
                    ((Function)elem).addAccess((Access)acc);
                }
                this.idToModelElement.put(id, acc);
                continue;
            }
            if (kindofaccess == 84 || kindofaccess == 83) {
                boolean pWrite = false;
                if (kindofaccess == 84) {
                    pWrite = true;
                }
                target = (Property)this.idToModelElement.get(targetId);
                acc = new PropertyAccess((Property)target, pWrite);
                acc.setUniqueId(id);
                if (elem instanceof CompositeAccess) {
                    ((CompositeAccess)elem).addAccess((Access)acc);
                } else if (elem instanceof de.fzi.sissy.metamod.Statement) {
                    ((de.fzi.sissy.metamod.Statement)elem).addAccess((Access)acc);
                } else if (elem instanceof Function) {
                    ((Function)elem).addAccess((Access)acc);
                }
                this.idToModelElement.put(id, acc);
                continue;
            }
            if (kindofaccess == 94 || kindofaccess == 95) {
                Variable target4 = (Variable)this.idToModelElement.get(targetId);
                acc2 = new SelfAccess((Class)target4.getType());
                if (kindofaccess == 95) {
                    acc2.setSuperAccess(true);
                }
                acc2.setUniqueId(id);
                if (elem instanceof CompositeAccess) {
                    ((CompositeAccess)elem).addAccess((Access)acc2);
                } else if (elem instanceof de.fzi.sissy.metamod.Statement) {
                    ((de.fzi.sissy.metamod.Statement)elem).addAccess((Access)acc2);
                } else if (elem instanceof Function) {
                    ((Function)elem).addAccess((Access)acc2);
                }
                this.idToModelElement.put(id, acc2);
                continue;
            }
            if (kindofaccess == 96) {
                CompositeAccess acc3 = new CompositeAccess();
                acc3.setUniqueId(id);
                if (elem instanceof CompositeAccess) {
                    ((CompositeAccess)elem).addAccess((Access)acc3);
                } else if (elem instanceof de.fzi.sissy.metamod.Statement) {
                    ((de.fzi.sissy.metamod.Statement)elem).addAccess((Access)acc3);
                } else if (elem instanceof Function) {
                    ((Function)elem).addAccess((Access)acc3);
                }
                this.idToModelElement.put(id, acc3);
                continue;
            }
            if (kindofaccess == 118) {
                Type target5 = (Type)this.idToModelElement.get(targetId);
                acc2 = new CastTypeAccess(target5);
                acc2.setUniqueId(id);
                if (elem instanceof CompositeAccess) {
                    ((CompositeAccess)elem).addAccess((Access)acc2);
                } else if (elem instanceof de.fzi.sissy.metamod.Statement) {
                    ((de.fzi.sissy.metamod.Statement)elem).addAccess((Access)acc2);
                } else if (elem instanceof Function) {
                    ((Function)elem).addAccess((Access)acc2);
                }
                this.idToModelElement.put(id, acc2);
                continue;
            }
            if (kindofaccess == 120) {
                Type target6 = (Type)this.idToModelElement.get(targetId);
                acc2 = new StaticTypeAccess(target6);
                acc2.setUniqueId(id);
                if (elem instanceof CompositeAccess) {
                    ((CompositeAccess)elem).addAccess((Access)acc2);
                } else if (elem instanceof de.fzi.sissy.metamod.Statement) {
                    ((de.fzi.sissy.metamod.Statement)elem).addAccess((Access)acc2);
                } else if (elem instanceof Function) {
                    ((Function)elem).addAccess((Access)acc2);
                }
                this.idToModelElement.put(id, acc2);
                continue;
            }
            if (kindofaccess == 119) {
                Type target7 = (Type)this.idToModelElement.get(targetId);
                acc2 = new RunTimeTypeAccess(target7);
                acc2.setUniqueId(id);
                if (elem instanceof CompositeAccess) {
                    ((CompositeAccess)elem).addAccess((Access)acc2);
                } else if (elem instanceof de.fzi.sissy.metamod.Statement) {
                    ((de.fzi.sissy.metamod.Statement)elem).addAccess((Access)acc2);
                } else if (elem instanceof Function) {
                    ((Function)elem).addAccess((Access)acc2);
                }
                this.idToModelElement.put(id, acc2);
                continue;
            }
            if (kindofaccess == 116 || kindofaccess == 115) {
                Type target8 = (Type)this.idToModelElement.get(targetId);
                acc2 = new ThrowTypeAccess(target8);
                if (kindofaccess == 115) {
                    acc2.setDeclared(true);
                } else {
                    acc2.setDeclared(false);
                }
                acc2.setUniqueId(id);
                if (elem instanceof de.fzi.sissy.metamod.Statement) {
                    ((de.fzi.sissy.metamod.Statement)elem).addAccess((Access)acc2);
                } else if (elem instanceof Function) {
                    ((Function)elem).addAccess((Access)acc2);
                }
                this.idToModelElement.put(id, acc2);
                continue;
            }
            if (kindofaccess != 114 && kindofaccess != 113) continue;
            Type target9 = (Type)this.idToModelElement.get(targetId);
            acc2 = new InheritanceTypeAccess((Class)target9);
            if (kindofaccess == 114) {
                acc2.setImplementationInheritance();
            } else {
                acc2.setInterfaceInheritance();
            }
            acc2.setUniqueId(id);
            Class c = (Class)this.idToModelElement.get(sourceId);
            c.addInheritanceTypeAccess((InheritanceTypeAccess)acc2);
            this.idToModelElement.put(id, acc2);
        }
    }

    private void restoreTypeArguments() throws SQLException {
        Connection con = this.connectionManager.getConnection();
        Statement stmt = con.createStatement();
        String query = "SELECT * FROM TTypeArguments JOIN TTypeParameters ON TTypeArguments.TypeParameterId = TTypeParameters.TypeParameterId ORDER BY AccessId, Position";
        Debug.info((String)(">>> restoreTypeArguments :: query =\n" + query + "\n"));
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            int accId = rs.getInt("AccessId");
            int typeId = rs.getInt("TargetTypeId");
            Access acc = (Access)this.idToModelElement.get(accId);
            Type type = (Type)this.idToModelElement.get(typeId);
            if (acc instanceof TypeAccess) {
                ((TypeAccess)acc).addTypeArg(type);
                continue;
            }
            if (!(acc instanceof FunctionAccess)) continue;
            ((FunctionAccess)acc).addTypeArg(type);
        }
    }

    private void restoreStructuralAbstractions() throws SQLException {
        int id;
        Connection con = this.connectionManager.getConnection();
        Statement stmt = con.createStatement();
        String query = "SELECT * FROM TAbstractions";
        Debug.info((String)(">>> restoreAbstractions :: query =\n" + query + "\n"));
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            id = rs.getInt("Id");
            int kind = rs.getInt("KindOfAbstraction");
            String name = rs.getString("Name");
            String type = rs.getString("Type");
            Object a = kind == 124 ? new Subsystem(name) : new StructuralAbstraction(name, type);
            a.setUniqueId(id);
            this.root.addStructuralAbstraction((StructuralAbstraction)a);
            this.idToModelElement.put(id, a);
        }
        stmt = con.createStatement();
        query = "SELECT * FROM TAbstractionElements";
        rs = stmt.executeQuery(query);
        while (rs.next()) {
            id = rs.getInt("AbstractionId");
            int elemId = rs.getInt("ModelElementId");
            ModelElement elem = (ModelElement)this.idToModelElement.get(elemId);
            StructuralAbstraction a = (StructuralAbstraction)this.idToModelElement.get(id);
            a.addModelElement(elem);
        }
    }

    private void restoreComments() throws SQLException {
        Connection con = this.connectionManager.getConnection();
        Statement stmt = con.createStatement();
        String query = "SELECT * FROM TComments";
        Debug.info((String)(">>> restoreComments :: query =\n" + query + "\n"));
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            int id = rs.getInt("Id");
            int formal = rs.getInt("IsFormal");
            int todo = rs.getInt("NumberOfTodos");
            String text = rs.getString("CommentText");
            Comment c = new Comment(formal == 1, text, todo);
            c.setUniqueId(id);
            this.idToModelElement.put(id, c);
        }
    }

    private void restorePositions() throws SQLException {
        Connection con = this.connectionManager.getConnection();
        Statement stmt = con.createStatement();
        String query = "SELECT * FROM TSourceEntities";
        Debug.info((String)(">>> restorePositions :: query =\n" + query + "\n"));
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            int id = rs.getInt("Id");
            SourceEntity element = (SourceEntity)this.idToModelElement.get(id);
            Position pos = this.loadPosition(rs);
            if (element == null) continue;
            element.setPosition(pos);
        }
    }

    private Position loadPosition(ResultSet rs) throws SQLException {
        Position pos;
        int srcFileId = rs.getInt("SourceFileId");
        int startline = rs.getInt("StartLine");
        int startchar = rs.getInt("StartChar");
        int endline = rs.getInt("EndLine");
        int endchar = rs.getInt("EndChar");
        int assemblyId = rs.getInt("AssemblyFileId");
        File srcFile = (File)this.idToModelElement.get(srcFileId);
        File assemblyFile = (File)this.idToModelElement.get(assemblyId);
        if (srcFile == null && assemblyFile == null) {
            pos = new Position(null, -1, -1, -1, -1);
        } else {
            pos = new Position(srcFile, startline, startchar, endline, endchar);
            if (assemblyFile != null) {
                pos.setAssembly(assemblyFile);
            }
        }
        return pos;
    }

    private void restoreAnnotationsAndStatus() throws SQLException {
        Connection con = this.connectionManager.getConnection();
        Statement stmt = con.createStatement();
        String query = "SELECT elem.* FROM TModelElements elem JOIN TConstants c on elem.Status = c.Value and c.Name != 'STATUS_NORMAL'";
        Debug.info((String)(">>> restoreStatus :: query =\n" + query + "\n"));
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            ModelElement elem = (ModelElement)this.idToModelElement.get(rs.getInt("Id"));
            if (elem == null) continue;
            elem.setStatus(rs.getInt("Status"));
        }
        stmt = con.createStatement();
        query = "SELECT * FROM TAnnotations ORDER BY ModelElementId, AnnotationId";
        Debug.info((String)(">>> restoreAnnotations :: query =\n" + query + "\n"));
        rs = stmt.executeQuery(query);
        while (rs.next()) {
            int elemId = rs.getInt("ModelElementId");
            int annId = rs.getInt("AnnotationId");
            ModelElement elem = (ModelElement)this.idToModelElement.get(elemId);
            ModelAnnotation ann = (ModelAnnotation)this.idToModelElement.get(annId);
            if (elem == null || ann == null || ann instanceof CloneInstance) continue;
            elem.addAnnotation(ann);
        }
    }

    public Root getRoot() {
        return this.root;
    }

    public static void main(String[] args) {
        new ModelImporter();
    }
}

