/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.persistence;

import de.fzi.sissy.persistence.Activator;
import de.fzi.sissy.persistence.JDBCError;
import de.fzi.sissy.persistence.config.DatabaseConfiguration;
import de.fzi.sissy.utils.Debug;
import de.fzi.sissy.utils.FileLoader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.osgi.framework.Bundle;

public class JDBCWrapper {
    private DatabaseConfiguration myConfiguration = null;
    private Connection jdbcConnection;

    public Connection getJdbcConnection() {
        return this.jdbcConnection;
    }

    public static JDBCWrapper createJDBCWrapper(DatabaseConfiguration configuration) {
        return new JDBCWrapper(configuration);
    }

    public JDBCWrapper(DatabaseConfiguration myConfig) {
        Debug.debug((String)("Initialising JDBC Wrapper using " + myConfig.toString()));
        this.myConfiguration = myConfig;
    }

    public void runScripts() {
        InputStreamReader inputStreamReader;
        Bundle bundle;
        if (this.myConfiguration.getDatabaseInitscriptFile() == null && this.myConfiguration.getDatabaseEmptyscriptFile() == null) {
            throw new JDBCError(new IllegalStateException("No scripts specified that could be run."));
        }
        if (this.myConfiguration.getDatabaseEmptyscriptFile() != null && this.myConfiguration.getDatabaseEmptyscriptFile().length() > 0) {
            bundle = Activator.getDefault().getBundle();
            inputStreamReader = FileLoader.openAsInputStreamReader((String)this.myConfiguration.getDatabaseEmptyscriptFile(), (Bundle)bundle);
            if (inputStreamReader != null) {
                try {
                    this.runScript(inputStreamReader);
                }
                catch (Exception e) {
                    Debug.info((String)"Empty script not applied, since DB is non existing, but will be created now.");
                    e.printStackTrace();
                }
            }
        }
        if (this.myConfiguration.getDatabaseInitscriptFile() != null && this.myConfiguration.getDatabaseInitscriptFile().length() > 0) {
            bundle = Activator.getDefault().getBundle();
            inputStreamReader = FileLoader.openAsInputStreamReader((String)this.myConfiguration.getDatabaseInitscriptFile(), (Bundle)bundle);
            if (inputStreamReader != null) {
                this.runScript(inputStreamReader);
            }
        }
    }

    public void printScripts(PrintWriter out) {
        try {
            FileReader dbFile;
            if (this.myConfiguration.getDatabaseEmptyscriptFile() == null && this.myConfiguration.getDatabaseInitscriptFile() == null) {
                throw new JDBCError(new IllegalStateException("No scripts specified that could be printed."));
            }
            if (this.myConfiguration.getDatabaseEmptyscriptFile().length() > 0) {
                dbFile = new FileReader(this.myConfiguration.getDatabaseEmptyscriptFile());
                this.printScript(dbFile, out);
            }
            if (this.myConfiguration.getDatabaseInitscriptFile().length() > 0) {
                dbFile = new FileReader(this.myConfiguration.getDatabaseInitscriptFile());
                this.printScript(dbFile, out);
            }
        }
        catch (FileNotFoundException e) {
            Debug.error((String)"File not found", (Throwable)e);
            throw new JDBCError(e);
        }
    }

    private void printScript(Reader input, PrintWriter out) {
        try {
            String line;
            BufferedReader inputFile = new BufferedReader(input);
            StringBuffer stmtBuffer = new StringBuffer();
            while ((line = inputFile.readLine()) != null) {
                stmtBuffer.append(line.trim()).append(" ");
                if (line.indexOf(";") == -1) continue;
                stmtBuffer.delete(stmtBuffer.indexOf(";") + 1, stmtBuffer.length());
                out.println(stmtBuffer.toString().trim());
                stmtBuffer = new StringBuffer(line.substring(line.indexOf(";") + 1).trim());
                stmtBuffer.append(" ");
            }
            inputFile.close();
        }
        catch (IOException ex) {
            Debug.error((String)"IO Exception", (Throwable)ex);
            throw new JDBCError(ex);
        }
    }

    public void runScript(Reader input) {
        this.getConnection();
        try {
            String line;
            BufferedReader inputFile = new BufferedReader(input);
            this.jdbcConnection.setAutoCommit(true);
            Statement stmt = this.jdbcConnection.createStatement();
            StringBuffer stmtBuffer = new StringBuffer();
            while ((line = inputFile.readLine()) != null) {
                stmtBuffer.append(line.trim()).append(" ");
                if (line.indexOf(";") != -1) {
                    stmtBuffer.delete(stmtBuffer.indexOf(";") + 1, stmtBuffer.length());
                    try {
                        if (this.myConfiguration.getDatabaseDriver().contains("derby")) {
                            stmt.execute(stmtBuffer.toString().trim().replace(";", ""));
                        } else {
                            stmt.execute(stmtBuffer.toString().trim());
                        }
                    }
                    catch (SQLException e) {
                        if (this.myConfiguration.getDatabaseDriver().contains("derby")) {
                            Debug.info((String)"Executing of scripts skipped due to derby usage.");
                            return;
                        }
                        if (this.myConfiguration.getDatabaseDriver().contains("postgresql")) {
                            if (!(stmtBuffer.toString().toLowerCase().trim().startsWith("drop table") && e.getSQLState().equals("42P01") || stmtBuffer.toString().toLowerCase().trim().startsWith("create table") && e.getSQLState().equals("42P07"))) {
                                Debug.warning((String)("Database table creation/deletion failed: " + e.getLocalizedMessage()));
                            }
                        }
                        Debug.warning((String)("Database table creation/deletion failed: " + e.getLocalizedMessage()));
                    }
                    stmtBuffer = new StringBuffer(line.substring(line.indexOf(";") + 1).trim());
                    stmtBuffer.append(" ");
                } else {
                    try {
                        if (stmtBuffer.toString().trim() != "") {
                            stmt.execute(stmtBuffer.toString().trim());
                        }
                    }
                    catch (SQLException e) {
                        if (this.myConfiguration.getDatabaseDriver().contains("derby")) {
                            Debug.info((String)"Executing of scripts skipped due to derby usage.");
                            return;
                        }
                        if (this.myConfiguration.getDatabaseDriver().contains("postgresql")) {
                            if (!(stmtBuffer.toString().toLowerCase().trim().startsWith("drop table") && e.getSQLState().equals("42Y55") || stmtBuffer.toString().toLowerCase().trim().startsWith("drop table") && e.getSQLState().equals("42P01") || stmtBuffer.toString().toLowerCase().trim().startsWith("create table") && e.getSQLState().equals("42P07") || stmtBuffer.toString().toLowerCase().trim().startsWith("alter table") && e.getSQLState().equals("42X86") || stmtBuffer.toString().toLowerCase().trim().startsWith("create table") && e.getSQLState().equals("42Y07") || stmtBuffer.toString().toLowerCase().trim().startsWith("drop table") && e.getSQLState().equals("42Y07"))) {
                                Debug.error((String)e.getSQLState());
                                return;
                            }
                        }
                        Debug.error((String)e.getSQLState());
                        return;
                    }
                }
                stmtBuffer = new StringBuffer();
            }
            inputFile.close();
        }
        catch (IOException ex) {
            Debug.error((String)("Exception occured in IO: " + ex.getLocalizedMessage()));
            throw new JDBCError(ex);
        }
        catch (SQLException ex) {
            Debug.error((String)("Execption occured in SQL Transaction: " + ex.getLocalizedMessage()));
            throw new JDBCError(ex);
        }
    }

    public void dropTable(String tableName) {
        this.getConnection();
        try {
            Statement statement = this.jdbcConnection.createStatement();
            statement.executeUpdate("drop table " + tableName);
        }
        catch (SQLException sQLException) {
            Debug.debug((String)"Tried to drop non-existing table");
        }
    }

    public void createTable(String tableName, String columString, boolean dropBeforeCreate) {
        if (dropBeforeCreate) {
            this.dropTable(tableName);
        }
        this.getConnection();
        try {
            Statement statement = this.jdbcConnection.createStatement();
            statement.executeUpdate("CREATE TABLE " + tableName + " ( " + columString + ")");
        }
        catch (SQLException e) {
            Debug.error((String)("Excpetion occured while trying to create database tables: " + e.getLocalizedMessage()));
            throw new JDBCError(e);
        }
    }

    public void runStatements(Reader input) {
        this.getConnection();
        try {
            String line;
            BufferedReader inputFile = new BufferedReader(input);
            long count = 0L;
            this.jdbcConnection.setAutoCommit(false);
            Statement stmt = this.jdbcConnection.createStatement();
            while ((line = inputFile.readLine()) != null) {
                if (count == 10000L) {
                    count = 0L;
                    stmt.executeBatch();
                    stmt.clearBatch();
                }
                ++count;
                if (this.myConfiguration.getDatabaseDriver().contains("derby")) {
                    line = line.replace(";", "");
                }
                stmt.addBatch(line);
            }
            inputFile.close();
            stmt.executeBatch();
            this.jdbcConnection.commit();
            this.jdbcConnection.setAutoCommit(true);
            this.closeConnection();
        }
        catch (IOException ex) {
            Debug.error((String)("IO Exception occured while doing IO: " + ex.getLocalizedMessage()));
            throw new JDBCError(ex);
        }
        catch (SQLException e) {
            Debug.error((String)("Exception occured while executing SQL Statement: " + e.getLocalizedMessage()));
            SQLException e2 = e.getNextException();
            if (e2 != null) {
                Debug.error((String)("Exception occured while executing SQL Statement: " + e2.getLocalizedMessage()));
            }
            throw new JDBCError(e);
        }
    }

    public void runStatements(InputStream input) {
        this.runStatements(new InputStreamReader(input));
    }

    public Connection getConnection() throws JDBCError {
        if (this.jdbcConnection == null) {
            Debug.debug((String)("Loading DB driver from class " + this.myConfiguration.getDatabaseDriver()));
            try {
                Class<?> dbDriverClass = Class.forName(this.myConfiguration.getDatabaseDriver());
                Debug.debug((String)("Found class " + dbDriverClass.getCanonicalName()));
            }
            catch (Exception e) {
                Debug.error((String)"Failed to load database driver");
                throw new JDBCError(e);
            }
            try {
                Properties props = new Properties();
                props.put("user", this.myConfiguration.getDatabaseUsername());
                props.put("password", this.myConfiguration.getDatabasePassword());
                this.jdbcConnection = DriverManager.getConnection(this.myConfiguration.getDatabaseURL(), props);
            }
            catch (SQLException e) {
                Debug.error((String)("Error accessing database: " + e.getLocalizedMessage()));
                throw new JDBCError(e);
            }
        }
        return this.jdbcConnection;
    }

    public ResultSet executeQuery(String query) {
        ResultSet rs;
        block4: {
            query = this.myConfiguration.formatSQLStatement(query);
            rs = null;
            try {
                Statement stmt = this.jdbcConnection.createStatement();
                if (this.isResultQuery(query)) {
                    rs = stmt.executeQuery(query);
                } else {
                    stmt.execute(query);
                }
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("02000")) break block4;
                Debug.error((String)("Exception while executing SDQ Query: " + e.getLocalizedMessage()));
                throw new JDBCError(e);
            }
        }
        return rs;
    }

    private boolean isResultQuery(String query) {
        if (query.toLowerCase().contains("insert")) {
            return false;
        }
        if (query.toLowerCase().contains("create")) {
            return false;
        }
        if (query.toLowerCase().contains("drop")) {
            return false;
        }
        return query.toLowerCase().contains("select");
    }

    public String getDBName() {
        return this.myConfiguration.getDatabaseName();
    }

    public void closeConnection() {
        if (this.myConfiguration.getDatabaseDriver().contains("derby")) {
            this.shutdownDerby();
        } else if (this.jdbcConnection != null) {
            try {
                this.jdbcConnection.close();
            }
            catch (SQLException e) {
                Debug.debug((String)("Failure closing database: " + e.getLocalizedMessage()));
            }
        }
        this.jdbcConnection = null;
    }

    private void shutdownDerby() {
        try {
            Debug.debug((String)(String.valueOf(this.myConfiguration.getDatabaseURL().toString().split(";")[0]) + ";shutdown=true"));
            DriverManager.getConnection(String.valueOf(this.myConfiguration.getDatabaseURL().toString().split(";")[0]) + ";shutdown=true");
        }
        catch (SQLException se) {
            if (se.getErrorCode() == 50000 && "XJ015".equals(se.getSQLState()) || se.getSQLState().equals("08006")) {
                Debug.debug((String)"Derby shut down normally");
            }
            Debug.error((String)("Derby Shutdown failed: " + se.getMessage()));
        }
    }

    public ResultSet executeQuery(Statement stmt, String query) throws SQLException {
        if (this.myConfiguration.getDatabaseDriver().contains("derby")) {
            query = query.replace(";", "");
        }
        return stmt.executeQuery(query);
    }
}

