/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.main.jobs;

import de.fzi.sissy.extractors.ExtractorConfiguration;
import de.fzi.sissy.extractors.java.Extractor;
import de.fzi.sissy.utils.Debug;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import org.eclipse.core.runtime.IProgressMonitor;

public class JavaExtractionJob
implements IJob {
    private ExtractorConfiguration extractorConfiguration;

    public JavaExtractionJob(ExtractorConfiguration extractorConfiguration) {
        this.extractorConfiguration = extractorConfiguration;
        Debug.println((String)extractorConfiguration.toString());
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        Debug.info((String)"java extraction job started");
        for (String folder : this.extractorConfiguration.getInputDirectoryPaths()) {
            Debug.debug((String)("Extracting folders: " + folder));
        }
        monitor.beginTask("extract java code", -1);
        try {
            new Extractor(this.extractorConfiguration).extract(monitor);
        }
        catch (UserCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobFailedException("Java extractor failed!", (Throwable)e);
        }
        monitor.done();
    }

    public String getName() {
        return "Java Fact Extraction";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }
}

