/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.main.jobs;

import de.fzi.sissy.main.configurations.ExpressionExportConfiguration;
import de.fzi.sissy.metamod.ModelElementRepository;
import de.fzi.sissy.utils.Debug;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import org.eclipse.core.runtime.IProgressMonitor;

public class ExportExpressionsJob
implements IJob {
    private ModelElementRepository modelRepository = null;
    private String filename;

    public ExportExpressionsJob(ExpressionExportConfiguration expressionExportConfiguration, ModelElementRepository repository) {
        this.modelRepository = repository;
        this.filename = expressionExportConfiguration.getExpressionFilePath();
        Debug.info((String)("export expressions to: " + this.filename));
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        monitor.beginTask("Export Expressions", -1);
        try {
            this.modelRepository.exportExpressionsToXML(this.filename);
        }
        catch (Exception e) {
            throw new JobFailedException("Export Expressions failed!", (Throwable)e);
        }
        monitor.done();
    }

    public String getName() {
        return "Export Expressions";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }
}

