/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.main.configurations;

import de.fzi.sissy.dashboardgenerator.DashboardGeneratorConfiguration;
import de.fzi.sissy.exporters.graphml.GraphMLExportConfiguration;
import de.fzi.sissy.extractors.ExtractorConfiguration;
import de.fzi.sissy.gastimporter.GASTImporterConfiguration;
import de.fzi.sissy.main.configurations.AnalysisConfiguration;
import de.fzi.sissy.main.configurations.ExpressionExportConfiguration;
import de.fzi.sissy.metrics.MetricCalculationConfiguration;
import de.fzi.sissy.persistence.ExportConfiguration;
import de.fzi.sissy.persistence.config.DatabaseConfiguration;
import de.fzi.sissy.persistence.config.NullDatabaseConfiguration;
import de.uka.ipd.sdq.workflow.AbstractComposedJobConfiguration;
import de.uka.ipd.sdq.workflow.AbstractJobConfiguration;
import de.uka.ipd.sdq.workflow.IJobConfiguration;

public class SISSyConfiguration
extends AbstractComposedJobConfiguration
implements IJobConfiguration {
    private static final int DATABASE_CONFIG_ID = 0;
    private static final int EXPORT_CONFIGURATION_ID = 1;
    private static final int EXTRACTOR_CONFIGURATION_ID = 2;
    private static final int ANALYSIS_CONFIGURATION_ID = 3;
    private static final int EXPRESSION_EXPORT_CONFIGURATION_ID = 4;
    private static final int GAST_IMPORTER_CONFIGURATION = 5;
    private static final int GRAPHML_EXPORTER_CONFIGURATION = 6;
    private static final int METRIC_CALCULATION_CONFIGURATION = 7;

    public SISSyConfiguration(DatabaseConfiguration dbConfig) {
        this.addChildConfiguration(0, (AbstractJobConfiguration)dbConfig);
        this.addChildConfiguration(1, (AbstractJobConfiguration)new ExportConfiguration());
        this.addChildConfiguration(2, (AbstractJobConfiguration)new ExtractorConfiguration());
        this.addChildConfiguration(3, (AbstractJobConfiguration)new AnalysisConfiguration(new DashboardGeneratorConfiguration(dbConfig)));
        this.addChildConfiguration(4, new ExpressionExportConfiguration());
        this.addChildConfiguration(5, (AbstractJobConfiguration)new GASTImporterConfiguration(dbConfig));
        this.addChildConfiguration(6, (AbstractJobConfiguration)new GraphMLExportConfiguration());
        this.addChildConfiguration(7, (AbstractJobConfiguration)new MetricCalculationConfiguration());
        this.getExportConfiguration().setDatabaseConfiguration(this.getDatabaseConfiguration());
    }

    public void setDatabaseConfiguration(DatabaseConfiguration dbConfig) {
        this.addChildConfiguration(0, (AbstractJobConfiguration)dbConfig);
        this.getExportConfiguration().setDatabaseConfiguration(dbConfig);
        this.getAnalysisConfiguration().getDashboardGeneratorConfiguration().setDatabaseConfiguration(dbConfig);
        this.getGASTImporterConfiguration().setDatabaseConfiguration(dbConfig);
    }

    public DatabaseConfiguration getDatabaseConfiguration() {
        return (DatabaseConfiguration)this.getChildConfiguration(0);
    }

    public ExtractorConfiguration getExtractorConfiguration() {
        return (ExtractorConfiguration)this.getChildConfiguration(2);
    }

    public AnalysisConfiguration getAnalysisConfiguration() {
        return (AnalysisConfiguration)this.getChildConfiguration(3);
    }

    public ExpressionExportConfiguration getExpressionExportConfiguration() {
        return (ExpressionExportConfiguration)this.getChildConfiguration(4);
    }

    public ExportConfiguration getExportConfiguration() {
        return (ExportConfiguration)this.getChildConfiguration(1);
    }

    public GASTImporterConfiguration getGASTImporterConfiguration() {
        return (GASTImporterConfiguration)this.getChildConfiguration(5);
    }

    public GraphMLExportConfiguration getGraphMLExportConfiguration() {
        return (GraphMLExportConfiguration)this.getChildConfiguration(6);
    }

    public MetricCalculationConfiguration getMetricCalculationConfiguration() {
        return (MetricCalculationConfiguration)this.getChildConfiguration(7);
    }

    public boolean doRunSissy() {
        return true;
    }

    public String getErrorMessage() {
        String result = super.getErrorMessage();
        String string = result = result == null ? "" : result;
        if (this.getExportConfiguration().isDoExportModel() && this.getExportConfiguration().getDatabaseConfiguration() instanceof NullDatabaseConfiguration) {
            result = String.valueOf(result) + "Need a valid Database configuration to export SISSy model\n";
        }
        if (this.getAnalysisConfiguration().isDoProblemPatternAnalysis() && this.getAnalysisConfiguration().getQueryFilenames().isEmpty()) {
            result = String.valueOf(result) + "Please select at least one Problem Pattern\n";
        }
        if (!this.getExtractorConfiguration().isRunExtraction() && this.getGraphMLExportConfiguration().isRunExport()) {
            result = String.valueOf(result) + "GraphML Export requires to run SISSy extraction \n";
        }
        if (this.getGASTImporterConfiguration().isDoExportGAST() && this.getDatabaseConfiguration() instanceof NullDatabaseConfiguration) {
            result = String.valueOf(result) + "GAST Export requires database\n";
        }
        if (this.getMetricCalculationConfiguration().isDoMetricCalculation() && !this.getExtractorConfiguration().isRunExtraction()) {
            result = String.valueOf(result) + "Metrics Calculation requires to run SISSy extraction \n";
        } else if (this.getMetricCalculationConfiguration().isDoMetricCalculation() && this.getMetricCalculationConfiguration().getSelectedMetrics().isEmpty()) {
            result = String.valueOf(result) + "Please select at least one Metric\n";
        }
        return result.equals("") ? null : result;
    }
}

