/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.meta;

import de.fzi.sissy.extractors.meta.GeneralCollector;
import de.fzi.sissy.extractors.meta.GeneralMapper;
import de.fzi.sissy.metamod.Access;
import de.fzi.sissy.metamod.Array;
import de.fzi.sissy.metamod.BlockStatement;
import de.fzi.sissy.metamod.CastTypeAccess;
import de.fzi.sissy.metamod.Class;
import de.fzi.sissy.metamod.Constructor;
import de.fzi.sissy.metamod.DeclarationTypeAccess;
import de.fzi.sissy.metamod.Delegate;
import de.fzi.sissy.metamod.Destructor;
import de.fzi.sissy.metamod.Field;
import de.fzi.sissy.metamod.File;
import de.fzi.sissy.metamod.FormalParameter;
import de.fzi.sissy.metamod.Function;
import de.fzi.sissy.metamod.FunctionAccess;
import de.fzi.sissy.metamod.GlobalFunction;
import de.fzi.sissy.metamod.GlobalVariable;
import de.fzi.sissy.metamod.InheritanceTypeAccess;
import de.fzi.sissy.metamod.LocalVariable;
import de.fzi.sissy.metamod.Member;
import de.fzi.sissy.metamod.Method;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.ModelElementRepository;
import de.fzi.sissy.metamod.NamedModelElement;
import de.fzi.sissy.metamod.Package;
import de.fzi.sissy.metamod.Position;
import de.fzi.sissy.metamod.Property;
import de.fzi.sissy.metamod.PropertyAccess;
import de.fzi.sissy.metamod.Reference;
import de.fzi.sissy.metamod.RunTimeTypeAccess;
import de.fzi.sissy.metamod.SelfAccess;
import de.fzi.sissy.metamod.SimpleStatement;
import de.fzi.sissy.metamod.SourceEntity;
import de.fzi.sissy.metamod.Statement;
import de.fzi.sissy.metamod.StaticTypeAccess;
import de.fzi.sissy.metamod.Type;
import de.fzi.sissy.metamod.TypeAlias;
import de.fzi.sissy.metamod.Variable;
import de.fzi.sissy.metamod.VariableAccess;
import de.fzi.sissy.utils.Debug;
import de.fzi.sissy.visualizations.StatementViewer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public abstract class GeneralMetamodBuilder {
    protected GeneralCollector collector;
    protected GeneralMapper mapper;
    protected ModelElementRepository modelElementRepository;
    protected StatementViewer sv;

    public GeneralMetamodBuilder(GeneralCollector collector, GeneralMapper mapper, ModelElementRepository modelElementRepository) {
        this.collector = collector;
        this.mapper = mapper;
        this.modelElementRepository = modelElementRepository;
    }

    public void setup() {
    }

    public void buildAll() {
        Debug.info((String)"building files...");
        this.buildFiles();
        Debug.info((String)"building packages...");
        this.buildPackages();
        Debug.info((String)"building primitive types...");
        this.buildPrimitiveTypes();
        Debug.info((String)"building classes...");
        this.buildClasses();
        Debug.info((String)"building arrays...");
        this.buildArrays();
        Debug.info((String)"building functions...");
        this.buildFunctions();
        this.buildDelegates();
        Debug.info((String)"building references...");
        this.buildReferences();
        Debug.info((String)"building type aliases...");
        this.buildTypeAliases();
        Debug.info((String)"building variables...");
        this.buildVariables();
        Debug.info((String)"building imports...");
        this.buildImports();
        Debug.info((String)"building accesses...");
        this.buildAccesses();
        this.establishContainmentRelations();
        Debug.info((String)"adding projects as structural abstractions");
        this.buildDefaultAbstractions();
    }

    protected void buildFiles() {
        for (Object file_element : this.collector.getFileElements()) {
            this.buildFile(file_element);
        }
    }

    protected void buildFile(Object file_element) {
        if (this.alreadyMapped(file_element)) {
            Debug.warning((String)"tried to build duplicate fileobject, prevented");
            return;
        }
        String filename = this.collector.getFilenameOfFileElement(file_element);
        if (filename == null) {
            Debug.warning((String)"buildFiles(): returned filename was null!");
            return;
        }
        File file_metamod = new File(filename);
        this.mapper.addInstance(file_element, (ModelElement)file_metamod);
        this.modelElementRepository.getRoot().addFile(file_metamod);
    }

    public abstract void buildImportedPackages(Object var1, File var2);

    protected void buildPackages() {
        for (Object package_element : this.collector.getPackageElements()) {
            this.buildPackage(package_element);
        }
    }

    protected void buildPackage(Object package_element) {
        if (this.alreadyMapped(package_element)) {
            Debug.warning((String)"buildPackage(): tried to build duplicate packageobject, prevented");
            return;
        }
        String packagename = this.collector.getPackagenameOfPackageElement(package_element);
        if (packagename == null) {
            Debug.warning((String)"buildPackage(): returned packagename was null!");
            return;
        }
        Package package_metamod = new Package(packagename, this.modelElementRepository.getRoot());
        this.mapper.addInstance(package_element, (ModelElement)package_metamod);
        this.modelElementRepository.getRoot().addPackage(package_metamod);
    }

    protected void buildPrimitiveTypes() {
        for (Object ptype_element : this.collector.getPrimitiveTypeElements()) {
            this.buildPrimitiveType(ptype_element);
        }
    }

    protected void buildPrimitiveType(Object ptype_element) {
        if (this.alreadyMapped(ptype_element)) {
            Debug.warning((String)"tried to build duplicate primitivetype-object, prevented");
            return;
        }
        String name = this.collector.getTypenameOfPrimitiveTypeElement(ptype_element);
        if (name == null) {
            Debug.warning((String)"buildPrimitiveTypes(): returned typename was null!");
            return;
        }
        Class pt_class_metamod = new Class(name, Class.KindOfClass.NORMALCLASS);
        pt_class_metamod.setPrimitive();
        this.mapper.addInstance(ptype_element, (ModelElement)pt_class_metamod);
        this.modelElementRepository.getRoot().addType((Type)pt_class_metamod);
    }

    protected void buildClasses() {
        for (Object class_element : this.collector.getClassElements()) {
            this.buildClass(class_element);
        }
    }

    protected void buildClass(Object class_element) {
        if (this.alreadyMapped(class_element)) {
            Debug.warning((String)"tried to build duplicate class object, prevented");
            return;
        }
        String name = this.collector.getNameOfClassElement(class_element);
        if (name == null) {
            Debug.warning((String)"buildClasses(): returned classname was null!");
            return;
        }
        Class class_metamod = new Class(name, Class.KindOfClass.NORMALCLASS);
        this.setupClassInterface(class_element, class_metamod);
        this.setupClassReferencetype(class_element, class_metamod);
        this.setupPosition(class_element, (SourceEntity)class_metamod);
        this.setupClassModifiers(class_element, class_metamod);
        this.mapper.addInstance(class_element, (ModelElement)class_metamod);
        this.establishClassPackageContainmentRelation(class_element, class_metamod);
    }

    protected void establishClassPackageContainmentRelation(Object class_element, Class class_metamod) {
        Object package_container_element = this.collector.getPackageContainerElementOfClassElement(class_element);
        if (package_container_element == null) {
            Debug.warning((String)("establishClassPackageContainmentRelation(): package container element for " + class_element.toString() + " was null!"));
            return;
        }
        Package container_package = (Package)this.mapper.getInstance(package_container_element);
        if (container_package == null) {
            Debug.warning((String)("establishClassPackageContainmentRelation(): mapped container metamod package for " + package_container_element.toString() + " was null!"));
            return;
        }
        container_package.addClass(class_metamod);
    }

    protected void establishTypeAliasPackageContainmentRelation(Object typealias_element, TypeAlias class_metamod) {
        Object package_container_element = this.collector.getPackageContainerElementOfClassElement(typealias_element);
        if (package_container_element == null) {
            Debug.warning((String)("establishTypeAliasPackageContainmentRelation(): package container element for " + typealias_element.toString() + " was null!"));
            return;
        }
        Package container_package = (Package)this.mapper.getInstance(package_container_element);
        if (container_package == null) {
            Debug.warning((String)("establishTypeAliasPackageContainmentRelation(): mapped container metamod package for " + package_container_element.toString() + " was null!"));
            return;
        }
        container_package.addTypeAlias(class_metamod);
    }

    protected boolean alreadyMapped(Object key) {
        return this.mapper.getInstance(key) != null;
    }

    protected void setupPosition(Object src_element, SourceEntity metamod_element) {
        Position position_metamod = this.collector.getPositionOfElement(src_element);
        if (position_metamod == null) {
            Debug.warning((String)("Null-Position setted for " + metamod_element.getClass().getName()));
            return;
        }
        metamod_element.setPosition(position_metamod);
    }

    protected void setupClassInterface(Object class_element, Class class_metamod) {
        if (this.collector.classElementIsInterface(class_element)) {
            class_metamod.setInterface();
        }
    }

    protected void setupClassReferencetype(Object class_element, Class class_metamod) {
        if (this.collector.classElementIsReferenceType(class_element)) {
            class_metamod.setReferenceType();
        } else {
            class_metamod.setValueType();
        }
    }

    protected void setupClassModifiers(Object class_element, Class class_metamod) {
        if (this.collector.classElementIsExternal(class_element)) {
            class_metamod.setExtern(true);
        } else {
            class_metamod.setExtern(false);
        }
        if (this.collector.classElementIsInternal(class_element)) {
            class_metamod.setInternal(true);
        } else {
            class_metamod.setInternal(false);
        }
        if (this.collector.classElementIsNew(class_element)) {
            class_metamod.setNew();
        } else {
            class_metamod.setOverride();
        }
        if (this.collector.classElementIsPrivate(class_element)) {
            class_metamod.setPrivate();
        } else if (this.collector.classElementIsProtected(class_element)) {
            class_metamod.setProtected();
        } else if (this.collector.classElementIsPublic(class_element)) {
            class_metamod.setPublic();
        } else if (this.collector.classElementIsPackage(class_element)) {
            class_metamod.setPackage();
        } else {
            class_metamod.setPublic();
        }
        if (this.collector.classElementIsStatic(class_element)) {
            class_metamod.setStatic(true);
        } else {
            class_metamod.setStatic(false);
        }
        if (this.collector.classElementIsFinal(class_element)) {
            class_metamod.setFinal(true);
        } else {
            class_metamod.setFinal(false);
        }
    }

    protected void buildArrays() {
        for (Object array_element : this.collector.getArrayElements()) {
            if (this.alreadyMapped(array_element)) {
                Debug.warning((String)"tried to build duplicate array object, prevented");
                continue;
            }
            Object base_type_element = this.collector.getBaseTypeOfArrayElement(array_element);
            Type base_type_metamod = (Type)this.mapper.getInstance(base_type_element);
            if (base_type_metamod == null) {
                Debug.warning((String)("buildArrays(): base type for " + array_element.toString() + " was null!"));
                continue;
            }
            Array array_metamod = new Array(base_type_metamod);
            this.setupArrayReferencetype(array_element, array_metamod);
            this.mapper.addInstance(array_element, (ModelElement)array_metamod);
            this.modelElementRepository.getRoot().addType((Type)array_metamod);
        }
    }

    protected void setupArrayReferencetype(Object array_element, Array array_metamod) {
        if (this.collector.arrayElementIsReferenceType(array_element)) {
            array_metamod.setReferenceType();
        } else {
            array_metamod.setValueType();
        }
    }

    protected final void buildFunctions() {
        Debug.info((String)"\tbuilding global functions...");
        this.buildGlobalFunctions();
        Debug.info((String)"\tbuilding methods...");
        this.buildMethods();
        Debug.info((String)"\tbuilding constructors...");
        this.buildConstructors();
        Debug.info((String)"\tbuilding destructors...");
        this.buildDestructors();
    }

    protected void buildGlobalFunctions() {
        Iterator itr = this.collector.getGlobalFunctionElements().iterator();
        Debug.info((String)("building global functions: " + this.collector.getGlobalFunctionElements().size()));
        while (itr.hasNext()) {
            Object global_function_element = itr.next();
            this.buildGlobalFunction(global_function_element);
        }
    }

    protected void buildGlobalFunction(Object global_function_element) {
        if (this.alreadyMapped(global_function_element)) {
            Debug.warning((String)("tried to build duplicate glob. function object " + global_function_element.toString() + ", prevented"));
            return;
        }
        String name = this.collector.getNameOfFunctionElement(global_function_element);
        if (name == null) {
            Debug.warning((String)("buildGlobalFunctions(): " + global_function_element.toString() + ": returned methodname was null!"));
            return;
        }
        GlobalFunction global_function_metamod = new GlobalFunction(name);
        this.mapper.addInstance(global_function_element, (ModelElement)global_function_metamod);
        Debug.info((String)("buildGlobalFunction(): " + global_function_element.toString() + " was mapped!"));
        this.setupFunction(global_function_element, (Function)global_function_metamod);
        Object package_container_element = this.collector.getPackageContainerElementOfGlobalFunctionElement(global_function_element);
        if (package_container_element == null) {
            Debug.warning((String)("buildGlobalFunction(): " + global_function_element.toString() + ": package container element was null!"));
            return;
        }
        Package container_package = (Package)this.mapper.getInstance(package_container_element);
        if (container_package == null) {
            Debug.warning((String)("buildGlobalFunction(): mapped container metamod package was null! for gf: " + global_function_element.toString()));
            return;
        }
        container_package.addGlobalFunction(global_function_metamod);
    }

    protected void buildMethods() {
        for (Object method_element : this.collector.getMethodElements()) {
            this.buildMethod(method_element);
        }
    }

    protected void buildMethod(Object method_element) {
        if (this.alreadyMapped(method_element)) {
            Debug.warning((String)"tried to build duplicate method object, prevented");
            return;
        }
        String name = this.collector.getNameOfFunctionElement(method_element);
        if (name == null) {
            Debug.warning((String)"buildMethods(): returned methodname was null!");
            return;
        }
        Method method_metamod = new Method(name);
        this.mapper.addInstance(method_element, (ModelElement)method_metamod);
        Debug.verbose((String)("buildMethod()" + method_element.toString() + " was mapped!"));
        this.setupFunction(method_element, (Function)method_metamod);
        this.establishMethodClassContainmentRelation(method_element, method_metamod);
    }

    protected void buildConstructors() {
        for (Object constructor_element : this.collector.getConstructorElements()) {
            this.buildConstructor(constructor_element);
        }
    }

    protected void buildConstructor(Object constructor_element) {
        if (this.alreadyMapped(constructor_element)) {
            Debug.warning((String)"tried to build duplicate constructor object, prevented");
            return;
        }
        String name = this.collector.getNameOfFunctionElement(constructor_element);
        if (name == null) {
            Debug.warning((String)"buildConstructors(): returned name was null!");
            return;
        }
        Constructor constructor_metamod = new Constructor(name);
        this.mapper.addInstance(constructor_element, (ModelElement)constructor_metamod);
        Debug.verbose((String)("buildConstructor(): " + constructor_element.toString() + " was mapped!"));
        this.setupFunction(constructor_element, (Function)constructor_metamod);
        this.establishConstructorClassContainmentRelation(constructor_element, constructor_metamod);
    }

    protected void buildDestructors() {
        for (Object destructor_element : this.collector.getDestructorElements()) {
            this.buildDestructor(destructor_element);
        }
    }

    protected void buildDestructor(Object destructor_element) {
        if (this.alreadyMapped(destructor_element)) {
            Debug.warning((String)"tried to build duplicate destructor object, prevented");
            return;
        }
        String name = this.collector.getNameOfFunctionElement(destructor_element);
        if (name == null) {
            Debug.warning((String)"buildDestructors(): returned name was null!");
            return;
        }
        Destructor destructor_metamod = new Destructor(name);
        this.mapper.addInstance(destructor_element, (ModelElement)destructor_metamod);
        Debug.verbose((String)("buildDestructor(): " + destructor_element.toString() + " was mapped!"));
        this.setupFunction(destructor_element, (Function)destructor_metamod);
        this.establishDestructorClassContainmentRelation(destructor_element, destructor_metamod);
    }

    protected void setupFunction(Object function_element, Function function_metamod) {
        this.setupFunctionPosition(function_element, function_metamod);
        this.setupFunctionModifiers(function_element, function_metamod);
        this.setupReturntype(function_element, function_metamod);
        this.buildFormalParameters(function_element, function_metamod);
        this.buildStatements(function_element, function_metamod);
    }

    protected void establishMethodClassContainmentRelation(Object method_element, Method method_metamod) {
        Object class_container_element = this.collector.getClassContainerElementOfMethodElement(method_element);
        if (class_container_element == null) {
            Debug.warning((String)"establishMethodClassContainmentRelation(): class-container-element was null!");
            return;
        }
        Class class_container_metamod = (Class)this.mapper.getInstance(class_container_element);
        if (class_container_metamod == null) {
            Debug.warning((String)"establishMethodClassContainmentRelation(): class-container-metamod was null!");
            return;
        }
        class_container_metamod.addMethod(method_metamod);
        if (method_metamod.isAbstract()) {
            class_container_metamod.setAbstract(true);
        }
    }

    protected void establishConstructorClassContainmentRelation(Object constructor_element, Constructor constructor_metamod) {
        Object class_container_element = this.collector.getClassContainerElementOfConstructorElement(constructor_element);
        if (class_container_element == null) {
            Debug.warning((String)"establishConstructorClassContainmentRelation(): class-container-element was null!");
            return;
        }
        Class class_container_metamod = (Class)this.mapper.getInstance(class_container_element);
        if (class_container_metamod == null) {
            Debug.warning((String)"establishConstructorClassContainmentRelation(): class-container-metamod was null!");
            return;
        }
        class_container_metamod.addConstructor(constructor_metamod);
        if (constructor_metamod.isAbstract()) {
            class_container_metamod.setAbstract(true);
        }
    }

    protected void establishDestructorClassContainmentRelation(Object destructor_element, Destructor destructor_metamod) {
        Object class_container_element = this.collector.getClassContainerElementOfDestructorElement(destructor_element);
        if (class_container_element == null) {
            Debug.warning((String)"establishDestructorClassContainmentRelation(): class-container-element was null!");
            return;
        }
        Class class_container_metamod = (Class)this.mapper.getInstance(class_container_element);
        if (class_container_metamod == null) {
            Debug.warning((String)"establishDestructorClassContainmentRelation(): class-container-metamod was null!");
            return;
        }
        class_container_metamod.addDestructor(destructor_metamod);
        if (destructor_metamod.isAbstract()) {
            class_container_metamod.setAbstract(true);
        }
    }

    protected void setupFunctionPosition(Object function_element, Function function_metamod) {
        this.setupPosition(function_element, (SourceEntity)function_metamod);
    }

    protected void setupFunctionModifiers(Object function_element, Function function_metamod) {
        if (function_metamod == null) {
            return;
        }
        if (function_metamod instanceof GlobalFunction) {
            GlobalFunction global_function_metamod = (GlobalFunction)function_metamod;
            if (this.collector.functionElementIsUnitInitializer(function_element)) {
                global_function_metamod.setKind(2);
            } else if (this.collector.functionElementIsUnitFinalizer(function_element)) {
                global_function_metamod.setKind(3);
            } else {
                global_function_metamod.setKind(1);
            }
        }
        if (function_metamod instanceof Member) {
            Member member_function_metamod = (Member)function_metamod;
            if (this.collector.functionElementIsExternal(function_element)) {
                member_function_metamod.setExtern(true);
            } else {
                member_function_metamod.setExtern(false);
            }
            if (this.collector.functionElementIsInternal(function_element)) {
                member_function_metamod.setInternal(true);
            } else {
                member_function_metamod.setInternal(false);
            }
            if (this.collector.functionElementIsNew(function_element)) {
                member_function_metamod.setNew();
            } else {
                member_function_metamod.setOverride();
            }
            if (this.collector.functionElementIsPrivate(function_element)) {
                member_function_metamod.setPrivate();
            } else if (this.collector.functionElementIsProtected(function_element)) {
                member_function_metamod.setProtected();
            } else if (this.collector.functionElementIsPublic(function_element)) {
                member_function_metamod.setPublic();
            } else if (this.collector.functionElementIsPackage(function_element)) {
                member_function_metamod.setPackage();
            } else {
                member_function_metamod.setPublic();
            }
            if (this.collector.functionElementIsStatic(function_element)) {
                member_function_metamod.setStatic(true);
            } else {
                member_function_metamod.setStatic(false);
            }
            if (this.collector.functionElementIsFinal(function_element)) {
                member_function_metamod.setFinal(true);
            } else {
                member_function_metamod.setFinal(false);
            }
            if (this.collector.functionElementIsAbstract(function_element)) {
                member_function_metamod.setAbstract(true);
            } else {
                member_function_metamod.setAbstract(false);
            }
            if (this.collector.functionElementIsVirtual(function_element)) {
                member_function_metamod.setVirtual(true);
            } else {
                member_function_metamod.setVirtual(false);
            }
            if (this.collector.functionElementIsIntrospectable(function_element)) {
                member_function_metamod.setIntrospectable(true);
            } else {
                member_function_metamod.setIntrospectable(false);
            }
        }
    }

    protected void setupReturntype(Object function_element, Function function_metamod) {
        if (function_metamod instanceof Constructor) {
            return;
        }
        if (function_metamod instanceof Destructor) {
            return;
        }
        Object return_type_element = this.collector.getReturnTypeElementOfFunctionElement(function_element);
        if (return_type_element == null && this.collector.functionElementIsFunction(function_element)) {
            Debug.warning((String)("setupReturntype(): " + function_element.toString() + ": return-type-element was null (but it's a true function element!)"));
            return;
        }
        if (!this.collector.functionElementIsFunction(function_element)) {
            return;
        }
        Type return_type_metamod = (Type)this.mapper.getInstance(return_type_element);
        if (return_type_metamod == null) {
            Debug.warning((String)("setupReturntype(): " + function_element.toString() + ": mapped return-type-metamod was null!"));
            return;
        }
        DeclarationTypeAccess dta = new DeclarationTypeAccess(return_type_metamod);
        dta.setPosition(function_metamod.getPosition());
        function_metamod.setReturnTypeDeclaration(dta);
    }

    protected void buildDelegates() {
        for (Object delegate_element : this.collector.getDelegateElements()) {
            this.buildDelegate(delegate_element);
        }
    }

    protected void buildDelegate(Object delegate_element) {
        if (this.alreadyMapped(delegate_element)) {
            ModelElement metamod_elem = this.mapper.getInstance(delegate_element);
            Debug.warning((String)("tried to build duplicate delegate object " + delegate_element.toString() + ", prevented. Mapped metamod-element: " + metamod_elem.getClass().getName()));
            return;
        }
        String name = this.collector.getNameOfDelegateElement(delegate_element);
        if (name == null) {
            Debug.warning((String)"buildDelegate(): returned name was null!");
            return;
        }
        Delegate delegate_metamod = new Delegate(name);
        this.mapper.addInstance(delegate_element, (ModelElement)delegate_metamod);
    }

    protected void buildReferences() {
        for (Object reference_element : this.collector.getReferenceElements()) {
            this.buildReference(reference_element);
        }
    }

    protected void buildReference(Object reference_element) {
        if (this.alreadyMapped(reference_element)) {
            ModelElement metamod_elem = this.mapper.getInstance(reference_element);
            Debug.warning((String)("tried to build duplicate reference object " + reference_element.toString() + ", prevented. Mapped metamod-element: " + metamod_elem.getClass().getName()));
            return;
        }
        String name = this.collector.getNameOfReferenceElement(reference_element);
        if (name == null) {
            Debug.warning((String)"buildReference(): returned name was null!");
            return;
        }
        Object referenced_type_element = this.collector.getReferencedTypeElementOfReferenceElement(reference_element);
        if (referenced_type_element == null) {
            Debug.warning((String)"buildReference(): returned referenced type element was null!");
            return;
        }
        Type referenced_type = (Type)this.mapper.getInstance(referenced_type_element);
        if (referenced_type == null) {
            Debug.warning((String)"buildReference(): mapped referenced type was null!");
            return;
        }
        Reference reference_metamod = new Reference(referenced_type, name);
        this.mapper.addInstance(reference_element, (ModelElement)reference_metamod);
    }

    protected void buildTypeAliases() {
        for (Object typealias_element : this.collector.getTypeAliasElements()) {
            this.buildTypeAlias(typealias_element);
        }
    }

    protected void buildTypeAlias(Object typealias_element) {
        if (this.alreadyMapped(typealias_element)) {
            ModelElement metamod_elem = this.mapper.getInstance(typealias_element);
            Debug.warning((String)("tried to build duplicate typealias object " + typealias_element.toString() + ", prevented. Mapped metamod-element: " + metamod_elem.getClass().getName()));
            return;
        }
        String name = this.collector.getNameOfTypeAliasElement(typealias_element);
        if (name == null) {
            Debug.warning((String)("buildTypeAlias(): returned name was null! " + typealias_element.toString()));
            return;
        }
        Object aliased_type_element = this.collector.getAliasedTypeElementOfTypeAliasElement(typealias_element);
        if (aliased_type_element == null) {
            Debug.warning((String)"buildTypeAlias(): returned aliased type element was null!");
            return;
        }
        Type aliased_type = (Type)this.mapper.getInstance(aliased_type_element);
        if (aliased_type == null) {
            Debug.warning((String)("buildTypeAlias(): mapped aliased type was null! aliased_type_element: " + aliased_type_element.toString() + " for type_alias_element: " + typealias_element.toString()));
            return;
        }
        TypeAlias typealias_metamod = new TypeAlias(aliased_type, name);
        this.mapper.addInstance(typealias_element, (ModelElement)typealias_metamod);
        this.establishTypeAliasPackageContainmentRelation(typealias_element, typealias_metamod);
    }

    protected void buildFormalParameters(Object function_element, Function function_metamod) {
        for (Object fp_element : this.collector.getFormalParameterElements(function_element)) {
            this.buildFormalParameter(function_metamod, fp_element);
        }
    }

    protected void buildFormalParameter(Function function_metamod, Object fp_element) {
        if (this.alreadyMapped(fp_element)) {
            ModelElement metamod_elem = this.mapper.getInstance(fp_element);
            Debug.warning((String)("tried to build duplicate formal parameter object " + fp_element.toString() + ", prevented. Mapped metamod-element: " + metamod_elem.getClass().getName() + " function-metamod: " + function_metamod.getSimpleName()));
            return;
        }
        String name = this.collector.getNameOfFormalParameterElement(fp_element);
        if (name == null) {
            Debug.warning((String)"buildFormalParameters(): returned name was null!");
            return;
        }
        FormalParameter fp_metamod = new FormalParameter(name);
        this.mapper.addInstance(fp_element, (ModelElement)fp_metamod);
        function_metamod.addFormalParameter(fp_metamod);
        this.setupFormalParameterPosition(fp_element, fp_metamod);
        this.setupFormalParameterTypeDeclaration(fp_element, fp_metamod);
    }

    protected void setupFormalParameterPosition(Object fp_element, FormalParameter fp_metamod) {
        this.setupPosition(fp_element, (SourceEntity)fp_metamod);
    }

    protected void setupFormalParameterTypeDeclaration(Object fp_element, FormalParameter fp_metamod) {
        Object type_element = this.collector.getTypeElementOfFormalParameterElement(fp_element);
        if (type_element == null) {
            Debug.warning((String)("setupFormalParameterTypeDeclaration(): Type-Element of FormalParameter " + fp_metamod.getSimpleName() + " was null!"));
            return;
        }
        Type type_metamod = (Type)this.mapper.getInstance(type_element);
        if (type_metamod == null) {
            Debug.warning((String)("setupFormalParameterTypeDeclaration(): Type of metamod-type-object " + fp_metamod.getSimpleName() + " was null!"));
            if (this.isInstanceOfClassType(type_element)) {
                this.buildClass(type_element);
            } else {
                this.buildPrimitiveType(type_element);
            }
            type_metamod = (Type)this.mapper.getInstance(type_element);
        }
        DeclarationTypeAccess dta = new DeclarationTypeAccess(type_metamod);
        dta.setPosition(fp_metamod.getPosition());
        fp_metamod.setTypeDeclaration(dta);
    }

    public abstract boolean isInstanceOfClassType(Object var1);

    protected void buildLocalVariables() {
        Iterator itr = this.collector.getLocalVariablesElements().iterator();
        Debug.info((String)("building local variables: " + this.collector.getLocalVariablesElements().size()));
        while (itr.hasNext()) {
            Object lv_element = itr.next();
            Object function_element = this.collector.getFunctionContainerElementOfLocalVariableElement(lv_element);
            if (function_element == null) {
                Debug.info((String)"buildLocalVariables(): function_element was null!");
                continue;
            }
            Function function_metamod = (Function)this.mapper.getInstance(function_element);
            if (function_metamod == null) {
                function_metamod = this.getFunctionMappedToCorrespondingScope(this.mapper, function_element);
                if (function_metamod == null) {
                    Debug.info((String)("buildLocalVariables(): function_metamod was null! " + function_element.toString()));
                    continue;
                }
                Debug.info((String)"buildLocalVariables(): function_metamod_resolution with scope worked!!!");
            }
            this.buildLocalVariable(function_metamod, lv_element);
        }
    }

    public abstract Function getFunctionMappedToCorrespondingScope(GeneralMapper var1, Object var2);

    protected void buildLocalVariable(Function function_metamod, Object lv_element) {
        if (this.alreadyMapped(lv_element)) {
            Debug.warning((String)"tried to build duplicate local variable object, prevented");
            return;
        }
        String name = this.collector.getNameOfLocalVariableElement(lv_element);
        if (name == null) {
            Debug.warning((String)"buildLocalVariables(): returned name was null!");
            return;
        }
        LocalVariable lv_metamod = new LocalVariable(name);
        this.mapper.addInstance(lv_element, (ModelElement)lv_metamod);
        function_metamod.addLocalVariable(lv_metamod);
        this.setupLocalVariablePosition(lv_element, lv_metamod);
        this.setupLocalVariableTypeDeclaration(lv_element, lv_metamod);
    }

    protected void setupLocalVariablePosition(Object lv_element, LocalVariable lv_metamod) {
        this.setupPosition(lv_element, (SourceEntity)lv_metamod);
    }

    protected void setupLocalVariableTypeDeclaration(Object lv_element, LocalVariable lv_metamod) {
        Object type_element = this.collector.getTypeElementOfLocalVariableElement(lv_element);
        if (type_element == null) {
            Debug.warning((String)"setupLocalVariableTypeDeclaration(): Type-Element of LocalVariable was null!");
            return;
        }
        Type type_metamod = (Type)this.mapper.getInstance(type_element);
        if (type_metamod == null) {
            Debug.warning((String)"setupLocalVariableTypeDeclaration(): Type of metamod-type-object was null!");
            return;
        }
        DeclarationTypeAccess dta = new DeclarationTypeAccess(type_metamod);
        dta.setPosition(lv_metamod.getPosition());
        lv_metamod.setTypeDeclaration(dta);
    }

    protected abstract void buildStatements(Object var1, Function var2);

    protected abstract void buildCatchParameters();

    public final void buildVariables() {
        Debug.info((String)"\tbuilding global variables...");
        this.buildGlobalVariables();
        Debug.info((String)"\tbuilding fields...");
        this.buildFields();
        this.buildLocalVariables();
        this.buildProperties();
    }

    protected void buildGlobalVariables() {
        for (Object global_variable_element : this.collector.getGlobalVariableElements()) {
            this.buildGlobalVariable(global_variable_element);
        }
    }

    private void buildGlobalVariable(Object global_variable_element) {
        if (this.alreadyMapped(global_variable_element)) {
            Debug.warning((String)"tried to build duplicate glob. variable object, prevented");
            return;
        }
        String name = this.collector.getNameOfGlobalVariableElement(global_variable_element);
        if (name == null) {
            Debug.warning((String)"buildGlobalVariables(): returned name was null!");
            return;
        }
        GlobalVariable global_variable_metamod = new GlobalVariable(name);
        this.mapper.addInstance(global_variable_element, (ModelElement)global_variable_metamod);
        if (this.collector.globalVariableElementIsConst(global_variable_element)) {
            global_variable_metamod.setConst(true);
        } else {
            global_variable_metamod.setConst(false);
        }
        this.setupGlobalVariablePosition(global_variable_element, global_variable_metamod);
        this.setupGlobalVariableTypeDeclaration(global_variable_element, global_variable_metamod);
        Object package_container_element = this.collector.getPackageContainerElementOfGlobalVariableElement(global_variable_element);
        if (package_container_element == null) {
            Debug.warning((String)("buildGlobalVariable(): package container element was null! for gv: " + global_variable_metamod.getSimpleName()));
            return;
        }
        Package container_package = (Package)this.mapper.getInstance(package_container_element);
        if (container_package == null) {
            Debug.warning((String)("buildGlobalVariable(): mapped container metamod package was null! for gv: " + global_variable_metamod.getSimpleName()));
            return;
        }
        container_package.addGlobalVariable(global_variable_metamod);
    }

    protected void setupGlobalVariablePosition(Object global_variable_element, GlobalVariable global_variable_metamod) {
        this.setupPosition(global_variable_element, (SourceEntity)global_variable_metamod);
    }

    protected void setupGlobalVariableTypeDeclaration(Object global_variable_element, GlobalVariable global_variable_metamod) {
        Object type_element = this.collector.getTypeElementOfGlobalVariableElement(global_variable_element);
        if (type_element == null) {
            Debug.warning((String)("setupGlobalVariableTypeDeclaration(): Type-Element of gv_element " + global_variable_metamod.getSimpleName() + " was null!"));
            return;
        }
        Type type_metamod = (Type)this.mapper.getInstance(type_element);
        if (type_metamod == null) {
            Debug.warning((String)("setupGlobalVariableTypeDeclaration(): Type of metamod-type-object " + global_variable_metamod.getSimpleName() + " was null!"));
            return;
        }
        DeclarationTypeAccess dta = new DeclarationTypeAccess(type_metamod);
        dta.setPosition(global_variable_metamod.getPosition());
        global_variable_metamod.setTypeDeclaration(dta);
    }

    public void buildFields() {
        for (Object field_element : this.collector.getFieldElements()) {
            Debug.info((String)("buildFields(): build field for symbol: " + field_element.toString()));
            this.buildField(field_element);
        }
    }

    protected void buildField(Object field_element) {
        if (this.alreadyMapped(field_element)) {
            Debug.warning((String)"tried to build duplicate field object, prevented");
            return;
        }
        String name = this.collector.getNameOfFieldElement(field_element);
        if (name == null) {
            Debug.warning((String)"buildFields(): returned fieldname was null!");
            return;
        }
        Field field_metamod = new Field(name);
        Debug.verbose((String)("buildField(): mapped field_element: " + field_element.toString() + " to metamod_field: " + field_metamod.getSimpleName()));
        this.mapper.addInstance(field_element, (ModelElement)field_metamod);
        this.establishFieldClassContainmentRelation(field_element, field_metamod);
        this.setupFieldPosition(field_element, field_metamod);
        this.setupVariableModifiers(field_element, field_metamod);
        this.setupFieldTypeDeclaration(field_element, field_metamod);
    }

    protected void establishFieldClassContainmentRelation(Object field_element, Field field_metamod) {
        Object class_container_element = this.collector.getClassContainerElementOfFieldElement(field_element);
        if (class_container_element == null) {
            Debug.warning((String)"establishFieldClassContainmentRelation(): class-container-element was null!");
            return;
        }
        Class class_container_metamod = (Class)this.mapper.getInstance(class_container_element);
        if (class_container_metamod == null) {
            Debug.warning((String)"establishFieldClassContainmentRelation(): class-container-metamod was null!");
            return;
        }
        class_container_metamod.addField(field_metamod);
    }

    protected void setupFieldPosition(Object field_element, Field field_metamod) {
        this.setupPosition(field_element, (SourceEntity)field_metamod);
    }

    protected void setupVariableModifiers(Object field_element, Field field_metamod) {
        if (this.collector.fieldElementIsExternal(field_element)) {
            field_metamod.setExtern(true);
        } else {
            field_metamod.setExtern(false);
        }
        if (this.collector.fieldElementIsInternal(field_element)) {
            field_metamod.setInternal(true);
        } else {
            field_metamod.setInternal(false);
        }
        if (this.collector.fieldElementIsNew(field_element)) {
            field_metamod.setNew();
        } else {
            field_metamod.setOverride();
        }
        if (this.collector.fieldElementIsPrivate(field_element)) {
            field_metamod.setPrivate();
        } else if (this.collector.fieldElementIsProtected(field_element)) {
            field_metamod.setProtected();
        } else if (this.collector.fieldElementIsPublic(field_element)) {
            field_metamod.setPublic();
        } else if (this.collector.fieldElementIsPackage(field_element)) {
            field_metamod.setPackage();
        } else {
            field_metamod.setPublic();
        }
        if (this.collector.fieldElementIsStatic(field_element)) {
            field_metamod.setStatic(true);
        } else {
            field_metamod.setStatic(false);
        }
        if (this.collector.fieldElementIsFinal(field_element)) {
            field_metamod.setFinal(true);
        } else {
            field_metamod.setFinal(false);
        }
        if (this.collector.fieldElementIsIntrospectable(field_element)) {
            field_metamod.setIntrospectable(true);
        } else {
            field_metamod.setIntrospectable(false);
        }
    }

    protected void setupFieldTypeDeclaration(Object field_element, Field field_metamod) {
        Object type_element = this.collector.getTypeElementOfFieldElement(field_element);
        if (type_element == null) {
            Debug.warning((String)"setupFieldTypeDeclaration(): Type-Element of Field was null!");
            return;
        }
        Type type_metamod = (Type)this.mapper.getInstance(type_element);
        if (type_metamod == null) {
            Debug.warning((String)("setupFieldTypeDeclaration(): Type of metamod-type-object to Field " + field_metamod.getSimpleName() + " was null!"));
            return;
        }
        DeclarationTypeAccess dta = new DeclarationTypeAccess(type_metamod);
        dta.setPosition(field_metamod.getPosition());
        field_metamod.setTypeDeclaration(dta);
    }

    protected void buildProperties() {
        for (Object property_element : this.collector.getPropertyElements()) {
            this.buildProperty(property_element);
        }
    }

    protected void buildProperty(Object property_element) {
        Object getter_element;
        if (this.alreadyMapped(property_element)) {
            Debug.warning((String)"tried to build duplicate property object, prevented");
            return;
        }
        String name = this.collector.getNameOfPropertyElement(property_element);
        if (name == null) {
            Debug.warning((String)"buildProperty(): returned propertyname was null!");
            return;
        }
        Property property_metamod = new Property(name);
        Debug.info((String)("Property " + property_metamod.getSimpleName() + " was created!"));
        this.mapper.addInstance(property_element, (ModelElement)property_metamod);
        this.establishPropertyClassContainmentRelation(property_element, property_metamod);
        this.setupPosition(property_element, (SourceEntity)property_metamod);
        this.setupPropertyModifiers(property_element, (Member)property_metamod);
        this.setupPropertyTypeDeclaration(property_element, (Field)property_metamod);
        Object setter_element = this.collector.getSetterElementOfPropertyElement(property_element);
        if (setter_element != null) {
            Method setter_metamod = new Method(String.valueOf(property_metamod.getSimpleName()) + ".set");
            this.setupPropertyModifiers(property_element, (Member)setter_metamod);
            BlockStatement body = new BlockStatement();
            setter_metamod.setBody(body);
            SimpleStatement accStatement = new SimpleStatement();
            body.addStatement((Statement)accStatement);
            ModelElement target = this.mapper.getInstance(setter_element);
            if (target != null) {
                if (target instanceof Method) {
                    accStatement.addAccess((Access)new FunctionAccess((Function)target));
                } else if (target instanceof Field) {
                    accStatement.addAccess((Access)new VariableAccess((Variable)target, true));
                } else {
                    Debug.warning((String)("GeneralMetamodBuilder: Target for setter method of property " + property_metamod.getSimpleName() + " was not a Method or a Field."));
                }
            }
            property_metamod.setSetter(setter_metamod);
        }
        if ((getter_element = this.collector.getGetterElementOfPropertyElement(property_element)) != null) {
            Method getter_metamod = new Method(String.valueOf(property_metamod.getSimpleName()) + ".get");
            this.setupPropertyModifiers(property_element, (Member)getter_metamod);
            BlockStatement body = new BlockStatement();
            getter_metamod.setBody(body);
            SimpleStatement accStatement = new SimpleStatement();
            body.addStatement((Statement)accStatement);
            ModelElement target = this.mapper.getInstance(getter_element);
            if (target != null) {
                if (target instanceof Method) {
                    accStatement.addAccess((Access)new FunctionAccess((Function)target));
                } else if (target instanceof Field) {
                    accStatement.addAccess((Access)new VariableAccess((Variable)target, true));
                } else {
                    Debug.warning((String)("GeneralMetamodBuilder: Target for getter method of property " + property_metamod.getSimpleName() + " was not a Method or a Field."));
                }
            }
            property_metamod.setGetter(getter_metamod);
        }
    }

    private void establishPropertyClassContainmentRelation(Object property_element, Property property_metamod) {
        Object class_container_element = this.collector.getClassContainerElementOfPropertyElement(property_element);
        if (class_container_element == null) {
            Debug.warning((String)"establishPropertyClassContainmentRelation(): class-container-element was null!");
            return;
        }
        Class class_container_metamod = (Class)this.mapper.getInstance(class_container_element);
        if (class_container_metamod == null) {
            Debug.warning((String)"establishPropertyClassContainmentRelation(): class-container-metamod was null!");
            return;
        }
        class_container_metamod.addField((Field)property_metamod);
    }

    protected void setupPropertyModifiers(Object property_element, Member member_metamod) {
        if (this.collector.propertyElementIsExternal(property_element)) {
            member_metamod.setExtern(true);
        } else {
            member_metamod.setExtern(false);
        }
        if (this.collector.propertyElementIsInternal(property_element)) {
            member_metamod.setInternal(true);
        } else {
            member_metamod.setInternal(false);
        }
        if (this.collector.propertyElementIsNew(property_element)) {
            member_metamod.setNew();
        } else {
            member_metamod.setOverride();
        }
        if (this.collector.propertyElementIsPrivate(property_element)) {
            member_metamod.setPrivate();
        } else if (this.collector.propertyElementIsProtected(property_element)) {
            member_metamod.setProtected();
        } else if (this.collector.propertyElementIsPublic(property_element)) {
            member_metamod.setPublic();
        } else if (this.collector.propertyElementIsPackage(property_element)) {
            member_metamod.setPackage();
        } else {
            member_metamod.setPublic();
        }
        if (this.collector.propertyElementIsStatic(property_element)) {
            member_metamod.setStatic(true);
        } else {
            member_metamod.setStatic(false);
        }
        if (this.collector.propertyElementIsFinal(property_element)) {
            member_metamod.setFinal(true);
        } else {
            member_metamod.setFinal(false);
        }
        if (this.collector.propertyElementIsIntrospectable(property_element)) {
            member_metamod.setIntrospectable(true);
        } else {
            member_metamod.setIntrospectable(false);
        }
    }

    protected void setupPropertyTypeDeclaration(Object property_element, Field property_metamod) {
        Object type_element = this.collector.getTypeElementOfPropertyElement(property_element);
        if (type_element == null) {
            Debug.warning((String)"setupPropertyTypeDeclaration(): Type-Element of Property was null!");
            return;
        }
        Type type_metamod = (Type)this.mapper.getInstance(type_element);
        if (type_metamod == null) {
            Debug.warning((String)("setupPropertyTypeDeclaration(): Type of metamod-type-object to Property " + property_metamod.getSimpleName() + " was null!"));
            return;
        }
        DeclarationTypeAccess dta = new DeclarationTypeAccess(type_metamod);
        dta.setPosition(property_metamod.getPosition());
        property_metamod.setTypeDeclaration(dta);
    }

    public final void buildImports() {
        for (Object file_element : this.collector.getFileElements()) {
            File file_metamod = (File)this.mapper.getInstance(file_element);
            if (file_metamod == null) continue;
            this.buildImportedPackages(file_element, file_metamod);
        }
    }

    public final void buildAccesses() {
        this.buildInheritanceTypeAccesses();
        this.buildOverriddenMembers();
        this.buildCastTypeAccesses();
        this.buildStaticTypeAccesses();
        this.buildRunTimeTypeAccesses();
        this.buildSelfAccesses();
        this.buildCompositeAccesses();
        this.buildVariableAccesses();
        this.buildFunctionAccesses();
    }

    public void buildInheritanceTypeAccesses() {
        Debug.info((String)"  building inheritance-type-accesses...");
        for (Object class_element : this.collector.getClassElements()) {
            Class class_metamod = (Class)this.mapper.getInstance(class_element);
            if (class_metamod == null) {
                Debug.warning((String)"InheritanceTypeAccesses(): mapped metamod-class-element was null!");
                continue;
            }
            Collection coll_super = this.collector.getSuperClassElementsOfClassElement(class_element);
            if (coll_super == null || coll_super.isEmpty()) continue;
            for (Object super_class_element : coll_super) {
                Class super_class_metamod = (Class)this.mapper.getInstance(super_class_element);
                if (super_class_metamod == null) {
                    Debug.warning((String)"InheritanceTypeAccesses(): mapped metamod-sub-class-element was null!");
                    continue;
                }
                InheritanceTypeAccess ita = new InheritanceTypeAccess(super_class_metamod);
                class_metamod.addInheritanceTypeAccess(ita);
            }
        }
    }

    protected abstract void buildOverriddenMembers();

    public void buildCastTypeAccesses() {
        Debug.info((String)"  building cast-type-accesses...");
        for (Object typecast_access_element : this.collector.getTypeCastAccessElements()) {
            Object type = this.collector.getTypeElementToTypeCastAccessElement(typecast_access_element);
            ModelElement metamod_object = this.mapper.getInstance(type);
            if (metamod_object == null) {
                Debug.warning((String)"buildCastTypeAccesses(): Metamod-Class-Object was null!");
                continue;
            }
            if (!(metamod_object instanceof Type)) {
                Debug.warning((String)("buildCastTypeAccesses(): Metamod-Class-Object was invalid for " + type.toString()));
                continue;
            }
            Type type_metamod = (Type)metamod_object;
            CastTypeAccess cast_type_access = new CastTypeAccess(type_metamod);
            Statement container_stm = (Statement)this.collector.getContainerStatementOfTypeCastAccessElement(typecast_access_element);
            if (container_stm != null) {
                container_stm.addAccess((Access)cast_type_access);
                Debug.info((String)("Type Cast Access to " + type_metamod.getSimpleName() + " added to Statement !"));
                continue;
            }
            Debug.warning((String)"buildCastTypeAccesses(): Container-Statement was null!");
        }
    }

    public void buildThrowTypeAccesses() {
    }

    public void buildDeclarationTypeAccesses() {
    }

    public void buildStaticTypeAccesses() {
        Debug.info((String)"  building static-type-accesses...");
        for (Object static_type_access_element : this.collector.getStaticTypeAccessElements()) {
            this.buildStaticTypeAccess(static_type_access_element);
        }
    }

    public void buildStaticTypeAccess(Object static_type_access_element) {
        Object target_class_element = this.collector.getTypeClassElementOfStaticTypeAccessElement(static_type_access_element);
        if (target_class_element == null) {
            Debug.warning((String)"buildStaticTypeAccess(): target_class_element was null!");
            return;
        }
        Class target_class_metamod = (Class)this.mapper.getInstance(target_class_element);
        if (target_class_metamod == null) {
            Debug.warning((String)"buildStaticTypeAccess(): target_class_metamod was null!");
            return;
        }
        StaticTypeAccess static_type_access_metamod = new StaticTypeAccess((Type)target_class_metamod);
        Statement container_stm = (Statement)this.collector.getContainerStatementOfStaticTypeAccessElement(static_type_access_element);
        if (container_stm != null) {
            container_stm.addAccess((Access)static_type_access_metamod);
        } else {
            Debug.warning((String)"buildStaticTypeAccess(): Container-Statement was null!");
        }
    }

    public void buildRunTimeTypeAccesses() {
        Debug.info((String)"  building runtime-type-accesses...");
        for (Object runtime_type_access_element : this.collector.getRunTimeTypeAccessElements()) {
            this.buildRunTimeTypeAccess(runtime_type_access_element);
        }
    }

    public void buildRunTimeTypeAccess(Object runtime_type_access_element) {
        Object target_class_element = this.collector.getTypeClassElementOfRunTimeTypeAccessElement(runtime_type_access_element);
        if (target_class_element == null) {
            Debug.warning((String)"buildRunTimeTypeAccess(): target_class_element was null!");
            return;
        }
        Type target_class_metamod = (Type)this.mapper.getInstance(target_class_element);
        if (target_class_metamod == null) {
            Debug.warning((String)"buildRunTimeTypeAccess(): target_class_metamod was null!");
            return;
        }
        RunTimeTypeAccess runtime_type_access_metamod = new RunTimeTypeAccess(target_class_metamod);
        Statement container_stm = (Statement)this.collector.getContainerStatementOfRunTimeTypeAccessElement(runtime_type_access_element);
        if (container_stm != null) {
            container_stm.addAccess((Access)runtime_type_access_metamod);
        } else {
            Debug.warning((String)"buildRunTimeTypeAccess(): Container-Statement was null!");
        }
    }

    public void buildSelfAccesses() {
        Debug.info((String)"  building self-accesses...");
        Iterator itr = this.collector.getSelfAccessElements().iterator();
        Debug.info((String)(" number: " + this.collector.getSelfAccessElements().size()));
        while (itr.hasNext()) {
            Object self_access_element = itr.next();
            this.buildSelfAccess(self_access_element);
        }
    }

    public void buildSelfAccess(Object self_access_element) {
        Object target_class_element = this.collector.getTargetClassElementOfSelfAccessElement(self_access_element);
        if (target_class_element == null) {
            Debug.warning((String)"buildSelfAccess(): target_class_element was null!");
            return;
        }
        Class target_class_metamod = (Class)this.mapper.getInstance(target_class_element);
        if (target_class_metamod == null) {
            Debug.warning((String)"buildSelfAccess(): target_class_metamod was null!");
            return;
        }
        SelfAccess self_access_metamod = new SelfAccess(target_class_metamod);
        Statement container_stm = (Statement)this.collector.getContainerStatementOfSelfAccessElement(self_access_element);
        if (container_stm != null) {
            container_stm.addAccess((Access)self_access_metamod);
        } else {
            Debug.warning((String)"buildSelfAccess(): Container-Statement was null!");
        }
    }

    public void buildCompositeAccesses() {
        for (Object composite_access_element : this.collector.getCompositeAccessElements()) {
            this.buildCompositeAccess(composite_access_element);
        }
    }

    public void buildCompositeAccess(Object composite_access_element) {
    }

    public void buildFunctionAccesses() {
        for (Object function_access_element : this.collector.getFunctionAccessElements()) {
            this.buildFunctionAccess(function_access_element);
        }
    }

    public void buildFunctionAccess(Object function_access_element) {
        Object function_element = this.collector.getFunctionElementToFunctionAccessElement(function_access_element);
        Function function_metamod = (Function)this.mapper.getInstance(function_element);
        if (function_metamod == null) {
            Debug.warning((String)("buildFunctionAcesses(): Metamod-Function-Object was null! Function-Element " + function_element.toString() + " was of Type " + function_element.getClass().getName()));
            return;
        }
        FunctionAccess function_access = new FunctionAccess(function_metamod);
        Statement container_stm = (Statement)this.collector.getContainerStatementOfFunctionAccessElement(function_access_element);
        if (container_stm != null) {
            container_stm.addAccess((Access)function_access);
        } else {
            Debug.warning((String)"buildFunctionAccess(): Container-Statement was null!");
        }
    }

    public void buildVariableAccesses() {
        for (Object variable_access_element : this.collector.getVariableAccessElements()) {
            Object variable_element = this.collector.getVariableElementToVariableAccessElement(variable_access_element);
            if (variable_element == null) {
                Debug.warning((String)"buildVariableAcesses(): Variable-Element was null!");
                continue;
            }
            Variable variable_metamod = (Variable)this.mapper.getInstance(variable_element);
            if (variable_metamod == null) {
                Debug.warning((String)("buildVariableAcesses():  Metamod-Variable-Object for " + this.getStringOfSymbolScope(variable_element) + " was null! Variable-Element was of Type " + variable_element.getClass().getName()));
                continue;
            }
            boolean isWrite = false;
            isWrite = this.collector.isWritingVariableAccess(variable_access_element);
            Object variable_access = variable_metamod instanceof Property ? new PropertyAccess((Property)variable_metamod, isWrite) : new VariableAccess(variable_metamod, isWrite);
            Statement container_stm = (Statement)this.collector.getContainerStatementOfVariableAccessElement(variable_access_element);
            if (container_stm != null) {
                container_stm.addAccess((Access)variable_access);
                Debug.verbose((String)("Variable Access to " + variable_metamod.getSimpleName() + " added to Statement ! "));
                ModelElement parent = container_stm.getParent();
                while (parent != null && !(parent instanceof NamedModelElement)) {
                    parent = parent.getParent();
                }
                if (parent == null) continue;
                Debug.verbose((String)("Parent of Statement is " + ((NamedModelElement)parent).getSimpleName()));
                continue;
            }
            Debug.warning((String)"buildVariableAcesses(): Container-Statement was null!");
        }
    }

    public abstract String getStringOfSymbolScope(Object var1);

    public void buildDelegateAccesses() {
    }

    public void buildPropertyAccesses() {
    }

    public final void establishContainmentRelations() {
        this.establishPackagePackageContainmentRelation();
        this.establishClassClassContainmentRelation();
    }

    public abstract void establishPackagePackageContainmentRelation();

    public abstract void establishClassClassContainmentRelation();

    public abstract void buildDefaultAbstractions();

    public void createStatementViewer() {
        Vector allMethods = new Vector();
        allMethods.addAll(this.collector.getMethodElements());
        allMethods.addAll(this.collector.getGlobalFunctionElements());
        allMethods.addAll(this.collector.getConstructorElements());
        allMethods.addAll(this.collector.getDestructorElements());
        Vector<Function> metamod_functions = new Vector<Function>();
        for (Object obj : allMethods) {
            Function metamod_function = (Function)this.mapper.getInstance(obj);
            metamod_functions.add(metamod_function);
        }
        if (!metamod_functions.isEmpty()) {
            this.sv = new StatementViewer();
            this.sv.showMethodSelection(metamod_functions);
        }
    }

    public ModelElementRepository getModelElementRepository() {
        return this.modelElementRepository;
    }

    public void setModelElementRepository(ModelElementRepository modelElementRepository) {
        this.modelElementRepository = modelElementRepository;
    }
}

