/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors;

import de.fzi.sissy.commentanalyzer.Main;
import de.fzi.sissy.extractors.ExtractorConfiguration;
import de.fzi.sissy.extractors.SubsystemHelper;
import de.fzi.sissy.extractors.clone.CloneStructureBuilder;
import de.fzi.sissy.extractors.clone.FilenameToStatementMapper;
import de.fzi.sissy.metamod.Function;
import de.fzi.sissy.metamod.ModelElementList;
import de.fzi.sissy.metamod.ModelElementRepository;
import de.fzi.sissy.metamod.Statement;
import de.fzi.sissy.metamod.StatementTreeWalker;
import de.fzi.sissy.utils.Debug;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class GenericExtractor {
    protected ModelElementRepository modelElementRepository = ModelElementRepository.getWorkingRepository();
    protected ExtractorConfiguration extractorConfiguration = null;
    protected String cloneAnalyzerCommentFile = null;
    protected String commentAnalyzerCommentFile = null;
    protected FileFilter fileFilter = null;
    private SubsystemHelper ssHelper = null;

    public GenericExtractor(ExtractorConfiguration extractorConfiguration, FileFilter ff, String commentAnalyserCommentFile, String cloneAnalyserCommentFile) {
        this.extractorConfiguration = extractorConfiguration;
        this.fileFilter = ff;
        this.cloneAnalyzerCommentFile = cloneAnalyserCommentFile;
        this.commentAnalyzerCommentFile = cloneAnalyserCommentFile;
    }

    public void extract(IProgressMonitor monitor) throws Exception {
        if (monitor != null) {
            monitor.subTask("model extraction");
        }
        if (monitor != null) {
            monitor.subTask("read parameters");
        }
        if (this.extractorConfiguration.getInputDirectoryPaths().size() <= 0) {
            throw new JobFailedException("No Source Input Directories selected");
        }
        this.setupSourceFilePathsAndFilterExcludes();
        this.setupSourceAndBinaryLibraryPaths();
        if (monitor != null) {
            monitor.subTask("extract subsystems");
        }
        this.extractSubsystemStructure();
        if (monitor != null) {
            monitor.subTask("build meta model");
        }
        this.buildMetaModel(monitor);
        if (monitor != null && monitor.isCanceled()) {
            throw new UserCanceledException();
        }
        if (this.extractorConfiguration.getCloneAnalysisConfiguration().isDoCloneAnalysis()) {
            if (monitor != null) {
                monitor.subTask("analyse clones");
            }
            Properties clone_analyzer_parameters = this.extractCloneAnalysisParameters();
            this.analyseClones(clone_analyzer_parameters);
        }
    }

    private void setupSourceAndBinaryLibraryPaths() {
        if (!this.extractorConfiguration.getSourceLibraryFilePaths().isEmpty()) {
            List<String> soureLibraryPaths = this.extractorConfiguration.getSourceLibraryFilePaths();
            List<String> sourceLibraryFiles = this.getFiles(soureLibraryPaths, this.getSourceFileFilter());
            this.printDebug("source library files", sourceLibraryFiles);
            this.modelElementRepository.setLibFileList(sourceLibraryFiles);
        }
        if (!this.extractorConfiguration.getBinaryLibraryFilePaths().isEmpty()) {
            List<String> binaryLibraryPaths = this.extractorConfiguration.getBinaryLibraryFilePaths();
            this.printDebug("binary library files", binaryLibraryPaths);
            this.modelElementRepository.setBinaryLibraryPathsList(binaryLibraryPaths);
        }
    }

    private void setupSourceFilePathsAndFilterExcludes() {
        List<String> soureFilePaths = this.extractorConfiguration.getInputDirectoryPaths();
        List<String> sourceFiles = this.getFiles(soureFilePaths, this.getSourceFileFilter());
        if (!this.extractorConfiguration.getExcludeFilePaths().isEmpty()) {
            List<String> excludePaths = this.extractorConfiguration.getExcludeFilePaths();
            ArrayList<String> newSourceFiles = null;
            for (String exPath : excludePaths) {
                newSourceFiles = new ArrayList<String>();
                for (String sourcePath : sourceFiles) {
                    if (sourcePath.contains(exPath)) continue;
                    newSourceFiles.add(sourcePath);
                }
                sourceFiles = newSourceFiles;
            }
        }
        this.modelElementRepository.setFileList(sourceFiles);
    }

    protected void analyseComments() {
        String fileName = "res/comments/comment_analyzer.cfg";
        fileName = fileName.replace("/", File.separator);
        List<String> sourcePaths = this.extractorConfiguration.getInputDirectoryPaths();
        String sourcePath = "";
        for (String path : sourcePaths) {
            sourcePath = String.valueOf(sourcePath) + path + ";";
        }
        if (sourcePath.length() > 1) {
            sourcePath = sourcePath.substring(0, sourcePath.length() - 2);
        }
        String[] args = new String[]{sourcePath, "-all", fileName, "-c", this.commentAnalyzerCommentFile};
        Main.main((String[])args);
    }

    protected void analyseClones(Properties clone_analyzer_parameters) {
        if (clone_analyzer_parameters == null) {
            return;
        }
        FilenameToStatementMapper mapper = FilenameToStatementMapper.getSingleton();
        ModelElementList list = this.modelElementRepository.getRoot().getFunctions();
        for (Function func : list) {
            StatementTreeWalker walker = new StatementTreeWalker((Statement)func.getBody());
            if (func.getBody() == null) continue;
            do {
                Statement stmt;
                if ((stmt = walker.getStatement()).getPosition() != null) {
                    mapper.addStatement(stmt.getPosition().getSourceFile().getPathName(), stmt);
                    continue;
                }
                Function function = stmt.getSurroundingFunction();
                while (!(function instanceof Function)) {
                    function = function.getParent();
                }
                Debug.warning((String)("CA: Metamod Statement Position is null in function " + function.getSimpleName()));
            } while (walker.next());
        }
        CloneStructureBuilder.getSingleton().executeCloneAnalyseAndCreateCloneStructure(this.modelElementRepository, clone_analyzer_parameters);
    }

    protected SubsystemHelper getSsHelper() {
        return this.ssHelper;
    }

    protected void extractSubsystemStructure() {
        String name = this.extractorConfiguration.getSubsystemSpecificationFilePath();
        if (name != null && !name.trim().equals("")) {
            this.ssHelper = new SubsystemHelper();
            this.ssHelper.loadConfigFromFile(name);
            this.ssHelper.addSubsystemsToRoot(this.modelElementRepository.getRoot());
        }
    }

    protected Properties extractCloneAnalysisParameters() {
        String min_clone_length = "" + this.extractorConfiguration.getCloneAnalysisConfiguration().getMinimumCloneLength();
        String file_filter = this.extractorConfiguration.getCloneAnalysisConfiguration().getFileFilter();
        String comment_file = this.extractorConfiguration.getCloneAnalysisConfiguration().getCommentPatternFilePath();
        boolean ignore_whitespace = this.extractorConfiguration.getCloneAnalysisConfiguration().isIgnoreWhitespace();
        boolean ignore_comments = this.extractorConfiguration.getCloneAnalysisConfiguration().isIgnoreComments();
        Properties default_parameters = CloneStructureBuilder.getDefaultParameters();
        if (this.cloneAnalyzerCommentFile != null) {
            default_parameters.setProperty("COMMENT_FILE_NAME", this.cloneAnalyzerCommentFile);
        }
        Properties ca_parameters = new Properties(default_parameters);
        if (min_clone_length != null) {
            ca_parameters.setProperty("MIN_CLONE_LENGTH", min_clone_length);
        }
        if (file_filter != null) {
            ca_parameters.setProperty("FILE_FILTER", file_filter);
        }
        if (comment_file != null) {
            ca_parameters.setProperty("COMMENT_FILE_NAME", comment_file);
        }
        if (ignore_whitespace) {
            ca_parameters.setProperty("IGNORE_WHITESPACE", "true");
        }
        if (ignore_comments) {
            ca_parameters.setProperty("IGNORE_COMMENTS", "true");
        }
        return ca_parameters;
    }

    protected abstract void buildMetaModel(IProgressMonitor var1) throws Exception;

    private void printDebug(String header, List<String> lines) {
        Debug.info((String)header);
        for (String line : lines) {
            Debug.info((String)line);
        }
    }

    protected FileFilter getSourceFileFilter() {
        return this.fileFilter;
    }

    protected List<String> parsePathList(String pathList) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer pathTokenizer = new StringTokenizer(pathList, File.pathSeparator, false);
        while (pathTokenizer.hasMoreTokens()) {
            String token = pathTokenizer.nextToken();
            list.add(token);
        }
        return list;
    }

    protected List<String> getFiles(List<String> searchPaths, FileFilter filter) {
        ArrayList<String> list = new ArrayList<String>();
        for (String searchPath : searchPaths) {
            File f;
            File file = new File(searchPath);
            ArrayList<String> tmpList = this.collectFiles(file, filter);
            if (tmpList.size() > 0) {
                list.addAll(tmpList);
                continue;
            }
            if (!file.exists() || !file.isFile()) continue;
            ArrayList<String> incList = new ArrayList<String>();
            ArrayList<String> excList = new ArrayList<String>();
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(file));
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("i ") || line.startsWith("I ")) {
                        incList.add(line.substring(2));
                        continue;
                    }
                    if (!line.startsWith("e ") && !line.startsWith("E ")) continue;
                    excList.add(line.substring(2));
                }
                br.close();
            }
            catch (IOException e) {
                Debug.error((String)e.getMessage());
            }
            int i = 0;
            while (i < incList.size()) {
                f = new File((String)incList.get(i));
                list.addAll(this.collectFiles(f, filter));
                ++i;
            }
            i = 0;
            while (i < excList.size()) {
                f = new File((String)excList.get(i));
                list.removeAll(this.collectFiles(f, filter));
                ++i;
            }
        }
        return list;
    }

    private ArrayList<String> collectFiles(File file, FileFilter filter) {
        ArrayList<String> list;
        block4: {
            block3: {
                list = new ArrayList<String>();
                if (!file.isDirectory()) break block3;
                File[] flist = file.listFiles();
                int i = 0;
                while (i < flist.length) {
                    list.addAll(this.collectFiles(flist[i], filter));
                    ++i;
                }
                break block4;
            }
            if (!filter.accept(file)) break block4;
            try {
                list.add(file.getCanonicalPath());
            }
            catch (IOException e) {
                Debug.error((String)e.getMessage());
            }
        }
        return list;
    }
}

