/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.java.recoder;

import de.fzi.sissy.utils.Debug;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ModelElement;
import recoder.ParserException;
import recoder.ServiceConfiguration;
import recoder.convenience.Format;
import recoder.io.DefaultSourceFileRepository;
import recoder.io.ProjectSettings;
import recoder.io.SourceFileRepository;
import recoder.java.CompilationUnit;
import recoder.kit.Problem;
import recoder.kit.ProblemReport;
import recoder.kit.Transformation;
import recoder.util.FileCollector;

public class RecoderProgram {
    private void warn(String message) {
        Debug.warning((String)message);
    }

    private void fail(String message) {
        Debug.error((String)message);
        throw new Error("1");
    }

    private void ensureSystemClassesAreInPath(ServiceConfiguration sc) {
        if (!sc.getProjectSettings().ensureSystemClassesAreInPath()) {
            this.fail("Problem with system setup: Cannot locate system classes");
        }
    }

    private boolean isLogicalClassName(String name) {
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        int i = 1;
        int s = name.length();
        while (i < s) {
            char x = name.charAt(i);
            if (x == '.' ? name.charAt(i - 1) == '.' : !Character.isJavaIdentifierPart(x)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String[] collectJavaFiles(String dir) {
        FileCollector col = new FileCollector(dir);
        ArrayList<String> list = new ArrayList<String>();
        while (col.next(DefaultSourceFileRepository.JAVA_FILENAME_FILTER)) {
            String path;
            try {
                path = col.getFile().getCanonicalPath();
            }
            catch (IOException iOException) {
                path = col.getFile().getAbsolutePath();
            }
            list.add(path);
        }
        return list.toArray(new String[0]);
    }

    public void setup(ServiceConfiguration sc, Class main, List fileList, List<String> binaryLibraryFileList) throws ParserException {
        if (sc == null) {
            throw new IllegalArgumentException("Service configuration required");
        }
        if (main == null) {
            throw new IllegalArgumentException("Main class required");
        }
        if (fileList == null) {
            throw new IllegalArgumentException("File list required");
        }
        SourceFileRepository sfr = sc.getSourceFileRepository();
        try {
            this.ensureSystemClassesAreInPath(sc);
            sc.getProjectSettings().ensureExtensionClassesAreInPath();
            if (binaryLibraryFileList != null && !binaryLibraryFileList.isEmpty()) {
                ProjectSettings projectSettings = sc.getProjectSettings();
                String oldInputPath = projectSettings.getProperty("input.path");
                StringBuilder builder = new StringBuilder();
                for (String binLib : binaryLibraryFileList) {
                    builder.append(String.valueOf(File.pathSeparator) + binLib);
                    File[] jarPaths = this.retrieveJARFilePaths(binLib);
                    int i = 0;
                    while (i < jarPaths.length) {
                        builder.append(String.valueOf(File.pathSeparator) + jarPaths[i].getAbsolutePath());
                        ++i;
                    }
                }
                String cfr_ignored_0 = String.valueOf(oldInputPath) + builder.toString();
                projectSettings.setProperty("input.path", String.valueOf(oldInputPath) + builder.toString());
            }
            String[] files = new String[fileList.size()];
            int i = 0;
            while (i < fileList.size()) {
                files[i] = (String)fileList.get(i);
                ++i;
            }
            List culist = sfr.getCompilationUnitsFromFiles(files);
            if (culist.size() < files.length) {
                this.warn("Could not load some files from analysis path.");
            }
        }
        catch (ParserException pe) {
            this.fail("A Parse Error has occured: " + (Object)((Object)pe));
            throw pe;
        }
    }

    private File[] retrieveJARFilePaths(String binLib) {
        File file = new File(binLib);
        if (file.exists() && file.isDirectory()) {
            File[] jarPathsFiles = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            return jarPathsFiles;
        }
        return new File[0];
    }

    private void execute(Transformation transform, List fileList) throws ParserException {
        CrossReferenceServiceConfiguration sc = transform.getServiceConfiguration();
        this.setup((ServiceConfiguration)sc, transform.getClass(), fileList, null);
        ProblemReport report = transform.execute();
        if (report instanceof Problem) {
            this.warn(report.toString());
        } else {
            Debug.info((String)"Transformation succeeded - writing results");
            SourceFileRepository sfr = sc.getSourceFileRepository();
            List units = sfr.getCompilationUnits();
            int i = 0;
            while (i < units.size()) {
                CompilationUnit cu = (CompilationUnit)units.get(i);
                if (!sfr.isUpToDate(cu)) {
                    Debug.info((String)Format.toString((String)"%u [%f]", (ModelElement)cu));
                    try {
                        sc.getSourceFileRepository().print(cu);
                    }
                    catch (IOException ioe) {
                        this.warn("An IO Exception has occured: " + ioe);
                    }
                }
                ++i;
            }
        }
    }
}

