/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.java.recoder;

import de.fzi.sissy.utils.Debug;
import java.util.ArrayList;
import java.util.List;
import recoder.ServiceConfiguration;
import recoder.abstraction.ClassType;
import recoder.abstraction.Method;
import recoder.abstraction.ProgramModelElement;
import recoder.abstraction.Type;
import recoder.convenience.Naming;
import recoder.java.Expression;
import recoder.java.Import;
import recoder.java.ProgramElement;
import recoder.java.Reference;
import recoder.java.declaration.VariableSpecification;
import recoder.java.reference.MethodReference;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.TypeReference;
import recoder.java.reference.UncollatedReferenceQualifier;
import recoder.service.DefaultCrossReferenceSourceInfo;

public class CustomSourceInfo
extends DefaultCrossReferenceSourceInfo {
    public CustomSourceInfo(ServiceConfiguration config) {
        super(config);
    }

    public Reference resolveURQ(UncollatedReferenceQualifier urq) {
        try {
            return super.resolveURQ(urq);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Type getType(Expression expr) {
        try {
            return super.getType(expr);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Type getType(ProgramElement pe) {
        try {
            return super.getType(pe);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Type getType(ProgramModelElement pme) {
        try {
            return super.getType(pme);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Type getType(String name, ProgramElement context) {
        try {
            return super.getType(name, context);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Type getType(TypeReference tr) {
        try {
            return super.getType(tr);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Type getType(VariableSpecification vs) {
        try {
            return super.getType(vs);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List<Method> getMethodsFromStaticOnDemandImports(MethodReference mr, List<Import> imports) {
        imports = this.filterImportsToAvoidRecoderNPE(imports);
        try {
            return super.getMethodsFromStaticOnDemandImports(mr, imports);
        }
        catch (NullPointerException nullPointerException) {
            Debug.warning((String)"Caught NPE from Recoder, Problem with Static on Demand Imports of Methods in Java 5");
            return new ArrayList<Method>();
        }
    }

    private List<Import> filterImportsToAvoidRecoderNPE(List<Import> imports) {
        ArrayList<Import> filteredImports = new ArrayList<Import>();
        for (Import imp : imports) {
            if (!imp.isStaticImport() || !imp.isMultiImport()) continue;
            ClassType classType = this.getServiceConfiguration().getNameInfo().getClassType(Naming.toPathName((ReferencePrefix)imp.getTypeReference()));
            if (classType != null) {
                filteredImports.add(imp);
                continue;
            }
            Debug.warning((String)("Prevented NPE in Recoder, Problem with Static on Demand Imports of Methods in Java 5, import: " + imp.toString()));
        }
        return filteredImports;
    }
}

