/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.java.recoder;

import java.io.PrintWriter;
import java.util.EventObject;
import java.util.List;
import recoder.java.CompilationUnit;
import recoder.java.ProgramElement;
import recoder.service.ChangeHistoryEvent;
import recoder.service.ChangeHistoryListener;
import recoder.service.ModelUpdateListener;
import recoder.service.TreeChange;
import recoder.util.ProgressEvent;
import recoder.util.ProgressListener;

public class ConsoleReports
implements ChangeHistoryListener,
ModelUpdateListener,
ProgressListener {
    private PrintWriter out;
    private int count = 0;
    private boolean printCompUnits = false;
    private long updateBeginTime;
    private int oldpercentage = -1;
    private Object oldstate = null;
    private long lastDisplayTime = 0L;
    static final long MIN_DELAY = 200L;
    static final int MAX_LINE_WIDTH = 77;

    public ConsoleReports(PrintWriter out) {
        if (out == null) {
            throw new NullPointerException("No output");
        }
        this.out = out;
    }

    public ConsoleReports(PrintWriter out, boolean printCompUnits) {
        if (out == null) {
            throw new NullPointerException("No output");
        }
        this.out = out;
        this.printCompUnits = printCompUnits;
    }

    public void modelChanged(ChangeHistoryEvent changes) {
        if (this.printCompUnits) {
            List news = changes.getChanges();
            int i = 0;
            int s = news.size();
            while (i < s) {
                ProgramElement pe = ((TreeChange)news.get(i)).getChangeRoot();
                if (pe instanceof CompilationUnit) {
                    ++this.count;
                    this.out.println("[" + this.count + "] " + ((CompilationUnit)pe).getName());
                    this.out.flush();
                }
                ++i;
            }
        }
    }

    public void modelUpdating(EventObject event) {
        this.out.println("Model Update Starts...");
        this.out.flush();
        this.updateBeginTime = System.currentTimeMillis();
    }

    public void modelUpdated(EventObject event) {
        long updateTime = System.currentTimeMillis() - this.updateBeginTime;
        this.out.println("...Model Updated in " + updateTime + "ms");
        this.out.flush();
    }

    public void workProgressed(ProgressEvent pe) {
        int max = pe.getWorkToDoCount();
        int val = pe.getWorkDoneCount();
        if (val == max) {
            val = 0;
            this.oldpercentage = -1;
            this.oldstate = null;
            StringBuffer output = new StringBuffer("\r100% (done)");
            int i = output.length();
            while (i < 77) {
                output.append(' ');
                ++i;
            }
            this.out.println(output);
            this.out.flush();
            return;
        }
        if (val > max) {
            max = val;
        }
        if (System.currentTimeMillis() - this.lastDisplayTime > 200L) {
            int p = 100 * val / max;
            Object state = pe.getState();
            if (p != this.oldpercentage || state != this.oldstate) {
                StringBuffer output = new StringBuffer("\r");
                if (p < 10) {
                    output.append("  ");
                } else if (p < 100) {
                    output.append(" ");
                }
                output.append(p);
                output.append('%');
                if (state != null) {
                    output.append(' ');
                    String msg = state.toString();
                    int msglength = msg.length();
                    int oversize = msglength - 72;
                    if (oversize > 0) {
                        int middle = (msglength - oversize - 3 + 1) / 2;
                        output.append(msg.substring(0, middle));
                        output.append("...");
                        output.append(msg.substring(msglength - middle, msglength));
                    } else {
                        output.append(msg);
                    }
                }
                int i = output.length();
                while (i < 77) {
                    output.append(' ');
                    ++i;
                }
                this.out.println(output);
                this.out.flush();
                this.lastDisplayTime = System.currentTimeMillis();
                this.oldpercentage = p;
                this.oldstate = state;
            }
        }
    }
}

