/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.java.builders;

import de.fzi.sissy.extractors.java.builders.Builder;
import de.fzi.sissy.extractors.java.builders.BuilderGroup;
import de.fzi.sissy.extractors.java.builders.ClassTypeBuilder;
import de.fzi.sissy.metamod.Class;
import de.fzi.sissy.metamod.Function;
import de.fzi.sissy.metamod.Statement;
import de.fzi.sissy.metamod.TypeParameterClass;
import java.util.ArrayList;
import java.util.List;
import recoder.abstraction.Field;
import recoder.abstraction.Method;
import recoder.abstraction.Type;
import recoder.convenience.TreeWalker;
import recoder.java.Expression;
import recoder.java.ProgramElement;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.TypeDeclarationContainer;

public class LocalClassesBuilder
extends Builder {
    private List<TypeDeclaration> typeDeclarations = new ArrayList<TypeDeclaration>();

    public LocalClassesBuilder(BuilderGroup builderGroup) {
        super(builderGroup);
    }

    public void extractFromRecoder(Method method_recoder) {
        if (method_recoder instanceof MethodDeclaration) {
            Function method_metamod = (Function)this.getBuilderGroup().getRecoderToOMMapper().getInstanceFromMapper(method_recoder);
            this.lookupAndAddClasses((ProgramElement)((MethodDeclaration)method_recoder), method_metamod);
        }
    }

    public void extractFromRecoder(Field field_recoder) {
        Expression init;
        if (field_recoder instanceof FieldSpecification && (init = ((FieldSpecification)field_recoder).getInitializer()) != null) {
            Statement initializer = (Statement)this.getBuilderGroup().getRecoderToOMMapper().getInstanceFromMapper(init);
            Function method_metamod = initializer.getSurroundingFunction();
            this.lookupAndAddClasses((ProgramElement)init, method_metamod);
        }
    }

    private void lookupAndAddClasses(ProgramElement programElement, Function method_metamod) {
        TreeWalker treeWalker = new TreeWalker(programElement);
        while (treeWalker.next()) {
            ProgramElement pe = treeWalker.getProgramElement();
            if (!(pe instanceof TypeDeclarationContainer)) continue;
            TypeDeclarationContainer tdc = (TypeDeclarationContainer)pe;
            this.retrieveClasstypesFromTypeDeclarationContainer(method_metamod, tdc);
        }
    }

    private void retrieveClasstypesFromTypeDeclarationContainer(Function method_metamod, TypeDeclarationContainer tdc) {
        int i = 0;
        while (i < tdc.getTypeDeclarationCount()) {
            TypeDeclaration typeDeclaration;
            ClassTypeBuilder classTypeBuilder = this.getBuilderGroup().getClassTypeBuilder();
            Class classType_metamod = (Class)classTypeBuilder.getOrCreateClassType((Type)(typeDeclaration = tdc.getTypeDeclarationAt(i)));
            if (!(classType_metamod instanceof TypeParameterClass)) {
                method_metamod.addLocalClass(classType_metamod);
            }
            this.getTypeDeclarations().add(typeDeclaration);
            ++i;
        }
    }

    public List<TypeDeclaration> getTypeDeclarations() {
        return this.typeDeclarations;
    }
}

