/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.java.builders;

import de.fzi.gast.expressions.ArrayValueSelection;
import de.fzi.gast.expressions.Assignment;
import de.fzi.gast.expressions.AssignmentOperations;
import de.fzi.gast.expressions.AssignmentOperatorExpression;
import de.fzi.gast.expressions.BoolLiteral;
import de.fzi.gast.expressions.BooleanExpression;
import de.fzi.gast.expressions.BooleanOperations;
import de.fzi.gast.expressions.BooleanOperatorExpression;
import de.fzi.gast.expressions.CastExpression;
import de.fzi.gast.expressions.CompareExpression;
import de.fzi.gast.expressions.CompareOperations;
import de.fzi.gast.expressions.ExpPosition;
import de.fzi.gast.expressions.ExpressionAnchor;
import de.fzi.gast.expressions.ExpressionAnchorKind;
import de.fzi.gast.expressions.FunctionCall;
import de.fzi.gast.expressions.FunctionCallPlaceholder;
import de.fzi.gast.expressions.GASTExpressionProxy;
import de.fzi.gast.expressions.IntLiteral;
import de.fzi.gast.expressions.Lvalue;
import de.fzi.gast.expressions.MemberAccessor;
import de.fzi.gast.expressions.MemberExpression;
import de.fzi.gast.expressions.NotExpression;
import de.fzi.gast.expressions.NullLiteral;
import de.fzi.gast.expressions.ParenthesisExpression;
import de.fzi.gast.expressions.Product;
import de.fzi.gast.expressions.ProductExpression;
import de.fzi.gast.expressions.ProductOperations;
import de.fzi.gast.expressions.Term;
import de.fzi.gast.expressions.TermExpression;
import de.fzi.gast.expressions.TermOperations;
import de.fzi.gast.expressions.TypeReference;
import de.fzi.gast.expressions.TypeReferencePlaceholder;
import de.fzi.gast.expressions.UnaryArithmeticExpression;
import de.fzi.gast.expressions.UnaryOperations;
import de.fzi.gast.expressions.Variable;
import de.fzi.gast.expressions.VariablePlaceholder;
import de.fzi.gast.expressions.expressionsFactory;
import de.fzi.gast.statements.GASTExpression;
import de.fzi.sissy.extractors.java.builders.Builder;
import de.fzi.sissy.extractors.java.builders.BuilderGroup;
import de.fzi.sissy.extractors.java.builders.Common;
import de.fzi.sissy.metamod.CastTypeAccess;
import de.fzi.sissy.metamod.File;
import de.fzi.sissy.metamod.Function;
import de.fzi.sissy.metamod.FunctionAccess;
import de.fzi.sissy.metamod.Member;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.ModelElementRepository;
import de.fzi.sissy.metamod.ParameterInstanciationTypeAccess;
import de.fzi.sissy.metamod.RunTimeTypeAccess;
import de.fzi.sissy.metamod.SelfAccess;
import de.fzi.sissy.metamod.SourceEntity;
import de.fzi.sissy.metamod.Statement;
import de.fzi.sissy.metamod.StaticTypeAccess;
import de.fzi.sissy.metamod.Type;
import de.fzi.sissy.metamod.TypeAccess;
import de.fzi.sissy.metamod.VariableAccess;
import de.fzi.sissy.utils.Debug;
import java.util.Iterator;
import recoder.abstraction.Constructor;
import recoder.abstraction.Field;
import recoder.abstraction.Method;
import recoder.abstraction.ParameterizedType;
import recoder.convenience.TreeWalker;
import recoder.java.CompilationUnit;
import recoder.java.Expression;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.Reference;
import recoder.java.SourceElement;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.java.expression.ExpressionStatement;
import recoder.java.expression.Literal;
import recoder.java.expression.Operator;
import recoder.java.expression.ParenthesizedExpression;
import recoder.java.expression.literal.BooleanLiteral;
import recoder.java.expression.literal.CharLiteral;
import recoder.java.expression.literal.DoubleLiteral;
import recoder.java.expression.literal.FloatLiteral;
import recoder.java.expression.literal.LongLiteral;
import recoder.java.expression.literal.StringLiteral;
import recoder.java.expression.operator.BinaryAnd;
import recoder.java.expression.operator.BinaryAndAssignment;
import recoder.java.expression.operator.BinaryNot;
import recoder.java.expression.operator.BinaryOr;
import recoder.java.expression.operator.BinaryOrAssignment;
import recoder.java.expression.operator.BinaryXOr;
import recoder.java.expression.operator.BinaryXOrAssignment;
import recoder.java.expression.operator.ComparativeOperator;
import recoder.java.expression.operator.Conditional;
import recoder.java.expression.operator.CopyAssignment;
import recoder.java.expression.operator.Divide;
import recoder.java.expression.operator.DivideAssignment;
import recoder.java.expression.operator.Equals;
import recoder.java.expression.operator.GreaterOrEquals;
import recoder.java.expression.operator.GreaterThan;
import recoder.java.expression.operator.Instanceof;
import recoder.java.expression.operator.LessOrEquals;
import recoder.java.expression.operator.LessThan;
import recoder.java.expression.operator.LogicalAnd;
import recoder.java.expression.operator.LogicalNot;
import recoder.java.expression.operator.LogicalOr;
import recoder.java.expression.operator.Minus;
import recoder.java.expression.operator.MinusAssignment;
import recoder.java.expression.operator.Modulo;
import recoder.java.expression.operator.ModuloAssignment;
import recoder.java.expression.operator.Negative;
import recoder.java.expression.operator.NewArray;
import recoder.java.expression.operator.NotEquals;
import recoder.java.expression.operator.Plus;
import recoder.java.expression.operator.PlusAssignment;
import recoder.java.expression.operator.PostDecrement;
import recoder.java.expression.operator.PostIncrement;
import recoder.java.expression.operator.PreDecrement;
import recoder.java.expression.operator.PreIncrement;
import recoder.java.expression.operator.ShiftLeft;
import recoder.java.expression.operator.ShiftLeftAssignment;
import recoder.java.expression.operator.ShiftRight;
import recoder.java.expression.operator.ShiftRightAssignment;
import recoder.java.expression.operator.Times;
import recoder.java.expression.operator.TimesAssignment;
import recoder.java.expression.operator.TypeCast;
import recoder.java.expression.operator.UnsignedShiftRight;
import recoder.java.expression.operator.UnsignedShiftRightAssignment;
import recoder.java.reference.ArrayReference;
import recoder.java.reference.ConstructorReference;
import recoder.java.reference.FieldReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.SuperReference;
import recoder.java.reference.ThisReference;
import recoder.java.reference.VariableReference;
import recoder.java.statement.Branch;
import recoder.java.statement.BranchStatement;
import recoder.java.statement.Case;
import recoder.java.statement.ExpressionJumpStatement;
import recoder.java.statement.If;
import recoder.java.statement.LoopStatement;
import recoder.java.statement.Switch;
import recoder.java.statement.Try;
import recoder.kit.UnitKit;
import recoder.list.generic.ASTList;

public class ExpressionBuilder
extends Builder {
    private ModelElementRepository repository;
    private expressionsFactory factory = expressionsFactory.eINSTANCE;

    public ExpressionBuilder(BuilderGroup builderGroup) {
        super(builderGroup);
        this.repository = ModelElementRepository.getWorkingRepository();
    }

    private void setPositionFromFileBuilderForExpressions(SourceElement sourceElement, GASTExpressionProxy expressionproxy) {
        ExpPosition position = this.factory.createExpPosition();
        File file = null;
        ProgramElement pe = (ProgramElement)sourceElement;
        CompilationUnit compilationUnit = UnitKit.getCompilationUnit((ProgramElement)pe);
        if (compilationUnit != null) {
            file = (File)this.getModelElementFromMapper(compilationUnit);
        } else {
            Debug.warning((String)"getSourcePosition: No Compilation Unit Found");
        }
        position.setFileSissyID(String.valueOf(file.getUniqueId()));
        position.setStartLine(sourceElement.getStartPosition().getLine());
        position.setStartColumn(sourceElement.getStartPosition().getColumn());
        position.setEndLine(sourceElement.getEndPosition().getLine());
        position.setEndColumn(sourceElement.getEndPosition().getColumn());
        expressionproxy.setExpPosition(position);
    }

    public ProgramElement convertExpressionFromAnchor(ProgramElement element_recoder, ProgramElement anchor_recoder, ExpressionAnchorKind anchorKind, boolean isWrite) {
        ExpressionAnchor expAnchor = this.factory.createExpressionAnchor();
        ModelElement anchor_metamod = this.getModelElementFromMapper(anchor_recoder);
        if (anchor_metamod == null) {
            Debug.error((String)("\n Anchor not in mapper: " + anchor_recoder.getStartPosition().getLine() + ">" + anchor_recoder.toSource() + "\t" + anchor_recoder.getClass().getName()));
            return null;
        }
        expAnchor.setSissyModelElementID(String.valueOf(anchor_metamod.getUniqueId()));
        expAnchor.setExpressionanchorkind(anchorKind);
        GASTExpression expression = this.convertExpression(element_recoder, isWrite);
        expAnchor.setGastexpressionproxy((GASTExpressionProxy)expression);
        this.repository.addExpressionAnchor(expAnchor);
        TreeWalker treeWalker = new TreeWalker(element_recoder);
        ProgramElement lastEl = element_recoder;
        while (treeWalker.next()) {
            lastEl = treeWalker.getProgramElement();
        }
        return lastEl;
    }

    public void extractFromRecoder(Method method_recoder) {
        if (method_recoder instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration_recoder = (MethodDeclaration)method_recoder;
            Function method_metamod = (Function)this.getModelElementFromMapper(method_recoder);
            if (method_metamod == null) {
                Debug.error((String)"No metamod function found for a given recoder function");
                return;
            }
            this.walkToFindAndCreateExpressions((ProgramElement)methodDeclaration_recoder);
        }
    }

    public void extractFromRecoder(Field field_recoder) {
        if (field_recoder instanceof FieldSpecification) {
            de.fzi.sissy.metamod.Field field_metamod = (de.fzi.sissy.metamod.Field)this.getModelElementFromMapper(field_recoder);
            if (field_metamod == null) {
                Debug.error((String)"No field function found for a given recoder field");
                return;
            }
            this.walkToFindAndCreateExpressions((ProgramElement)((FieldSpecification)field_recoder));
        }
    }

    private void walkToFindAndCreateExpressions(ProgramElement pe) {
        this.convertChildren(pe, ExpressionAnchorKind.CONDITION);
    }

    private ProgramElement convertChildren(ProgramElement pe, ExpressionAnchorKind anchorKind) {
        TreeWalker treeWalker = new TreeWalker(pe);
        ProgramElement element_recoder = pe;
        while (treeWalker.next()) {
            element_recoder = treeWalker.getProgramElement();
            if (element_recoder instanceof ExpressionStatement) {
                element_recoder = this.convertExpressionFromAnchor(element_recoder, element_recoder, anchorKind, false);
            } else if (element_recoder instanceof VariableSpecification) {
                Expression init = ((VariableSpecification)element_recoder).getInitializer();
                if (init != null) {
                    ProgramElement parent_recoder = element_recoder;
                    ModelElement parent_metamod = null;
                    while (parent_metamod == null || !(parent_metamod instanceof Statement)) {
                        parent_recoder = parent_recoder.getASTParent();
                        parent_metamod = this.getModelElementFromMapper(parent_recoder);
                    }
                    element_recoder = this.convertExpressionFromAnchor((ProgramElement)init, parent_recoder, anchorKind, false);
                }
            } else if (element_recoder instanceof LoopStatement) {
                element_recoder = this.convertLoopStatement(element_recoder);
            } else if (element_recoder instanceof BranchStatement) {
                element_recoder = this.convertBranchStatement(element_recoder);
            } else {
                if (!(element_recoder instanceof ExpressionJumpStatement)) continue;
                element_recoder = this.convertExpressionFromAnchor((ProgramElement)((ExpressionJumpStatement)element_recoder).getExpression(), element_recoder, ExpressionAnchorKind.CONDITION, false);
            }
            if (element_recoder == null) continue;
            while (element_recoder != treeWalker.getProgramElement()) {
                treeWalker.next();
            }
        }
        return element_recoder;
    }

    private ProgramElement convertBranchStatement(ProgramElement element_recoder) {
        BranchStatement branchStmt_recoder = (BranchStatement)element_recoder;
        if (branchStmt_recoder instanceof If) {
            this.convertExpressionFromAnchor((ProgramElement)((If)branchStmt_recoder).getExpression(), (ProgramElement)branchStmt_recoder, ExpressionAnchorKind.CONDITION, false);
        } else if (branchStmt_recoder instanceof Switch) {
            this.convertExpressionFromAnchor((ProgramElement)((Switch)branchStmt_recoder).getExpression(), (ProgramElement)branchStmt_recoder, ExpressionAnchorKind.CONDITION, false);
        } else if (branchStmt_recoder instanceof Try) {
            element_recoder = this.convertChildren((ProgramElement)((Try)branchStmt_recoder).getBody(), ExpressionAnchorKind.CONDITION);
        }
        int i = 0;
        while (i < branchStmt_recoder.getBranchCount()) {
            Branch branch = branchStmt_recoder.getBranchAt(i);
            if (branch instanceof Case) {
                this.convertExpressionFromAnchor((ProgramElement)((Case)branch).getExpression(), (ProgramElement)branch, ExpressionAnchorKind.CONDITION, false);
            }
            element_recoder = this.convertChildren((ProgramElement)branch, ExpressionAnchorKind.CONDITION);
            ++i;
        }
        return element_recoder;
    }

    private ProgramElement convertLoopStatement(ProgramElement element_recoder) {
        ASTList updates;
        LoopStatement loopStmt_recoder = (LoopStatement)element_recoder;
        ASTList inits = loopStmt_recoder.getInitializers();
        if (inits != null) {
            Iterator it = inits.iterator();
            while (it.hasNext()) {
                this.convertChildren((ProgramElement)it.next(), ExpressionAnchorKind.INIT);
            }
        }
        if ((updates = loopStmt_recoder.getUpdates()) != null) {
            Iterator exprIt = updates.iterator();
            while (exprIt.hasNext()) {
                this.convertExpressionFromAnchor((ProgramElement)exprIt.next(), (ProgramElement)loopStmt_recoder, ExpressionAnchorKind.INCREMENT, false);
            }
        }
        this.convertExpressionFromAnchor((ProgramElement)loopStmt_recoder.getGuard(), (ProgramElement)loopStmt_recoder, ExpressionAnchorKind.CONDITION, false);
        element_recoder = this.convertChildren((ProgramElement)loopStmt_recoder.getBody(), ExpressionAnchorKind.CONDITION);
        return element_recoder;
    }

    private GASTExpression convertExpression(ProgramElement element_recoder, boolean isWrite) {
        if (element_recoder instanceof Instanceof) {
            return this.convertInstanceof((Instanceof)element_recoder);
        }
        if (element_recoder instanceof NewArray) {
            return this.convertNewArray((NewArray)element_recoder);
        }
        if (element_recoder instanceof ConstructorReference) {
            return this.convertConstructorReference((ConstructorReference)element_recoder);
        }
        if (element_recoder instanceof MethodReference) {
            return this.convertMethodReference((MethodReference)element_recoder);
        }
        if (element_recoder instanceof VariableReference) {
            return this.convertVariableReference((VariableReference)element_recoder, isWrite);
        }
        if (element_recoder instanceof ParenthesizedExpression) {
            return this.convertParenthesizedExpression((ParenthesizedExpression)element_recoder, isWrite);
        }
        if (element_recoder instanceof TypeCast) {
            return this.convertCastExpression((TypeCast)element_recoder);
        }
        if (element_recoder instanceof recoder.java.reference.TypeReference) {
            return this.convertTypeReference((recoder.java.reference.TypeReference)element_recoder);
        }
        if (element_recoder instanceof ArrayReference) {
            return this.convertArrayReference((ArrayReference)element_recoder);
        }
        if (element_recoder instanceof Literal) {
            return this.convertLiteral((Literal)element_recoder);
        }
        if (element_recoder instanceof ThisReference) {
            return this.convertThisReference((ThisReference)element_recoder);
        }
        if (element_recoder instanceof SuperReference) {
            return this.convertSuperReference((SuperReference)element_recoder);
        }
        if (element_recoder instanceof Operator) {
            Operator operator_recoder = (Operator)element_recoder;
            if (operator_recoder.getArity() == 1) {
                return this.convertUnaryExpression(operator_recoder);
            }
            if (operator_recoder.getArity() == 2) {
                return this.convertBinaryExpression(operator_recoder);
            }
            return this.convertConditional((Conditional)operator_recoder);
        }
        return null;
    }

    private GASTExpression convertNewArray(NewArray newArray_recoder) {
        recoder.java.reference.TypeReference typeref = newArray_recoder.getTypeReference();
        recoder.abstraction.Type type_recoder = this.getSourceInfo().getType(typeref);
        Type type_metamod = (Type)this.getModelElementFromMapper(type_recoder);
        ParameterInstanciationTypeAccess pita = new ParameterInstanciationTypeAccess(type_metamod);
        TypeReferencePlaceholder trp = this.factory.createTypeReferencePlaceholder();
        this.setPositionFromFileBuilderForExpressions((SourceElement)typeref, (GASTExpressionProxy)trp);
        trp.setSissyModelElementID(String.valueOf(pita.getUniqueId()));
        return trp;
    }

    private GASTExpression convertConstructorReference(ConstructorReference constructorRef_recoder) {
        Constructor referencedConstructor_recoder = this.getSourceInfo().getConstructor(constructorRef_recoder);
        if (referencedConstructor_recoder != null) {
            de.fzi.sissy.metamod.Constructor accessedConstructor_metamod = (de.fzi.sissy.metamod.Constructor)this.getModelElementFromMapper(referencedConstructor_recoder);
            FunctionAccess functionAccess = new FunctionAccess((Function)accessedConstructor_metamod);
            this.setPositionFromFileBuilder((SourceElement)constructorRef_recoder, (SourceEntity)functionAccess);
            Common.extractTypeArguments(functionAccess, constructorRef_recoder, this.getBuilderGroup());
            FunctionCallPlaceholder fcp = this.factory.createFunctionCallPlaceholder();
            this.setPositionFromFileBuilderForExpressions((SourceElement)constructorRef_recoder, (GASTExpressionProxy)fcp);
            fcp.setSissyModelElementID(String.valueOf(functionAccess.getUniqueId()));
            ASTList arguments = constructorRef_recoder.getArguments();
            if (arguments != null) {
                this.convertArguments(fcp, (ASTList<Expression>)arguments);
            }
            return fcp;
        }
        return null;
    }

    private GASTExpression convertParenthesizedExpression(ParenthesizedExpression parenthesizedExpression_recoder, boolean isWrite) {
        Assignment expression_metamod = (Assignment)this.convertExpression((ProgramElement)((Expression)parenthesizedExpression_recoder.getChildAt(0)), isWrite);
        ParenthesisExpression pe = this.factory.createParenthesisExpression();
        this.setPositionFromFileBuilderForExpressions((SourceElement)parenthesizedExpression_recoder, (GASTExpressionProxy)pe);
        pe.setInner(expression_metamod);
        return pe;
    }

    private GASTExpression convertStaticTypeReference(recoder.java.reference.TypeReference typeReference_recoder) {
        TypeReferencePlaceholder typeReference_metamod = this.factory.createTypeReferencePlaceholder();
        this.setPositionFromFileBuilderForExpressions((SourceElement)typeReference_recoder, (GASTExpressionProxy)typeReference_metamod);
        recoder.abstraction.Type referencedType_recoder = this.getSourceInfo().getType(typeReference_recoder);
        Type metamod_type = (Type)this.getModelElementFromMapper(referencedType_recoder);
        if (metamod_type != null) {
            StaticTypeAccess sta_metamod = new StaticTypeAccess(metamod_type);
            this.setPositionFromFileBuilder((SourceElement)typeReference_recoder, (SourceEntity)sta_metamod);
            typeReference_metamod.setSissyModelElementID(String.valueOf(sta_metamod.getUniqueId()));
        } else {
            Debug.warning((String)"StaticTypeAccess-Generation: Metamod-Type was null!");
        }
        ReferencePrefix prefix = typeReference_recoder.getReferencePrefix();
        if (prefix != null) {
            MemberExpression me = (MemberExpression)this.convertStaticTypeReference((recoder.java.reference.TypeReference)prefix);
            MemberAccessor ma = this.factory.createMemberAccessor();
            this.setPositionFromFileBuilderForExpressions((SourceElement)prefix, (GASTExpressionProxy)ma);
            ma.setLeft(me);
            ma.setRight((de.fzi.gast.expressions.Reference)typeReference_metamod);
            return ma;
        }
        return typeReference_metamod;
    }

    private GASTExpression convertMethodReference(MethodReference methodRef_recoder) {
        Method referencedMethod_recoder = this.getSourceInfo().getMethod(methodRef_recoder);
        if (referencedMethod_recoder != null) {
            ReferencePrefix prefix;
            de.fzi.sissy.metamod.Method accessedMethod_metamod = (de.fzi.sissy.metamod.Method)this.getModelElementFromMapper(referencedMethod_recoder);
            FunctionAccess functionAccess = new FunctionAccess((Function)accessedMethod_metamod);
            this.setPositionFromFileBuilder((SourceElement)methodRef_recoder, (SourceEntity)functionAccess);
            Common.extractTypeArguments(functionAccess, methodRef_recoder, this.getBuilderGroup());
            FunctionCallPlaceholder fcp = this.factory.createFunctionCallPlaceholder();
            this.setPositionFromFileBuilderForExpressions((SourceElement)methodRef_recoder, (GASTExpressionProxy)fcp);
            fcp.setSissyModelElementID(String.valueOf(functionAccess.getUniqueId()));
            ASTList arguments = methodRef_recoder.getArguments();
            if (arguments != null) {
                this.convertArguments(fcp, (ASTList<Expression>)arguments);
            }
            if ((prefix = methodRef_recoder.getReferencePrefix()) != null) {
                MemberAccessor ma = this.factory.createMemberAccessor();
                this.setPositionFromFileBuilderForExpressions((SourceElement)prefix, (GASTExpressionProxy)ma);
                if (prefix instanceof ThisReference) {
                    ma.setLeft(this.convertThisReference((ThisReference)prefix));
                } else if (prefix instanceof SuperReference) {
                    ma.setLeft(this.convertSuperReference((SuperReference)prefix));
                } else if (prefix instanceof recoder.java.reference.TypeReference) {
                    ma.setLeft((MemberExpression)this.convertStaticTypeReference((recoder.java.reference.TypeReference)prefix));
                } else {
                    ma.setLeft((MemberExpression)this.convertExpression((ProgramElement)prefix, false));
                }
                ma.setRight((de.fzi.gast.expressions.Reference)fcp);
                return ma;
            }
            return fcp;
        }
        return null;
    }

    private void convertArguments(FunctionCallPlaceholder fcp, ASTList<Expression> arguments) {
        for (Expression expression : arguments) {
            Assignment assignment = (Assignment)this.convertExpression((ProgramElement)expression, false);
            if (assignment != null) {
                fcp.getParameterexpression().add((Object)assignment);
                continue;
            }
            Debug.error((String)("Returned assignment was null, Expression Type: " + expression.getClass().toString()));
        }
    }

    private MemberExpression convertSuperReference(SuperReference this_recoder) {
        SelfAccess this_metamod = this.constructSelfAccess((Reference)this_recoder);
        this_metamod.setSuperAccess(true);
        VariablePlaceholder vp = this.factory.createVariablePlaceholder();
        this.setPositionFromFileBuilderForExpressions((SourceElement)this_recoder, (GASTExpressionProxy)vp);
        vp.setSissyModelElementID(String.valueOf(this_metamod.getUniqueId()));
        return vp;
    }

    private MemberExpression convertThisReference(ThisReference this_recoder) {
        SelfAccess this_metamod = this.constructSelfAccess((Reference)this_recoder);
        VariablePlaceholder vp = this.factory.createVariablePlaceholder();
        this.setPositionFromFileBuilderForExpressions((SourceElement)this_recoder, (GASTExpressionProxy)vp);
        vp.setSissyModelElementID(String.valueOf(this_metamod.getUniqueId()));
        return vp;
    }

    private SelfAccess constructSelfAccess(Reference this_recoder) {
        ModelElement parent_metamod;
        NonTerminalProgramElement parent_recoder = this_recoder.getASTParent();
        do {
            if (parent_recoder instanceof MethodReference) {
                Method referencedMethod_recoder = this.getSourceInfo().getMethod((MethodReference)parent_recoder);
                if (referencedMethod_recoder != null) {
                    de.fzi.sissy.metamod.Method accessedMethod_metamod = (de.fzi.sissy.metamod.Method)this.getModelElementFromMapper(referencedMethod_recoder);
                    parent_metamod = accessedMethod_metamod;
                    break;
                }
            } else if (parent_recoder instanceof FieldReference) {
                recoder.abstraction.Variable variable_recoder = this.getSourceInfo().getVariable((VariableReference)parent_recoder);
                de.fzi.sissy.metamod.Variable variable_metamod = (de.fzi.sissy.metamod.Variable)this.getModelElementFromMapper(variable_recoder);
                parent_metamod = variable_metamod;
                break;
            }
            parent_metamod = this.getModelElementFromMapper(parent_recoder);
            parent_recoder = parent_recoder.getASTParent();
        } while (!(parent_metamod instanceof Member));
        SelfAccess this_metamod = new SelfAccess(((Member)parent_metamod).getSurroundingClass());
        return this_metamod;
    }

    private GASTExpression convertVariableReference(VariableReference variableReference_recoder, boolean write) {
        FieldReference fieldReference_recoder;
        ReferencePrefix prefix;
        recoder.abstraction.Variable variable_recoder = this.getSourceInfo().getVariable(variableReference_recoder);
        de.fzi.sissy.metamod.Variable variable_metamod = null;
        variable_metamod = (de.fzi.sissy.metamod.Variable)this.getModelElementFromMapper(variable_recoder);
        VariableAccess access_metamod = new VariableAccess(variable_metamod, write);
        this.setPositionFromFileBuilder((SourceElement)variableReference_recoder, (SourceEntity)access_metamod);
        VariablePlaceholder vp = this.factory.createVariablePlaceholder();
        this.setPositionFromFileBuilderForExpressions((SourceElement)variableReference_recoder, (GASTExpressionProxy)vp);
        vp.setSissyModelElementID(String.valueOf(access_metamod.getUniqueId()));
        if (variableReference_recoder instanceof FieldReference && (prefix = (fieldReference_recoder = (FieldReference)variableReference_recoder).getReferencePrefix()) != null) {
            MemberAccessor ma = this.factory.createMemberAccessor();
            this.setPositionFromFileBuilderForExpressions((SourceElement)fieldReference_recoder, (GASTExpressionProxy)ma);
            if (prefix != null) {
                if (prefix instanceof ThisReference) {
                    MemberExpression me = this.convertFieldThis(variableReference_recoder, false, ma);
                    ma.setLeft(me);
                } else if (prefix instanceof SuperReference) {
                    MemberExpression me = this.convertFieldThis(variableReference_recoder, true, ma);
                    ma.setLeft(me);
                } else if (prefix instanceof recoder.java.reference.TypeReference) {
                    ma.setLeft((MemberExpression)this.convertStaticTypeReference((recoder.java.reference.TypeReference)prefix));
                } else {
                    ma.setLeft((MemberExpression)this.convertExpression((ProgramElement)prefix, false));
                }
                ma.setRight((de.fzi.gast.expressions.Reference)vp);
                return ma;
            }
        }
        return vp;
    }

    private MemberExpression convertFieldThis(VariableReference variableReference_recoder, boolean isSuper, MemberAccessor memberAccessor) {
        ThisReference this_recoder = (ThisReference)((FieldReference)variableReference_recoder).getReferencePrefix();
        return this.convertThisReference(this_recoder);
    }

    private GASTExpression convertArrayReference(ArrayReference arrayRef_recoder) {
        GASTExpression array_metamod = this.convertExpression((ProgramElement)arrayRef_recoder.getExpressionAt(0), false);
        ASTList dimensionExpressions = arrayRef_recoder.getDimensionExpressions();
        Iterator it = dimensionExpressions.iterator();
        ArrayValueSelection avs = this.factory.createArrayValueSelection();
        this.setPositionFromFileBuilderForExpressions((SourceElement)arrayRef_recoder, (GASTExpressionProxy)avs);
        while (it.hasNext()) {
            avs.getIndex().add((Object)((Term)this.convertExpression((ProgramElement)it.next(), false)));
        }
        if (array_metamod instanceof Variable) {
            Variable v = (Variable)array_metamod;
            v.setArrayvalueselection(avs);
            return v;
        }
        FunctionCall fc = (FunctionCall)array_metamod;
        fc.setArrayvalueselection(avs);
        return fc;
    }

    private GASTExpression convertInstanceof(Instanceof instanceof_recoder) {
        CompareExpression ce = this.factory.createCompareExpression();
        this.setPositionFromFileBuilderForExpressions((SourceElement)instanceof_recoder, (GASTExpressionProxy)ce);
        ce.setOperation(CompareOperations.INSTANCEOF);
        ce.setLeft((Term)this.convertExpression((ProgramElement)instanceof_recoder.getExpressionAt(0), false));
        ce.setRight((Term)this.convertExpression((ProgramElement)instanceof_recoder.getTypeReference(), false));
        return ce;
    }

    private GASTExpression convertTypeReference(recoder.java.reference.TypeReference typeRef_recoder) {
        recoder.abstraction.Type referencedType_recoder = this.getSourceInfo().getType(typeRef_recoder);
        if (!typeRef_recoder.getName().equals("void") && referencedType_recoder == null) {
            Debug.warning((String)("CAB: Recoder-Referenced-Type was null! " + typeRef_recoder.getName()));
            return null;
        }
        recoder.abstraction.Type oldType_recoder = referencedType_recoder;
        if (referencedType_recoder instanceof ParameterizedType) {
            referencedType_recoder = ((ParameterizedType)referencedType_recoder).getGenericType();
        }
        Type referenced_classType_metamod = this.getBuilderGroup().getClassTypeBuilder().getOrCreateClassType(referencedType_recoder);
        if (!typeRef_recoder.getName().equals("void") && referenced_classType_metamod == null) {
            Debug.warning((String)("CAB: Metamod-Referenced-Type was null! " + typeRef_recoder.getName()));
            return null;
        }
        NonTerminalProgramElement typeReference_parent = typeRef_recoder.getASTParent();
        TypeReferencePlaceholder trp = this.factory.createTypeReferencePlaceholder();
        this.setPositionFromFileBuilderForExpressions((SourceElement)typeReference_parent, (GASTExpressionProxy)trp);
        if (typeReference_parent instanceof TypeCast) {
            CastTypeAccess access = this.convertCastTypeAccess(typeRef_recoder, oldType_recoder, referenced_classType_metamod, typeReference_parent);
            trp.setSissyModelElementID(String.valueOf(access.getUniqueId()));
            return trp;
        }
        if (typeReference_parent instanceof Instanceof) {
            RunTimeTypeAccess access = this.convertRuntimeTypeAccess(typeRef_recoder, oldType_recoder, referenced_classType_metamod, typeReference_parent);
            trp.setSissyModelElementID(String.valueOf(access.getUniqueId()));
            return trp;
        }
        return null;
    }

    private RunTimeTypeAccess convertRuntimeTypeAccess(recoder.java.reference.TypeReference typeRef_recoder, recoder.abstraction.Type oldType_recoder, Type referenced_classType_metamod, NonTerminalProgramElement typeReference_parent) {
        Instanceof instanceof_recoder = (Instanceof)typeReference_parent;
        RunTimeTypeAccess rtt_access = new RunTimeTypeAccess(referenced_classType_metamod);
        Common.extractTypeArguments((TypeAccess)rtt_access, oldType_recoder, this.getBuilderGroup());
        this.setPositionFromFileBuilder((SourceElement)instanceof_recoder, (SourceEntity)rtt_access);
        return rtt_access;
    }

    private CastTypeAccess convertCastTypeAccess(recoder.java.reference.TypeReference typeRef_recoder, recoder.abstraction.Type oldType_recoder, Type referenced_classType_metamod, NonTerminalProgramElement typeReference_parent) {
        TypeCast typeCast = (TypeCast)typeReference_parent;
        CastTypeAccess castTypeAccess = new CastTypeAccess(referenced_classType_metamod);
        Common.extractTypeArguments((TypeAccess)castTypeAccess, oldType_recoder, this.getBuilderGroup());
        this.setPositionFromFileBuilder((SourceElement)typeCast, (SourceEntity)castTypeAccess);
        return castTypeAccess;
    }

    private GASTExpression convertCastExpression(TypeCast typeOperator_recoder) {
        TypeReferencePlaceholder trp = (TypeReferencePlaceholder)this.convertExpression((ProgramElement)typeOperator_recoder.getTypeReference(), false);
        BooleanExpression castedEspression_metamod = (BooleanExpression)this.convertExpression((ProgramElement)((Expression)typeOperator_recoder.getChildAt(1)), false);
        CastExpression ce = this.factory.createCastExpression();
        this.setPositionFromFileBuilderForExpressions((SourceElement)typeOperator_recoder, (GASTExpressionProxy)ce);
        ce.setType((TypeReference)trp);
        ce.setExpression(castedEspression_metamod);
        return ce;
    }

    private GASTExpression convertConditional(Conditional conditional_recoder) {
        de.fzi.gast.expressions.Conditional cond = this.factory.createConditional();
        this.setPositionFromFileBuilderForExpressions((SourceElement)conditional_recoder, (GASTExpressionProxy)cond);
        cond.setCondition((BooleanExpression)this.convertExpression((ProgramElement)conditional_recoder.getExpressionAt(0), false));
        cond.setThen((BooleanExpression)this.convertExpression((ProgramElement)conditional_recoder.getExpressionAt(1), false));
        cond.setElse((BooleanExpression)this.convertExpression((ProgramElement)conditional_recoder.getExpressionAt(2), false));
        return cond;
    }

    private GASTExpression convertLiteral(Literal literal_recoder) {
        if (literal_recoder instanceof BooleanLiteral) {
            BoolLiteral bl = this.factory.createBoolLiteral();
            this.setPositionFromFileBuilderForExpressions((SourceElement)literal_recoder, (GASTExpressionProxy)bl);
            bl.setValue(((BooleanLiteral)literal_recoder).getValue());
            return bl;
        }
        if (literal_recoder instanceof CharLiteral) {
            de.fzi.gast.expressions.CharLiteral cl = this.factory.createCharLiteral();
            this.setPositionFromFileBuilderForExpressions((SourceElement)literal_recoder, (GASTExpressionProxy)cl);
            cl.setValue(((CharLiteral)literal_recoder).getValue().codePointAt(1));
            return cl;
        }
        if (literal_recoder instanceof DoubleLiteral) {
            de.fzi.gast.expressions.DoubleLiteral dl = this.factory.createDoubleLiteral();
            this.setPositionFromFileBuilderForExpressions((SourceElement)literal_recoder, (GASTExpressionProxy)dl);
            dl.setValue(Double.parseDouble(((DoubleLiteral)literal_recoder).getValue()));
            return dl;
        }
        if (literal_recoder instanceof FloatLiteral) {
            de.fzi.gast.expressions.DoubleLiteral dl = this.factory.createDoubleLiteral();
            this.setPositionFromFileBuilderForExpressions((SourceElement)literal_recoder, (GASTExpressionProxy)dl);
            dl.setValue(Double.parseDouble(((FloatLiteral)literal_recoder).getValue()));
            return dl;
        }
        if (literal_recoder instanceof recoder.java.expression.literal.IntLiteral) {
            IntLiteral il = this.factory.createIntLiteral();
            this.setPositionFromFileBuilderForExpressions((SourceElement)literal_recoder, (GASTExpressionProxy)il);
            il.setValue((long)Integer.parseInt(((recoder.java.expression.literal.IntLiteral)literal_recoder).getValue()));
            return il;
        }
        if (literal_recoder instanceof LongLiteral) {
            IntLiteral il = this.factory.createIntLiteral();
            this.setPositionFromFileBuilderForExpressions((SourceElement)literal_recoder, (GASTExpressionProxy)il);
            il.setValue(Long.parseLong(((LongLiteral)literal_recoder).getValue().replace("l", "").replace("L", "")));
            return il;
        }
        if (literal_recoder instanceof recoder.java.expression.literal.NullLiteral) {
            NullLiteral nl = this.factory.createNullLiteral();
            this.setPositionFromFileBuilderForExpressions((SourceElement)literal_recoder, (GASTExpressionProxy)nl);
            return nl;
        }
        if (literal_recoder instanceof StringLiteral) {
            de.fzi.gast.expressions.StringLiteral sl = this.factory.createStringLiteral();
            this.setPositionFromFileBuilderForExpressions((SourceElement)literal_recoder, (GASTExpressionProxy)sl);
            String value = ((StringLiteral)literal_recoder).getValue();
            value = value.substring(1, value.length() - 1);
            sl.setValue(value);
            return sl;
        }
        return null;
    }

    private GASTExpression convertUnaryExpression(Operator unaryExpression_recoder) {
        if (unaryExpression_recoder instanceof LogicalNot) {
            NotExpression ne = this.factory.createNotExpression();
            this.setPositionFromFileBuilderForExpressions((SourceElement)unaryExpression_recoder, (GASTExpressionProxy)ne);
            ne.setInner((BooleanExpression)((Term)this.convertExpression((ProgramElement)unaryExpression_recoder.getExpressionAt(0), false)));
            return ne;
        }
        UnaryArithmeticExpression uae = this.factory.createUnaryArithmeticExpression();
        this.setPositionFromFileBuilderForExpressions((SourceElement)unaryExpression_recoder, (GASTExpressionProxy)uae);
        boolean isWrite = false;
        if (unaryExpression_recoder instanceof PreIncrement) {
            uae.setOperation(UnaryOperations.PREINCREMENT);
            isWrite = true;
        } else if (unaryExpression_recoder instanceof PreDecrement) {
            uae.setOperation(UnaryOperations.PREDECREMENT);
            isWrite = true;
        } else if (unaryExpression_recoder instanceof PostIncrement) {
            uae.setOperation(UnaryOperations.POSTINCREMENT);
            isWrite = true;
        } else if (unaryExpression_recoder instanceof PostDecrement) {
            uae.setOperation(UnaryOperations.POSTDECREMENT);
            isWrite = true;
        } else if (unaryExpression_recoder instanceof Negative) {
            uae.setOperation(UnaryOperations.UNARYMINUS);
        } else if (unaryExpression_recoder instanceof BinaryNot) {
            uae.setOperation(UnaryOperations.NEGATION);
        }
        uae.setInner((Term)this.convertExpression((ProgramElement)unaryExpression_recoder.getExpressionAt(0), isWrite));
        return uae;
    }

    private GASTExpression convertBinaryExpression(Operator binaryExpression_recoder) {
        if (binaryExpression_recoder instanceof recoder.java.expression.Assignment) {
            return this.convertAssignment((recoder.java.expression.Assignment)binaryExpression_recoder);
        }
        if (binaryExpression_recoder instanceof Plus || binaryExpression_recoder instanceof Minus) {
            return this.convertTermExpression(binaryExpression_recoder);
        }
        if (binaryExpression_recoder instanceof Times || binaryExpression_recoder instanceof Divide || binaryExpression_recoder instanceof Modulo) {
            return this.convertProductExpression(binaryExpression_recoder);
        }
        if (binaryExpression_recoder instanceof ComparativeOperator) {
            return this.convertCompareExpression(binaryExpression_recoder);
        }
        if (binaryExpression_recoder instanceof LogicalAnd || binaryExpression_recoder instanceof LogicalOr || binaryExpression_recoder instanceof BinaryAnd || binaryExpression_recoder instanceof BinaryOr || binaryExpression_recoder instanceof BinaryXOr || binaryExpression_recoder instanceof ShiftLeft || binaryExpression_recoder instanceof ShiftRight || binaryExpression_recoder instanceof UnsignedShiftRight) {
            return this.convertBooleanExpression(binaryExpression_recoder);
        }
        return null;
    }

    private GASTExpression convertBooleanExpression(Operator binaryExpression_recoder) {
        BooleanOperatorExpression boe = this.factory.createBooleanOperatorExpression();
        this.setPositionFromFileBuilderForExpressions((SourceElement)binaryExpression_recoder, (GASTExpressionProxy)boe);
        boe.setLeft((BooleanExpression)this.convertExpression((ProgramElement)binaryExpression_recoder.getExpressionAt(0), false));
        boe.setRight((BooleanExpression)this.convertExpression((ProgramElement)binaryExpression_recoder.getExpressionAt(1), false));
        if (binaryExpression_recoder instanceof LogicalAnd) {
            boe.setOperation(BooleanOperations.AND);
        } else if (binaryExpression_recoder instanceof LogicalOr) {
            boe.setOperation(BooleanOperations.OR);
        } else if (binaryExpression_recoder instanceof BinaryAnd) {
            boe.setOperation(BooleanOperations.BITAND);
        } else if (binaryExpression_recoder instanceof BinaryOr) {
            boe.setOperation(BooleanOperations.BITOR);
        } else if (binaryExpression_recoder instanceof BinaryXOr) {
            boe.setOperation(BooleanOperations.BITXOR);
        } else if (binaryExpression_recoder instanceof ShiftLeft) {
            boe.setOperation(BooleanOperations.SHIFTLEFT);
        } else if (binaryExpression_recoder instanceof ShiftRight) {
            boe.setOperation(BooleanOperations.SHIFTRIGHT);
        } else if (binaryExpression_recoder instanceof UnsignedShiftRight) {
            boe.setOperation(BooleanOperations.UNSIGNEDSHIFTRIGHT);
        }
        return boe;
    }

    private GASTExpression convertCompareExpression(Operator binaryExpression_recoder) {
        CompareExpression ce = this.factory.createCompareExpression();
        this.setPositionFromFileBuilderForExpressions((SourceElement)binaryExpression_recoder, (GASTExpressionProxy)ce);
        ce.setLeft((Term)this.convertExpression((ProgramElement)binaryExpression_recoder.getExpressionAt(0), false));
        ce.setRight((Term)this.convertExpression((ProgramElement)binaryExpression_recoder.getExpressionAt(1), false));
        if (binaryExpression_recoder instanceof Equals) {
            ce.setOperation(CompareOperations.EQUAL);
        } else if (binaryExpression_recoder instanceof GreaterOrEquals) {
            ce.setOperation(CompareOperations.GREATEREQUAL);
        } else if (binaryExpression_recoder instanceof GreaterThan) {
            ce.setOperation(CompareOperations.GREATER);
        } else if (binaryExpression_recoder instanceof LessOrEquals) {
            ce.setOperation(CompareOperations.LESSEQUAL);
        } else if (binaryExpression_recoder instanceof LessThan) {
            ce.setOperation(CompareOperations.LESS);
        } else if (binaryExpression_recoder instanceof NotEquals) {
            ce.setOperation(CompareOperations.NOTEQUAL);
        }
        return ce;
    }

    private GASTExpression convertProductExpression(Operator binaryExpression_recoder) {
        ProductExpression pe = this.factory.createProductExpression();
        this.setPositionFromFileBuilderForExpressions((SourceElement)binaryExpression_recoder, (GASTExpressionProxy)pe);
        pe.setLeft((Product)this.convertExpression((ProgramElement)binaryExpression_recoder.getExpressionAt(0), false));
        pe.setRight((Product)this.convertExpression((ProgramElement)binaryExpression_recoder.getExpressionAt(1), false));
        if (binaryExpression_recoder instanceof Times) {
            pe.setOperation(ProductOperations.MULT);
        } else if (binaryExpression_recoder instanceof Divide) {
            pe.setOperation(ProductOperations.DIV);
        } else if (binaryExpression_recoder instanceof Modulo) {
            pe.setOperation(ProductOperations.MOD);
        }
        return pe;
    }

    private GASTExpression convertTermExpression(Operator binaryExpression_recoder) {
        TermExpression te = this.factory.createTermExpression();
        this.setPositionFromFileBuilderForExpressions((SourceElement)binaryExpression_recoder, (GASTExpressionProxy)te);
        te.setLeft((Term)this.convertExpression((ProgramElement)binaryExpression_recoder.getExpressionAt(0), false));
        te.setRight((Term)this.convertExpression((ProgramElement)binaryExpression_recoder.getExpressionAt(1), false));
        if (binaryExpression_recoder instanceof Plus) {
            te.setOperation(TermOperations.ADD);
        } else if (binaryExpression_recoder instanceof Minus) {
            te.setOperation(TermOperations.SUB);
        }
        return te;
    }

    private GASTExpression convertAssignment(recoder.java.expression.Assignment assignment_recoder) {
        AssignmentOperatorExpression aoe = this.factory.createAssignmentOperatorExpression();
        this.setPositionFromFileBuilderForExpressions((SourceElement)assignment_recoder, (GASTExpressionProxy)aoe);
        aoe.setLeft((Lvalue)this.convertExpression((ProgramElement)assignment_recoder.getExpressionAt(0), true));
        aoe.setRight((Assignment)this.convertExpression((ProgramElement)assignment_recoder.getExpressionAt(1), true));
        if (assignment_recoder instanceof CopyAssignment) {
            aoe.setOperation(AssignmentOperations.ASSIGN);
        } else if (assignment_recoder instanceof BinaryAndAssignment) {
            aoe.setOperation(AssignmentOperations.BITANDASSIGN);
        } else if (assignment_recoder instanceof BinaryOrAssignment) {
            aoe.setOperation(AssignmentOperations.BITORASSIGN);
        } else if (assignment_recoder instanceof BinaryXOrAssignment) {
            aoe.setOperation(AssignmentOperations.BITXORASSIGN);
        } else if (assignment_recoder instanceof DivideAssignment) {
            aoe.setOperation(AssignmentOperations.DIVASSIGN);
        } else if (assignment_recoder instanceof MinusAssignment) {
            aoe.setOperation(AssignmentOperations.SUBASSIGN);
        } else if (assignment_recoder instanceof ModuloAssignment) {
            aoe.setOperation(AssignmentOperations.MODASSIGN);
        } else if (assignment_recoder instanceof PlusAssignment) {
            aoe.setOperation(AssignmentOperations.ADDASSIGN);
        } else if (assignment_recoder instanceof ShiftLeftAssignment) {
            aoe.setOperation(AssignmentOperations.SHIFTLEFTASSIGN);
        } else if (assignment_recoder instanceof ShiftRightAssignment) {
            aoe.setOperation(AssignmentOperations.SHIFTRIGHTASSIGN);
        } else if (assignment_recoder instanceof TimesAssignment) {
            aoe.setOperation(AssignmentOperations.MULASSIGN);
        } else {
            boolean cfr_ignored_0 = assignment_recoder instanceof UnsignedShiftRightAssignment;
        }
        return aoe;
    }
}

