/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.java.builders;

import de.fzi.sissy.extractors.java.builders.Edge;
import de.fzi.sissy.extractors.java.builders.Node;
import java.util.Iterator;
import java.util.Vector;
import recoder.java.Statement;
import recoder.java.StatementBlock;
import recoder.java.StatementContainer;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.statement.Branch;
import recoder.java.statement.For;
import recoder.java.statement.If;
import recoder.java.statement.LoopStatement;
import recoder.java.statement.Switch;
import recoder.java.statement.While;

public class CFGBuilder {
    public Node buildCFG(MethodDeclaration methodDecl) {
        StatementBlock block = methodDecl.getBody();
        if (block != null) {
            Statement[] stmts = (Statement[])block.getBody().toArray((Object[])new Statement[0]);
            Node n = this.buildSubNode(stmts);
            Vector<Node> beforeEndNodes = this.getNodesBeforeEndNode(n);
            this.removeEdgesToEndNode(beforeEndNodes);
            return n;
        }
        return new Node();
    }

    public Node buildSubNode(Statement[] stmts) {
        Node oldNode;
        Iterator iter;
        Vector<Node> oldNodes = new Vector<Node>();
        Node startNode = new Node();
        oldNodes.addElement(startNode);
        int i = 0;
        while (i < stmts.length) {
            Node endNode;
            Node exprNode;
            if (stmts[i] instanceof If) {
                StatementContainer thenContainer;
                If ifStatement = (If)stmts[i];
                exprNode = new Node(ifStatement.getExpression().toSource());
                Node thenNode = null;
                Statement thenStatement = ifStatement.getThen().getBody();
                if (thenStatement != null && (thenContainer = thenStatement.getStatementContainer()).getStatementCount() > 0) {
                    thenStatement = thenContainer.getStatementAt(thenContainer.getStatementCount() - 1);
                    if (thenStatement instanceof StatementBlock) {
                        StatementBlock thenBlock = (StatementBlock)thenStatement;
                        thenNode = this.buildSubNode((Statement[])thenBlock.getBody().toArray((Object[])new Statement[0]));
                    } else {
                        thenNode = new Node(thenStatement.toSource());
                        endNode = new Node("[end]");
                        thenNode.addEdge(new Edge(endNode));
                    }
                }
                exprNode.addEdge(new Edge(thenNode));
                for (Node oldNode2 : oldNodes) {
                    oldNode2.addEdge(new Edge(exprNode));
                }
                oldNodes.clear();
                oldNodes.addElement(exprNode);
                Vector<Node> beforeEndNodes = this.getNodesBeforeEndNode(thenNode);
                this.removeEdgesToEndNode(beforeEndNodes);
                oldNodes.addAll(beforeEndNodes);
            } else if (stmts[i] instanceof For || stmts[i] instanceof While) {
                StatementContainer loopContainer;
                LoopStatement loop = (LoopStatement)stmts[i];
                Node guardNode = new Node(loop.getGuard() != null ? loop.getGuard().toSource() : "loop guard");
                Node bodyNode = null;
                Statement loopStatement = loop.getBody();
                if (loopStatement != null && (loopContainer = loopStatement.getStatementContainer()).getStatementCount() > 0) {
                    loopStatement = loopContainer.getStatementAt(loopContainer.getStatementCount() - 1);
                    if (loopStatement instanceof StatementBlock) {
                        StatementBlock loopBlock = (StatementBlock)loopStatement;
                        bodyNode = this.buildSubNode((Statement[])loopBlock.getBody().toArray((Object[])new Statement[0]));
                    } else {
                        bodyNode = new Node(loopStatement.toSource());
                        endNode = new Node("[end]");
                        bodyNode.addEdge(new Edge(endNode));
                    }
                }
                guardNode.addEdge(new Edge(bodyNode));
                Vector<Node> beforeEndNodes = this.getNodesBeforeEndNode(bodyNode);
                this.removeEdgesToEndNode(beforeEndNodes);
                for (Node n : beforeEndNodes) {
                    n.addEdge(new Edge(guardNode));
                }
                for (Node oldNode3 : oldNodes) {
                    oldNode3.addEdge(new Edge(guardNode));
                }
                oldNodes.clear();
                oldNodes.addElement(guardNode);
            } else if (stmts[i] instanceof Switch) {
                Switch switchStatement = (Switch)stmts[i];
                exprNode = new Node(switchStatement.getExpression().toSource());
                Branch[] branches = (Branch[])switchStatement.getBranchList().toArray((Object[])new Branch[0]);
                Vector<Node> branchNodes = new Vector<Node>();
                int k = 0;
                while (k < branches.length) {
                    int stmtCount = branches[k].getStatementCount();
                    if (stmtCount == 1) {
                        Node n;
                        n = new Node(branches[k].getStatementAt(0).toSource());
                        Node endNode2 = new Node("[end]");
                        n.addEdge(new Edge(endNode2));
                        branchNodes.addElement(n);
                    } else {
                        Statement[] subStmts = new Statement[stmtCount];
                        int j = 0;
                        while (j < branches[k].getStatementCount()) {
                            subStmts[j] = branches[k].getStatementAt(j);
                            ++j;
                        }
                        Node n = this.buildSubNode(subStmts);
                        branchNodes.addElement(n);
                    }
                    ++k;
                }
                Iterator iter2 = branchNodes.iterator();
                Node branchNode2 = null;
                while (iter2.hasNext()) {
                    branchNode2 = (Node)iter2.next();
                    exprNode.addEdge(new Edge(branchNode2));
                }
                for (Node oldNode3 : oldNodes) {
                    oldNode3.addEdge(new Edge(exprNode));
                }
                oldNodes.clear();
                oldNodes.addElement(exprNode);
                Vector<Node> totalBeforeEndNodes = new Vector<Node>();
                Vector<Node> beforeEndNodes = null;
                for (Node branchNode2 : branchNodes) {
                    beforeEndNodes = this.getNodesBeforeEndNode(branchNode2);
                    this.removeEdgesToEndNode(beforeEndNodes);
                    totalBeforeEndNodes.addAll(beforeEndNodes);
                }
                oldNodes.addAll(totalBeforeEndNodes);
            } else {
                Node n = new Node(stmts[i].toSource());
                iter = oldNodes.iterator();
                oldNode = null;
                while (iter.hasNext()) {
                    oldNode = (Node)iter.next();
                    oldNode.addEdge(new Edge(n));
                }
                oldNodes.clear();
                oldNodes.addElement(n);
            }
            ++i;
        }
        Node endNode = new Node("[end]");
        iter = oldNodes.iterator();
        oldNode = null;
        while (iter.hasNext()) {
            oldNode = (Node)iter.next();
            oldNode.addEdge(new Edge(endNode));
        }
        if (startNode.getEdges().size() > 0) {
            return startNode.getEdges().elementAt(0).getTargetNode();
        }
        return new Node();
    }

    public int countNodes(Node node) {
        return node.countNodes();
    }

    public int countEdges(Node node) {
        return node.countEdges();
    }

    private void removeEdgesToEndNode(Node node) {
        Iterator<Edge> edgeIter = node.getEdges().iterator();
        while (edgeIter.hasNext()) {
            Edge e = edgeIter.next();
            if (!e.getTargetNode().getExpr().equals("[end]")) continue;
            edgeIter.remove();
        }
    }

    private void removeEdgesToEndNode(Vector<Node> nodes) {
        for (Node n : nodes) {
            this.removeEdgesToEndNode(n);
        }
    }

    private Vector<Node> getNodesBeforeEndNode(Node node) {
        Vector<Node> nodes = new Vector<Node>();
        nodes.addElement(node);
        Vector<Node> newNodes = new Vector<Node>();
        Vector newEdges = (Vector)node.getEdges().clone();
        while (newEdges.size() != 0) {
            for (Edge e : newEdges) {
                if (nodes.contains(e.getTargetNode())) continue;
                newNodes.addElement(e.getTargetNode());
            }
            newEdges.clear();
            Iterator nodeIter = newNodes.iterator();
            while (nodeIter.hasNext()) {
                newEdges.addAll(((Node)nodeIter.next()).getEdges());
            }
            nodes.addAll(newNodes);
            newNodes.clear();
        }
        Vector<Node> beforeEndNodes = new Vector<Node>();
        for (Node n : nodes) {
            for (Edge e : n.getEdges()) {
                if (!e.getTargetNode().getExpr().equals("[end]")) continue;
                beforeEndNodes.addElement(n);
            }
        }
        return beforeEndNodes;
    }
}

