/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.java;

import de.fzi.sissy.extractors.ExtractorConfiguration;
import de.fzi.sissy.extractors.java.Extractor;
import de.fzi.sissy.extractors.java.builders.BuilderGroup;
import de.fzi.sissy.extractors.java.builders.MetamodBuilder;
import de.fzi.sissy.extractors.java.recoder.CustomErrorHandler;
import de.fzi.sissy.extractors.java.recoder.CustomServiceConfiguration;
import de.fzi.sissy.extractors.java.recoder.RecoderProgram;
import de.fzi.sissy.metamod.Array;
import de.fzi.sissy.metamod.DeclarationTypeAccess;
import de.fzi.sissy.metamod.ModelElementRepository;
import de.fzi.sissy.metamod.ParameterInstanciationTypeAccess;
import de.fzi.sissy.metamod.Type;
import de.fzi.sissy.utils.Debug;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ParserException;
import recoder.ServiceConfiguration;
import recoder.io.ClassFileRepository;
import recoder.io.ProjectSettings;
import recoder.io.SourceFileRepository;
import recoder.service.ErrorHandler;
import recoder.service.NameInfo;
import recoder.service.SourceInfo;

public class ExtractorFassade {
    protected CrossReferenceServiceConfiguration crossReferenceServiceConfiguration = null;
    protected CustomServiceConfiguration customServiceConfiguration = null;
    protected ModelElementRepository modelElementRepository = null;
    protected ClassFileRepository classFileRepository = null;
    protected SourceInfo sourceInfo = null;
    protected SourceFileRepository sourceFileRepository = null;
    protected NameInfo nameInfo = null;
    private boolean clone_analyses_active = true;
    private ExtractorConfiguration.JavaCodeSourceLevel langVersion = ExtractorConfiguration.JavaCodeSourceLevel.JAVA_5_0;
    private boolean extractExpressions;

    public boolean isExtractExpressions() {
        return this.extractExpressions;
    }

    public void setExtractExpressions(boolean extractExpressions) {
        this.extractExpressions = extractExpressions;
    }

    public void dispose() {
        this.crossReferenceServiceConfiguration = null;
        this.customServiceConfiguration = null;
        this.classFileRepository = null;
        this.sourceInfo = null;
        this.sourceFileRepository = null;
        this.nameInfo = null;
    }

    public ExtractorFassade() throws ParserException {
        this(ModelElementRepository.getWorkingRepository());
    }

    public ExtractorFassade(ModelElementRepository modelElementRepository) throws ParserException {
        this.modelElementRepository = modelElementRepository;
    }

    public void setLangVersion(ExtractorConfiguration.JavaCodeSourceLevel version) {
        if (version != null) {
            this.langVersion = version;
        }
    }

    public void extract(IProgressMonitor monitor) throws ParserException {
        if (monitor != null) {
            monitor.subTask("run recoder");
        }
        this.initialize(this.modelElementRepository);
        if (monitor != null) {
            monitor.subTask("build metamodel from recoder ast");
        }
        this.extractAll(monitor);
    }

    private void initialize(ModelElementRepository mer) throws ParserException {
        boolean useCustomServiceConf = true;
        if (useCustomServiceConf) {
            Debug.info((String)"Using CustomServiceConfiguration");
            this.customServiceConfiguration = new CustomServiceConfiguration();
            this.setupServiceConfiguration((ServiceConfiguration)this.customServiceConfiguration, (ErrorHandler)new CustomErrorHandler(), mer);
        } else {
            this.crossReferenceServiceConfiguration = new CrossReferenceServiceConfiguration();
            this.setupServiceConfiguration((ServiceConfiguration)this.crossReferenceServiceConfiguration, null, mer);
        }
    }

    private void setupServiceConfiguration(ServiceConfiguration serviceConfiguration, ErrorHandler errorHandler, ModelElementRepository mer) throws ParserException {
        ProjectSettings projectSettings = serviceConfiguration.getProjectSettings();
        this.setupSourceLevelProperties(projectSettings);
        if (errorHandler != null) {
            serviceConfiguration.getProjectSettings().setErrorHandler(errorHandler);
        }
        RecoderProgram recoderProgram = new RecoderProgram();
        recoderProgram.setup(serviceConfiguration, Extractor.class, mer.getFileList(), mer.getBinaryLibraryPathsList());
        this.nameInfo = serviceConfiguration.getNameInfo();
        this.sourceInfo = serviceConfiguration.getSourceInfo();
        this.sourceFileRepository = serviceConfiguration.getSourceFileRepository();
        this.classFileRepository = serviceConfiguration.getClassFileRepository();
    }

    private void setupSourceLevelProperties(ProjectSettings prjSet) {
        if (this.langVersion.equals((Object)ExtractorConfiguration.JavaCodeSourceLevel.JAVA_5_0)) {
            prjSet.setProperty("jdk1.4", "true");
            prjSet.setProperty("java5", "true");
        } else if (this.langVersion.equals((Object)ExtractorConfiguration.JavaCodeSourceLevel.JAVA_1_4)) {
            prjSet.setProperty("java5", "false");
            prjSet.setProperty("jdk1.4", "true");
        } else if (this.langVersion.equals((Object)ExtractorConfiguration.JavaCodeSourceLevel.JAVA_1_3)) {
            prjSet.setProperty("java5", "false");
            prjSet.setProperty("jdk1.4", "false");
        } else {
            Debug.warning((String)"ExtractorFassade::initialize - unknown java language version");
            prjSet.setProperty("java5", "true");
            prjSet.setProperty("jdk1.4", "true");
        }
    }

    private void extractAll(IProgressMonitor monitor) throws ParserException {
        Debug.info((String)"extractAll started...");
        BuilderGroup builderGroup = new BuilderGroup(this);
        MetamodBuilder metamod_builder = builderGroup.getMetamodBuilder();
        metamod_builder.setup(this.modelElementRepository, this.classFileRepository, this.sourceInfo, this.sourceFileRepository, this.nameInfo);
        if (monitor != null) {
            monitor.subTask("create primitive types");
        }
        metamod_builder.createPrimitiveTypeClasses();
        if (monitor != null) {
            monitor.subTask("create files");
        }
        metamod_builder.createFiles();
        if (monitor != null) {
            monitor.subTask("find direct classes");
        }
        metamod_builder.findDirectClasses(this.getNameInfo());
        if (monitor != null) {
            monitor.subTask("find inner classes");
        }
        metamod_builder.findInnerClasses();
        if (monitor != null) {
            monitor.subTask("find local classes");
        }
        metamod_builder.findLocalClasses();
        if (monitor != null) {
            monitor.subTask("union classes");
        }
        metamod_builder.unionClasses();
        if (monitor != null) {
            monitor.subTask("eliminate duplicate classes");
        }
        metamod_builder.eliminateDuplicateClasses();
        if (monitor != null) {
            monitor.subTask("find methods, constructors, fields");
        }
        metamod_builder.findMethodsConstructorsAndFields();
        if (monitor != null) {
            monitor.subTask("create classes");
        }
        metamod_builder.createClasses();
        if (monitor != null) {
            monitor.subTask("establish inner class relation");
        }
        metamod_builder.establishInnerClassRelation();
        if (monitor != null) {
            monitor.subTask("create fields");
        }
        metamod_builder.createFields();
        if (monitor != null) {
            monitor.subTask("separate constructors and methods");
        }
        metamod_builder.separateConstructorsAndMethods();
        if (monitor != null) {
            monitor.subTask("create constructors and methods");
        }
        metamod_builder.createMethods();
        metamod_builder.createConstructors();
        metamod_builder.reuniteConstructorsAndMethods();
        metamod_builder.findAndCreateInitializers();
        if (monitor != null) {
            monitor.subTask("establish local class relation");
        }
        metamod_builder.establishLocalClassRelation();
        if (monitor != null) {
            monitor.subTask("establish direct superclass relation");
        }
        metamod_builder.establishDirectSuperclassRelation();
        if (monitor != null) {
            monitor.subTask("find and create accesses");
        }
        metamod_builder.findAndCreateAccesses();
        if (this.extractExpressions) {
            if (monitor != null) {
                monitor.subTask("find and create expressions");
            }
            metamod_builder.findAndCreateExpressions();
            Debug.debug((String)("Number of Expression-Anchors:" + this.modelElementRepository.getExpressionsRoot().getExpressionanchors().size()));
        }
        metamod_builder.setupOverrideStatusOfMethods();
        if (monitor != null) {
            monitor.subTask("establish inner package relation");
        }
        metamod_builder.establishInnerPackageRelation();
        ArrayList elements = this.modelElementRepository.getModelElements();
        for (Object element : elements) {
            DeclarationTypeAccess dta;
            Type type;
            if (!(element instanceof DeclarationTypeAccess) || !((type = (dta = (DeclarationTypeAccess)element).getAccessedType()) instanceof Array)) continue;
            Type basetype = ((Array)type).getUndecoratedType();
            ParameterInstanciationTypeAccess pita = new ParameterInstanciationTypeAccess(basetype);
            dta.addParameterTypeAccess(pita);
        }
        builderGroup.dispose();
        Debug.info((String)"Finished extracting");
    }

    public NameInfo getNameInfo() {
        return this.nameInfo;
    }

    public SourceFileRepository getSourceFileRepository() {
        return this.sourceFileRepository;
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public void setNameInfo(NameInfo info) {
        this.nameInfo = info;
    }

    public void setSourceFileRepository(SourceFileRepository repository) {
        this.sourceFileRepository = repository;
    }

    public void setSourceInfo(SourceInfo info) {
        this.sourceInfo = info;
    }

    public ClassFileRepository getClassFileRepository() {
        return this.classFileRepository;
    }

    public void setClassFileRepository(ClassFileRepository repository) {
        this.classFileRepository = repository;
    }

    public CrossReferenceServiceConfiguration getCrossReferenceServiceConfiguration() {
        return this.crossReferenceServiceConfiguration;
    }

    public void setCrossReferenceServiceConfiguration(CrossReferenceServiceConfiguration configuration) {
        this.crossReferenceServiceConfiguration = configuration;
    }

    public ModelElementRepository getModelElementRepository() {
        return this.modelElementRepository;
    }

    public void activateCloneAnalyses(boolean activate) {
        this.clone_analyses_active = activate;
    }
}

