/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.delphi;

import de.fzi.delphi.output.IOPOutput;
import de.fzi.delphi.output.IOPOutputImplementation;
import de.fzi.delphi.parser.OPReferencesParser;
import de.fzi.delphi.symbols.Attribute;
import de.fzi.delphi.symbols.CompilationUnit;
import de.fzi.delphi.symbols.Method;
import de.fzi.delphi.symbols.Scope;
import de.fzi.delphi.symbols.Symbol;
import de.fzi.delphi.types.Type;
import de.fzi.sissy.extractors.delphi.OutputPair;
import de.fzi.sissy.utils.Debug;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class SissyOutput
extends IOPOutputImplementation
implements IOPOutput {
    private Vector opNewCompilationUnits = new Vector();
    private Vector opUsesCompilationUnits = new Vector();
    private Vector opTypeReferences = new Vector();
    private Vector opTypeDeclarations = new Vector();
    private Vector opTypeCasts = new Vector();
    private Vector opAttributDeclarations = new Vector();
    private Vector opAttributReferences = new Vector();
    private Vector opMethodDeclarations = new Vector();
    private Vector opMethodReferences = new Vector();
    private Vector opSelfAccesses = new Vector();
    private Vector opRuntimeTypeAccesses;
    private Vector opStaticTypeAccesses = new Vector();
    private Vector opCompositeAccesses;
    private Scope opRootScope = null;
    private Vector collectedCompilationUnits;
    private Vector collectedTypes;
    private Map opSymbolToCompilationUnitMapper;

    public SissyOutput() {
        this.opRuntimeTypeAccesses = new Vector();
        this.opCompositeAccesses = new Vector();
        this.collectedCompilationUnits = new Vector();
        this.collectedTypes = new Vector();
        this.opSymbolToCompilationUnitMapper = new HashMap();
    }

    private void setRootScope(Scope location) {
        if (this.opRootScope == null && location != null) {
            this.opRootScope = location.getRootScope();
        }
    }

    private void collectCompilationUnit(Symbol op_symbol) {
        Scope scope = op_symbol.getScope();
        if (scope != null) {
            CompilationUnit op_compilation_unit = scope.getCompilationUnit();
            if (op_compilation_unit != null) {
                if (!this.collectedCompilationUnits.contains(op_compilation_unit)) {
                    this.collectedCompilationUnits.add(op_compilation_unit);
                    if (!this.opSymbolToCompilationUnitMapper.containsKey(op_symbol)) {
                        this.opSymbolToCompilationUnitMapper.put(op_symbol, op_compilation_unit);
                    } else {
                        Debug.warning((String)"Symbol already mapped to Compilation Unit");
                    }
                }
            } else {
                Debug.warning((String)"CompilationUnit was null!");
            }
        } else {
            Debug.warning((String)"collectCompUnits: Scope of Symbol was null!");
        }
    }

    public void markTypeDeclaration(Scope location, Type t) {
        Debug.verbose((String)"markTypeDeclaration executed");
        this.setRootScope(location);
        if (!this.collectedTypes.contains(t)) {
            this.collectedTypes.add(t);
        }
        OutputPair outputPair = new OutputPair(location, (Symbol)t);
        this.opTypeDeclarations.add(outputPair);
    }

    public void markTypeReference(Scope location, Type t) {
        Debug.verbose((String)"markTypeReference executed");
        this.setRootScope(location);
        if (!this.collectedTypes.contains(t)) {
            this.collectedTypes.add(t);
        }
        OutputPair outputPair = new OutputPair(location, (Symbol)t);
        if (OPReferencesParser.getCurrentStatement() != null) {
            outputPair.setCurrentStatement(OPReferencesParser.getCurrentStatement());
        } else {
            Debug.warning((String)"Statement for Type-Reference was null!");
        }
        this.opTypeReferences.add(outputPair);
    }

    public void markTypeCast(Scope location, Type t) {
        Debug.verbose((String)"markTypeCast executed");
        this.setRootScope(location);
        OutputPair outputPair = new OutputPair(location, (Symbol)t);
        this.opTypeCasts.add(outputPair);
    }

    public void markAttributeDeclaration(Scope location, Attribute v) {
        Debug.verbose((String)"markAttributeDeclaration executed");
        this.setRootScope(location);
        OutputPair outputPair = new OutputPair(location, (Symbol)v);
        this.opAttributDeclarations.add(outputPair);
    }

    public void markAttributeReference(Scope location, Attribute v) {
        Debug.verbose((String)"markAttributeReference executed");
        this.setRootScope(location);
        OutputPair outputPair = new OutputPair(location, (Symbol)v);
        if (OPReferencesParser.getCurrentStatement() != null) {
            outputPair.setCurrentStatement(OPReferencesParser.getCurrentStatement());
        } else {
            Debug.warning((String)"Statement for Attribute-Reference was null!");
        }
        this.opAttributReferences.add(outputPair);
    }

    public void markMethodDeclaration(Scope location, Method f) {
        Debug.verbose((String)"markMethodDeclaration executed");
        this.setRootScope(location);
        OutputPair outputPair = new OutputPair(location, (Symbol)f);
        this.opMethodDeclarations.add(outputPair);
    }

    public void markMethodReference(Scope location, Method f) {
        Debug.verbose((String)"markMethodReference executed");
        this.setRootScope(location);
        OutputPair outputPair = new OutputPair(location, (Symbol)f);
        if (OPReferencesParser.getCurrentStatement() != null) {
            outputPair.setCurrentStatement(OPReferencesParser.getCurrentStatement());
        } else {
            Debug.info((String)"Statement for Method-Reference was null!");
        }
        this.opMethodReferences.add(outputPair);
    }

    public void markNewCompilationUnit(String name) {
        Debug.verbose((String)"markNewCompilationUnit executed");
        this.opNewCompilationUnits.add(name);
    }

    public void markUsesCompilationUnit(Scope location, String name) {
        Debug.verbose((String)"markUsesCompilationUnit executed");
        this.setRootScope(location);
        OutputPair outputPair = new OutputPair(location, name);
        this.opUsesCompilationUnits.add(outputPair);
    }

    public void printCommentLine(String comment) {
    }

    public void printAllScopeEntities(Scope scope) {
    }

    public void close() {
    }

    public void printOutput() {
        Debug.info((String)"OP-Extraction-Summary:");
        Debug.info((String)("#AttributDeclarations: " + this.getOpAttributDeclarations().size()));
        Debug.info((String)("#AttributReferences:   " + this.getOpAttributReferences().size()));
        Debug.info((String)("#MethodDeclarations:   " + this.getOpMethodDeclarations().size()));
        Debug.info((String)("#MethodReferences:     " + this.getOpMethodReferences().size()));
        Debug.info((String)("#TypeDeclarations:     " + this.getOpTypeDeclarations().size()));
        Debug.info((String)("#TypeReferences:       " + this.getOpTypeReferences().size()));
        Debug.info((String)("#NewCompUnits:         " + this.getOpNewCompilationUnits().size()));
        Debug.info((String)("#UsesCompUnits:        " + this.getOpUsesCompilationUnits().size()));
        Debug.info((String)("#TypeCasts:            " + this.getOpTypeCasts().size()));
    }

    public Vector getOpAttributDeclarations() {
        return this.opAttributDeclarations;
    }

    public void setOpAttributDeclarations(Vector opAttributDeclarations) {
        this.opAttributDeclarations = opAttributDeclarations;
    }

    public Vector getOpAttributReferences() {
        return this.opAttributReferences;
    }

    public void setOpAttributReferences(Vector opAttributReferences) {
        this.opAttributReferences = opAttributReferences;
    }

    public Vector getOpMethodDeclarations() {
        return this.opMethodDeclarations;
    }

    public void setOpMethodDeclarations(Vector opMethodDeclarations) {
        this.opMethodDeclarations = opMethodDeclarations;
    }

    public Vector getOpMethodReferences() {
        return this.opMethodReferences;
    }

    public void setOpMethodReferences(Vector opMethodReferences) {
        this.opMethodReferences = opMethodReferences;
    }

    public Vector getOpNewCompilationUnits() {
        return this.opNewCompilationUnits;
    }

    public void setOpNewCompilationUnits(Vector opNewCompilationUnits) {
        this.opNewCompilationUnits = opNewCompilationUnits;
    }

    public Vector getOpTypeCasts() {
        return this.opTypeCasts;
    }

    public void setOpTypeCasts(Vector opTypeCasts) {
        this.opTypeCasts = opTypeCasts;
    }

    public Vector getOpTypeDeclarations() {
        return this.opTypeDeclarations;
    }

    public void setOpTypeDeclarations(Vector opTypeDeclarations) {
        this.opTypeDeclarations = opTypeDeclarations;
    }

    public Vector getOpTypeReferences() {
        return this.opTypeReferences;
    }

    public Vector getOpStaticTypeAccesses() {
        return this.opStaticTypeAccesses;
    }

    public Vector getOpRuntimeTypeAccesses() {
        return this.opRuntimeTypeAccesses;
    }

    public Vector getOpCompositeAccesses() {
        return this.opCompositeAccesses;
    }

    public Vector getOpSelfAccesses() {
        return this.opSelfAccesses;
    }

    public void setOpTypeReferences(Vector opTypeReferences) {
        this.opTypeReferences = opTypeReferences;
    }

    public Vector getOpUsesCompilationUnits() {
        return this.opUsesCompilationUnits;
    }

    public void setOpUsesCompilationUnits(Vector opUsesCompilationUnits) {
        this.opUsesCompilationUnits = opUsesCompilationUnits;
    }

    public Vector getCollectedCompilationUnits() {
        return this.collectedCompilationUnits;
    }

    public void setCollectedCompilationUnits(Vector collectedCompilationUnits) {
        this.collectedCompilationUnits = collectedCompilationUnits;
    }

    public Map getOpSymbolToCompilationUnitMapper() {
        return this.opSymbolToCompilationUnitMapper;
    }

    public void setOpSymbolToCompilationUnitMapper(Map opSymbolToCompilationUnitMapper) {
        this.opSymbolToCompilationUnitMapper = opSymbolToCompilationUnitMapper;
    }

    public Scope getOpRootScope() {
        return this.opRootScope;
    }

    public Vector getCollectedTypes() {
        return this.collectedTypes;
    }

    public void setCollectedTypes(Vector collectedTypes) {
        this.collectedTypes = collectedTypes;
    }

    public void markSelfAccess(Scope location, Symbol inheritedSymbol) {
        Debug.info((String)"markSelfAccess executed");
        OutputPair outputPair = new OutputPair(location, inheritedSymbol);
        if (OPReferencesParser.getCurrentStatement() != null) {
            outputPair.setCurrentStatement(OPReferencesParser.getCurrentStatement());
        } else {
            Debug.warning((String)"Statement for SelfAccess was null!");
        }
        this.opSelfAccesses.add(outputPair);
    }

    public void markStaticTypeAccess(Scope location, Symbol typeSymbol) {
        Debug.verbose((String)"markStaticTypeAccess executed");
        OutputPair outputPair = new OutputPair(location, typeSymbol);
        if (OPReferencesParser.getCurrentStatement() != null) {
            outputPair.setCurrentStatement(OPReferencesParser.getCurrentStatement());
        } else {
            Debug.warning((String)"Statement for StaticTypeAccess was null!");
        }
        this.opStaticTypeAccesses.add(outputPair);
    }

    public void markRuntimeTypeAccess(Scope location, Symbol typeSymbol) {
        Debug.verbose((String)"markRuntimeTypeAccess executed");
        OutputPair outputPair = new OutputPair(location, typeSymbol);
        if (OPReferencesParser.getCurrentStatement() != null) {
            outputPair.setCurrentStatement(OPReferencesParser.getCurrentStatement());
        } else {
            Debug.warning((String)"Statement for RuntimeTypeAccess was null!");
        }
        this.opRuntimeTypeAccesses.add(outputPair);
    }

    public void markCompositeAccess(Scope location, Symbol typeSymbol) {
        Debug.verbose((String)"markCompositeTypeAccess executed");
        OutputPair outputPair = new OutputPair(location, typeSymbol);
        if (OPReferencesParser.getCurrentStatement() != null) {
            outputPair.setCurrentStatement(OPReferencesParser.getCurrentStatement());
        } else {
            Debug.warning((String)"Statement for CompositeAccess was null!");
        }
        this.opCompositeAccesses.add(outputPair);
    }
}

