/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.delphi;

import de.fzi.delphi.OPMain;
import de.fzi.delphi.OPProjectManager;
import de.fzi.delphi.output.IOPOutput;
import de.fzi.sissy.extractors.ExtractorConfiguration;
import de.fzi.sissy.extractors.GenericExtractor;
import de.fzi.sissy.extractors.delphi.DelphiCollector;
import de.fzi.sissy.extractors.delphi.DelphiFileFilter;
import de.fzi.sissy.extractors.delphi.DelphiMetamodBuilder;
import de.fzi.sissy.extractors.delphi.SissyOutput;
import de.fzi.sissy.extractors.meta.GeneralMapper;
import de.fzi.sissy.metamod.ModelElementRepository;
import de.fzi.sissy.utils.Debug;
import de.fzi.sissy.visualizations.StatementViewer;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;

public class OPFactExtractor
extends GenericExtractor {
    private String list_file_name = "dpinput.lst";
    private String includePath = null;
    private StatementViewer sv;
    private DelphiMetamodBuilder metamod_builder;

    public OPFactExtractor(ExtractorConfiguration extractorConfiguration) {
        super(extractorConfiguration, (FileFilter)new DelphiFileFilter(), "res\\comments\\delphi.dat", "res\\clone\\delphi_comments.dat");
        this.includePath = extractorConfiguration.getIncludeDirectoriesConfigFile();
    }

    private synchronized void analyse() throws IOException, MalformedURLException {
        long currentTimeMillisBeforeAnalyzing = System.currentTimeMillis();
        Debug.info((String)("Time before analyzing project " + new Date(currentTimeMillisBeforeAnalyzing)));
        this.extractOP();
        long currentTimeMillisAfterAnalyzing = System.currentTimeMillis();
        Debug.info((String)("Time elapsed so far " + Float.toString((float)(currentTimeMillisAfterAnalyzing - currentTimeMillisBeforeAnalyzing) / 1000.0f) + " s"));
    }

    public void extractOP() {
        File lst_file = new File(this.list_file_name);
        try {
            lst_file.createNewFile();
            FileWriter fw = new FileWriter(lst_file);
            Iterator itr = ModelElementRepository.getWorkingRepository().getFileList().iterator();
            while (itr.hasNext()) {
                String path_name = String.valueOf((String)itr.next()) + "\n";
                fw.write(path_name);
            }
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String[] configParameter = this.includePath != null ? new String[]{"-v", "2", "--format", "sissy", "-l", this.list_file_name, "-I", this.includePath} : new String[]{"-v", "2", "--format", "sissy", "-l", this.list_file_name};
        SissyOutput sissyOutput = new SissyOutput();
        OPProjectManager.setOutput((IOPOutput)sissyOutput);
        try {
            OPMain.main((String[])configParameter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        GeneralMapper mapper = new GeneralMapper();
        DelphiCollector collector = new DelphiCollector(sissyOutput, mapper);
        this.metamod_builder = new DelphiMetamodBuilder(collector, mapper, this.modelElementRepository);
        this.metamod_builder.buildAll();
    }

    protected void buildMetaModel(IProgressMonitor monitor) {
        try {
            this.analyse();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

