/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.delphi;

import de.fzi.delphi.symbols.CompilationUnit;
import de.fzi.delphi.symbols.Scope;
import de.fzi.delphi.symbols.Symbol;
import de.fzi.delphi.symbols.types.ClassType;
import de.fzi.sissy.extractors.meta.GeneralCollector;
import de.fzi.sissy.extractors.meta.GeneralMapper;
import de.fzi.sissy.extractors.meta.GeneralMetamodBuilder;
import de.fzi.sissy.metamod.BlockStatement;
import de.fzi.sissy.metamod.Class;
import de.fzi.sissy.metamod.Constructor;
import de.fzi.sissy.metamod.Destructor;
import de.fzi.sissy.metamod.File;
import de.fzi.sissy.metamod.Function;
import de.fzi.sissy.metamod.Member;
import de.fzi.sissy.metamod.Method;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.ModelElementList;
import de.fzi.sissy.metamod.ModelElementRepository;
import de.fzi.sissy.metamod.Package;
import de.fzi.sissy.metamod.Position;
import de.fzi.sissy.metamod.Statement;
import de.fzi.sissy.metamod.StatementTreeWalker;
import de.fzi.sissy.metamod.StructuralAbstraction;
import de.fzi.sissy.utils.Debug;
import de.fzi.sissy.visualizations.StatementViewer;
import java.util.ArrayList;
import java.util.Collection;

public class DelphiMetamodBuilder
extends GeneralMetamodBuilder {
    public DelphiMetamodBuilder(GeneralCollector collector, GeneralMapper mapper, ModelElementRepository modelElementRepository) {
        super(collector, mapper, modelElementRepository);
    }

    public void buildImportedPackages(Object file_element, File file_metamod) {
        if (!(file_element instanceof CompilationUnit)) {
            return;
        }
        CompilationUnit cu = (CompilationUnit)file_element;
        ArrayList imports = new ArrayList();
        imports.addAll(cu.getInterfaceUsesList());
        imports.addAll(cu.getImplementationUsesList());
        for (Scope scope : imports) {
            ModelElement pack;
            if (scope == null || (pack = this.mapper.getInstance((Object)scope)) == null || !(pack instanceof Package)) continue;
            file_metamod.addImportedPackage((Package)pack);
        }
    }

    protected void buildStatements(Object function_element, Function function_metamod) {
        BlockStatement body = ((de.fzi.delphi.symbols.Method)function_element).getBody();
        if (body == null) {
            Debug.info((String)("buildStatements(): Function-Element " + function_metamod.getSimpleName() + " (OPParser) with null-body found. ==> Build empty BlockStatement as body!"));
            body = new BlockStatement();
        }
        StatementTreeWalker walker = new StatementTreeWalker((Statement)body);
        do {
            Statement stm;
            Position stm_position;
            if ((stm_position = (stm = walker.getStatement()).getPosition()) == null) continue;
            stm_position.setSourceFile(function_metamod.getPosition().getSourceFile());
        } while (walker.next());
        function_metamod.setBody(body);
    }

    protected void buildOverriddenMembers() {
        for (Object class_element : this.collector.getClassElements()) {
            Class class_metamod = (Class)this.mapper.getInstance(class_element);
            if (class_metamod == null) continue;
            for (Method m : class_metamod.getMethods()) {
                Member overridden = this.computeOverriddenMember((Member)m);
                if (overridden == null) continue;
                m.setOverridenMember(overridden);
                m.setOverride();
            }
            for (Constructor c : class_metamod.getConstructors()) {
                Member overridden = this.computeOverriddenMember((Member)c);
                if (overridden == null) continue;
                c.setOverridenMember(overridden);
                c.setOverride();
            }
            for (Destructor d : class_metamod.getDestructors()) {
                Member overridden = this.computeOverriddenMember((Member)d);
                if (overridden == null) continue;
                d.setOverridenMember(overridden);
                d.setOverride();
            }
        }
    }

    private Member computeOverriddenMember(Member m) {
        Class cls = m.getSurroundingClass();
        if (cls != null) {
            for (Class super_cls : cls.getAllSuperTypes()) {
                ModelElementList candidates = new ModelElementList();
                candidates.addAll((Collection)super_cls.getMethods());
                candidates.addAll((Collection)super_cls.getConstructors());
                candidates.addAll((Collection)super_cls.getDestructors());
                for (Member overridden : candidates) {
                    if (m.isOverride() && ((Function)m).hasIdenticalSignature((Function)overridden)) {
                        return overridden;
                    }
                    if (!super_cls.isInterface() || !((Function)m).hasIdenticalSignature((Function)overridden)) continue;
                    return overridden;
                }
            }
        }
        return null;
    }

    protected void buildCatchParameters() {
    }

    public void establishPackagePackageContainmentRelation() {
    }

    public void establishClassClassContainmentRelation() {
    }

    public void buildDefaultAbstractions() {
        for (File file : this.modelElementRepository.getRoot().getFiles()) {
            if (!this.isProjectFile(file)) continue;
            this.buildAbstractionFromProject(file);
        }
    }

    private boolean isProjectFile(File file) {
        return file.getPathName().toLowerCase().endsWith(".dpr") || file.getPathName().toLowerCase().endsWith(".dpk");
    }

    private void buildAbstractionFromProject(File file) {
        StructuralAbstraction abstraction = new StructuralAbstraction(file.getPathName(), "PROJECT");
        for (Package pack : file.getImportedPackages()) {
            abstraction.addModelElement((ModelElement)pack);
        }
        this.modelElementRepository.getRoot().addStructuralAbstraction(abstraction);
    }

    public StatementViewer getStatementViewer() {
        return this.sv;
    }

    public boolean isInstanceOfClassType(Object element) {
        return element instanceof ClassType;
    }

    public Function getFunctionMappedToCorrespondingScope(GeneralMapper mapper, Object function_element) {
        Function function_metamod = (Function)mapper.getInstance((Object)((de.fzi.delphi.symbols.Method)function_element).getCorrespondingScope());
        return function_metamod;
    }

    public String getStringOfSymbolScope(Object variable_element) {
        return ((Symbol)variable_element).getScope().toString();
    }
}

