/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.delphi;

import de.fzi.delphi.CodeblockInfo;
import de.fzi.delphi.OPProjectManager;
import de.fzi.delphi.PositionElement;
import de.fzi.delphi.ProjectListEntry;
import de.fzi.delphi.symbols.Attribute;
import de.fzi.delphi.symbols.CompilationUnit;
import de.fzi.delphi.symbols.Method;
import de.fzi.delphi.symbols.MethodComposite;
import de.fzi.delphi.symbols.Property;
import de.fzi.delphi.symbols.Scope;
import de.fzi.delphi.symbols.Symbol;
import de.fzi.delphi.symbols.types.ArrayType;
import de.fzi.delphi.symbols.types.CharacterType;
import de.fzi.delphi.symbols.types.ClassType;
import de.fzi.delphi.symbols.types.EnumeratedType;
import de.fzi.delphi.symbols.types.FileType;
import de.fzi.delphi.symbols.types.IntegerType;
import de.fzi.delphi.symbols.types.NilType;
import de.fzi.delphi.symbols.types.PointerType;
import de.fzi.delphi.symbols.types.ProceduralType;
import de.fzi.delphi.symbols.types.RealType;
import de.fzi.delphi.symbols.types.RecordType;
import de.fzi.delphi.symbols.types.SetType;
import de.fzi.delphi.symbols.types.StringType;
import de.fzi.delphi.symbols.types.SubrangeType;
import de.fzi.delphi.symbols.types.UnknownClassType;
import de.fzi.delphi.symbols.types.UserDefinedType;
import de.fzi.delphi.symbols.types.VariantType;
import de.fzi.delphi.types.Type;
import de.fzi.sissy.extractors.delphi.OutputPair;
import de.fzi.sissy.extractors.delphi.ScopeWalker;
import de.fzi.sissy.extractors.delphi.SissyOutput;
import de.fzi.sissy.extractors.meta.GeneralCollector;
import de.fzi.sissy.extractors.meta.GeneralMapper;
import de.fzi.sissy.metamod.File;
import de.fzi.sissy.metamod.Function;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.Position;
import de.fzi.sissy.utils.Debug;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class DelphiCollector
extends GeneralCollector {
    private GeneralMapper mapper;
    private SissyOutput sissyOutput;
    private static int max_recursion = 10;

    public DelphiCollector(SissyOutput sissyOutput, GeneralMapper mapper) {
        this.sissyOutput = sissyOutput;
        this.mapper = mapper;
        this.extractScopesAndSymbols();
        this.extractMethodReferences(sissyOutput);
        this.extractAttributeReferences(sissyOutput);
        this.extractAccesses(sissyOutput);
        this.extractTypeCasts(sissyOutput);
    }

    private void extractMethodReferences(SissyOutput sissyOutput) {
        for (OutputPair method_ref : sissyOutput.getOpMethodReferences()) {
            Method method = (Method)method_ref.getSymbol();
            if (method != null) {
                this.collectSymbol((Symbol)method);
            }
            Scope scope = method_ref.getScope();
            scope.getCorrespondingSymbol();
            method_ref.getCurrentStatement();
            this.addFunctionAccessElement(method_ref);
        }
    }

    private void extractTypeCasts(SissyOutput sissyOutput) {
        for (OutputPair type_cast : sissyOutput.getOpTypeCasts()) {
            Type type = (Type)type_cast.getSymbol();
            if (type != null) {
                this.collectSymbol((Symbol)type);
            }
            Scope scope = type_cast.getScope();
            scope.getCorrespondingSymbol();
            type_cast.getCurrentStatement();
            this.addTypeCastAccessElement(type_cast);
        }
    }

    private void extractAttributeReferences(SissyOutput sissyOutput) {
        for (OutputPair attrb_ref : sissyOutput.getOpAttributReferences()) {
            Attribute attrb = (Attribute)attrb_ref.getSymbol();
            if (attrb != null) {
                this.collectSymbol((Symbol)attrb);
            }
            Scope scope = attrb_ref.getScope();
            scope.getCorrespondingSymbol();
            attrb_ref.getCurrentStatement();
            this.addVariableAccessElement(attrb_ref);
        }
    }

    private void extractAccesses(SissyOutput sissyOutput) {
        this.setSelfAccessElements(sissyOutput.getOpSelfAccesses());
        this.setStaticTypeAccessElements(sissyOutput.getOpStaticTypeAccesses());
        this.setRunTimeTypeAccessElements(sissyOutput.getOpRuntimeTypeAccesses());
        this.setCompositeAccessElements(sissyOutput.getOpCompositeAccesses());
    }

    private void extractScopesAndSymbols() {
        Scope root_scope = OPProjectManager.getProjectScope();
        if (root_scope == null) {
            Debug.warning((String)"root_scope was null!!");
            return;
        }
        ScopeWalker walker = new ScopeWalker(root_scope);
        do {
            Scope current_scope;
            if ((current_scope = walker.getCurrentScope()) != null) {
                Debug.verbose((String)("Scope-Name: " + current_scope.getFullName()));
                current_scope.getCorrespondingSymbol();
                for (Symbol symbol : current_scope.getSymbols()) {
                    if (symbol.getScope() != current_scope) {
                        Debug.warning((String)("extractScopesAndSymbols(): Container-Scope was not correct ?? Symbol: " + symbol.getFullName()));
                    }
                    this.collectSymbol(symbol);
                }
            } else {
                Debug.warning((String)"Current Scope was null!");
            }
        } while (walker.next());
    }

    private void collectSymbol(Symbol symbol) {
        if (symbol == null) {
            Debug.warning((String)"Attempt to collect null-symbol prevented!");
            return;
        }
        if (symbol.isInstanceOf("CompilationUnit")) {
            CompilationUnit compilationUnit = (CompilationUnit)symbol;
            Scope scope = compilationUnit.getCorrespondingScope();
            ProjectListEntry ple = OPProjectManager.getProjectListEntry((String)compilationUnit.getName());
            if (ple == null) {
                Debug.warning((String)"ProjectListEntry for CompilationUnit-Symbol was null!");
                return;
            }
            this.addFileElement(symbol);
            this.addPackageElement(scope);
        } else if (symbol.isInstanceOf("Property")) {
            Property cfr_ignored_0 = (Property)symbol;
            this.addPropertyElement(symbol);
        } else if (symbol.isInstanceOf("Attribute")) {
            Attribute attrb = (Attribute)symbol;
            Scope scope = attrb.getScope();
            Symbol container_symbol = scope.getCorrespondingSymbol();
            if (container_symbol != null && container_symbol.isInstanceOf("Method")) {
                Method method = (Method)container_symbol;
                if (method.getParameters().contains(attrb)) {
                    Debug.verbose((String)("Attribute as FormalParameter identified ==> not collected! " + symbol.toString()));
                    return;
                }
                Debug.verbose((String)("Attribute as LocalVariable identified! " + symbol.toString()));
                this.addLocalVariablesElement(attrb);
            } else if (container_symbol != null && container_symbol.isInstanceOf("ClassType")) {
                Debug.verbose((String)("Field: " + symbol.toString()));
                this.addFieldElement(symbol);
            } else {
                Debug.verbose((String)("Global Variable: " + symbol.toString()));
                this.addGlobalVariableElement(symbol);
            }
        } else if (symbol.isInstanceOf("Method")) {
            Method method = (Method)symbol;
            Object container_class_element = this.getContainerClassElementOfSymbol((Symbol)method);
            if (container_class_element == null) {
                if (method.getCategory() == 0) {
                    method.setCategory(1);
                }
                this.addGlobalFunctionElement(method);
                return;
            }
            switch (method.getCategory()) {
                case 1: {
                    this.addMethodElement(method);
                    break;
                }
                case 2: {
                    this.addMethodElement(method);
                    break;
                }
                case 3: {
                    this.addConstructorElement(method);
                    break;
                }
                case 4: {
                    this.addDestructorElement(method);
                    break;
                }
                case 5: {
                    this.addMethodElement(method);
                    break;
                }
                case 6: {
                    this.addMethodElement(method);
                }
                default: {
                    Debug.warning((String)"Method without category found! ==> set to function and added to method-elements");
                    method.setCategory(2);
                    this.addMethodElement(method);
                    break;
                }
            }
        } else if (symbol.isInstanceOf("MethodComposite")) {
            MethodComposite comp = (MethodComposite)symbol;
            Iterator myIt = comp.getOverloadedMethods().iterator();
            while (myIt.hasNext()) {
                this.collectSymbol((Symbol)((Method)myIt.next()));
            }
        } else if (symbol.isInstanceOf("ArrayType")) {
            ArrayType cfr_ignored_1 = (ArrayType)symbol;
            this.addArrayElement(symbol);
        } else if (symbol.isInstanceOf("NilType")) {
            NilType cfr_ignored_2 = (NilType)symbol;
            this.addPrimitiveTypeElement(symbol);
        } else if (symbol.isInstanceOf("PointerType")) {
            PointerType cfr_ignored_3 = (PointerType)symbol;
            this.addReferenceElement(symbol);
        } else if (symbol.isInstanceOf("ProceduralType")) {
            ProceduralType cfr_ignored_4 = (ProceduralType)symbol;
            this.addDelegateElement(symbol);
        } else if (symbol.isInstanceOf("CharacterType")) {
            CharacterType cfr_ignored_5 = (CharacterType)symbol;
            this.addPrimitiveTypeElement(symbol);
        } else if (symbol.isInstanceOf("EnumeratedType")) {
            EnumeratedType cfr_ignored_6 = (EnumeratedType)symbol;
            this.addPrimitiveTypeElement(symbol);
        } else if (symbol.isInstanceOf("IntegerType")) {
            IntegerType cfr_ignored_7 = (IntegerType)symbol;
            this.addPrimitiveTypeElement(symbol);
        } else if (symbol.isInstanceOf("SubrangeType")) {
            SubrangeType cfr_ignored_8 = (SubrangeType)symbol;
            this.addPrimitiveTypeElement(symbol);
        } else if (symbol.isInstanceOf("RealType")) {
            RealType cfr_ignored_9 = (RealType)symbol;
            this.addPrimitiveTypeElement(symbol);
        } else if (symbol.isInstanceOf("StringType")) {
            StringType cfr_ignored_10 = (StringType)symbol;
            this.addPrimitiveTypeElement(symbol);
        } else if (symbol.isInstanceOf("UnknownClassType")) {
            UnknownClassType cfr_ignored_11 = (UnknownClassType)symbol;
            this.addClassElement(symbol);
        } else if (symbol.isInstanceOf("ClassType")) {
            ClassType cfr_ignored_12 = (ClassType)symbol;
            this.addClassElement(symbol);
        } else if (symbol.isInstanceOf("FileType")) {
            FileType cfr_ignored_13 = (FileType)symbol;
        } else if (symbol.isInstanceOf("RecordType")) {
            RecordType cfr_ignored_14 = (RecordType)symbol;
            this.addClassElement(symbol);
        } else if (symbol.isInstanceOf("SetType")) {
            SetType cfr_ignored_15 = (SetType)symbol;
            this.addClassElement(symbol);
        } else if (symbol.isInstanceOf("UserDefinedType")) {
            UserDefinedType cfr_ignored_16 = (UserDefinedType)symbol;
            this.addTypeAliasElement(symbol);
        } else if (symbol.isInstanceOf("VariantType")) {
            VariantType cfr_ignored_17 = (VariantType)symbol;
            this.addPrimitiveTypeElement(symbol);
        }
    }

    private Object getContainerClassElementOfSymbol(Symbol symbol) {
        if (max_recursion < 0) {
            return null;
        }
        Scope container_scope = null;
        Symbol container_symbol = null;
        if (symbol.getScope() != null) {
            container_scope = symbol.getScope();
            if (container_scope.getCorrespondingSymbol() != null) {
                container_symbol = container_scope.getCorrespondingSymbol();
                if (container_symbol != null && container_symbol.isInstanceOf("Type")) {
                    return container_symbol;
                }
                --max_recursion;
                Object result = this.getContainerClassElementOfSymbol(container_symbol);
                ++max_recursion;
                return result;
            }
            return null;
        }
        return null;
    }

    private void showCodeblockInfo(CodeblockInfo cbi) {
        Debug.verbose((String)("Branches:        " + cbi.getBranches()));
        Debug.verbose((String)("Statements:      " + cbi.getStatements()));
        Debug.verbose((String)("TotalLines:      " + cbi.getTotalLines()));
        Debug.verbose((String)("CommentLines:    " + cbi.getCommentLines()));
        Debug.verbose((String)("Type:            " + cbi.getType()));
    }

    private void showSymbol(Symbol smb) {
        Debug.verbose((String)("Name:            " + smb.getName()));
        Debug.verbose((String)("Lines:           " + smb.getLine()));
        if (smb.getScope() != null) {
            Debug.verbose((String)("Scope-Name:      " + smb.getScope().getName()));
        }
    }

    private void showType(Type type) {
        Debug.verbose((String)("TypeName:        " + type.getName()));
        if (type.getCorrespondingScope() != null) {
            Debug.verbose((String)("Corr-Scope-Name: " + type.getCorrespondingScope().getName()));
        }
    }

    protected Object getFileContainerElementOfPackageElement(Object package_element) {
        return null;
    }

    protected Object getPackageContainerElementOfPackageElement(Object package_element) {
        return null;
    }

    protected Object getClassContainerElementOfClassElement(Object class_element) {
        Type cfr_ignored_0 = (Type)class_element;
        return null;
    }

    public Collection getSuperClassElementsOfClassElement(Object class_element) {
        if (!(class_element instanceof ClassType)) {
            return new Vector();
        }
        ClassType class_op = (ClassType)class_element;
        return class_op.getSuperClasses();
    }

    protected Object getClassContainerElementOfMethodElement(Object method_element) {
        Method method_op = (Method)method_element;
        return this.getContainerClassElementOfSymbol((Symbol)method_op);
    }

    protected Object getClassContainerElementOfConstructorElement(Object constructor_element) {
        Method method_op = (Method)constructor_element;
        Scope scope = method_op.getScope();
        Symbol symbol = scope.getCorrespondingSymbol();
        if (symbol != null && symbol.isInstanceOf("ClassType")) {
            return symbol;
        }
        Debug.warning((String)"ClassType for constructor not found!!");
        return null;
    }

    protected Object getClassContainerElementOfDestructorElement(Object destructor_element) {
        Method method_op = (Method)destructor_element;
        Scope scope = method_op.getScope();
        Symbol symbol = scope.getCorrespondingSymbol();
        if (symbol != null && symbol.isInstanceOf("ClassType")) {
            return symbol;
        }
        Debug.warning((String)"ClassType for destructor not found!!");
        return null;
    }

    protected Object getClassContainerElementOfFieldElement(Object field_element) {
        Attribute attrib = (Attribute)field_element;
        Scope scope = attrib.getScope();
        Symbol symbol = scope.getCorrespondingSymbol();
        if (symbol != null && symbol.isInstanceOf("ClassType")) {
            return symbol;
        }
        Debug.verbose((String)("getClassContainerForFieldElement(): ClassType for attribute " + attrib.getName() + " not found!!"));
        return null;
    }

    protected Object getFunctionContainerElementOfLocalVariableElement(Object lv_element) {
        if (lv_element instanceof Attribute) {
            Attribute attribute_element = (Attribute)lv_element;
            Scope scope = attribute_element.getScope();
            Symbol symbol = scope.getCorrespondingSymbol();
            if (symbol != null && symbol.isInstanceOf("Method")) {
                Debug.info((String)scope.toString());
                Debug.info((String)symbol.toString());
                return symbol;
            }
            Debug.warning((String)("For LocalVariableElement " + attribute_element.getName() + " no MethodContainer found!"));
            return null;
        }
        return null;
    }

    protected Object getFunctionContainerElementOfFormalParameterElement(Object fp_element) {
        if (fp_element instanceof Attribute) {
            Attribute attribute_element = (Attribute)fp_element;
            Scope parent_scope = attribute_element.getScope();
            Symbol corr_symbol = parent_scope.getCorrespondingSymbol();
            if (corr_symbol != null && corr_symbol.isInstanceOf("Method")) {
                return corr_symbol;
            }
            return null;
        }
        return null;
    }

    protected Object getFunctionContainerElementOfCatchParameterElement(Object cp_element) {
        return null;
    }

    protected String getFilenameOfFileElement(Object file_element) {
        CompilationUnit op_comp_unit = (CompilationUnit)file_element;
        ProjectListEntry pe = OPProjectManager.getProjectListEntry((String)op_comp_unit.getCorrespondingScope().getName());
        return pe.getFilename();
    }

    protected String getPackagenameOfPackageElement(Object package_element) {
        Scope compilation_unit_scope = (Scope)package_element;
        return compilation_unit_scope.getName();
    }

    protected String getTypenameOfPrimitiveTypeElement(Object primitive_type_element) {
        return ((Symbol)primitive_type_element).getName();
    }

    protected String getNameOfClassElement(Object class_element) {
        Type class_type_op = (Type)class_element;
        return class_type_op.getName();
    }

    protected Position getPositionOfElement(Object element) {
        if (element instanceof Symbol) {
            Symbol symbol = (Symbol)element;
            Scope container_scope = symbol.getScope();
            CompilationUnit compilation_unit = null;
            if (container_scope == null) {
                Debug.warning((String)("getPositionOfElement(): container_scope was null! for symbol " + symbol.toString()));
            } else {
                compilation_unit = container_scope.getCompilationUnit();
            }
            if (compilation_unit != null) {
                File file_metamod = (File)this.mapper.getInstance((Object)compilation_unit);
                if (file_metamod == null) {
                    file_metamod = DelphiCollector.getUnknownFileObject();
                }
                PositionElement posElement = symbol.getPositionElement();
                int start_line = -1;
                int start_column = -1;
                int end_line = -1;
                int end_column = -1;
                if (posElement != null) {
                    start_line = posElement.getStartLine();
                    start_column = posElement.getStartColumn();
                    end_line = posElement.getEndLine();
                    end_column = posElement.getEndColumn();
                } else {
                    Debug.warning((String)("PositionElement for Symbol was null: " + symbol.toString()));
                }
                Position position = new Position(file_metamod, start_line, start_column, end_line, end_column);
                return position;
            }
        }
        return null;
    }

    protected Object getBaseTypeOfArrayElement(Object array_element) {
        ArrayType array_type = (ArrayType)array_element;
        return array_type.getArrayType();
    }

    protected String getNameOfFunctionElement(Object function_element) {
        Method method_element = (Method)function_element;
        return method_element.getName();
    }

    protected String getNameOfFieldElement(Object field_element) {
        Attribute attribute_element = (Attribute)field_element;
        return attribute_element.getName();
    }

    protected List getFormalParameterElements(Object function_element) {
        Method method_element = (Method)function_element;
        return method_element.getParameters();
    }

    protected String getNameOfFormalParameterElement(Object fp_element) {
        if (fp_element instanceof Attribute) {
            Attribute attribute_element = (Attribute)fp_element;
            return attribute_element.getName();
        }
        return null;
    }

    protected Object getTypeElementOfFormalParameterElement(Object fp_element) {
        if (fp_element instanceof Attribute) {
            Attribute attribute_element = (Attribute)fp_element;
            return attribute_element.getType();
        }
        return null;
    }

    protected List getLocalVariableElements(Object function_element) {
        Vector lv_elements = new Vector();
        Method method_element = (Method)function_element;
        method_element.getCorrespondingScope();
        return lv_elements;
    }

    protected String getNameOfLocalVariableElement(Object lv_element) {
        if (lv_element instanceof Attribute) {
            Attribute attribute_element = (Attribute)lv_element;
            return attribute_element.getName();
        }
        return null;
    }

    protected Object getTypeElementOfLocalVariableElement(Object lv_element) {
        if (lv_element instanceof Attribute) {
            Attribute attribute_element = (Attribute)lv_element;
            return attribute_element.getType();
        }
        return null;
    }

    protected Object getTypeElementOfFieldElement(Object field_element) {
        if (field_element instanceof Attribute) {
            Attribute attribute_element = (Attribute)field_element;
            return attribute_element.getType();
        }
        return null;
    }

    protected String getNameOfGlobalVariableElement(Object gv_element) {
        Attribute attrb = (Attribute)gv_element;
        return attrb.getName();
    }

    protected Object getTypeElementOfGlobalVariableElement(Object gv_element) {
        Attribute attrb = (Attribute)gv_element;
        if (attrb.getType() == null) {
            return OPProjectManager.getConstantType();
        }
        return attrb.getType();
    }

    protected String getNameOfPropertyElement(Object property_element) {
        Property property = (Property)property_element;
        return property.getName();
    }

    protected Object getTypeElementOfPropertyElement(Object property_element) {
        Property property = (Property)property_element;
        return property.getType();
    }

    protected Object getGetterElementOfPropertyElement(Object property_element) {
        Property property = (Property)property_element;
        return property.getGetter();
    }

    protected Object getSetterElementOfPropertyElement(Object property_element) {
        Property property = (Property)property_element;
        return property.getSetter();
    }

    protected boolean classElementIsInterface(Object class_element) {
        if (!(class_element instanceof ClassType)) {
            return false;
        }
        ClassType class_type = (ClassType)class_element;
        return class_type.isInterface();
    }

    protected boolean classElementIsReferenceType(Object class_element) {
        return true;
    }

    public boolean classElementIsExternal(Object class_element) {
        return false;
    }

    public boolean classElementIsInternal(Object class_element) {
        return false;
    }

    public boolean classElementIsNew(Object class_element) {
        return true;
    }

    public boolean classElementIsPrivate(Object class_element) {
        return false;
    }

    public boolean classElementIsProtected(Object class_element) {
        return false;
    }

    public boolean classElementIsPublic(Object class_element) {
        Type class_type = (Type)class_element;
        return class_type.isInterfaceDeclaration();
    }

    public boolean classElementIsPackage(Object class_element) {
        Type class_type = (Type)class_element;
        return !class_type.isInterfaceDeclaration();
    }

    public boolean classElementIsStatic(Object class_element) {
        return false;
    }

    public boolean classElementIsFinal(Object class_element) {
        return false;
    }

    public boolean functionElementIsExternal(Object function_element) {
        return false;
    }

    public boolean functionElementIsInternal(Object function_element) {
        return false;
    }

    public boolean functionElementIsNew(Object function_element) {
        Method method = (Method)function_element;
        return !method.isOverride();
    }

    public boolean functionElementIsPrivate(Object function_element) {
        Method method = (Method)function_element;
        return method.getVisibility() == 6;
    }

    public boolean functionElementIsProtected(Object function_element) {
        Method method = (Method)function_element;
        return method.getVisibility() == 3;
    }

    public boolean functionElementIsPublic(Object function_element) {
        Method method = (Method)function_element;
        return method.getVisibility() == 1 || method.getVisibility() == 2 || method.getVisibility() == 5;
    }

    public boolean functionElementIsPackage(Object function_element) {
        Method method = (Method)function_element;
        return method.getVisibility() == 4;
    }

    public boolean functionElementIsStatic(Object function_element) {
        Method method = (Method)function_element;
        return method.isClassMethod();
    }

    public boolean functionElementIsFinal(Object function_element) {
        return false;
    }

    public boolean functionElementIsVirtual(Object function_element) {
        Method method = (Method)function_element;
        return method.isVirtual() || method.isOverride();
    }

    public boolean functionElementIsIntrospectable(Object function_element) {
        Method method = (Method)function_element;
        return method.isPublished();
    }

    public boolean functionElementIsUnitInitializer(Object function_element) {
        Method method = (Method)function_element;
        return method.getCategory() == 5;
    }

    public boolean functionElementIsUnitFinalizer(Object function_element) {
        Method method = (Method)function_element;
        return method.getCategory() == 6;
    }

    public boolean fieldElementIsExternal(Object field_element) {
        return false;
    }

    public boolean fieldElementIsInternal(Object field_element) {
        return false;
    }

    public boolean fieldElementIsNew(Object field_element) {
        Attribute cfr_ignored_0 = (Attribute)field_element;
        return true;
    }

    public boolean fieldElementIsPrivate(Object field_element) {
        Attribute attrib = (Attribute)field_element;
        return attrib.getVisibility() == 6;
    }

    public boolean fieldElementIsProtected(Object field_element) {
        Attribute attrib = (Attribute)field_element;
        return attrib.getVisibility() == 3;
    }

    public boolean fieldElementIsPublic(Object field_element) {
        Attribute attrib = (Attribute)field_element;
        return attrib.getVisibility() == 1 || attrib.getVisibility() == 2 || attrib.getVisibility() == 5;
    }

    public boolean fieldElementIsPackage(Object field_element) {
        Attribute attrib = (Attribute)field_element;
        return attrib.getVisibility() == 4;
    }

    public boolean fieldElementIsStatic(Object field_element) {
        return false;
    }

    public boolean fieldElementIsFinal(Object field_element) {
        return false;
    }

    public boolean fieldElementIsIntrospectable(Object field_element) {
        Attribute attrib = (Attribute)field_element;
        return attrib.isPublished();
    }

    public boolean arrayElementIsReferenceType(Object array_element) {
        return true;
    }

    public Object getReturnTypeElementOfFunctionElement(Object function_element) {
        Method method = (Method)function_element;
        switch (method.getCategory()) {
            case 2: {
                return method.getType();
            }
        }
        return null;
    }

    public boolean globalVariableElementIsConst(Object global_variable_element) {
        Attribute cfr_ignored_0 = (Attribute)global_variable_element;
        return false;
    }

    protected Object getSetterElementOfpropertyElement(Object property_element) {
        Property property = (Property)property_element;
        return property.getSetter();
    }

    protected Object getGetterElementOfpropertyElement(Object property_element) {
        Property property = (Property)property_element;
        return property.getGetter();
    }

    public boolean propertyElementIsExternal(Object property_element) {
        return false;
    }

    public boolean propertyElementIsInternal(Object property_element) {
        return false;
    }

    public boolean propertyElementIsNew(Object property_element) {
        return true;
    }

    public boolean propertyElementIsPrivate(Object property_element) {
        Property property = (Property)property_element;
        return property.getVisibility() == 4;
    }

    public boolean propertyElementIsProtected(Object property_element) {
        Property property = (Property)property_element;
        return property.getVisibility() == 3;
    }

    public boolean propertyElementIsPublic(Object property_element) {
        Property property = (Property)property_element;
        return property.getVisibility() == 1;
    }

    public boolean propertyElementIsPackage(Object property_element) {
        Property cfr_ignored_0 = (Property)property_element;
        return false;
    }

    public boolean propertyElementIsStatic(Object property_element) {
        return false;
    }

    public boolean propertyElementIsFinal(Object property_element) {
        return false;
    }

    public boolean propertyElementIsIntrospectable(Object property_element) {
        Property property = (Property)property_element;
        return property.isPublished();
    }

    public Object getClassContainerElementOfPropertyElement(Object property_element) {
        Property property = (Property)property_element;
        Scope scope = property.getScope();
        Symbol corr_symbol = scope.getCorrespondingSymbol();
        if (corr_symbol != null && corr_symbol.isInstanceOf("ClassType")) {
            return corr_symbol;
        }
        Debug.warning((String)"ClassContainer of PropertyElement not found!");
        return null;
    }

    public Object getFunctionElementToFunctionAccessElement(Object function_access_element) {
        OutputPair op = (OutputPair)function_access_element;
        return op.getSymbol();
    }

    public Object getContainerStatementOfFunctionAccessElement(Object function_access_element) {
        OutputPair op = (OutputPair)function_access_element;
        if (op.getCurrentStatement() != null) {
            return op.getCurrentStatement();
        }
        return this.getContainerMethodBodyStatementOfAccessElement(op);
    }

    public Object getVariableElementToVariableAccessElement(Object variable_access_element) {
        OutputPair op = (OutputPair)variable_access_element;
        return op.getSymbol();
    }

    public Object getContainerStatementOfVariableAccessElement(Object variable_access_element) {
        OutputPair op = (OutputPair)variable_access_element;
        if (op.getCurrentStatement() != null) {
            return op.getCurrentStatement();
        }
        return this.getContainerMethodBodyStatementOfAccessElement(op);
    }

    public boolean isWritingVariableAccess(Object variable_access_element) {
        return false;
    }

    private Object getContainerMethodBodyStatementOfAccessElement(Object access_element) {
        OutputPair op = (OutputPair)access_element;
        Scope container_scope = op.getScope();
        if (container_scope != null) {
            Symbol corresponding_container_symbol = container_scope.getCorrespondingSymbol();
            if (corresponding_container_symbol != null) {
                ModelElement mapped_metamod_container = this.mapper.getInstance((Object)corresponding_container_symbol);
                if (mapped_metamod_container != null) {
                    if (mapped_metamod_container instanceof Function) {
                        Function function_metamod = (Function)mapped_metamod_container;
                        return function_metamod.getBody();
                    }
                    Debug.verbose((String)("findbody: mapped container was not metamod-Function, but " + mapped_metamod_container.getClass().getName()));
                    return null;
                }
                Debug.verbose((String)"findbody: mapped container was null!");
                return null;
            }
            Debug.verbose((String)"findbody: Container-Symbol was null!");
            return null;
        }
        Debug.verbose((String)"findbody: Container-Scope was null!");
        return null;
    }

    public Object getTypeElementToTypeCastAccessElement(Object typecast_access_element) {
        OutputPair op = (OutputPair)typecast_access_element;
        return op.getSymbol();
    }

    public Object getContainerStatementOfTypeCastAccessElement(Object typecast_access_element) {
        OutputPair op = (OutputPair)typecast_access_element;
        if (op.getCurrentStatement() != null) {
            return op.getCurrentStatement();
        }
        return this.getContainerMethodBodyStatementOfAccessElement(op);
    }

    public boolean functionElementIsProcedure(Object function_element) {
        Method method = (Method)function_element;
        return method.getCategory() == 1;
    }

    public boolean functionElementIsFunction(Object function_element) {
        Method method = (Method)function_element;
        return method.getCategory() == 2;
    }

    public boolean functionElementIsAbstract(Object function_element) {
        Method method = (Method)function_element;
        return method.isAbstract();
    }

    public Object getPackageContainerElementOfGlobalFunctionElement(Object global_function_element) {
        Method method = (Method)global_function_element;
        if (method.getScope() != null && method.getScope().getCompilationUnit() != null) {
            Scope compilation_unit_scope = method.getScope().getCompilationUnit().getCorrespondingScope();
            if (compilation_unit_scope == null) {
                Debug.warning((String)("getPackageContainerElementOfGlobalFunctionElement(): corresondingscope was null! for method: " + method.getFullName()));
            }
            return compilation_unit_scope;
        }
        if (method.getScope() == null) {
            Debug.warning((String)("getPackageContainerElementOfGlobalFunctionElement(): scope was null! for method: " + method.getFullName()));
        } else if (method.getScope().getCompilationUnit() == null) {
            Debug.warning((String)("getPackageContainerElementOfGlobalFunctionElement(): scope.compilationUnit was null! for method: " + method.getFullName()));
        }
        return null;
    }

    public Object getPackageContainerElementOfGlobalVariableElement(Object global_variable_element) {
        Attribute attrb = (Attribute)global_variable_element;
        if (attrb.getScope() != null && attrb.getScope().getCompilationUnit() != null) {
            Scope compilation_unit_scope = attrb.getScope().getCompilationUnit().getCorrespondingScope();
            return compilation_unit_scope;
        }
        return null;
    }

    public Object getPackageContainerElementOfClassElement(Object class_element) {
        Type type = (Type)class_element;
        if (type.getScope() != null && type.getScope().getCompilationUnit() != null) {
            Scope compilation_unit_scope = type.getScope().getCompilationUnit().getCorrespondingScope();
            if (compilation_unit_scope == null) {
                Debug.warning((String)"getPackageContainerElementOfClassElement(): compilation_unit_scope was null!");
            }
            return compilation_unit_scope;
        }
        if (type.getScope() == null) {
            Debug.warning((String)("getPackageContainerElementOfClassElement(): type.getScope() was null! for type: " + type.getFullName()));
        } else if (type.getScope().getCompilationUnit() == null) {
            Debug.warning((String)("getPackageContainerElementOfClassElement(): type.getScope().getCompilationUnit() was null! for type: " + type.getFullName()));
        }
        return null;
    }

    public String getNameOfDelegateElement(Object delegate_element) {
        ProceduralType pt = (ProceduralType)delegate_element;
        return pt.getName();
    }

    public String getNameOfReferenceElement(Object reference_element) {
        PointerType pointer_type = (PointerType)reference_element;
        return pointer_type.getName();
    }

    public Object getReferencedTypeElementOfReferenceElement(Object reference_element) {
        PointerType pointer_type = (PointerType)reference_element;
        return pointer_type.getBaseType();
    }

    public String getNameOfTypeAliasElement(Object typealias_element) {
        UserDefinedType ud_type = (UserDefinedType)typealias_element;
        return ud_type.getName();
    }

    public Object getAliasedTypeElementOfTypeAliasElement(Object typealias_element) {
        UserDefinedType ud_type = (UserDefinedType)typealias_element;
        return ud_type.getBaseType();
    }

    public Object getPackageContainerElementOfTypeAliasElement(Object typealias_element) {
        Type type = (Type)typealias_element;
        if (type.getScope() != null && type.getScope().getCompilationUnit() != null) {
            Scope compilation_unit_scope = type.getScope().getCompilationUnit().getCorrespondingScope();
            return compilation_unit_scope;
        }
        return null;
    }

    public Object getTargetClassElementOfSelfAccessElement(Object self_access_element) {
        OutputPair output_pair = (OutputPair)self_access_element;
        Symbol accessed_symbol = (Symbol)output_pair.getSymbol();
        return this.getContainerClassElementOfSymbol(accessed_symbol);
    }

    public Object getContainerStatementOfSelfAccessElement(Object self_access_element) {
        OutputPair output_pair = (OutputPair)self_access_element;
        if (output_pair.getCurrentStatement() != null) {
            return output_pair.getCurrentStatement();
        }
        return this.getContainerMethodBodyStatementOfAccessElement(output_pair);
    }

    public Object getTypeClassElementOfRunTimeTypeAccessElement(Object runtime_type_access_element) {
        OutputPair output_pair = (OutputPair)runtime_type_access_element;
        Symbol accessed_symbol = (Symbol)output_pair.getSymbol();
        return accessed_symbol;
    }

    public Object getContainerStatementOfRunTimeTypeAccessElement(Object runtime_type_access_element) {
        OutputPair output_pair = (OutputPair)runtime_type_access_element;
        if (output_pair.getCurrentStatement() != null) {
            return output_pair.getCurrentStatement();
        }
        return this.getContainerMethodBodyStatementOfAccessElement(output_pair);
    }

    public Object getTypeClassElementOfStaticTypeAccessElement(Object static_type_access_element) {
        OutputPair output_pair = (OutputPair)static_type_access_element;
        Symbol accessed_symbol = (Symbol)output_pair.getSymbol();
        return accessed_symbol;
    }

    public Object getContainerStatementOfStaticTypeAccessElement(Object static_type_access_element) {
        OutputPair output_pair = (OutputPair)static_type_access_element;
        if (output_pair.getCurrentStatement() != null) {
            return output_pair.getCurrentStatement();
        }
        return this.getContainerMethodBodyStatementOfAccessElement(output_pair);
    }
}

