/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.cpp.externcomitter;

public class WordAcceptor {
    private String word;
    private int currentindex;
    private int wordLength;
    private boolean flexibleWhitespace;
    private boolean whitespaceActive = false;
    private int extraLength = 0;

    public WordAcceptor(String word) {
        this.word = word;
        this.wordLength = word.length();
        this.currentindex = 0;
        this.extraLength = 0;
        this.flexibleWhitespace = false;
        this.whitespaceActive = false;
    }

    public WordAcceptor(String word, boolean flexibleWhitespace) {
        this(word);
        this.flexibleWhitespace = flexibleWhitespace;
    }

    private boolean next(char character) {
        if (this.flexibleWhitespace) {
            return this.handleFlexibleWhitespace(character);
        }
        if (this.currentindex < this.word.length() && this.word.charAt(this.currentindex) == character) {
            ++this.currentindex;
            return true;
        }
        return false;
    }

    private boolean handleFlexibleWhitespace(char character) {
        if (this.whitespaceActive && character != ' ') {
            this.whitespaceActive = false;
            ++this.currentindex;
        }
        if (this.currentindex < this.word.length() && this.word.charAt(this.currentindex) == character) {
            if (character == ' ') {
                if (!this.whitespaceActive) {
                    this.whitespaceActive = true;
                } else {
                    ++this.extraLength;
                }
            } else {
                ++this.currentindex;
            }
            return true;
        }
        return false;
    }

    public boolean wordIsCompletelyAccepted() {
        return this.currentindex >= this.wordLength;
    }

    public void reset() {
        this.currentindex = 0;
        this.extraLength = 0;
        this.whitespaceActive = false;
    }

    public int getWordLength() {
        return this.wordLength;
    }

    public int getBruttoWordLength() {
        return this.wordLength + this.extraLength;
    }

    public boolean handleNextCharacter(char character) {
        if (this.next(character)) {
            return this.wordIsCompletelyAccepted();
        }
        this.reset();
        return false;
    }

    public String getWord() {
        return this.word;
    }
}

