/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.cpp.externcomitter;

import de.fzi.sissy.extractors.cpp.externcomitter.Marker;
import de.fzi.sissy.extractors.cpp.externcomitter.WordAcceptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Stack;

public class ExternCOmitter {
    public final String OUTPUT_EXTENSION = ".externc";
    private String originFilename;
    private String externcFilename;
    private String backupFilename;

    public static void main(String[] args) {
        ExternCOmitter omitter = new ExternCOmitter();
        omitter.omitExterncAndWriteToFile(args[0]);
    }

    public void omitExterncAndWriteToFile(String filename) {
        this.originFilename = filename;
        this.backupFilename = String.valueOf(filename) + ".bak";
        this.externcFilename = String.valueOf(filename) + ".externc";
        File backupfile = this.renameFile(this.originFilename, this.backupFilename);
        FileReader reader = null;
        try {
            reader = new FileReader(backupfile);
            StringBuffer buffer = this.readAndManipulateFile(reader);
            this.writeOutput(this.originFilename, buffer);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private File renameFile(String filenameStart, String filenameTarget) {
        File start = new File(filenameStart);
        File target = new File(filenameTarget);
        if (start.exists()) {
            start.renameTo(target);
        }
        return target;
    }

    public void nameFilesBack() {
        this.renameFile(this.originFilename, this.externcFilename);
        this.renameFile(this.backupFilename, this.originFilename);
    }

    private StringBuffer readAndManipulateFile(InputStreamReader reader) {
        StringBuffer buffer = new StringBuffer();
        Stack<Marker> stack = new Stack<Marker>();
        WordAcceptor startExternChecker = new WordAcceptor("extern \"C\" {", true);
        WordAcceptor startAsmChecker = new WordAcceptor("_asm {", true);
        WordAcceptor openBracketChecker = new WordAcceptor("{");
        WordAcceptor endBracketChecker = new WordAcceptor("}");
        WordAcceptor startTypedefChecker = new WordAcceptor("typedef struct I");
        WordAcceptor endSemicolonChecker = new WordAcceptor(";");
        WordAcceptor startDirectiveChecker = new WordAcceptor("#");
        try {
            int chr = 0;
            int chr_counter = 0;
            while ((chr = reader.read()) != -1) {
                buffer.append((char)chr);
                ++chr_counter;
                if (startExternChecker.handleNextCharacter((char)chr)) {
                    chr_counter = ExternCOmitter.handleStartChecking(buffer, stack, startExternChecker, chr_counter, Marker.KindOfMarker.EXTERNOPEN, ReplaceMode.EMBRACE);
                } else if (startAsmChecker.handleNextCharacter((char)chr)) {
                    chr_counter = ExternCOmitter.handleStartChecking(buffer, stack, startAsmChecker, chr_counter, Marker.KindOfMarker.ASMOPEN, ReplaceMode.START);
                } else if (openBracketChecker.handleNextCharacter((char)chr)) {
                    Marker marker = ExternCOmitter.createMarker(openBracketChecker, chr_counter, Marker.KindOfMarker.OPEN);
                    stack.push(marker);
                }
                if (startTypedefChecker.handleNextCharacter((char)chr)) {
                    chr_counter = ExternCOmitter.handleStartChecking(buffer, stack, startTypedefChecker, chr_counter, Marker.KindOfMarker.TYDEFINT, ReplaceMode.START);
                }
                if (startDirectiveChecker.handleNextCharacter((char)chr)) {
                    buffer.replace(chr_counter - startDirectiveChecker.getBruttoWordLength(), chr_counter, "// " + startDirectiveChecker.getWord());
                    chr_counter = buffer.length();
                }
                if (endSemicolonChecker.handleNextCharacter((char)chr) && !stack.isEmpty()) {
                    switch (stack.peek().getKind()) {
                        case TYDEFINT: {
                            ExternCOmitter.replace(buffer, endSemicolonChecker, chr_counter, ReplaceMode.END);
                            chr_counter = buffer.length();
                            stack.pop();
                        }
                    }
                }
                if (!endBracketChecker.handleNextCharacter((char)chr) || stack.isEmpty()) continue;
                switch (stack.peek().getKind()) {
                    case EXTERNOPEN: {
                        ExternCOmitter.replace(buffer, endBracketChecker, chr_counter, ReplaceMode.EMBRACE);
                        chr_counter = buffer.length();
                        stack.pop();
                        break;
                    }
                    case ASMOPEN: {
                        ExternCOmitter.replace(buffer, endBracketChecker, chr_counter, ReplaceMode.END);
                        chr_counter = buffer.length();
                        stack.pop();
                        break;
                    }
                    case OPEN: {
                        stack.pop();
                    }
                }
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    private static int handleStartChecking(StringBuffer buffer, Stack<Marker> stack, WordAcceptor checker, int chr_counter, Marker.KindOfMarker kind, ReplaceMode replaceMode) {
        Marker marker = ExternCOmitter.createMarker(checker, chr_counter, kind);
        stack.push(marker);
        ExternCOmitter.replace(buffer, checker, chr_counter, replaceMode);
        chr_counter = buffer.length();
        return chr_counter;
    }

    private static void replace(StringBuffer buffer, WordAcceptor checker, int chr_counter, ReplaceMode replaceMode) {
        switch (replaceMode) {
            case START: {
                buffer.replace(chr_counter - checker.getBruttoWordLength(), chr_counter, "/* " + checker.getWord());
                break;
            }
            case END: {
                buffer.replace(chr_counter - checker.getBruttoWordLength(), chr_counter, String.valueOf(checker.getWord()) + " */");
                break;
            }
            case EMBRACE: {
                buffer.replace(chr_counter - checker.getBruttoWordLength(), chr_counter, "/* " + checker.getWord() + " */");
            }
        }
    }

    private static Marker createMarker(WordAcceptor acceptor, int chr_counter, Marker.KindOfMarker kind) {
        return new Marker(chr_counter - acceptor.getWordLength(), acceptor.getWordLength(), kind);
    }

    private void writeOutput(String outputFileName, StringBuffer buffer) {
        File outputFile = new File(outputFileName);
        try {
            outputFile.createNewFile();
            FileWriter writer = new FileWriter(outputFile);
            writer.write(buffer.toString());
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static enum ReplaceMode {
        START,
        END,
        EMBRACE;

    }
}

