/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.cpp;

import de.fzi.sissy.extractors.ExtractorConfiguration;
import de.fzi.sissy.extractors.GenericExtractor;
import de.fzi.sissy.extractors.cpp.CPPFileFilter;
import de.fzi.sissy.extractors.cpp.CPPFileFilterWithHeaders;
import de.fzi.sissy.extractors.cpp.cdt3.CDT3Extractor;
import de.fzi.sissy.extractors.cpp.cdt6.CDT6Extractor;
import de.fzi.sissy.extractors.cpp.externcomitter.ExternCOmitter;
import de.fzi.sissy.metamod.Class;
import de.fzi.sissy.metamod.Member;
import de.fzi.sissy.metamod.Method;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.Root;
import de.fzi.sissy.metamod.StructuralAbstraction;
import de.fzi.sissy.metamod.Subsystem;
import de.fzi.sissy.utils.Debug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;

public class CDTExtractor
extends GenericExtractor {
    private boolean onlycpp;
    private String incFileName = null;
    private String defFileName = null;
    private ExtractorConfiguration.CDTVersion useCDT6 = ExtractorConfiguration.CDTVersion.CDT_3;

    public CDTExtractor(ExtractorConfiguration extractorConfiguration) {
        super(extractorConfiguration, (FileFilter)new CPPFileFilterWithHeaders(), "res\\comments\\java_cpp.dat", "res\\clone\\java_cpp_comments.dat");
        this.extractCPPSpecificParameters();
    }

    protected void extractCPPSpecificParameters() {
        this.onlycpp = this.extractorConfiguration.isExtractOnlyCPPFiles();
        if (!this.extractorConfiguration.getIncludeDirectoriesConfigFile().equals("")) {
            this.incFileName = this.extractorConfiguration.getIncludeDirectoriesConfigFile();
        }
        if (!this.extractorConfiguration.getPreprocessorDefinitionsConfigFile().equals("")) {
            this.defFileName = this.extractorConfiguration.getPreprocessorDefinitionsConfigFile();
        }
        this.useCDT6 = this.extractorConfiguration.getCdtVersion();
    }

    protected void buildMetaModel(IProgressMonitor monitor) {
        boolean defaultSubsys = true;
        List<String> srcFileList = this.modelElementRepository.getFileList();
        if (this.onlycpp) {
            srcFileList = this.filterListAccordingToFileFilter(srcFileList, new CPPFileFilter());
        }
        Map definitions = this.prepareDefinitions(this.defFileName);
        List<String> includePaths = this.retrieveIncludePathsFromFile(this.incFileName);
        if (!includePaths.isEmpty()) {
            this.printList("Using include paths:", includePaths);
        }
        if (this.getSsHelper() != null) {
            defaultSubsys = false;
        }
        int numFiles = srcFileList.size();
        if (monitor != null) {
            monitor.beginTask("Process Files", numFiles);
        }
        long startTime = System.currentTimeMillis();
        CDT6Extractor extractor6 = null;
        CDT3Extractor extractor3 = null;
        if (this.useCDT6 == ExtractorConfiguration.CDTVersion.CDT_6) {
            extractor6 = new CDT6Extractor(this.modelElementRepository, this.extractorConfiguration, definitions, includePaths);
        } else {
            extractor3 = new CDT3Extractor(this.modelElementRepository, this.extractorConfiguration, definitions, includePaths);
        }
        HashMap<String, Subsystem> map = new HashMap<String, Subsystem>();
        int i = 0;
        for (String srcFilePath : srcFileList) {
            ++i;
            if (monitor != null) {
                if (monitor.isCanceled()) {
                    return;
                }
                monitor.subTask("Process File " + i + " of " + srcFileList.size());
            }
            ExternCOmitter externCOmitter = null;
            if (this.extractorConfiguration.omitExternC()) {
                externCOmitter = new ExternCOmitter();
                externCOmitter.omitExterncAndWriteToFile(srcFilePath);
            }
            File f = new File(srcFilePath);
            de.fzi.sissy.metamod.File file = null;
            file = this.useCDT6 == ExtractorConfiguration.CDTVersion.CDT_6 ? extractor6.extractFileToMetamod(f) : extractor3.extractFileToMetamod(f);
            Debug.info((String)("Parsing " + f.getAbsolutePath() + " ... [" + i + "/" + numFiles + "] (File: " + f.getAbsolutePath() + ")"));
            this.createSubsystemStructure(map, f, file, defaultSubsys);
            if (this.extractorConfiguration.omitExternC()) {
                externCOmitter.nameFilesBack();
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (defaultSubsys) {
            this.createTransitiveSubsystemStructure(map);
        }
        this.postProcess();
        long endTime = System.currentTimeMillis();
        Debug.info((String)("Time elapsed: " + (endTime - startTime) / 1000L + " s"));
    }

    private void createSubsystemStructure(HashMap<String, Subsystem> map, File f, de.fzi.sissy.metamod.File file, boolean defaultSubsys) {
        if (defaultSubsys) {
            Subsystem subsys = map.get(f.getParent());
            if (subsys == null) {
                subsys = new Subsystem(f.getParentFile().getName());
                map.put(f.getParent(), subsys);
                this.modelElementRepository.getRoot().addStructuralAbstraction((StructuralAbstraction)subsys);
            }
            subsys.addModelElement((ModelElement)file);
        } else {
            this.assignFileToSubsystem(file);
        }
    }

    private void createTransitiveSubsystemStructure(HashMap<String, Subsystem> map) {
        block0: for (String key : map.keySet()) {
            File f = new File(key);
            while (f.getParentFile() != null) {
                Subsystem parent = map.get(f.getParent());
                if (parent != null) {
                    parent.addModelElement((ModelElement)map.get(key));
                    continue block0;
                }
                f = f.getParentFile();
            }
        }
    }

    private Map prepareDefinitions(String defFileName) {
        Hashtable<String, String> definitions = new Hashtable<String, String>();
        if (defFileName == null) {
            return definitions;
        }
        Debug.setDebugLevel((int)6);
        File propFile = new File(defFileName);
        if (propFile.exists()) {
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(defFileName));
                Debug.info((String)"Macro definitions successfully loaded.");
                Enumeration<?> names = props.propertyNames();
                while (names.hasMoreElements()) {
                    String key = (String)names.nextElement();
                    String value = props.getProperty(key);
                    Debug.info((String)(String.valueOf(key) + " = " + value));
                    definitions.put(key, value);
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return definitions;
    }

    private List<String> retrieveIncludePathsFromFile(String fileName) {
        File inclDirFile;
        LinkedList<String> includePaths = new LinkedList<String>();
        if (fileName == null) {
            return includePaths;
        }
        if (fileName != null && (inclDirFile = new File(fileName)).exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(inclDirFile));
                String line = "";
                while ((line = reader.readLine()) != null) {
                    includePaths.add(line.trim());
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return includePaths;
    }

    private List<String> filterListAccordingToFileFilter(List<String> filePathList, FileFilter fileFilter) {
        ArrayList<String> result = new ArrayList<String>();
        for (String filePath : filePathList) {
            File file = new File(filePath);
            if (!fileFilter.accept(file)) continue;
            result.add(filePath);
        }
        return result;
    }

    private void printList(String caption, List<String> stringList) {
        Debug.info((String)caption);
        for (String item : stringList) {
            Debug.info((String)item);
        }
    }

    private void postProcess() {
        Debug.info((String)"Postprocessing...");
        Debug.info((String)"Computing overridden members...");
        Root root = this.modelElementRepository.getRoot();
        for (Class clss : root.getClasses()) {
            for (Method m : clss.getMethods()) {
                this.computeOverriddenMember(m);
            }
        }
    }

    private void computeOverriddenMember(Method method) {
        Class classtype = method.getSurroundingClass();
        if (method.signature() == null) {
            Debug.println((String)method.toString());
        }
        Debug.mminfo((Object)("Compute overridden member of class " + classtype.getSimpleName() + " (" + method.signature() + ":" + method.signature().quickcompareCode() + ")..."));
        for (Class supertype : classtype.getAllSuperTypes()) {
            Debug.mminfo((Object)("Searching " + supertype.getSimpleName() + " (" + supertype.getMethods().size() + " methods)..."));
            for (Method supermethod : supertype.getMethods()) {
                Debug.mminfo((Object)(supermethod.signature() + ":" + supermethod.signature().quickcompareCode()));
                if (!method.signature().equals(supermethod.signature()) || !supermethod.isVirtual()) continue;
                Debug.mminfo((Object)("Found overridden member in class " + supertype.getSimpleName() + " (" + supertype + ")"));
                method.setOverridenMember((Member)supermethod);
                method.setOverride();
            }
        }
    }

    private void assignFileToSubsystem(de.fzi.sissy.metamod.File file) {
        this.getSsHelper().addFile(file);
    }
}

