/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.cpp.cdt3;

import de.fzi.sissy.extractors.cpp.cdt3.ASTMapper;
import de.fzi.sissy.extractors.cpp.cdt3.ASTVisitor;
import de.fzi.sissy.extractors.cpp.cdt3.RefCollector;
import de.fzi.sissy.metamod.File;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTBaseSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameter;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;

public class SRFWriterVisitor
implements ASTVisitor {
    private PrintWriter writer;
    private HashMap classMap;
    private HashMap funMap;

    public SRFWriterVisitor(String filename, ASTMapper mapper) throws IOException {
        this.writer = new PrintWriter(new BufferedWriter(new FileWriter(filename)));
        this.classMap = mapper.getClassSpecifierMap();
        this.funMap = mapper.getFunctionMap();
    }

    public void setASTMapper(ASTMapper mapper) {
        this.classMap = mapper.getClassSpecifierMap();
        this.funMap = mapper.getFunctionMap();
    }

    private String reduce(String[] s) {
        StringBuffer buf = new StringBuffer();
        if (s.length > 0) {
            buf.append(s[0]);
        }
        int i = 1;
        while (i < s.length) {
            buf.append("." + s[i]);
            ++i;
        }
        return buf.toString();
    }

    private String getTypename(IASTTypeSpecifier typeSpec) {
        if (typeSpec instanceof IASTClassSpecifier) {
            IASTClassSpecifier classSpec = (IASTClassSpecifier)typeSpec;
            return this.reduce(classSpec.getFullyQualifiedName());
        }
        if (typeSpec instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier elabTypeSpec = (IASTElaboratedTypeSpecifier)typeSpec;
            return this.reduce(elabTypeSpec.getFullyQualifiedName());
        }
        if (typeSpec instanceof IASTEnumerationSpecifier) {
            IASTEnumerationSpecifier enumSpec = (IASTEnumerationSpecifier)typeSpec;
            return this.reduce(enumSpec.getFullyQualifiedName());
        }
        if (typeSpec instanceof IASTSimpleTypeSpecifier) {
            IASTSimpleTypeSpecifier simpleTypeSpec = (IASTSimpleTypeSpecifier)typeSpec;
            return simpleTypeSpec.getTypename();
        }
        if (typeSpec instanceof IASTTemplateParameter) {
            IASTTemplateParameter templParam = (IASTTemplateParameter)typeSpec;
            return templParam.getIdentifier();
        }
        if (typeSpec instanceof IASTTypedefDeclaration) {
            IASTTypedefDeclaration typedef = (IASTTypedefDeclaration)typeSpec;
            return this.reduce(typedef.getFullyQualifiedName());
        }
        return "<no typename>";
    }

    @Override
    public void visitIASTClassSpecifier(IASTClassSpecifier specifier) {
        this.writer.println("Class " + this.reduce(specifier.getFullyQualifiedName()));
        Iterator iter = specifier.getBaseClauses();
        while (iter.hasNext()) {
            IASTBaseSpecifier baseSpec = (IASTBaseSpecifier)iter.next();
            this.writer.println("inheritsFrom " + this.reduce(specifier.getFullyQualifiedName()) + " " + baseSpec.getParentClassName());
        }
        try {
            iter = specifier.getDeclarations();
            while (iter.hasNext()) {
                IASTDeclaration decl = (IASTDeclaration)iter.next();
                if (decl instanceof IASTField) {
                    IASTField fld = (IASTField)decl;
                    this.writer.println("hasAttribute " + this.reduce(specifier.getFullyQualifiedName()) + " " + fld.getName());
                    continue;
                }
                if (!(decl instanceof IASTMethod)) continue;
                IASTMethod m = (IASTMethod)decl;
                this.writer.println("hasMethod " + this.reduce(specifier.getFullyQualifiedName()) + " " + m.getName());
            }
        }
        catch (ASTNotImplementedException e) {
            e.printStackTrace();
        }
        RefCollector collector = (RefCollector)this.classMap.get(specifier);
        if (collector != null) {
            for (ISourceElementCallbackDelegate elem : collector.getRefs()) {
                if (elem instanceof IASTFunction) {
                    IASTFunction fun = (IASTFunction)elem;
                    this.writer.println("accesses " + this.reduce(fun.getFullyQualifiedName()) + " " + this.reduce(specifier.getFullyQualifiedName()));
                    continue;
                }
                if (!(elem instanceof IASTField)) continue;
                IASTField fld = (IASTField)elem;
                this.writer.println("usesAttribute " + this.reduce(specifier.getFullyQualifiedName()) + " " + this.reduce(fld.getFullyQualifiedName()));
            }
        }
    }

    @Override
    public void visitIASTVariable(IASTVariable variable) {
        this.writer.print("Variable " + this.reduce(variable.getFullyQualifiedName()));
        IASTAbstractDeclaration absDecl = variable.getAbstractDeclaration();
        IASTTypeSpecifier typeSpec = absDecl.getTypeSpecifier();
        this.writer.println(" " + this.getTypename(typeSpec));
    }

    @Override
    public void visitIASTField(IASTField field) {
        this.writer.print("Attribute " + this.reduce(field.getFullyQualifiedName()));
        IASTAbstractDeclaration absDecl = field.getAbstractDeclaration();
        IASTTypeSpecifier typeSpec = absDecl.getTypeSpecifier();
        this.writer.println(" " + this.getTypename(typeSpec));
    }

    @Override
    public void visitIASTFunction(IASTFunction function) {
        this.writer.println("Function " + this.reduce(function.getFullyQualifiedName()) + " " + function.getName() + " " + function.isStatic());
        IASTAbstractDeclaration absDecl = function.getReturnType();
        IASTTypeSpecifier typeSpec = absDecl.getTypeSpecifier();
        this.writer.println("returns " + this.reduce(function.getFullyQualifiedName()) + " " + this.getTypename(typeSpec));
        RefCollector collector = (RefCollector)this.funMap.get(function);
        if (collector != null) {
            for (ISourceElementCallbackDelegate elem : collector.getRefs()) {
                if (elem instanceof IASTFunction) {
                    IASTFunction fun = (IASTFunction)elem;
                    this.writer.println("calls " + this.reduce(function.getFullyQualifiedName()) + " " + this.reduce(fun.getFullyQualifiedName()));
                    continue;
                }
                if (!(elem instanceof IASTField)) continue;
                IASTField fld = (IASTField)elem;
                this.writer.println("usesAttribute " + this.reduce(function.getFullyQualifiedName()) + " " + this.reduce(fld.getFullyQualifiedName()));
            }
        }
    }

    @Override
    public void visitIASTMethod(IASTMethod method) {
        this.writer.println("Method " + this.reduce(method.getFullyQualifiedName()) + " " + method.getName() + " " + method.isStatic());
        IASTAbstractDeclaration absDecl = method.getReturnType();
        IASTTypeSpecifier typeSpec = absDecl.getTypeSpecifier();
        this.writer.println("returns " + this.reduce(method.getFullyQualifiedName()) + " " + this.getTypename(typeSpec));
        RefCollector collector = (RefCollector)this.funMap.get(method);
        if (collector != null) {
            for (ISourceElementCallbackDelegate elem : collector.getRefs()) {
                if (elem instanceof IASTFunction) {
                    IASTFunction fun = (IASTFunction)elem;
                    this.writer.println("calls " + this.reduce(method.getFullyQualifiedName()) + " " + this.reduce(fun.getFullyQualifiedName()));
                    continue;
                }
                if (!(elem instanceof IASTField)) continue;
                IASTField fld = (IASTField)elem;
                this.writer.println("usesAttribute " + this.reduce(method.getFullyQualifiedName()) + " " + this.reduce(fld.getFullyQualifiedName()));
            }
        }
    }

    @Override
    public void doneVisiting() {
        this.writer.close();
    }

    @Override
    public void newFile(File file, ASTMapper mapper) {
        this.setASTMapper(mapper);
    }

    @Override
    public void visitIASTTypedefDeclaration(IASTTypedefDeclaration decl) {
    }

    @Override
    public void enterNamespaceDefinition(IASTNamespaceDefinition namespace) {
    }

    @Override
    public void exitNamespaceDefinition(IASTNamespaceDefinition namespace) {
    }
}

