/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.cpp.cdt3;

import de.fzi.sissy.extractors.cpp.cdt3.ASTMapper;
import de.fzi.sissy.extractors.cpp.cdt3.RefCollector;
import de.fzi.sissy.extractors.cpp.cdt3.Util;
import de.fzi.sissy.utils.Debug;
import java.util.HashMap;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.IASTClassReference;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFieldReference;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTFunctionReference;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTMethodReference;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IASTVariableReference;
import org.eclipse.cdt.internal.core.parser.StructuralParseCallback;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTLinkageSpecification;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTScope;

public class ExtractorParseCallback
extends StructuralParseCallback
implements ASTMapper {
    private HashMap classSpecifierMap = new HashMap();
    private HashMap functionMap = new HashMap();

    private void addRef(ISourceElementCallbackDelegate ref) {
        if (this.currentScope instanceof IASTFunction) {
            RefCollector collector = (RefCollector)this.functionMap.get(this.currentScope);
            collector.addRef(ref);
        } else if (this.currentScope instanceof IASTClassSpecifier) {
            RefCollector collector = (RefCollector)this.classSpecifierMap.get(this.currentScope);
            collector.addRef(ref);
        }
    }

    private void addElement(IASTDeclaration element) {
        if (this.currentScope instanceof ASTScope) {
            ((ASTScope)this.currentScope).addDeclaration(element);
        } else if (this.currentScope instanceof ASTLinkageSpecification) {
            ((ASTLinkageSpecification)this.currentScope).addDeclaration(element);
        }
    }

    private void enterScope(IASTNode node) {
        if (node instanceof IASTScope) {
            if (node instanceof ASTScope) {
                ((ASTScope)node).initDeclarations();
            }
            this.pushScope((IASTScope)node);
        }
    }

    private void exitScope(IASTNode node) {
        if (node instanceof IASTScope) {
            this.popScope();
        }
    }

    private void pushScope(IASTScope scope) {
        this.scopeStack.addFirst(this.currentScope);
        this.currentScope = scope;
    }

    private IASTScope popScope() {
        IASTScope oldScope = this.currentScope;
        this.currentScope = this.scopeStack.size() > 0 ? (IASTScope)this.scopeStack.removeFirst() : null;
        return oldScope;
    }

    @Override
    public HashMap getClassSpecifierMap() {
        return this.classSpecifierMap;
    }

    @Override
    public HashMap getFunctionMap() {
        return this.functionMap;
    }

    @Override
    public HashMap getReferenceMap() {
        return new HashMap();
    }

    public void enterFunctionBody(IASTFunction function) {
        System.out.println("enter function: " + Util.reduce(function.getFullyQualifiedName()));
        if (function.getOwnerTemplateDeclaration() == null) {
            this.addElement((IASTDeclaration)function);
        } else if (function.getOwnerTemplateDeclaration() instanceof IASTTemplateDeclaration) {
            this.addElement((IASTDeclaration)((IASTTemplateDeclaration)function.getOwnerTemplateDeclaration()));
        }
        if (this.functionMap.get(function) == null) {
            RefCollector collector = new RefCollector();
            this.functionMap.put(function, collector);
        }
        this.enterScope((IASTNode)function);
    }

    public void enterMethodBody(IASTMethod method) {
        System.out.println("enter method (" + this.inclusionLevel + "): " + Util.reduce(method.getFullyQualifiedName()));
        if (method.getOwnerTemplateDeclaration() == null) {
            this.addElement((IASTDeclaration)method);
        } else if (method.getOwnerTemplateDeclaration() instanceof IASTTemplateDeclaration) {
            this.addElement((IASTDeclaration)((IASTTemplateDeclaration)method.getOwnerTemplateDeclaration()));
        }
        if (this.functionMap.get(method) == null) {
            RefCollector collector = new RefCollector();
            this.functionMap.put(method, collector);
        }
        this.enterScope((IASTNode)method);
    }

    public void exitFunctionBody(IASTFunction function) {
        this.exitScope((IASTNode)function);
    }

    public void exitMethodBody(IASTMethod method) {
        System.out.println("exit method: " + Util.reduce(method.getFullyQualifiedName()));
        this.exitScope((IASTNode)method);
    }

    public void enterClassSpecifier(IASTClassSpecifier clss) {
        Debug.info((String)("enter class: " + clss.getName()));
        if (this.classSpecifierMap.get(clss) == null) {
            RefCollector collector = new RefCollector();
            this.classSpecifierMap.put(clss, collector);
        }
        this.enterScope((IASTNode)clss);
    }

    public void exitClassSpecifier(IASTClassSpecifier classSpecification) {
        this.exitScope((IASTNode)classSpecification);
    }

    public void acceptClassReference(IASTClassReference reference) {
        IASTClassSpecifier classSpec = (IASTClassSpecifier)reference.getReferencedElement();
        this.addRef((ISourceElementCallbackDelegate)classSpec);
    }

    public void acceptFunctionReference(IASTFunctionReference reference) {
        IASTFunction fun = (IASTFunction)reference.getReferencedElement();
        this.addRef((ISourceElementCallbackDelegate)fun);
    }

    public void acceptMethodReference(IASTMethodReference reference) {
        IASTMethod method = (IASTMethod)reference.getReferencedElement();
        System.out.println("referenced method: " + method.getName());
        this.addRef((ISourceElementCallbackDelegate)method);
    }

    public void acceptFieldReference(IASTFieldReference reference) {
        IASTField fld = (IASTField)reference.getReferencedElement();
        this.addRef((ISourceElementCallbackDelegate)fld);
    }

    public void acceptVariableReference(IASTVariableReference reference) {
        IASTVariable var = (IASTVariable)reference.getReferencedElement();
        this.addRef((ISourceElementCallbackDelegate)var);
    }

    public void acceptParameterReference(IASTParameterReference reference) {
        IASTParameterDeclaration paramDecl = (IASTParameterDeclaration)reference.getReferencedElement();
        this.addRef((ISourceElementCallbackDelegate)paramDecl);
    }
}

