/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.extractors.clone;

import com.generationjava.io.xml.XmlWriter;
import de.fzi.cloneanalyzer.CloneAnalyzerConsole;
import de.fzi.cloneanalyzer.core.CloneSetStructure;
import de.fzi.cloneanalyzer.core.MaxCloneSet;
import de.fzi.sissy.extractors.clone.FilenameToStatementMapper;
import de.fzi.sissy.metamod.Clone;
import de.fzi.sissy.metamod.CloneInstance;
import de.fzi.sissy.metamod.Function;
import de.fzi.sissy.metamod.ModelElementList;
import de.fzi.sissy.metamod.ModelElementRepository;
import de.fzi.sissy.metamod.Statement;
import de.fzi.sissy.utils.Debug;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class CloneStructureBuilder {
    private static CloneStructureBuilder singleton = null;
    public static final String MIN_CLONE_LENGTH = "MIN_CLONE_LENGTH";
    public static final String FILE_FILTER = "FILE_FILTER";
    public static final String COMMENT_FILE_NAME = "COMMENT_FILE_NAME";
    public static final String IGNORE_WHITESPACE = "IGNORE_WHITESPACE";
    public static final String IGNORE_COMMENTS = "IGNORE_COMMENTS";

    public static CloneStructureBuilder getSingleton() {
        if (singleton == null) {
            singleton = new CloneStructureBuilder();
        }
        return singleton;
    }

    public static Properties getDefaultParameters() {
        Properties default_parameters = new Properties();
        default_parameters.setProperty(MIN_CLONE_LENGTH, "5");
        default_parameters.setProperty(FILE_FILTER, ".*\\.(java|c|cpp|h|hpp|pas|dpr)");
        default_parameters.setProperty(COMMENT_FILE_NAME, "comments.dat");
        default_parameters.setProperty(IGNORE_WHITESPACE, "false");
        default_parameters.setProperty(IGNORE_COMMENTS, "false");
        return default_parameters;
    }

    private String createCloneAnalyzerParamTempFile(List pathList) {
        String result = null;
        try {
            File tempFile = File.createTempFile("cloneanalyzerconfig", ".xmltemp");
            tempFile.deleteOnExit();
            FileWriter fw = new FileWriter(tempFile);
            XmlWriter writer = new XmlWriter((Writer)fw);
            fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.writeEntity("CloneAnalyzerConfig");
            for (String path : pathList) {
                writer.writeEntity("IncludeDirectory");
                writer.writeAttribute("path", path);
                writer.endEntity();
            }
            writer.endEntity();
            writer.close();
            fw.close();
            result = tempFile.getCanonicalPath();
        }
        catch (Exception e) {
            Debug.error((String)("Exception occured while initializing clone analyzer arguments: " + e.getMessage()));
            result = null;
        }
        return result;
    }

    public void executeCloneAnalyseAndCreateCloneStructure(ModelElementRepository modelElementRepository, Properties parameters) {
        Statement current_statement;
        Vector current_cloneInstance_collection;
        List pathList = modelElementRepository.getAnalysisPathList();
        String minCloneLength = parameters.getProperty(MIN_CLONE_LENGTH);
        String fileFilter = parameters.getProperty(FILE_FILTER);
        String ignoreWhitespace = parameters.getProperty(IGNORE_WHITESPACE);
        String ignoreComments = parameters.getProperty(IGNORE_COMMENTS);
        String commentFileName = parameters.getProperty(COMMENT_FILE_NAME);
        String analysisFile = this.createCloneAnalyzerParamTempFile(pathList);
        if (analysisFile == null) {
            return;
        }
        String[] args = new String[]{"CloneAnalyzerConsole", "-m", String.valueOf(minCloneLength), "-d", analysisFile, "-f", fileFilter, "-iw", ignoreWhitespace, "-ic", ignoreComments, "-c", commentFileName};
        CloneSetStructure css = CloneAnalyzerConsole.main((String[])args);
        if (css == null) {
            return;
        }
        Object[] cloneSetObjects = css.getArray();
        Vector cloneSet_collection = new Vector();
        int j = 0;
        while (j < cloneSetObjects.length) {
            MaxCloneSet mcs = (MaxCloneSet)cloneSetObjects[j];
            Object[] cloneInstanceObjects = mcs.getArray();
            Vector cloneInstance_collection = new Vector();
            int k = 0;
            while (k < cloneInstanceObjects.length) {
                de.fzi.cloneanalyzer.core.CloneInstance ci = (de.fzi.cloneanalyzer.core.CloneInstance)cloneInstanceObjects[k];
                String filename = "" + ci.getStartLine().getFile();
                if (filename.charAt(1) == ':') {
                    filename = new String(String.valueOf(filename.substring(0, 1).toLowerCase()) + filename.substring(1));
                }
                ModelElementList statement_list = FilenameToStatementMapper.getSingleton().getStatements(filename);
                Vector<Statement> statement_collection = new Vector<Statement>();
                if (statement_list == null) {
                    Debug.warning((String)("CA: Statement-List for File " + filename + " was null !"));
                } else {
                    if (statement_list.size() == 0) {
                        Debug.warning((String)("CA: Statement-List for File " + filename + " was empty !"));
                    }
                    int t = 0;
                    while (t < statement_list.size()) {
                        Statement statement = (Statement)statement_list.get(t);
                        if (this.isOverlapping(ci, statement)) {
                            statement_collection.add(statement);
                        } else if (this.contains(ci, statement)) {
                            statement_collection.add(statement);
                        }
                        ++t;
                    }
                }
                cloneInstance_collection.add(statement_collection);
                ++k;
            }
            cloneSet_collection.add(cloneInstance_collection);
            ++j;
        }
        Vector new_cloneSet_collection = new Vector();
        int i_cs = 0;
        while (i_cs < cloneSet_collection.size()) {
            current_cloneInstance_collection = (Vector)cloneSet_collection.get(i_cs);
            int number_statement_collections = current_cloneInstance_collection.size();
            Vector new_cloneInstance_collection = null;
            Vector statement_collection = (Vector)current_cloneInstance_collection.get(0);
            String current_method_signature = "";
            int i_stm = 0;
            while (i_stm < statement_collection.size()) {
                current_statement = (Statement)statement_collection.get(i_stm);
                Function method_of_statement = current_statement.getSurroundingFunction();
                if (method_of_statement == null) {
                    Debug.warning((String)"CA: Method of Statement was null !");
                    Debug.warning((String)current_statement.getPosition().getSourceFile().getPathName());
                } else {
                    if (!current_method_signature.equals(method_of_statement.signature().toString())) {
                        new_cloneInstance_collection = new Vector();
                        int j2 = 0;
                        while (j2 < number_statement_collections) {
                            new_cloneInstance_collection.add(new Vector());
                            ++j2;
                        }
                        new_cloneSet_collection.add(new_cloneInstance_collection);
                    }
                    int i_t = 0;
                    while (i_t < number_statement_collections) {
                        try {
                            Statement transfer_statement = (Statement)((Vector)current_cloneInstance_collection.get(i_t)).get(i_stm);
                            ((Vector)new_cloneInstance_collection.get(i_t)).add(transfer_statement);
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            Debug.warning((String)"Some Statements for CloneInstance were incomplete!");
                        }
                        ++i_t;
                    }
                    current_method_signature = method_of_statement.signature().toString();
                }
                ++i_stm;
            }
            ++i_cs;
        }
        Debug.info((String)"After Processing of Data from CloneAnalyzer:");
        Debug.info((String)("Number of Metamod-Clones: " + new_cloneSet_collection.size()));
        i_cs = 0;
        while (i_cs < new_cloneSet_collection.size()) {
            current_cloneInstance_collection = (Vector)new_cloneSet_collection.get(i_cs);
            Debug.info((String)("For Clone " + i_cs + ":"));
            Clone metamod_clone = new Clone();
            int i_ci = 0;
            while (i_ci < current_cloneInstance_collection.size()) {
                Vector current_statement_collection = (Vector)current_cloneInstance_collection.get(i_ci);
                Debug.info((String)("For CloneInstance " + i_ci + ": "));
                Debug.info((String)("Number of Statements: " + current_statement_collection.size()));
                CloneInstance metamod_cloneInstance = new CloneInstance();
                metamod_clone.addCloneInstance(metamod_cloneInstance);
                int i_stm = 0;
                while (i_stm < current_statement_collection.size()) {
                    current_statement = (Statement)current_statement_collection.get(i_stm);
                    metamod_cloneInstance.addStatement(current_statement);
                    ++i_stm;
                }
                ++i_ci;
            }
            modelElementRepository.getRoot().addClone(metamod_clone);
            ++i_cs;
        }
    }

    private boolean contains(de.fzi.cloneanalyzer.core.CloneInstance ci, Statement statement) {
        int startLine_statement = statement.getPosition().getStartLine();
        int endLine_statement = statement.getPosition().getEndLine();
        int startLine_cloneInstance = ci.getStartLine().getLineNumber() + 1;
        int endLine_cloneInstance = ci.getEndLine().getLineNumber() + 1;
        boolean ergebnis = startLine_statement >= startLine_cloneInstance && endLine_statement <= endLine_cloneInstance;
        return ergebnis;
    }

    private boolean isOverlapping(de.fzi.cloneanalyzer.core.CloneInstance ci, Statement statement) {
        int startLine_statement = statement.getPosition().getStartLine();
        int endLine_statement = statement.getPosition().getEndLine();
        int startLine_cloneInstance = ci.getStartLine().getLineNumber() + 1;
        int endLine_cloneInstance = ci.getEndLine().getLineNumber() + 1;
        boolean ergebnis = startLine_statement >= startLine_cloneInstance && startLine_statement <= endLine_cloneInstance && endLine_statement > endLine_cloneInstance;
        return ergebnis;
    }
}

