/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.dpanalyzer.roles;

import de.fzi.sissy.dpanalyzer.DesignPatternDescription;
import de.fzi.sissy.dpanalyzer.DesignPatternRetrievalProcess;
import de.fzi.sissy.dpanalyzer.MetamodRetrievalEngineImplementation;
import de.fzi.sissy.dpanalyzer.constraints.Constraint;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.metamod.NamedModelElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public abstract class Role {
    protected DesignPatternDescription dp_description;
    protected String role_name;
    protected String identifier;
    protected List constraints;
    private static int ident_level = 0;

    public static void increaseIdentLevel() {
        ++ident_level;
    }

    public static void decreaseIdentLevel() {
        --ident_level;
    }

    public Role(String role_name, String identifier, DesignPatternDescription dp_description) {
        this.role_name = role_name;
        this.identifier = identifier;
        this.dp_description = dp_description;
        this.constraints = new LinkedList();
    }

    public Collection evaluate(Collection candidate_list) {
        Role.increaseIdentLevel();
        Vector result = new Vector();
        result.addAll(candidate_list);
        this.printStart(result.size());
        Iterator constraint_itr = this.constraints.iterator();
        while (!result.isEmpty() && constraint_itr.hasNext()) {
            Constraint constraint = (Constraint)constraint_itr.next();
            System.out.println(String.valueOf(Role.getEmptyString(ident_level * 3 + 2)) + "CheckObjectConstraint: " + constraint.getShortString());
            Vector neu_result = (Vector)result.clone();
            for (Object candidate_element : result) {
                this.getDesignPatternDescription().mapIdentifierToRoleCandidate(this.identifier, candidate_element);
                System.out.println(String.valueOf(Role.getEmptyString(ident_level * 3 + 4)) + "Check Candidate: \"" + MetamodRetrievalEngineImplementation.getSingleton().getFullQualifiedNameOfMetamodObject((ModelElement)candidate_element) + "\"");
                if (!constraint.check()) {
                    neu_result.remove(candidate_element);
                } else if (candidate_element instanceof NamedModelElement) {
                    System.out.println(String.valueOf(Role.getEmptyString(ident_level * 3 + 6)) + "Candidate: \"" + ((NamedModelElement)candidate_element).getSimpleName() + "\" KEEPS constraint: " + constraint.getShortString());
                } else {
                    System.out.println(String.valueOf(Role.getEmptyString(ident_level * 3 + 6)) + "Candidate: " + MetamodRetrievalEngineImplementation.getSingleton().getFullQualifiedNameOfMetamodObject((ModelElement)candidate_element) + "\" KEEPS constraint: " + constraint.getShortString());
                }
                this.getDesignPatternDescription().unmapIdentifier(this.identifier);
            }
            result = neu_result;
        }
        this.printEnd(result.size());
        if (!result.isEmpty()) {
            DesignPatternRetrievalProcess.getSingleton().getCurrentDesignPatternInstance().addRoleMapping(this.role_name, result);
        }
        Role.decreaseIdentLevel();
        return result;
    }

    public void addConstraint(Constraint constraint) {
        this.constraints.add(constraint);
        constraint.setDesignPatternDescription(this.getDesignPatternDescription());
    }

    public void setDesignPatternDescription(DesignPatternDescription dp_description) {
        this.dp_description = dp_description;
    }

    public DesignPatternDescription getDesignPatternDescription() {
        return this.dp_description;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.toSmallString());
        sb.append("\n");
        for (Constraint constraint : this.constraints) {
            sb.append("--> " + constraint.toString());
            sb.append("\n");
        }
        sb.append("\n");
        sb.append("\n");
        return sb.toString();
    }

    public String toSmallString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.getClass().getSimpleName()) + "(" + this.role_name + ")");
        if (this.identifier != null) {
            sb.append(":" + this.identifier);
        }
        return sb.toString();
    }

    protected void printStart(int number) {
        System.out.println(String.valueOf(Role.getEmptyString(ident_level * 3)) + "Start Evaluating " + this.getClass().getSimpleName() + "(" + this.role_name + "): Candidates: " + number);
    }

    protected void printLeft(int number) {
        System.out.println(String.valueOf(Role.getEmptyString(ident_level * 3)) + "Evaluating " + this.getClass().getSimpleName() + "(" + this.role_name + "): Left Candidates: " + number);
    }

    protected void printEnd(int number) {
        System.out.println(String.valueOf(Role.getEmptyString(ident_level * 3)) + "Stop Evaluating " + this.getClass().getSimpleName() + "(" + this.role_name + "): Result-Objects: " + number);
    }

    public static String getEmptyString(int length) {
        StringBuffer sb = new StringBuffer();
        int i = 1;
        while (i <= length) {
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    public String getRoleName() {
        return this.role_name;
    }

    public void setRoleName(String role_name) {
        this.role_name = role_name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public List getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List constraints) {
        this.constraints = constraints;
    }
}

