/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.dpanalyzer.constraints;

import de.fzi.sissy.dpanalyzer.DesignPatternDescription;
import de.fzi.sissy.dpanalyzer.constraints.Constraint;
import de.fzi.sissy.dpanalyzer.constraints.ConstraintImplementation;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class ORConstraint
extends ConstraintImplementation {
    private Collection constraint_collection = new LinkedList();

    public ORConstraint(Constraint[] constraints) {
        int i = 0;
        while (i < constraints.length) {
            constraints[i].setDesignPatternDescription(this.getDesignPatternDescription());
            this.constraint_collection.add(constraints[i]);
            ++i;
        }
    }

    public ORConstraint(Constraint constraint1, Constraint constraint2) {
        constraint1.setDesignPatternDescription(this.getDesignPatternDescription());
        constraint2.setDesignPatternDescription(this.getDesignPatternDescription());
        this.constraint_collection.add(constraint1);
        this.constraint_collection.add(constraint2);
    }

    @Override
    public boolean check() {
        for (Constraint constraint : this.constraint_collection) {
            if (!constraint.check()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String stringOfInnerParts() {
        StringBuffer sb = new StringBuffer();
        Iterator constraint_itr = this.constraint_collection.iterator();
        while (constraint_itr.hasNext()) {
            Constraint constraint = (Constraint)constraint_itr.next();
            sb.append(constraint.toString());
            if (!constraint_itr.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public void setDesignPatternDescription(DesignPatternDescription dpd) {
        super.setDesignPatternDescription(dpd);
        for (Constraint constraint : this.constraint_collection) {
            constraint.setDesignPatternDescription(dpd);
        }
    }
}

