/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.dpanalyzer.constraints;

import de.fzi.sissy.dpanalyzer.constraints.ConstraintImplementation;
import de.fzi.sissy.dpanalyzer.evaluation.interfaces.BooleanConstraint;
import de.fzi.sissy.dpanalyzer.evaluation.interfaces.IdentifierConstraint;
import de.fzi.sissy.dpanalyzer.evaluation.interfaces.IntegerConstraint;
import de.fzi.sissy.dpanalyzer.evaluation.interfaces.ObjectTypeConstraint;
import de.fzi.sissy.dpanalyzer.evaluation.interfaces.RoleConstraint;
import de.fzi.sissy.dpanalyzer.evaluation.interfaces.StringConstraint;
import de.fzi.sissy.dpanalyzer.evaluation.parts.BooleanEvaluationPart;
import de.fzi.sissy.dpanalyzer.evaluation.parts.EvaluationPart;
import de.fzi.sissy.dpanalyzer.evaluation.parts.IdentifierEvaluationPart;
import de.fzi.sissy.dpanalyzer.evaluation.parts.IntegerEvaluationPart;
import de.fzi.sissy.dpanalyzer.evaluation.parts.ObjectTypeEvaluationPart;
import de.fzi.sissy.dpanalyzer.evaluation.parts.RoleEvaluationPart;
import de.fzi.sissy.dpanalyzer.evaluation.parts.StringEvaluationPart;
import de.fzi.sissy.dpanalyzer.roles.Role;
import de.fzi.sissy.metamod.ModelElement;
import de.fzi.sissy.utils.Debug;

public abstract class CheckObjectConstraint
extends ConstraintImplementation {
    protected String check_object_identifier;
    protected EvaluationPart evaluation_part;

    public CheckObjectConstraint(String check_object_identifier, boolean isTrue) {
        this(check_object_identifier);
        if (this instanceof BooleanConstraint) {
            this.evaluation_part = new BooleanEvaluationPart(isTrue, (BooleanConstraint)((Object)this));
        } else {
            Debug.warning((String)("Constraint " + this.getClass().getName() + " does not implement " + BooleanConstraint.class.getName()));
        }
    }

    public CheckObjectConstraint(String check_object_identifier, Role evaluation_role) {
        this(check_object_identifier);
        if (this instanceof RoleConstraint) {
            this.evaluation_part = new RoleEvaluationPart(evaluation_role, (RoleConstraint)((Object)this));
        } else {
            Debug.warning((String)("Constraint " + this.getClass().getName() + " does not implement " + RoleConstraint.class.getName()));
        }
    }

    public CheckObjectConstraint(String check_object_identifier, String evaluation_string, boolean isID) {
        this(check_object_identifier);
        if (isID) {
            if (this instanceof IdentifierConstraint) {
                this.evaluation_part = new IdentifierEvaluationPart(evaluation_string, (IdentifierConstraint)((Object)this));
            } else {
                Debug.warning((String)("Constraint " + this.getClass().getName() + " does not implement " + IdentifierConstraint.class.getName()));
            }
        } else if (this instanceof StringConstraint) {
            this.evaluation_part = new StringEvaluationPart(evaluation_string, (StringConstraint)((Object)this));
        } else {
            Debug.warning((String)("Constraint " + this.getClass().getName() + " does not implement " + StringConstraint.class.getName()));
        }
    }

    public CheckObjectConstraint(String check_object_identifier, Class evaluation_class) {
        this(check_object_identifier);
        if (this instanceof ObjectTypeConstraint) {
            this.evaluation_part = new ObjectTypeEvaluationPart(evaluation_class, (ObjectTypeConstraint)((Object)this));
        } else {
            Debug.warning((String)("Constraint " + this.getClass().getName() + " does not implement " + ObjectTypeConstraint.class.getName()));
        }
    }

    public CheckObjectConstraint(String check_object_identifier, int evaluation_number) {
        this(check_object_identifier);
        if (this instanceof IntegerConstraint) {
            this.evaluation_part = new IntegerEvaluationPart(evaluation_number, (IntegerConstraint)((Object)this));
        } else {
            Debug.warning((String)("Constraint " + this.getClass().getName() + " does not implement " + IntegerConstraint.class.getName()));
        }
    }

    private CheckObjectConstraint(String check_object_identifier) {
        this.check_object_identifier = check_object_identifier;
    }

    @Override
    public boolean check() {
        ModelElement check_object = this.getModelElementByIdentifier(this.check_object_identifier);
        if (check_object == null) {
            Debug.warning((String)"Check-Object was null!");
            return false;
        }
        return this.checkObject(check_object);
    }

    protected abstract boolean checkObject(Object var1);

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.getClass().getSimpleName()) + "(" + this.check_object_identifier + ", " + this.stringOfInnerParts() + ")");
        return sb.toString();
    }

    @Override
    protected String stringOfInnerParts() {
        return this.evaluation_part.toString();
    }

    public EvaluationPart getEvaluationPart() {
        return this.evaluation_part;
    }

    public void setEvaluationPart(EvaluationPart evaluation_part) {
        this.evaluation_part = evaluation_part;
    }
}

