select
	'LinesOfCode' as Metric,
	sum(f.linesofcode) as Value
from
	TFiles f,
	TConstants c
where
	f.kindoffile = c.value and
	c.name = 'FILE_SOURCE'
union
	
select
	'LinesOfCodeInFunctionBodies' as Metric,
	sum(func.numberoflines) as Value
from
	TFunctions func,
	TModelElements e,
	TConstants c
where
	func.id = e.id and
	e.status = c.value and
	c.name = 'STATUS_NORMAL'
union

select
	'NumberOfFiles' as Metric,
	count(f.id) as Value
from
	TFiles f,
	TConstants c
where
	f.kindoffile = c.value and
	c.name = 'FILE_SOURCE'
union

select
	'NumberOfClasses' as Metric,
	count(t.id) as Value
from
	TTypes t,
	TModelElements e,
	TConstants c1,
	TConstants c2
where
	t.id = e.id and
	e.kindofelement = c1.value and
	e.status = c2.value and
	(c1.name = 'TYPE_CLASS' or
	 c1.name = 'TYPE_INTERFACE' or
	 c1.name = 'TYPE_GENERICCLASS' or
	 c1.name = 'TYPE_GENERICINTERFACE') and
	c2.name = 'STATUS_NORMAL'
union
	
select
	'NumberOfMethods' as Metric,
	count(f.id) as Value
from
	TFunctions f,
	TMembers m,
	TModelElements e,
	TConstants c1,
	TConstants c2
where
	f.id = m.id and
	f.id = e.id and
	e.status = c1.value and
	f.kindoffunction = c2.value and
	m.classid <> -1 and
	c1.name = 'STATUS_NORMAL' and
	(c2.name = 'FUNC_METHOD' or
	 c2.name = 'FUNC_CONSTRUCTOR' or
	 c2.name = 'FUNC_DESTRUCTOR')
union

select
	'NumberOfAttributes' as Metric,
	count(v.id) as Value
from
	TVariables v,
	TMembers m,
	TModelElements e,
	TConstants c1,
	TConstants c2
where
	v.id = m.id and
	v.id = e.id and
	e.status = c1.value and
	v.kindofvariable = c2.value and
	m.classid <> -1 and
	c1.name = 'STATUS_NORMAL' and
	c2.name = 'VAR_FIELD'
union

select
	'NumberOfGlobalFunctions' as Metric,
	count(f.id) as Value
from
	TFunctions f,
	TModelElements e,
	TConstants c1,
	TConstants c2
where
	f.id = e.id and
	e.status = c1.value and
	f.kindoffunction = c2.value and
	c1.name = 'STATUS_NORMAL' and
	(c2.name = 'FUNC_GLOBALFUNC' or
	 c2.name = 'FUNC_GENERIC')
union

select
	'NumberOfGlobalVariables' as Metric,
	count(v.id) as Value
from
	TVariables v,
	TModelElements e,
	TConstants c1,
	TConstants c2
where
	v.id = e.id and
	e.status = c1.value and
	v.kindofvariable = c2.value and
	c1.name = 'STATUS_NORMAL' and
	c2.name = 'VAR_GLOBALVAR'
;

