/**
FZI Forschungszentrum Informatik, Karlsruhe
mtrifu@fzi.de
*/

SELECT DISTINCT
	functionType.fullname as accessed_class_name,
	accessedSig.signature as accessed_method_signature,
	baseType.fullname as prefered_superclass_name,
	pack.fullname as accessing_package_name,
	cls.fullname as accessing_class_name,
	sig.signature as accessing_function_signature,
	accessedFromFunctionFile.pathname AS file_name,
	accessedFromFunctionSE.startline as line_number
FROM
	TAccesses accesses join
	TMembers members on (accesses.targetid = members.id) left join
	TFunctions baseFunction on (members.overridenmemberid = baseFunction.id) join
	TMembers basemember on (members.overridenmemberid = basemember.id) join
	TFunctions accessedFunction on (members.id = accessedFunction.id) join
	TSignatures accessedSig on accessedSig.functionid = accessedFunction.id join
	TTypes functionType on (accessedFunction.classid = functionType.id) join
	TTypes baseType on (baseFunction.classid = baseType.id) join
	TFunctions accessedFromFunction on (accesses.functionid = accessedFromFunction.id) join
	TSignatures sig on sig.functionid = accessedFromFunction.id join	
	TModelElements mAccessedFromFunction on (accessedFromFunction.id = mAccessedFromFunction.id) join
	TConstants con2 on (con2.value = mAccessedFromFunction.status and con2.name = 'STATUS_NORMAL') left outer join
	TPackages pack on pack.id = accessedFromFunction.packageid left outer join
	TTypes cls on accessedFromFunction.classid = cls.id left outer join
	TSourceEntities accessedFromFunctionSE on (accessedFromFunction.id = accessedFromFunctionSE.id) left outer join
	TFiles accessedFromFunctionFile on (accessedFromFunctionFile.id = accessedFromFunctionSE.sourcefileid) 
WHERE
	accesses.targetid = members.id AND
	members.overridenmemberid <> -1 AND
	NOT EXISTS (
		SELECT *
		FROM TInheritances i
		WHERE i.classId = accesses.classid AND basemember.classid = i.superId
	) 
;
