/* $Id: UeberbuchteDatei.sql,v 1.1 2009/08/06 18:32:21 stammel Exp $ */
/* FZI Forschungszentrum Informatik */



create or replace view VPublicOrPackageClasses as

select distinct
	C.id as ClassId
from
	TTypes as C join
	TMembers as meC on (meC.id = C.id) join
	TConstants as con on (meC.visibility = con.value)
where
	C.classid = -1 AND
	(con.name = 'VISIBILITY_PUBLIC'
	OR
	con.name = 'VISIBILITY_PACKAGE')
;


SELECT 
	meFile.pathname as file_name,
	COUNT(*) as number_of_classes
FROM 
	VPublicOrPackageClasses as PPClasses inner join
	TModelElements m on (PPClasses.Classid = m.id) join
	TConstants cm on (cm.value = m.status and cm.name = 'STATUS_NORMAL') join
	TSourceEntities as seClass on seClass.id = PPClasses.ClassId inner join
	TFiles as meFile on meFile.id = seClass.sourceFileId
GROUP BY
	seClass.sourceFileId, 
	meFile.pathname
HAVING 
	COUNT(*) > 1
ORDER BY 2 DESC
;




drop view VPublicOrPackageClasses;
