/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.sissy.commandline;

import de.fzi.sissy.commandline.ArgParser;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ArgParserBuilder {
    public ArgParser getSISSyArgParser() {
        return new ArgParser("SISSy", "SISSy\n\t[-java <path-list> <params>]\n\t[-cpp <path-list> <params>]\n\t[-delphi <path-list> <params>]\n\t[-export [-cfg <cfg-file>] [{-o <output-file> | -db <dbname>}] [-dbtype <dbtype>] [-u <username>] [-pw <password>] [-drv <db-driver>] [-url <db-url> | -dbdir <dbdir>]  [-ctext] ] [-logerrors]]\n\t[-query [-cfg <cfg-file>] [-db <dbname>] <params>]\n\n\t[-problempattern [-dashboard <directory>]]");
    }

    public ArgParser initializeMainArgumentParser(String[] args) {
        ArgParser argParser = this.getSISSyArgParser();
        argParser.addOption("java", "path-list", "analyze a JAVA project.");
        argParser.addOption("cpp", "path-list", "analyse a C/C++ project.");
        argParser.addOption("delphi", "path-list", "analyse a Delphi project.");
        argParser.addOption("export", null, "export system repository.");
        argParser.addOption("problempattern", null, "run problem pattern queries.");
        argParser.addOption("logerrors", null, "save errors to the database for future reference.");
        argParser.addOption("logtofile", "filepath", "redirects output to file.");
        ArgParserBuilder.addExportArgumentOptions(argParser);
        ArgParserBuilder.addGASTExportOptions(argParser);
        ArgParserBuilder.addProblemPatternParameters(argParser);
        argParser.parse(args);
        return argParser;
    }

    public void addGenericExtractorOptions(ArgParser argParser) {
        argParser.addOption("libsrc", "path-list", "a list of pathnames pointing to folders containing library source code included in the project.");
        argParser.addOption("libbin", "path-list", "a list of pathnames pointing to folders containing binary libraries included in the project.");
        argParser.addOption("exclude", "path-list", "a list of pathnames which are excluded from extraction.");
        argParser.addOption("nocomments", null, "code comment analysis will NOT be executed. (For calculation of lines of code (LOC) comments have to be analysed.)");
        argParser.addOption("clone", null, "clone analysis will be executed.");
        argParser.addOption("min", "min-len", "the minimum clone length.");
        argParser.addOption("ff", "file-filter", "specify your own file-filter for clone-analysis.");
        argParser.addOption("cf", "comment-file", "syntactic form of comments is specified in this file.");
        argParser.addOption("iw", null, "ignore whitespace during clone-analysis.");
        argParser.addOption("ic", null, "ignore comments during clone-analysis.");
        argParser.addOption("subsys", "filename", "path to the xml subsystem specification file.");
        argParser.addOption("fakedeps", null, "create fake model element (function, class) in case of unresolved dependency.");
        argParser.addOption("fakesForProblemBindings", null, "create fake model element (function, class) in case of problem bindings.");
        argParser.addOption("expr", "expressions-file", "exports expressions into file.");
        argParser.reparse();
    }

    public void addJAVASpecificOptions(ArgParser argParser) {
        argParser.setUsage("SISSy -java <path-list>\n\t<path-list>\t\ta list of pathnames pointing to folders containing the sources (separated by " + File.pathSeparator + "). For example \"C:/tmp/" + File.pathSeparator + "src" + File.pathSeparator + "work/files\".\n");
        argParser.addOption("source", "level", "sets the JAVA compiler compliance level of the analyzed sources. It can be 1.3, 1.4 or 5.0 and the default value is 1.4.");
        argParser.reparse();
    }

    public void addCPPSpecificOptions(ArgParser argParser) {
        argParser.setUsage("SISSy -cpp <path_list>\n\t<path-list>\t\ta list of pathnames pointing to folders containing the sources (separated by " + File.pathSeparator + "). For example \"C:/tmp/" + File.pathSeparator + "src" + File.pathSeparator + "work/files\".\n");
        argParser.addOption("ver", "versionnumber", "version of cdt (i.e. 3 or 6), default is 6");
        argParser.addOption("cpponly", null, "parse only CPP files.");
        argParser.addOption("include", "file-name", "a file containing additional include folders (one per line)");
        argParser.addOption("def", "file-name", "a file containing the macro configuration used in the analysis. Each macro definition is a \"name = value\" pair.");
        argParser.addOption("preomit", null, "omits certain elements from source code");
        argParser.reparse();
    }

    public void addDelphiSpecificOptions(ArgParser argParser) {
        argParser.setUsage("SISSy -delphi <path-list>\n\t<path-list>\t\ta list of pathnames pointing to folders containing the sources (separated by " + File.pathSeparator + "). For example \"C:/tmp/" + File.pathSeparator + "src" + File.pathSeparator + "work/files\".\n");
        argParser.addOption("I", "include-list", "path list containing all include directories.");
        argParser.reparse();
    }

    public static void addExportArgumentOptions(ArgParser argParser) {
        argParser.addOption("cfg", "cfg-file", "an alternate jdbc config file. If this param is not supplied the default config file is used.");
        argParser.addOption("o", "output-file", "the result will be stored as SQL commands in the specified file.");
        argParser.addOption("db", "dbname", "the result will be stored in the specified database. If none of the -o or -db params is given the output will be stored in the default database specified in the <cfg-file>.");
        argParser.addOption("dbtype", "db-type", "the type of database: postgres, derby, mysql, sqlite");
        argParser.addOption("u", "db-username", "the username for accessing the database.");
        argParser.addOption("pw", "db-password", "the password for accessing the database.");
        argParser.addOption("drv", "db-driver", "the driver name for accessing the database.");
        argParser.addOption("url", "db-url", "the URL for accessing the database (only for postgres and mysql)");
        argParser.addOption("dbdir", "db-dir", "the directory-path for filebased database (only for derby and sqlite)");
        argParser.addOption("ctext", "", "exports the text of code comments into database.");
    }

    public static void addGASTExportOptions(ArgParser argParser) {
        argParser.addOption("gast", "gast-file", "export gast to specified file. ");
    }

    public static List<String> getPathList(String path) {
        System.out.println("path: " + path);
        ArrayList<String> pathList = new ArrayList<String>();
        if (path != null) {
            StringTokenizer tokenizer = new StringTokenizer(path, ";");
            while (tokenizer.hasMoreTokens()) {
                pathList.add(tokenizer.nextToken());
            }
        }
        return pathList;
    }

    public static void addProblemPatternParameters(ArgParser argParser) {
        argParser.addOption("dashboard", "directorypath", "create problem pattern dashboard in specified directory.");
    }
}

