/*
 * Copyright (c) 2004-2005 CAS Software AG, 
 * 10 Wilhelm-Schickard Street, 76131 Karlsruhe, Germany
 * 
 * Copyright (c) 2004-2006 FZI Forschungszentrum Informatik, 
 * 10-14 Haid-und-Neu Street, 76131 Karlsruhe, Germany
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/*
	$Header: /cvsroot/sissy/SISSy/src/de/fzi/delphi/parser/op_parser.g,v 1.3 2008/04/23 18:49:34 mtrifu Exp $
*/

/*
	ACHTUNG:
	in folgenden Regeln wurden Warnungen deaktiviert
	- elseBlock -> ok, laut Doku / keine Prfung
	- caseStatement -> Laufzeitprfung/nicht getestet
	- statementList -> keine Prfung
*/
header{	
	// Package
	package de.fzi.delphi.parser;
	// Imports
	import java.util.Vector;
	import java.util.List;

import antlr.ASTFactory;
import antlr.ASTPair;
import antlr.CommonAST;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.impl.ASTArray;
import antlr.collections.impl.BitSet;
import de.fzi.delphi.CommonASTWithLineNumber;
import de.fzi.delphi.OPDebug;
import de.fzi.delphi.CodeblockInfo;
import de.fzi.delphi.OPProjectManager;
import de.fzi.delphi.PositionElement;

}
class OPParser extends Parser;
options {
	buildAST=true;
	ASTLabelType = "de.fzi.delphi.CommonASTWithLineNumber";
	k = 2; 
	importVocab=OPLexer;	
	exportVocab=OPParser;
	defaultErrorHandler=false;
}


{ ////////////////////////////////
  ////  ACTION
	// Configuration

	// ACHTUNG! Resolving kann dann nicht mehr funktionieren
	private static boolean tagIdentsWithLineNumber = false;

	private static String NEWLINE = System.getProperty("line.separator");
	private String currentFilename = ""; // getFilename();

	private static String currentNode = null; // used for .dot output
	private int indentLevel = 0;
	private OPLexer lexer = null;
	private List usesList = new Vector();

	// states
	private boolean isForwardDeclaration = false;
	private boolean isExternalDeclaration = false;
	private boolean isDispatchInterface = false;
	private boolean specialIdentAllowed = false;
	
	private int innerFunctionLevel = 0;
	/**
	 * @param lexer
	 */
	public void setLexer(OPLexer lexer) {
		this.lexer = lexer;
	}

	public void setCurrentFilename(String filename) {
		this.currentFilename = filename;
	}

	public void setTagIdentsWithLineNumber(boolean flag){
		tagIdentsWithLineNumber = flag;
	}
	
	/**
	 * @return List which contains the name of the current unit, 
	 * 			followed by the list of used units.
	 */
	public List getUsesList(){
		return usesList;
	}
	
	private void debugPrint(int level, String s) {
		OPDebug.debugPrint(level,s);
	}

	private boolean isUnitIdent(Token t) {
		// Lookup somewhere
		String unitName = OPProjectManager.extractUnitName(t.getText());
		
		if( unitName == null ){
			unitName = OPProjectManager.getFilenameForCompilationUnit(t.getText());
		}
		
		if( unitName == null )
			return false;
		else
			return true;
	}

	private boolean isDirective(Token token){
		int tokenType = token.getType();		
		if( tokenType == CDECL	
			|| tokenType == ABSTRACT
			|| tokenType == DYNAMIC
			|| tokenType == EXPORT
			|| tokenType == FAR
			|| tokenType == FORWARD
			|| tokenType == LOCAL
			|| tokenType == NEAR
			|| tokenType == OVERLOAD
			|| tokenType == OVERRIDE
			|| tokenType == PASCAL
			|| tokenType == REGISTER
			|| tokenType == REINTRODUCE
			|| tokenType == SAFECALL
			|| tokenType == STDCALL
			|| tokenType == VARARGS
			|| tokenType == VIRTUAL
			|| tokenType == ASSEMBLER
			|| tokenType == READONLY 
			|| tokenType == WRITEONLY	
			|| tokenType == DISPID
			|| tokenType == EXTERNAL
			|| tokenType == NAME
			|| tokenType == MESSAGE
		)
				return true;
		else
				return false;
	}

private PositionElement createPositionElement(antlr.Token pi) {
if ((pi!=null)&&(pi instanceof de.fzi.delphi.symbols.TokenWithStartPosition)) {
														     PositionElement posElement = new PositionElement((de.fzi.delphi.symbols.TokenWithStartPosition)pi);
//														     System.out.println("Position for "+pi.getText()+": ");
														     //posElement.print();
														     return posElement;
								//			     #propertyIdent.setPositionElement(posElement);		
}
return null;
	}


	private String indent(int count) {
		StringBuffer str = new StringBuffer();

		for (int i = 0; i < count; i++)
			str.append("  ");
		return str.toString();

	}
//	public void traceIn(String rname) throws TokenStreamException {
//		// patched LLkParser requ.
//		//		super.trace(currentFilename+": "+indent(indentLevel)+ "enter ", rname);
//		if (currentNode != null) {
//			System.out.println(currentNode + "->" + rname);
//			System.out.println("\t[");
//			System.out.println("\t\tcolor=darkgreen");
//			System.out.println("\t\tfontcolor=blue");
//			System.out.println("\t\tlabel=\"" + lexer.getCurrentLine() + "\"");
//			System.out.println("\t]");
//		}
//		indentLevel++;
//		currentNode = rname;
//	}
//	
//	public void traceOut(String rname) throws TokenStreamException {
//		// patched LLkParser requ.
//		indentLevel--;
//		//		super.trace(currentFilename+": "+indent(indentLevel)+"exit ", rname);
//	}


  ////  END OF ACTION
  ////////////////////////////////
}

///////////////////////////////////////////
// Grammar
goal
	: 
	(		program
		|	package_
		|	unit
		|	library_
	)
	{ debugPrint(9,NEWLINE+"<EOF>"); } 
		// <EOF> 
    ;

// Sourcefile classes
library_
	:		LIBRARY^ 							{ debugPrint(10,"Library"); }
				identifier SEMI!
			programBlock 
			// DOT!
	;

package_
	:		PACKAGE^ 							{ debugPrint(10,"Package "); }
				identifier SEMI!
			(requiresClause)?
			(containsClause)?
			END DOT!
	;

unit
	:	UNIT^								{ debugPrint(10,"Unit "); } 
			id:identifier					
			{	usesList.add( #id.getText() );	}
			(
				directive
			)? SEMI! 
			unitBody
		END! DOT!
	;
program
	:
		(programHeading)?
			programBlock
	;

programHeading
	:
		p:PROGRAM^ { debugPrint(10,"Program "); }
		{ if( currentFilename == null ) currentFilename = "<unknown>"; }
		{ debugPrint(9,NEWLINE+currentFilename+":"+p.getLine()+": [program]:");}
		id:identifier
			{	usesList.add( #id.getText() );	}
			
				( 	LPAREN!							{ debugPrint(9,", parameters: "); }	
		 				args:identList 
		 			RPAREN! )? 
		 		SEMI! 
	;

requiresClause 
	:	REQUIRES! (identList!)+ SEMI!
	;
	
containsClause
	:	CONTAINS^ 
		ulist:unitList 
    		{
    			AST current = #ulist.getFirstChild();
    			do{
	    			usesList.add(current.getText());
    			}
    			while( (current=current.getNextSibling()) != null );
    		}
    	SEMI!
	;

unitBody
	:	interfaceSection
		implementationSection
		(initSection)?
	;
interfaceSection
	:	INTERFACE^
		(usesClause)?
		(interfaceDecl)*
	;

interfaceDecl
	:	 (	basicDecl     	
	|	exportedHeading
			)
		{#interfaceDecl=#(#[DECL_SECT,"DECL_SECT"],#interfaceDecl); }
	;

implementationSection
{ debugPrint(2+5,"<Implementation Section>"); }
	:	IMPLEMENTATION^ 
		(usesClause)?
		(declSection)*
		(exportsStatement)*
	;

exportsStatement
	:	EXPORTS^ exportsItem (COMMA! exportsItem)* SEMI!
	;

exportsItem
	:	identifier 
		((NAME|INDEX) "'"! constValue "'"!
			((NAME|INDEX) "'"! constValue "'"!)?
		)?
	;
		
initSection
{ debugPrint(2+5,NEWLINE+"<initSection>"); }
	:	(	INITIALIZATION^
		|	b:BEGIN^ {#b.setType(INITIALIZATION); } 
		) 
		statementList
		
		(finalizationSection)?
	;

finalizationSection
	:	FINALIZATION^ statementList
	;
	
exportedHeading
	:	
	(	procedureHeading SEMI! 
    	{ #exportedHeading=#(#[PROC_DECL,"PROC_DECL"],#exportedHeading); }
	|	functionHeading SEMI!  
    	{ #exportedHeading=#(#[FUNC_DECL,"FUNC_DECL"],#exportedHeading); }
    )
    { // MB: Auch im interface-Abschnitt knnen
	  // forward-/external-Funktionen stehen, fr diese mssen
	  // die entspr. Flags unmittelbar nach der Dekl. zurckgesetzt werden...
	  isForwardDeclaration = false;
      isExternalDeclaration = false;	 }
	;

programBlock
	:
		( usesClause )*
		subprogramBody
	;	
	
identList
    :       identifier
    			( COMMA! 							{ debugPrint(10,","); 	}
    				identifier
    			)*
    		{ #identList=#([IDLIST,"IDLIST"],#identList); }	
    ;      
    

qualifiedIdentifier! // reserved in tree
	:	({ LA(1) == DOT }? id:identifier (did1:dotIdent)?
			{ #qualifiedIdentifier = #( #id,#did1); }
		|	nid:normalIdent (did2:dotIdent)?
			{ #qualifiedIdentifier = #( #nid ,#did2); }
		)
	;

dotIdent!
	:	
		d:DOT! { #d.setText("<QI>"); 
				 debugPrint(10, "."); }	
		id:identifier (did:dotIdent)?
		{ #dotIdent = #(#id,#did); } // evtl. did auf null prfen. 
									// Vermutlich nicht notwendig, wg. nulltree
//		( 	options{ greedy=true; }
//		:	DOT^		 							{ debugPrint(10, "."); }	
//			identifier
//		)* 
	;
	
qualIdentList
    :       qualifiedIdentifier
    			( COMMA! 							{ debugPrint(10,","); 	}
    				qualifiedIdentifier
    			)*
    		{ ##=#([IDLIST,"IDLIST"],##); }	
    ;      
	
identifier
	:	( specialIdent
	|	normalIdent
	)
	;

simpleIdent returns [PositionElement posElement=null;]
:	 id:IDENT										
	 	{  
			debugPrint(10, id.getText()+" ");   
if ((id!=null)&&(id instanceof de.fzi.delphi.symbols.TokenWithStartPosition)) {
														     posElement = new PositionElement((de.fzi.delphi.symbols.TokenWithStartPosition)id);
//														     System.out.println("Position for "+id.getText()+": ");
														     //posElement.print();
														     #simpleIdent.setPositionElement(posElement);		
}
										
			   
			//if( tagIdentsWithLineNumber == true ) {
//				#id.setText(#id.getText()+" ["+id.getLine()+"]"); 
//					}
								     /*
								     if (id instanceof de.fzi.delphi.symbols.TokenWithStartPosition) {
								     		   de.fzi.delphi.symbols.TokenWithStartPosition id_p = (de.fzi.delphi.symbols.TokenWithStartPosition)id;
								     		   System.out.println(id.getText());
								     	   System.out.println("StartLine: "+id_p.getStartLine());	
																     	   System.out.println("StartColumn: "+id_p.getStartColumn());	
																     	   System.out.println("EndLine: "+id_p.getEndLine());	
																     	   System.out.println("EndColumn: "+id_p.getEndColumn());	
								     }
								     */
			}
	;
	
normalIdent returns [PositionElement posElement=null;]
	:	posElement=simpleIdent
	|posElement=	propertyIdent
	|posElement=	directiveIdent
	|posElement=	dispInterfaceIdent
	;
	
propertyIdent returns [PositionElement posElement=null;]
	:	pi1:INDEX		{ #pi1.setType(IDENT); #propertyIdent.setPositionElement(posElement=createPositionElement(pi1));		 }
	|	pi2:READ		{ #pi2.setType(IDENT); #propertyIdent.setPositionElement(posElement=createPositionElement(pi2));		 }
	|	pi3:WRITE		{ #pi3.setType(IDENT); #propertyIdent.setPositionElement(posElement=createPositionElement(pi3));		 }
	|	pi4:STORED		{ #pi4.setType(IDENT); #propertyIdent.setPositionElement(posElement=createPositionElement(pi4));		 }
 	|	pi5:DEFAULT		{ #pi5.setType(IDENT); #propertyIdent.setPositionElement(posElement=createPositionElement(pi5));		 }
|	pi6:NODEFAULT	{ #pi6.setType(IDENT); #propertyIdent.setPositionElement(posElement=createPositionElement(pi6));		 }
;

directiveIdent returns [PositionElement posElement=null;]
	:	pi1:FORWARD			{ #pi1.setType(IDENT); #directiveIdent.setPositionElement(posElement=createPositionElement(pi1));		 }
	|	pi2:MESSAGE			{ #pi2.setType(IDENT); #directiveIdent.setPositionElement(posElement=createPositionElement(pi2));		 }
	| 	pi3:EXTERNAL		{ #pi3.setType(IDENT); #directiveIdent.setPositionElement(posElement=createPositionElement(pi3));		 }
	|	pi4:NAME			{ #pi4.setType(IDENT); #directiveIdent.setPositionElement(posElement=createPositionElement(pi4));		 }
	|	pi5:CDECL			{ #pi5.setType(IDENT); #directiveIdent.setPositionElement(posElement=createPositionElement(pi5));		 }
	|	pi6:ABSTRACT		{ #pi6.setType(IDENT); #directiveIdent.setPositionElement(posElement=createPositionElement(pi6));		 }
	|	pi7:DYNAMIC			{ #pi7.setType(IDENT); #directiveIdent.setPositionElement(posElement=createPositionElement(pi7));		 }
	|	pi8:EXPORT			{ #pi8.setType(IDENT); #directiveIdent.setPositionElement(posElement=createPositionElement(pi8));		 }
	|	pi9:FAR				{ #pi9.setType(IDENT); #directiveIdent.setPositionElement(posElement=createPositionElement(pi9));		 }
	|	pi10:LOCAL			{ #pi10.setType(IDENT); #directiveIdent.setPositionElement(posElement=createPositionElement(pi10));		 }
	|	pi11:NEAR			{ #pi11.setType(IDENT); #directiveIdent.setPositionElement(posElement=createPositionElement(pi11));		 }
	|	pi12:OVERLOAD		{ #pi12.setType(IDENT); #directiveIdent.setPositionElement(posElement=createPositionElement(pi12));		 }
	|	pi13:OVERRIDE		{ #pi13.setType(IDENT); #directiveIdent.setPositionElement(posElement=createPositionElement(pi13));		 }
	|	pi14:PASCAL			{ #pi14.setType(IDENT); #directiveIdent.setPositionElement(posElement=createPositionElement(pi14));		 }
	|	pi15:REGISTER		{ #pi15.setType(IDENT); #directiveIdent.setPositionElement(posElement=createPositionElement(pi15));		 }
	|	pi16:REINTRODUCE	{ #pi16.setType(IDENT); #directiveIdent.setPositionElement(posElement=createPositionElement(pi16));		 }
	|	pi17:SAFECALL		{ #pi17.setType(IDENT); #directiveIdent.setPositionElement(posElement=createPositionElement(pi17));		 }
	|	pi18:STDCALL		{ #pi18.setType(IDENT); #directiveIdent.setPositionElement(posElement=createPositionElement(pi18));		 }
	|	pi19:VARARGS		{ #pi19.setType(IDENT); #directiveIdent.setPositionElement(posElement=createPositionElement(pi19));		 }
	|	pi20:VIRTUAL		{ #pi20.setType(IDENT); #directiveIdent.setPositionElement(posElement=createPositionElement(pi20));		 }
	|	pi21:ASSEMBLER		{ #pi21.setType(IDENT); #directiveIdent.setPositionElement(posElement=createPositionElement(pi21));		 }
	;

dispInterfaceIdent returns [PositionElement posElement=null;]
	:	pi1:READONLY 	{ #pi1.setType(IDENT); #dispInterfaceIdent.setPositionElement(posElement=createPositionElement(pi1));		 }
	|	pi2:WRITEONLY 	{ #pi2.setType(IDENT); #dispInterfaceIdent.setPositionElement(posElement=createPositionElement(pi2));		 }
	|	pi3:DISPID 		{ #pi3.setType(IDENT); #dispInterfaceIdent.setPositionElement(posElement=createPositionElement(pi3));		 }
	;	

specialIdent returns [PositionElement posElement=null;]
	:
/* MB: Real keywords. May not be used as identifiers.
		pi1:TYPE 	{ 	#pi1.setType(IDENT);
						System.out.println(NEWLINE+"## Warning: 'Keyword' TYPE used as Identifier"); }
	|	pi2:CLASS 	{ 	#pi2.setType(IDENT);
						System.out.println(NEWLINE+"## Warning: 'Keyword' CLASS used as Identifier"); }
	|
*/
		pi3:PACKAGE { 	#pi3.setType(IDENT); #specialIdent.setPositionElement(posElement=createPositionElement(pi3));		 
						System.out.println(NEWLINE+"## Warning: 'Keyword' PACKAGE used as Identifier"); }
	|	pi4:AT		{ 	#pi4.setType(IDENT); #specialIdent.setPositionElement(posElement=createPositionElement(pi4));		 
						System.out.println(NEWLINE+"## Warning: 'Keyword' AT used as Identifier"); }
	|	pi5:VARIANT { 	#pi5.setType(IDENT); #specialIdent.setPositionElement(posElement=createPositionElement(pi5));		 
						System.out.println(NEWLINE+"## Warning: 'Keyword' VARIANT used as Identifier"); }
	;
	
subprogramBody 
  :   	
  	(declSection)*
  	(exportsStatement)?
  	( mainProgram )?	//Optional main program "begin ... end"
  ;


mainProgram
	:	{   debugPrint(10,NEWLINE+currentFilename+":"+lexer.getCurrentLine()+":[main-block]");       
	   Token tk = LT(1);
		    PositionElement posElement = createPositionElement(tk);
}	
		compoundStatement 
		DOT! 
		{ #mainProgram=#(#[MAIN_PROGRAM,"MAIN_PROGRAM"],#mainProgram); 
		
  	 	  Token endtk = lexer.getTokenObject();
    	  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
    	  #mainProgram.setPositionElement(posElement);
  }
	;

/* usesClause
	{   debugPrint(10,NEWLINE+currentFilename+":"+lexer.getCurrentLine()+": [usesClause]: ");       }	
    :       USES^ 
    		idlist:identList 
    		{
    			AST current = #idlist.getFirstChild();
    			do{
	    			usesList.add(current.getText());
    			}
    			while( (current=current.getNextSibling()) != null );
    		}
    		SEMI!
	;
*/

// neue Uses Regel mit "IN <File>" von Markus 
usesClause
	{   debugPrint(10,NEWLINE+currentFilename+":"+lexer.getCurrentLine()+": [usesClause]: ");       }	
    :       USES^ 
    		ulist:unitList 
    		{
    			AST current = #ulist.getFirstChild();
    			do{
	    			usesList.add(current.getText());
    			}
    			while( (current=current.getNextSibling()) != null );
    		}
    		SEMI!
	;

// gehrt zur neuen-Uses Regel mit "IN <File>" von Markus 
unitList
	:
    		identifier (IN! stringLiteral!)?
    		( COMMA! identifier (IN! stringLiteral!)? ) *
    		{ #unitList=#([IDLIST,"IDLIST"],#unitList); }	
	;

	
declSection
	:	
//		( basicDecl )* // wenn man alles zusammenfasst ist die Reihenfolge gelockert
//    	( procedureDecl | functionDecl )*
	(	basicDecl
    	| 	
    		// doesn't work for inner-inner-functions
   			{	innerFunctionLevel++;  }
    		(	procedureDecl 
    		| 	functionDecl
    		)
    		{ 	innerFunctionLevel--; }
    	| constructorDecl
    	| destructorDecl
    )
    { #declSection=#(#[DECL_SECT,"DECL_SECT"],#declSection); }
	;
	
/////////////////////////////////////////////////////////////////////////////////
// Declarations
basicDecl
	: 	varDeclSection
	|	constDeclSection
	|	typeDeclSection
	|	labelDecl
  ;

labelDecl
	:	l:LABEL^ 
		{   debugPrint(9,NEWLINE+currentFilename+":"+l.getLine()+": [labelDecl]: ");}
		{ #l.setType(	LABEL_DECL ); }
		expressionList // identList
		SEMI! 
	;
	
varDeclSection
	: 	v: VAR! {   debugPrint(9,NEWLINE+currentFilename+":"+v.getLine()+": [varDeclSection]");       }	
//		{ 	#v.setType(VAR_DECL); 
//			#v.setText("VAR_DECL"); 
//		}
		( varDecl SEMI! )+
	;

varDecl 
  	:
  	{
			    Token tk = LT(1);
		    PositionElement posElement = createPositionElement(tk); 
		}	
  		identList c:COLON^ { #c.setType(VAR_DECL); }
  		( 
	  		DEREF! 			{ debugPrint(10,"(pointer)"); }	
			// Verwerfen, weil der AST noch nicht damit rechnet
  		) ?	
		(
	  		( 	typeId 
	  			( varDeclInit )?  		
			|	structuredType
				( varDeclInit )?
			|	range 
	  			( varDeclInit )?  		
			| 	proceduralType 
	  			( varDeclInit )?  		
			)
  			
		)
		{ 			Token endtk = lexer.getTokenObject();
						  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
						  //System.out.println("VARDEC: "+posElement);
						  #varDecl.setPositionElement(posElement);
		}		
  	;

varDeclInit
	:	(ABSOLUTE^|EQUALS^) objectInitialization // constValue
	;
	
objectInitialization
	:	recordConstant
	|	lp:LPAREN^ { #lp.setType(OBJ_INIT); 
					 #lp.setText("OBJ_INIT"); 
					}
			objectInitialization
			(COMMA! objectInitialization)* 
		RPAREN!
	|	expression
	;

recordConstant
	:		recordFieldConstant
			( options { greedy=true; } 	
			:	SEMI! recordFieldConstant 
			 )*
			 (SEMI!)?
	;
	
recordFieldConstant
	:	identifier 
			c:COLON^ { #c.setType(ASSIGN); }
			objectInitialization
	;

typeDeclSection
  : 	TYPE! 
  		( typeDecl SEMI! )+
  ;

typeDecl
	:
	{   Token tk = LT(1);
		    PositionElement posElement = createPositionElement(tk);
}
		type_id:identifier
		eq:EQUALS^ {   debugPrint(10,NEWLINE+currentFilename+":"+eq.getLine()+": [typeDecl]: "); }	
	
	 	{ #eq.setType(TYPE_DECL); }
		(
			( 
				TYPE! 			{   debugPrint(2+10,"(new, distinct)"); }	
			)? 
			(
				DEREF!
			)?
	    	( 	structuredType
	    	|	interfaceHead
	    	|	dispinterfaceHead
	    	|	proceduralType
	    	|	classRefType
	    	|	classHead
	    	|	typeId 
	    	// part of TypeId |	enumDecl
	    	| 	range
	    	)
	    )
{Token endtk = lexer.getTokenObject();
						  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
						  #typeDecl.setPositionElement(posElement);}
;

enumDecl
	:	LPAREN! expressionList RPAREN!
		{ #enumDecl = #([ENUM_DECL,"ENUM_DECL"],#enumDecl); }
	;

//enumDecl
//	:    	lp:LPAREN! { debugPrint(20,NEWLINE+currentFilename+":"+lp.getLine()+": <enum>"); }
//	    	
//	    	//il:
//	    	(	identifier ( EQUALS expression )?
//    			( COMMA! 							{ debugPrint(10,","); 	}
//    				identifier ( EQUALS expression )?
//    			)*
//			)
//	    	RPAREN!
//	    	//{ #enumDecl = #([ENUM_DECL],#enumDecl ) ; }
//	;
	
proceduralType
	:	(PROCEDURE^|FUNCTION^)
  		(LPAREN! (formalParameters)? RPAREN!)? 
  		(COLON! typeId)?
 			( //options{ greedy=true; } :
 				{ isDirective(LT(1)) || isDirective(LT(2)) }?	
 					( (SEMI!)? directive! )  // die TreeParser erwarten nur einen DIRECTIVE Knoten
 			)*
		( OF OBJECT )?
		{ #proceduralType = #([TYPE_NODE,"TYPE_NODE"],#proceduralType) ; }
	;

interfaceHead
	{ CommonAST	extnd=null,
				guid=null;
	}
	:	i:INTERFACE!

		// EXTENDS
		(
			( 	LPAREN!
					{   debugPrint(20,": [xtds]:"); }
					il:identList!
							{   
							 	extnd = #([EXTENDS,"EXTENDS"],#il); 
							}
				RPAREN! 
			)
			| ()			{
				 				extnd = #([EXTENDS,"EXTENDS"]); 
							}
		)

		
		(
			(	// COM Global UID
				(	LBRACKET!
					str:STRING_LIT!
					RBRACKET! 
					{ guid = #([COM_GUID,"COM_GUID"],#str); }
				)
			|	()	{ guid = #([COM_GUID,"COM_GUID"]); }
			)
			( 
				( 
		 			classMethodDecl
						SEMI!
				| 		propertyDecl 
						SEMI!
				)+
			)?
			
			END!
		)?		

		{ #interfaceHead = #(#i,extnd,guid,#interfaceHead); }
		
	;

dispinterfaceHead
	{ CommonAST	extnd=null,
				guid=null;
	}
	:	
		i:DISPINTERFACE!{ isDispatchInterface = true; }

		// EXTENDS
		(
			( 	LPAREN!
					{   debugPrint(20,": [xtds]:"); }
					il:identList!
							{   
							 	extnd = #([EXTENDS,"EXTENDS"],#il); 
							}
				RPAREN! 
			)
			| ()			{
				 				extnd = #([EXTENDS,"EXTENDS"]); 
							}
		)
		
		(
			(	// COM Global UID
				( 	
					LBRACKET! 
					str:STRING_LIT!
					RBRACKET! 
					{ guid = #([COM_GUID,"COM_GUID"],#str); }
				)
				|() 	{ guid = #([COM_GUID,"COM_GUID"]); }
			)		
			(
				( 	dispinterfaceClassMethodDecl
				| 	dispinterfacePropertyDecl
				)+
			)?
			e:END! 	//{ System.out.print(e.getLine());}
		)?
		{ 
			{ isDispatchInterface = false; }
			#dispinterfaceHead = #(#i,extnd,guid,#dispinterfaceHead);
		}
	;

dispinterfaceClassMethodDecl
	:
		classMethodDecl
//		( dispInterfaceDirectives )?
		SEMI!
	;

dispinterfacePropertyDecl
	:	
		p:PROPERTY!//^ { #p.setType(PRPTY_DECL); }
		{ debugPrint(10,NEWLINE+currentFilename+","+p.getLine()+": [propertyDecl]: name:"); }	
		identifier
			
		(propertyInterface)?
		(	
	 		(SEMI!)?
			(directive|propertySpecifiers) 		
			(	
				options{ greedy=true; }
				:
				(SEMI!)?
				(directive|propertySpecifiers) 	
			)*
		)?
		SEMI!
		{ #dispinterfacePropertyDecl = #([PRPTY_DECL,"PRPTY_DECL"],#dispinterfacePropertyDecl); }	
	;



//dispInterfaceDirectives
//	:	(SEMI!)? 
//			((dispInterfaceSingleDirective)+|directive)
//		( SEMI! ((dispInterfaceSingleDirective)+|directive) )*
//	;

//dispInterfaceSingleDirective!
//	:	READONLY 
//		{ #dispInterfaceSingleDirective = #([DIRECTIVE,"DIRECTIVE"],READONLY); }
//	|	WRITEONLY	
//		{ #dispInterfaceSingleDirective = #([DIRECTIVE,"DIRECTIVE"],WRITEONLY); }
//	|	DISPID (MINUS|PLUS)? ui:unsignedInteger
//		{ #dispInterfaceSingleDirective = #([DIRECTIVE,"DIRECTIVE"],#(DISPID,ui)); }
//	
//	;
	
classHead!
	{ CommonAST extnd; 
	 Vector s=null; }
	:
			{   Token tk = LT(1);
		    PositionElement posElement = createPositionElement(tk);
			}
				c:CLASS			{   debugPrint(10,NEWLINE+currentFilename+":"+c.getLine()+": [classDecl]:"+c.getText()+" "); }	
				(
					( 	LPAREN!
							{   debugPrint(20,": [xtds]:"); }
							il:qualIdentList!
							{
									{   debugPrint(20,"############"); }
									 	extnd = #([EXTENDS,"EXTENDS"],#il); 
									}
						RPAREN! 
					)
					| ()			{
						 				extnd = #([EXTENDS,"EXTENDS"]); 
									}
				)
				
				( 
					cdcl:classDecl! 
				)?
				{ 	#classHead = #(c,extnd); 
					if( #cdcl != null )
						##.addASTList(#cdcl);
				 	 	  
				 	 	  Token endtk = lexer.getTokenObject();
    	  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
    	  #c.setPositionElement(posElement);
		}
	;


classDecl! 
	:		/*
				If a member's declaration appears without its own visibility specifier, 
				the member has the same visibility as the one that precedes it. Members 
				at the beginning of a class declaration that don't have a specified 
				visibility are by default published, provided the class is compiled in 
				the {$M+} state or is derived from a class compiled in the {$M+} state;
				otherwise, such members are public.
			*/
		{ CommonASTWithLineNumber ast = null; 
			## = #([AST_LIST]);
}
		( 
			cep:classElementDecl!
			{ 
					if( ast == null )
						ast = #([PUBLISHED,"published"],#cep);
					else
						ast.addChild(#cep);
			}
		)*
		{ if( ast != null )
			##.addChild(ast);
		}
		( 
			cv:classVisibility!
			// neuer Unter-Ast
			(ce:classElementDecl!
				{ #cv.addChild(#ce); }
			// hinzufgen
			)*
			{ ##.addChild( #cv ); }
		)*
		END! 
			;

classVisibility
	:	( 	PUBLIC^ 
		|	AUTOMATED^ 
		)		
		{ debugPrint(10,NEWLINE+"\t"+"publicSection:");       }
	|	PUBLISHED^		{ debugPrint(10,NEWLINE+"\t"+"publishedSection:");       }
	|	PRIVATE^			{ debugPrint(10,NEWLINE+"\t"+"privateSection:");       }
	|	PROTECTED^		{ debugPrint(10,NEWLINE+"\t"+"protectedSection:");       }
	;

classElementDecl
	{ debugPrint(10,NEWLINE+"\t"+"Classelem:");       }
	:	
	(	varDecl SEMI! 
	|	classMethodDecl SEMI!
	| 	propertyDecl SEMI!
//	| recordDecl 
//	| arrayDecl
	|	structuredType
	)
	;

propertyDecl
	: 
	{  		    Token tk = LT(1);
		    PositionElement posElement = createPositionElement(tk); 
		 }
		p:PROPERTY!//^ { #p.setType(PRPTY_DECL); }
		{ debugPrint(10,NEWLINE+currentFilename+","+p.getLine()+": [propertyDecl]: name:"); }	
		// public, private etc. are allowed as IDENT here 
		( identifier 
		|	pub:PUBLIC 		{#pub.setType(IDENT);} 
		|	priv:PRIVATE 	{#priv.setType(IDENT);} 
		|	auto:AUTOMATED	{#auto.setType(IDENT);} 
		|	publish:PUBLISHED	{#publish.setType(IDENT);} 
		|	prot:PROTECTED	{#prot.setType(IDENT);} 
		)
		(propertyInterface)?
		(	
			(SEMI!)?
			(directive|propertySpecifiers) 		
			(	
				options{ greedy=true; }
				:
				(SEMI!)?
				(directive|propertySpecifiers) 	
			)*
		)?
		{ #propertyDecl = #([PRPTY_DECL,"PRPTY_DECL"],#propertyDecl); 
					Token endtk = lexer.getTokenObject();
						  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
						  #propertyDecl.setPositionElement(posElement);
		}
	;

propertyReadWrite
	:	READ^ 				
			{ debugPrint(20,", read by: "); }
			simpleIdent
	|	WRITE^ 
			{ debugPrint(20,", written by: "); }
			simpleIdent
	;

propertySpecifiers
	:	
	(
			( propertyReadWrite (propertyReadWrite)? )
	|	 	INDEX^										{ debugPrint(20,", 'index'"); }
			(	constValue
			|	enumDecl
			|	setConstructor 
			)? 
	| 	STORED^ 
//			id_store:IDENT						{ debugPrint(20,", stored: "+id_store.getText()); }
			propertySpecifiersValue
	|	(   DEFAULT^ 
			// OrdinalType and SetTypes
			(propertySpecifiersValue)?
		|	NODEFAULT 
		)	{ debugPrint(20,", default:"); }
	| 	IMPLEMENTS^								{ debugPrint(20,", 'implements'"); }
	)
//	{ System.err.println(LA(1)+"/["+LT(1).getText()+"]"); }
	;

propertySpecifiersValue
	:(	constValue
	|	enumDecl
	|	setConstructor 
	)
//	{ #propertySpecifiersValue = #([EXPR,"EXPR"],#propertySpecifiersValue); }
	;

propertyInterface
	:	(propertyParameterList)? 
		COLON!	typeId
	;
	
propertyParameterList
	:	(LBRACKET!|LBRACKET_ALT!) 

			parameterSpec 
  				(SEMI! parameterSpec)* 
		(RBRACKET!|RBRACKET_ALT!)
		{ #propertyParameterList = #([PARAM_LIST,"PARAM_LIST"],propertyParameterList); }
		//{ #propertyParameterList = #([PRPTY_PARAM_LIST,"PRPTY_PARAM_LIST"],propertyParameterList); }


		//		 	(CONST^|OUT^)? identList 
//		 		c1:COLON^ { #c1.setType(PRPTY_PARAM); }
//		 		typeId 
//			( 	options { greedy=true; }
//				: SEMI! (CONST^|OUT^)? 
//					identList 
//					cn:COLON^ { #cn.setType(PRPTY_PARAM); }
//					typeId  )*
//			(SEMI!)?				// Letztes SEMI optional
	;

		
classMethodDecl
	:	
	(	functionHeading 
		{ #classMethodDecl = #(#[FUNC_DECL,"FUNC_DECL"],#classMethodDecl ) ; }
	|	procedureHeading
		{ #classMethodDecl = #(#[PROC_DECL,"PROC_DECL"],#classMethodDecl ) ; }
	|	constructorHeading
		{ #classMethodDecl = #(#[CONSTR_DECL,"CONSTR_DECL"],#classMethodDecl ) ; }
	| 	destructorHeading
		{ #classMethodDecl = #(#[DESTR_DECL,"DESTR_DECL"],#classMethodDecl ) ; }
	)
	(EQUALS qualifiedIdentifier)?
	;

arrayDecl
													{ debugPrint(10,"[arrayDecl]:"); }
  :
  {   Token tk = LT(1);
		    PositionElement posElement = createPositionElement(tk);
}
			a:ARRAY^ 	{ #a.setType(ARRAY_DECL); }
  	(
  			(LBRACKET!|LBRACKET_ALT!) 
  				expressionRange)? 
  				arrayDimDecl
    {
  	 	  Token endtk = lexer.getTokenObject();
    	  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
    	  #arrayDecl.setPositionElement(posElement);
  };

arrayDimDecl
  {	
  	int dimension = 1;
  }	
	:	(	(RBRACKET!|RBRACKET_ALT!) 
			( 
				ARRAY^ 
					(LBRACKET!|LBRACKET_ALT!) 
						expressionRange 
					(RBRACKET!|RBRACKET_ALT!) 
													{ dimension++; }
			)*
		|	(	
				c:COMMA^ expressionRange 						{ dimension++; 
														#c.setType(ARRAY_DECL);
													}	
			)+ 
			(RBRACKET!|RBRACKET_ALT!)
	  	)?											{ debugPrint(10,", dim="+dimension); }	
	  	OF! 
	  	(	CONST
	  	|	typeId
	  	|	structuredType
	  	)
	;

expressionRange!
	{ 		debugPrint(10,"<expressionRange"); 	}
	:						{   debugPrint(2+4,"["); }
	(
		e1:expression //simpleExpression
		(
			(	d:DOTDOT^ 			{   debugPrint(2+4,".."); }
				{ #d.setType(RANGE); }
				e2:expression //simpleExpression 
				{ #expressionRange =#([EXPR,"EXPR"],#(#d,#e1,#e2)); }
			)
			|
			() { #expressionRange = #e1; }
		)
	)
	{   debugPrint(2+4,"]"); }
	{ 		debugPrint(10,">"); 	}
	;
	
constDeclSection
	{   debugPrint(10,currentFilename+":"+lexer.getCurrentLine()+": [constDeclSection]");       }	
  	: 
  	{  		    Token tk = LT(1);
		    PositionElement posElement = createPositionElement(tk); 
		 }
		 (CONST^|RESOURCESTRING^)
  		(
  			constDecl 
  			SEMI!
  		)+
  {
  	 	  Token endtk = lexer.getTokenObject();
    	  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
    	  #constDeclSection.setPositionElement(posElement);
  }
  ;

constDecl 
	{   debugPrint(10," [constDecl]: ");       
		int stype = -1 ; 
	}	
	:  	{  		    Token tk = LT(1);
		    PositionElement posElement = createPositionElement(tk); 
		 }
		id:identifier 
		(
			( COLON! 
				(	t:typeId 
				|	structuredType 
				)
				( e1:EQUALS^ { #e1.setType(ASSIGN); } 
					(	
						objectInitialization
					|	setConstructor
					) 
				)?
			)
			|	
			( 	e3:EQUALS^	{ #e3.setType(ASSIGN); } 
				expression
			)
		)
	  {
  	 	  Token endtk = lexer.getTokenObject();
    	  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
    	  #id.setPositionElement(posElement);
  }
	;

declSectionOptional
	:	(declSection)+
	|	( 
			// add imag. token
			{## = #([DECL_SECT, "DECL_SECT"], ##);}
		) 
	;
	
procedureDecl
  : 	
{   Token tk = LT(1);
		    PositionElement posElement = createPositionElement(tk);
}
  		procedureHeading (SEMI!)
  		(
	  		{ !isForwardDeclaration && !isExternalDeclaration }? 
	  			(	
					declSectionOptional
					compoundStatement
			    	SEMI!
			    )
	    |	() { 
	    		isForwardDeclaration = false; 
	    		isExternalDeclaration = false;
	    		}
	    ) 
    	{ #procedureDecl=#(#[PROC_DECL,"PROC_DECL"],#procedureDecl); 
    	  ##.setLine(555);
    	  Token endtk = lexer.getTokenObject();
    	  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
    	  #procedureDecl.setPositionElement(posElement);
   	}
  ;

procedureHeading
	:	(CLASS)? id:PROCEDURE! 							{ debugPrint(10,NEWLINE+currentFilename+":"+id.getLine()+": [procedureDecl]: "); 
//	System.out.println(c.getClass().getName());
										/*
										     if ((c!=null)&&(c instanceof de.fzi.delphi.symbols.TokenWithStartPosition)) {
										     posElement = new PositionElement((de.fzi.delphi.symbols.TokenWithStartPosition)c);		
										     } else
																				     if ((id!=null)&&(id instanceof de.fzi.delphi.symbols.TokenWithStartPosition)) {
																														     posElement = new PositionElement((de.fzi.delphi.symbols.TokenWithStartPosition)id);		
										     }
				*/
										}
			qualifiedIdentifier 
			(	
				LPAREN! 
					(formalParameters)? 
				RPAREN!				{ debugPrint(10,"()"); }
			)? 
			( options{ greedy=true; }
				:
				SEMI! directive 
			)*
						
  	;

functionDecl
	{   debugPrint(9,NEWLINE+"[FunctionDecl]"); }
		  : 
		{  		    Token tk = LT(1);
		    PositionElement posElement = createPositionElement(tk); 
		 }
			functionHeading SEMI!
  		(
	  		{ isForwardDeclaration == false 
	  			&& !isExternalDeclaration
	  			}? 
	  			(	
					declSectionOptional
					compoundStatement
			    	SEMI!
			    )
	    |	() {
	    		isForwardDeclaration = false; 
	    		isExternalDeclaration = false;
	    		}
	    ) 
	    { isExternalDeclaration = false; }
    	{ #functionDecl=#(#[FUNC_DECL,"FUNC_DECL"],#functionDecl); 
    	  Token endtk = lexer.getTokenObject();
    	  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
    	  #functionDecl.setPositionElement(posElement);
    	}
  ;



functionHeading 
	:	(CLASS)? FUNCTION!	{   debugPrint(10,": [functionHeading]: ");
		/*
												     if ((c!=null)&&(c instanceof de.fzi.delphi.symbols.TokenWithStartPosition)) {
										     posElement = new PositionElement((de.fzi.delphi.symbols.TokenWithStartPosition)c);		
										     } else
																				     if ((id!=null)&&(id instanceof de.fzi.delphi.symbols.TokenWithStartPosition)) {
																														     posElement = new PositionElement((de.fzi.delphi.symbols.TokenWithStartPosition)id);		
										     }
	 */
										 }
	  		qualifiedIdentifier
	  	(			
  			( LPAREN! (formalParameters)? RPAREN! )? 
  			( COLON! typeId )? 
			( 	( options{ greedy=true; }
				:	(SEMI!)? 
						directive
				)*
			)
		)
	;

constructorDecl
	{   debugPrint(9,NEWLINE+"[FunctionDecl]"); }
	  : 
	  {    Token tk = LT(1);
		    PositionElement posElement = createPositionElement(tk); 
		}	
	  	constructorHeading s:SEMI!
			declSectionOptional
			compoundStatement
    	SEMI!
    	
    	{ 	
    		#constructorDecl=#(#[CONSTR_DECL,"CONSTR_DECL"],#constructorDecl); 
    			  Token endtk = lexer.getTokenObject();
    	  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
    	  #constructorDecl.setPositionElement(posElement);
    		}
  ;

constructorHeading
	:	CONSTRUCTOR! 
			qualifiedIdentifier
	   	(LPAREN! (formalParameters)? RPAREN!)? 
			( options {greedy=true;}
				:
				SEMI! directive )*
	;


destructorDecl
	{   debugPrint(9,NEWLINE+"[FunctionDecl]"); }
		  : 
		{      Token tk = LT(1);
		    PositionElement posElement = createPositionElement(tk); 
		}	
  	destructorHeading SEMI!
			declSectionOptional
			compoundStatement
    	SEMI!
    	{ #destructorDecl=#(#[DESTR_DECL,"DESTR_DECL"],#destructorDecl); 
    	  Token endtk = lexer.getTokenObject();
    	  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
    	  #destructorDecl.setPositionElement(posElement);
    	}
  ;

destructorHeading 
	:
		DESTRUCTOR! 
			qualifiedIdentifier
	   	(LPAREN! (formalParameters)? RPAREN!)? 
			(options {greedy=true;}
				:
			 SEMI! directive )*
	;
		


formalParameters
  :		parameterSpec 
  			(SEMI! parameterSpec)* 
    	{#formalParameters = #(#[PARAM_LIST,"PARAM_LIST"],#formalParameters);}
  ;


parameterSpec
	{   debugPrint(10,NEWLINE+"[Parameterspec]"); }	
  : 	
  {   Token tk = LT(1);
		    PositionElement posElement = createPositionElement(tk);
}
  (paramPrefix)? 
  		identList
		(
			(	// c:COLON^ {#c.setType(PARAM_SPEC);}
				COLON!
				( 	
					tn:typeId 	
				|	structuredType  		
				| 	proceduralType 
				|	CONST
				)
			)
			|()
		)
		( 
			EQUALS 
				constExpression
		|	() 		
		)
		{ #parameterSpec=#([PARAM_SPEC,"PARAM_SPEC"] ,#parameterSpec); 
		    			  Token endtk = lexer.getTokenObject();
    	  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
    	  #parameterSpec.setPositionElement(posElement);
    	  //System.out.println("PAPA: "+posElement);
		}
  ;

paramPrefix
	:	VAR^|CONST^|OUT^
	;
	
constExpression // dummy rule
	:	expression // which evaluates to constant at compile-time 
	;
	
/////////////////////////////////////////////////////////////////////////////////
// Statements
statement
	{   debugPrint(9,NEWLINE); }	
	:
( 
		label
	)?
	(	simpleStatement 
	//	|	inheritedStatement
	|	gotoStatement 
	|	emptyStatement 
	// structured statements
	|   ifStatement 
	|   whileStatement 
	|	repeatStatement 
	|	forStatement 
	|	withStatement 
	|	caseStatement 
	|	raiseStatement 
	|	tryStatement 
	|   compoundStatement 
	)
		;

// Statements for Statement List (without empty-stm.)
statementforlist
	{   debugPrint(9,NEWLINE); }	
	:
( 
		label
	)?
	(	simpleStatement 
	//	|	inheritedStatement
	|	gotoStatement 
	// structured statements
	|   ifStatement 
	|   whileStatement 
	|	repeatStatement 
	|	forStatement 
	|	withStatement 
	|	caseStatement 
	|	raiseStatement 
	|	tryStatement 
	|   compoundStatement 
	)
		;


emptyStatement!
	:	    { Token tk = LT(1); PositionElement posElement = createPositionElement(tk);	 }	
		{	#emptyStatement = #([EMPTY_STMNT,"EMPTY_STMNT"]); }
		{ Token endtk = lexer.getTokenObject();
						  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
						  #emptyStatement.setPositionElement(posElement);
}
	;

// Assignment or procedureCall ...
simpleStatement returns [PositionElement posElement=null;]
	:	{   debugPrint(9,currentFilename+":"+lexer.getCurrentLine()+": "); 
    Token tk = LT(1);
		    posElement = createPositionElement(tk);
}			
		expression 
		(
			(	
				b:ASSIGN^ 						{ debugPrint(10,"[assignment]"); }
				{ specialIdentAllowed = true; }
					expression 	
				{ specialIdentAllowed = false; }
			)
		)?
			{ Token endtk = LT(0);
						  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
						  #simpleStatement.setPositionElement(posElement);
						  System.out.println("SIMPLE: "+posElement);
}
	;	

	

label
	:	{   debugPrint(10,currentFilename+":[label="); }
		( identifier | INT_LIT )
		{   debugPrint(10,"]"); }
		COLON!
		{ ## = #([LABEL,"LABEL"],##); }
		
	;
	
gotoStatement
  	:{ Token tk = LT(1); PositionElement posElement = createPositionElement(tk);	 }	
  		g:GOTO^		
  			{   debugPrint(9,currentFilename+":"+g.getLine()+":[gotoStatement]: goto ");}
  			(identifier|INT_LIT)
	{ Token endtk = lexer.getTokenObject();
						  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
						  #gotoStatement.setPositionElement(posElement);
}
	;

ifStatement
    :	
    { Token tk = LT(1); PositionElement posElement = createPositionElement(tk);	 }	
    IF^ expression THEN!
    	(   	statement    	) 
{ Token endtk = LT(1);
						  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
						  #ifStatement.setPositionElement(posElement);
}
( 
		// CONFLICT: the old "dangling-else" problem...
		//           ANTLR generates proper code matching
		//			 as soon as possible.  Hush warning.		
		//options {generateAmbigWarnings=false;}
		options {greedy=true; }
		:	elseBlock 
		{ endtk = lexer.getTokenObject();
						  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
						  #ifStatement.setPositionElement(posElement);
})?
;

elseBlock
	:
		ELSE^
			statement 
    	
	;

forStatement
  :
   { Token tk = LT(1); PositionElement posElement = createPositionElement(tk);	 }	
   line:FOR^ {   debugPrint(9,currentFilename+":"+line.getLine()+":[forStatement]: "); }	
  		forStart
		(forTo|forDownTo)
		forDo
{ Token endtk = lexer.getTokenObject();
						  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
						  #forStatement.setPositionElement(posElement);
}
  ;

forStart
	:	identifier ASSIGN^ expression 
	;
	
forTo
	:	TO^ expression 
	;
	
forDownTo
	:	DOWNTO^	expression 
	;
	
forDo
	:	 DO^ 		statement 
	;
  
whileStatement
  :    
  { Token tk = LT(1); PositionElement posElement = createPositionElement(tk);	 }	
  line: WHILE^  expression DO! {   debugPrint(9,currentFilename+":"+line.getLine()+":[whileStatement]: "); }	
  		statement
 { Token endtk = lexer.getTokenObject();
						  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
						  #whileStatement.setPositionElement(posElement);
}
  ;

repeatStatement
  :  
  { Token tk = LT(1); PositionElement posElement = createPositionElement(tk);	 }	
  	line:REPEAT^		{   debugPrint(9,currentFilename+":"+line.getLine()+": [repeatStatement]: "); }	
  	(	
  		statementList
  	)	{   debugPrint(9,NEWLINE+currentFilename+":"+(line.getLine()+1)+": [statementList]: "); }	
  	UNTIL! expression
 { Token endtk = lexer.getTokenObject();
						  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
						  #repeatStatement.setPositionElement(posElement);
}
  ;

withStatement
	:  
	{ Token tk = LT(1); PositionElement posElement = createPositionElement(tk);	 }	
		line:WITH^		{   debugPrint(9,currentFilename+":"+line.getLine()+":[withStatement]: "); }	
			expressionList 
		DO!
		statement
	 { Token endtk = LT(1);
						  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
						  #withStatement.setPositionElement(posElement);
						  System.out.println("WITH: "+posElement);
}
	;

                 
raiseStatement
	:
		{ Token tk = LT(1); PositionElement posElement = createPositionElement(tk);	 }	
		line:RAISE^			{   debugPrint(9,currentFilename+":"+line.getLine()+":[raiseStatement]: "); }	
			( expression
				// variable 
				(raiseAt)?
			)? 
	 { Token endtk = lexer.getTokenObject();
						  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
						  #raiseStatement.setPositionElement(posElement);
}
	;

raiseAt
	:
		 AT^ 
		 // ADDR_OP 				{ debugPrint(20," at @"); }
			//	variable 
			expression

	;	
tryStatement
	:	
			{ Token tk = LT(1); PositionElement posElement = createPositionElement(tk);	 }	
		lineStart:TRY^										{   debugPrint(9,currentFilename+":"+lineStart.getLine()+":[tryStatement]: "); }	
		statementList
		(
			tryExceptStatement
		|	tryFinallyStatement
		)
	 { Token endtk = lexer.getTokenObject();
						  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
						  #tryStatement.setPositionElement(posElement);
}
	;
	
tryExceptStatement
	:	lineStart:EXCEPT^										{   debugPrint(20,NEWLINE+currentFilename+":"+lineStart.getLine()+":[exceptBlock]: "); }	
        (
        	exceptionBlock
		)												
			lineEnd:END! 										{   debugPrint(20,NEWLINE+currentFilename+":"+lineEnd.getLine()+":[end of try-except-block]: "); }
	;

tryFinallyStatement
	:   lineStart:FINALLY^										{   debugPrint(20,NEWLINE+currentFilename+":"+lineStart.getLine()+":[finallyBlock]: "); }	
                   statementList
		lineEnd:END! 											{   debugPrint(20,NEWLINE+currentFilename+":"+lineEnd.getLine()+":[end of try-finally-block]: "); }	
	;

exceptionBlock
	:	
		statementList
	|	(
			exceptionOn
			( options { greedy=true; }
				: SEMI! exceptionOn )*
				(SEMI!)?
        	(exceptionElse)?
		)
	;
	
exceptionOn
	:
		lineStart:ON^
				( identifier COLON )? 
						{   debugPrint(20,NEWLINE+currentFilename+":"+lineStart.getLine()+":[exception on]: "); }	
				typeId 
		exceptionDo
	;	
	
exceptionElse
	:	ELSE^								{ debugPrint(20," else: "); }	 
         	statementList
    ;
    
exceptionDo
	:
		DO^ 					{ debugPrint(20," do: "); }	
			statement 
	;	

compoundStatement
    :
    { Token tk = LT(1); PositionElement posElement = createPositionElement(tk);	 }	
		      (bbline:BEGIN! eeline:END!  { debugPrint(9,"["+bbline.getLine()+":compoundStatement begin]: "); }
    	      { debugPrint(9, "["+eeline.getLine()+":compoundStatement end]"); } )
{ ##=#(#[STMNT_LIST,"STMNT_LIST"],##); }
    { Token endtk = lexer.getTokenObject();
						  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
						  #compoundStatement.setPositionElement(posElement);
}
|{ Token tk = LT(1); PositionElement posElement = createPositionElement(tk);	 }	
		(    bline:BEGIN!  { debugPrint(9,"["+bline.getLine()+":compoundStatement begin]: "); }
    		( statementList )
    	  eline:END!    { debugPrint(9, "["+eline.getLine()+":compoundStatement end]"); }
    )
    { Token endtk = lexer.getTokenObject();
						  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
						  #compoundStatement.setPositionElement(posElement);
}
|{ Token tk = LT(1); PositionElement posElement = createPositionElement(tk);	 }	
   	(	assemblerStatement
		{ ##=#(#[STMNT_LIST,"STMNT_LIST"],##); }
   	)	 
   	{ Token endtk = lexer.getTokenObject();
						  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
						  #compoundStatement.setPositionElement(posElement);
}
	    ;


assemblerStatement
	:	// ASM_DIREC 
		a:ASM^
		{
			{ debugPrint(9,"["+a.getLine()+":assemblerStatement asm] "); }
		//	AsmParser asmparser = new AsmParser(getInputState());
			//CodeblockInfo ci = asmparser.asmBody();
		}
		e:END!
		{
			{ debugPrint(9,"["+e.getLine()+":assemblerStatement end] "); }
			// get linecount from lexer
/*			String strTotalLines=""+ci.getTotalLines();
			String strCommentLines=""+ci.getCommentLines();
			String strBranches=""+ci.getBranches();
			## = #(#a,
					#(#[META_INFO,"TotalLines"],[INT_LIT,strTotalLines]),
					#(#[META_INFO,"CommentLines"],[INT_LIT,strCommentLines]),
					#(#[META_INFO,"Branches"],[INT_LIT,strBranches])
				);*/
			## = #(#a,
					#(#[META_INFO,"TotalLines"],[INT_LIT,"0"]),
					#(#[META_INFO,"CommentLines"],[INT_LIT,"0"]),
					#(#[META_INFO,"Branches"],[INT_LIT,"0"])
				);
		}
			
	;



statementList
: 	
statement
	( options { greedy=true; }
			: SEMI! statement 
						)*
		(SEMI!)?
		{ #statementList=#(#[STMNT_LIST,"STMNT_LIST"],#statementList); }
	;


/*
statementList
: 	
statementforlist  
	( options { greedy=true; }
			: SEMI! statementforlist 
						)*
		(SEMI!)?
		{ #statementList=#(#[STMNT_LIST,"STMNT_LIST"],#statementList); }
	;
*/

caseStatement
	:
			{ Token tk = LT(1); PositionElement posElement = createPositionElement(tk);	 }	
			CASE^									{ debugPrint(10,"[caseStatement]"); 	}
			expression OF!
				caseSelector 
			 	( 	options { greedy=true; }
					:	SEMI! caseSelector 
			 	)*
				( SEMI! )?
				( caseElse	)?
		END!
		{ Token endtk = lexer.getTokenObject();
						  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
						  #caseStatement.setPositionElement(posElement);
} 
	;    

caseElse
	:	ELSE^
			statementList
	;
	
caseSelector
	: 	caseLabel ( COMMA caseLabel ) *
		 COLON^ statement 
	;
	
caseLabel
	:	// variable, lit, const, range
		// (range|constValue) 
	// DEBUG	constValue (DOTDOT constValue)?
		constExpression (DOTDOT constExpression )?
	;

// parameterList und actualParameter werden m.W. nicht verwendet...
/*parameterList
	: actualParameter ( COMMA! actualParameter )*
    		{#parameterList = #(#[PARAM_LIST,"PARAM_LIST"],#parameterList);}
	;
	
actualParameter
	:	expression ( writeFormatter )? // FIXME: MB: ( VAR | CONST | OUT )? 
	;
*/
setConstructor
												{ debugPrint(10,"<new set>"); 	}
	:
		(LBRACKET!|LBRACKET_ALT!) 
			(setElement ( COMMA! setElement)* )? 
		(RBRACKET!|RBRACKET_ALT!)
		{ #setConstructor = #([SET_CONSTR,"SET_CONSTR"],#setConstructor); }
	;


setElement 
//	{ 		debugPrint(10,"<range"); 	}
//	:	{   debugPrint(2+4,"["); }
//		expression 
//		(	d:DOTDOT^ 			{   debugPrint(2+4,".."); }
//			{ #d.setType(RANGE); }
//		 expression)?
//		{   debugPrint(2+4,"]"); }
//	{ 		debugPrint(10,">"); 	}
	:	expressionRange
	;

range
//	{ 		debugPrint(10,"<range"); 	}
//	:	{   debugPrint(2+4,"["); }
//		constValue
//			d:DOTDOT^ 			{   debugPrint(2+4,".."); }
//			{ #d.setType(RANGE); }
//		constValue
//		{   debugPrint(2+4,"]"); }
//	{ 		debugPrint(10,">"); 	}
	:	expressionRange
	;

//arrayDim
//	:	( 
//			(	l1:LBRACKET^		{	#l1.setType(ARRAY_INDEX);	}
//			|	l2:LBRACKET_ALT^	{	#l2.setType(ARRAY_INDEX);	}
//			)		
//				expressionList
//			(RBRACKET!|RBRACKET_ALT!)
//			(DEREF)*
//		)+
//	;

/////////////////////////////////////////////////////////////////////////////////
// Expressions

expressionList
    :       expression  ( writeFormatter! )?
    			( COMMA! 							{ debugPrint(10,","); 	}
    				expression)*
    	{ #expressionList = #([EXPR_LIST,"EXPR_LIST"],#expressionList); }
    ;   

// MB: to format floats like: x:3:2
writeFormatter
	: COLON expression (COLON expression)?
	;

factor
{ boolean isFunctionCall = false; 
	CommonAST a = null;
}
	:(	simpleFactor[false]
//		( d0:DEREF { #d0.setText("^factor"); } )*
		{ if( LA(1) == LPAREN )
			isFunctionCall = true;
		}
		( f1:factor_1[isFunctionCall])?
//		( d:DEREF { #d.setText("^factor"); } )*
	|	NOT^ factor
	|	ADDR_OP^ factor
	|	INHERITED^ (factor)?
	)
	{	
		if( isFunctionCall && #f1 != null )
			#factor = #([FUNC_CALL,"FUNC_CALL"],#factor);
	}
	;

factor_1[boolean isFuncCall]
	:	factorTail[isFuncCall]
//		( d:DEREF { #d.setText("^factor_1"); } )*
		(factor_1 [false] )?
		
	;

factorTail[boolean isFuncCall]
	{ 	CommonASTWithLineNumber el_temp = null;
	 	CommonASTWithLineNumber temp_factorTail = null;
	}
	:	
		(
		LPAREN!
			(el:expressionList! { el_temp = #el; } )? 
		RPAREN!
			{ 	if( el_temp != null ){
				   	if( isFuncCall ) 
						#temp_factorTail = #([PARAM_LIST,"PARAM_LIST"],#el_temp); 
				  	else	
				  		#temp_factorTail = #el_temp; 
				}else if( isFuncCall ) 
					#temp_factorTail = #([PARAM_LIST,"PARAM_LIST"]);
				## = #temp_factorTail;
			}
		)
	|   (
		(	a1:LBRACKET^	{ #a1.setType(ARRAY_INDEX); }
		|	a2:LBRACKET_ALT^	{ #a2.setType(ARRAY_INDEX); }
		) 
		 expression	
		 	( 	c:COMMA^ { #c.setType(ARRAY_INDEX); }
		 		expression 
		 	)* 
		(RBRACKET!|RBRACKET_ALT!)
		)
	|   (DEREF)
	;

simpleFactor[boolean isFuncCall] returns [PositionElement posElement=null;]
	:
	(	{ specialIdentAllowed }? specialIdent
	|	normalIdent 
	|	unsignedConstant
	|	predefinedType { #simpleFactor=#( #[TYPE_NODE,"TYPE_NODE"],#simpleFactor ); }
	|	LPAREN! expression RPAREN!
	)
	;
	
signedFactor
	{ 		debugPrint(20,"[signedFactor]"); 	}

	:	(	p:PLUS^ 	{	#p.setType(UNARY_PLUS);
							debugPrint(2+5," <+> "); }
		|	m:MINUS^	{	#m.setType(UNARY_MINUS);
							debugPrint(2+5," <-> "); }
		)? 	
		factor
	;
	
	
	//term : signedFactor (IS^{ debugPrint(2+5," <is> "); 	} signedFactor) | termb;
		
term
	{ 		debugPrint(20,"[term]"); 	}

	:	{ if( LA(2) == DOT ) specialIdentAllowed = true; }
		signedFactor
 		 (
		   ((	TIMES^							{ debugPrint(2+5," < * > "); 	}
			|	DIVIDE^   						{ debugPrint(2+5," < / > "); 	}
			|	MOD^								{ debugPrint(2+5," <mod> "); 	}
			|	DIV^								{ debugPrint(2+5," <div> "); 	}
			|	AND^								{ debugPrint(2+5," <and> "); 	}
			|	SHL^								{ debugPrint(2+5," <shl> "); 	}
			|	SHR^								{ debugPrint(2+5," <shr> "); 	}
						//|	IS^								{ debugPrint(2+5," <is> "); 	}
		 	|   d:DOT^							{ specialIdentAllowed = true; 
		 											#d.setText("<EX>");
		 										}
) 
			signedFactor)
			|(
		 		AS^	 { debugPrint(2+5," <as> "); }
		 			typeId
			 )
		)*
		{ specialIdentAllowed = false; }
	;

simpleExpression
	{ 		debugPrint(20,"[simpleExpression]"); 	}
	:	term ( 
			(	PLUS^	{ 		debugPrint(2+5," < + > "); 	}
				// #( PLUS term term)
			|	MINUS^	{ 		debugPrint(2+5," < - > "); 	}
				// #( MINUS term term)
			|	OR^		{ 		debugPrint(2+5," <or>"); 	}
				// #( OR term term)
			|	XOR^ 	{ 		debugPrint(2+5," <xor> "); 	}
|	IS^								{ debugPrint(2+5," <is> "); 	}
						// #( XOR term term)
			) term )*
	; 

expression
	{ 		debugPrint(20," [l."+lexer.getCurrentLine()+":expression]"); 
		  Token tk = null;	}
	: 
	{
	 tk = LT(1);
 //System.out.println("Expression-Start: "+tk);
	}
	//	{	System.out.println("expression-BEGIN Line/Column: "+lexer.getLine()+", "+lexer.getColumn());}
	    s1:simpleExpression 
		( 
			(	EQUALS^								{ debugPrint(2+5," <equals> "); 	}
			|	NOT_EQUALS^							{ debugPrint(2+5," <not_equals> "); 	}
			|	LT^									{ debugPrint(2+5," <lesser> "); 	}
			|	LTE^								{ debugPrint(2+5," <lesser_or_eq> "); 	}
			|	GT^									{ debugPrint(2+5," <greater> "); 	}
			|	GTE^								{ debugPrint(2+5," <greater_or_eq> "); 	}
			|	IN^									{ debugPrint(2+5," <in> "); 	}
			) 
			sn:simpleExpression
		)*
	 	{ #expression=#([EXPR,"EXPR"],#expression); 
	 		 	// System.out.println("expression-END Line/Column: "+lexer.getLine()+", "+lexer.getColumn());
	 tk = LT(1);
 //System.out.println("Expression-End: "+tk);
	
	}

	;



/////////////////////////////////////////////////////////////////////////////////
// Konstanten

constValue
/* eigentlich "expression", die zur bersetzungszeit ausgewertet werden kann */
	:
	(	integerConstant
	|	unsignedReal
	|	booleanConstant
	|	charLiteral
	|	stringLiteral
	|	simpleIdent // identifier // Konstante 
    |	NIL									{ debugPrint(2+4,"<nil>"); }
   	) 
	;

unsignedConstant
{ 		debugPrint(2+4,"->[unsignedConstant: "); 	}
    :
    (	unsignedInteger
    | 	unsignedReal
	|	booleanConstant
	|	charLiteral
	|	stringLiteral
	|	setConstructor
    |	NIL									{ debugPrint(2+4,"<nil>"); }
	)
	{ 		debugPrint(2+4,"]"); 	}
    ;
  
 
//typedConstant
//	{   debugPrint(20,"[typedConstant]: ");       }	
//	: 	expression 
//	|	arrayOrRecordConstant	
//	;
 
//arrayOrRecordConstant
//	:	LPAREN
//		(	arrayConstant 
//		|	recordConstant
//		)
//		RPAREN
//	;
	
//arrayConstant 
//	:	expression ( COMMA expression )+ 
//	;
	
	
//recordConstant
//	: 	LPAREN recordFieldConstant
//		( options { greedy=true; }
//			: SEMI! recordFieldConstant )*
//		(SEMI!)?
//		RPAREN
//	;
//	
//recordFieldConstant
//	:
//		identifier COLON expression
//	;

booleanConstant
	:	( TRUE | FALSE )
	;

integerConstant
	:	(	p:PLUS^ 	{#p.setType(UNARY_PLUS); }
		|	m:MINUS^	{#m.setType(UNARY_MINUS); }
		)? 
		unsignedInteger
	;

realConstant
	:	(	p:PLUS^ 	{#p.setType(UNARY_PLUS); }
		|	m:MINUS^	{#m.setType(UNARY_MINUS); }
		)? 
		unsignedReal
	;

/////////////////////////////////////////////////////////////////////////////////
// Literale
   
unsignedInteger
    :	i:INT_LIT     							{ debugPrint(2+4,"<Integer: "+i.getText()+">"); }
    |	h:HEX_CONST								{ debugPrint(2+4,"<HexConst: "+h.getText()+">"); }
 	;

unsignedReal
    :	r:REAL_LIT    							{ debugPrint(2+4,"<Real:"+r.getText()+">");}
	;
	
stringLiteral!
{ StringBuffer s=new StringBuffer(); }
    :       									{ debugPrint(2+4,"<String: '"); }
    	(
    		t1:STRING_LIT  						{ s.append(t1.getText()); }
    	//|	t2:CHAR_LIT  						{ s.append(t2.getText()); }
    	)+										{ debugPrint(2+4,s.toString()); }
    	{ #stringLiteral = #[STRING_LIT,s.toString()]; }
												{ debugPrint(2+4,"'>"); }
    ;	

charLiteral
	:		c:CHAR_LIT							{ debugPrint(2+4,"<Char: "+c.getText()+">"); }
	;	       
	
structuredType
	:	(PACKED)? 
		(	arrayDecl
		|	setType
		|	fileType
		|	recordDecl
		)
		(PACKED)?
		{	#structuredType = #([TYPE_NODE,"TYPE_NODE"],#structuredType); }

	;

arrayType 
{ debugPrint(2+20,NEWLINE+"arrayType "); }
	:	ARRAY^ 
		( (LBRACKET|LBRACKET_ALT) 
			ordinalType (COMMA ordinalType)* 
			(RBRACKET|RBRACKET_ALT) 
		)? 
		OF typeId 
		(	pd:directive SEMI! )? // (portabilityDirective)?
		{#pd = #([PORTAB_DIRECTIVE],#pd); }
	;

recordDecl
{ debugPrint(2+20,NEWLINE+"recordDecl "); }
	:	
	{   Token tk = LT(1);
		    PositionElement posElement = createPositionElement(tk);
}
		r:RECORD^ {#r.setType(RECORD_DECL); }
	//	{ #typeDecl = #(#[RECORD_DECL],#type_id,#r) ; }
		(fieldList)? 
		END!
		(directive SEMI!)?  // (portabilityDirective)?
	{ Token endtk = LT(1);
						  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
						  #recordDecl.setPositionElement(posElement);
						  System.out.println("RECORD: "+posElement);
};


// Variant Records
variantSection
{ debugPrint(2+20,NEWLINE+"variantSection "); }
	// evtl. konflikt mit anderem CASE
	// VariantSection	->	CASE [Ident ':'] TypeId OF (RecVariant ';')...
	: c:CASE^ 	{ #c.setType(VARIANT_SECT); }
		(id:identifier! COLON!)? tId:typeId! OF! rvl:recVariantList!
		{ // Tree Construction
			#variantSection=
				#( #variantSection,
					#( #[VAR_DECL,"VAR_DECL"],
						#( #[IDLIST,"IDLIST"],
							#id
						)
						,#tId
					)
					,#rvl
				);
		}
	;

recVariantList
	:	(recVariant SEMI!)+
	;
	
recVariant
{ debugPrint(2+20,NEWLINE+"recVariant "); }
	:	constExpression ( COMMA! constExpression )* 
			COLON^
			LPAREN!
				(fieldList)?
			RPAREN!
	;

fieldList
	:	
		( varDecl (SEMI!)? )+ ( variantSection (SEMI!)? )?
	|	( variantSection (SEMI!)? )
	
		// ( ( varDecl (SEMI!)? )+ )?
		// ( variantSection (SEMI!)? )?
	; 
			
setType
	{   debugPrint(20," set-type: ");       }	
	:	SET^ OF! 
		ordinalType 
		(directive SEMI!)? // (portabilityDirective)? 
	;	

fileType
	{   debugPrint(20," file-type: ");       }	
	:
	{   Token tk = LT(1);
		    PositionElement posElement = createPositionElement(tk);
} 	f:FILE^ { #f.setType(FILE_TYPE); }
		(OF! typeId)?
		(directive SEMI!)? // (portabilityDirective)? 
	    {
  	 	  Token endtk = lexer.getTokenObject();
    	  posElement.setEndPosition((de.fzi.delphi.symbols.TokenWithStartPosition)endtk);
    	  #fileType.setPositionElement(posElement);
  };

classRefType
	:	CLASS^ OF typeId
	;
	
ordinalType
	{ debugPrint(20,NEWLINE+"ordinalType"); }
	: 	
		enumDecl
	|	expressionRange //range
	|	booleanConstant
	|	qualifiedIdentifier //identifier
	|	predefinedType // DEBUG: eigentlich OrdIdent
	|	integerConstant
	|	charLiteral
	;

unitIdent!
	:	i:IDENT
	{ #unitIdent = #([UNIT_IDENT], i); }
	;	

typeId!
{ debugPrint(20," typeId: ");       }	
	:	
		{isUnitIdent(LT(1)) }?
		ui:unitIdent DOT tn1:typeName
		{ #typeId = #([TYPE_NODE,"TYPE_NODE"],tn1,ui) ; }
	|	tn2:typeName
		{ #typeId = #([TYPE_NODE,"TYPE_NODE"],tn2 ) ; }
	|	ed:enumDecl
		{ #typeId = #([TYPE_NODE,"TYPE_NODE"],ed ) ; }
	;
//		(ui:unitIdent DOT)?
//			tn:typeName
//		{ #typeId = #([TYPE_NODE,"TYPE_NODE"],#( #([DOT]),#ui ,#tn ) ) ; }

typeName
{ debugPrint(20," typeName: ");       }	
	:  	predefinedType
	|	{   debugPrint(20,"ID:");}
		identifier
	;

predefinedType
{	CommonAST tok=null; 
	debugPrint(20," predefinedType: ");       }	    
 :
	(	// normale Typen	
			real48:REAL48 				{ tok = #real48 ;}
		|	single:SINGLE 				{ tok = #single ;}
		|	double_:DOUBLE 				{ tok = #double_ ;}
		| 	real:REAL 					{ tok = #real ;}
		|	boolean_:BOOLEAN 			{ tok = #boolean_ ;}
		|	integer1:INTEGER 			{ tok = #integer1 ;} 
		|	cardinal:CARDINAL 			{ tok = #cardinal ;}
		|	shortint:SHORTINT 			{ tok = #shortint ;}
		|	smallint:SMALLINT 			{ tok = #smallint ;}
		|	longint:LONGINT 			{ tok = #longint ;}
		|	int64:INT64 				{ tok = #int64 ;}
		|	byte_:BYTE 					{ tok = #byte_ ;}
		|	word:WORD 					{ tok = #word ;}
		|	longword:LONGWORD 			{ tok = #longword ;}
		|	ansistring:ANSISTRING 		{ tok = #ansistring ;}
		|	widestring:WIDESTRING 		{ tok = #widestring ;}
		|	variant:VARIANT 			{ tok = #variant ;}
		|	olevariant:OLEVARIANT 		{ tok = #olevariant ;}
	) 
	{	#predefinedType = #([PREDEF_TYPE,"PREDEF_TYPE"],#predefinedType); } 	
	| 	// String typen mit Lngenangabe
		(
			 	string: STRING  
			 	( 	(LBRACKET!|LBRACKET_ALT!) c1:constValue! (RBRACKET|RBRACKET_ALT) 
			 	{ #predefinedType=#([PREDEF_TYPE,"PREDEF_TYPE"],#([STRING,"STRING"],c1)); }
				|	()
				{ #predefinedType=#([PREDEF_TYPE,"PREDEF_TYPE"],#predefinedType); }
				)
		)
    ;

directive
	:
	{ debugPrint(2+10,"<Directive:>"); }
	(	directiveMessage
	| 	directiveExternal
	|	directiveDispId
	|	CDECL	
	|	ABSTRACT
	|	DYNAMIC
	|	EXPORT
	|	FAR
	|	f:FORWARD			{ isForwardDeclaration = true; }
	|	LOCAL
	|	NEAR
	|	OVERLOAD
	|	OVERRIDE
	|	PASCAL
	|	REGISTER
	|	REINTRODUCE
	|	SAFECALL
	|	STDCALL
	|	VARARGS
	|	VIRTUAL
	|	ASSEMBLER
	|	READONLY 
	|	WRITEONLY	
	)+
	{ #directive = #([DIRECTIVE,"DIRECTIVE"],#directive); }
	;

directiveDispId
	:	DISPID^ integerConstant
	;

directiveIndex
	:	INDEX^ INT_LIT
	;

directiveName
	:	NAME^
		(	(stringLiteral|IDENT)
			( options{greedy=true;}
				:	PLUS (stringLiteral|IDENT)
			)* 
		)? 
	;

directiveExternal
	:	EXTERNAL^ 
		(	(stringLiteral|IDENT)
			(options{greedy=true;}
				:	PLUS (stringLiteral|IDENT)
			)* 
		)? 
		( 	directiveName
		|	directiveIndex )*

		{ isExternalDeclaration = true ; }
	;

directiveMessage
	:	MESSAGE^ constValue
	;
		
portabilityDirective
	:	
	(	PLATFORM 
	|	DEPRECATED 
	|	LIBRARY
	)+
	;

