/*
 * Copyright (c) 2004-2005 CAS Software AG, 
 * 10 Wilhelm-Schickard Street, 76131 Karlsruhe, Germany
 * 
 * Copyright (c) 2004-2006 FZI Forschungszentrum Informatik, 
 * 10-14 Haid-und-Neu Street, 76131 Karlsruhe, Germany
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Nur Deklarationen im Interface-Teil einer Datei analysieren
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////    
header {	
	package de.fzi.delphi.parser;
	
	// Imports

	import java.util.List;
	import java.util.ListIterator;
	import java.util.Vector;
	
	import antlr.ASTPair;
	import antlr.MismatchedTokenException;
	import antlr.NoViableAltException;
	import antlr.RecognitionException;
	import antlr.Token;
	import antlr.collections.AST;
	import antlr.collections.impl.BitSet;
	import de.fzi.delphi.CommonASTWithLineNumber;
	import de.fzi.delphi.OPDebug;
	import de.fzi.delphi.OPProjectManager;
	import de.fzi.delphi.PositionElement;
	import de.fzi.delphi.output.IOPOutput;
	import de.fzi.delphi.output.SRFOutput;
	import de.fzi.delphi.symbols.*;
	import de.fzi.delphi.symbols.types.*;
	import de.fzi.delphi.types.Type;

	import de.fzi.sissy.metamod.Statement;
	import de.fzi.sissy.metamod.SimpleStatement;
	import de.fzi.sissy.metamod.BranchStatement;
	import de.fzi.sissy.metamod.BlockStatement;
	import de.fzi.sissy.metamod.JumpStatement;
	import de.fzi.sissy.metamod.LoopStatement;
	import de.fzi.sissy.metamod.ExceptionHandler;
	import de.fzi.sissy.metamod.ModelElementList;
	import de.fzi.sissy.metamod.CatchBlock;
	import de.fzi.sissy.metamod.Position;
	import de.fzi.sissy.util.Debug;
}

class OPInterface extends OPDeclarationsParser; 

options {
	buildAST=true;
	ASTLabelType = "de.fzi.delphi.CommonASTWithLineNumber";
//	classHeaderPrefix="abstract";
}

goal returns [Scope scope=null]
{ 
	String compUnitName="";
	scopingEngine = new ScopingEngine(OPProjectManager.getProjectScope());
	output = OPProjectManager.getOutput();
}
	: 
	(		program
		|	unit
//		|	package_
//		|	library_
	)
	{ 
		try {
			scopingEngine.prevScope(); // program, unit ...
		} catch (ScopingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		scope = scopingEngine.getRootScope();
	}
    ;

unit
	{ printRuleName("OPInterface."+"unit"); }
	:	#(UNIT
			id:IDENT 
			{	
				if( output != null && output instanceof SRFOutput ){
					output.printCommentLine("declarations of "+#id.getText());
					((SRFOutput)output).setRootScopeName(#id.getText());
					((SRFOutput)output).writeHeader();
					output = null;
				}


				unitName = id.getText();
				// open unit Scope
				CompilationUnit compilationUnit = new CompilationUnit(unitName);
				Scope compilationUnitScope = scopingEngine.createNewScope(unitName); 				
				compilationUnitScope.setCorrespondingSymbol(compilationUnit);

				markNewCompilationUnit(unitName);
				
				scopingEngine.getRootScope().addSymbol(compilationUnit);
			}
			( directive	)? 
			unitBody
		)
	;	

unitBody
	:	
//		{ System.err.println(" INTERFACE Section----"); }
		interfaceSection
//		{ System.err.println("---- IMPLEMENTATION Section----"); }
		implementationSection!
 		(
 //			{ System.err.println("---- INITIALIZATION Section ----"); }
 			initSection	!
 		)?
	;

usesClause
	{ printRuleName("OPInterface."+"usesClause"); 
		Vector temp;
	}
	:	#(USES 
			temp=identList
		)
		{
			OPDebug.debugPrint(1,"Uses:");

			Scope unitScope=null;
			unitScope = scopingEngine.getCurrentScope();
			CompilationUnit compilationUnit = unitScope.getCompilationUnit();

			for(int i=0;i<temp.size();i++){
				String unitName = ((CommonASTWithLineNumber)temp.elementAt(i)).getText();
		
				OPDebug.debugPrintln(5,unitName);
				OPProjectManager.readDeclarationsFromCompilationUnit(unitName);

				// Macht nur Sinn, wenn der UnitScope schon existiert ...
				// sollte er aber, wenn oben die Deklarationen eingelesen wurden
				Scope usedUnitScope = OPProjectManager.getProjectScope().getSubScope(unitName);
				
				// nur zur Liste hinzufgen, wenn gelesen wurde
				if( usedUnitScope != null ){
					if( isInterfaceSection )
						compilationUnit.addInterfaceUses(usedUnitScope);
					else
						compilationUnit.addImplementationUses(usedUnitScope);
				}
				// eingelesen wird erst im zweiten durchgang
				// OPProjectManager.markUses(unitName,temp.elementAt(i).toString());
				markUsesCompilationUnit(scopingEngine.getCurrentScope(),scopingEngine.getRootScope().getFullName()+"."+unitName);
			}
		}
	;

interfaceSection
	:	#( INTERFACE { 	isInterfaceSection = true; 
						scopingEngine.setInterface(true);
						}
			(usesClause)?
			( ifDecl:interfaceSectionDecl
			)*
		)
		{ 	isInterfaceSection = false; 
			scopingEngine.setInterface(false);
		}
	;

implementationSection
	{ printRuleName("OPInterface."+"implementationSection");  }
	:	#( IMPLEMENTATION
			(.)*
		)
	;

