header {	
	package de.fzi.delphi.parser;
	
	// Imports	
	import java.util.Vector;
	import java.util.List;
	import java.util.ListIterator;
	import java.util.Stack;
	import antlr.collections.AST;	
	import de.fzi.delphi.OPDebug;
	import de.fzi.delphi.CodeblockInfo;
	import de.fzi.delphi.CommonASTWithLineNumber;
	import de.fzi.delphi.OPProjectManager;
	import de.fzi.delphi.output.IOPOutput;
	import de.fzi.delphi.output.SRFOutput;
	import de.fzi.delphi.symbols.Attribute;
	import de.fzi.delphi.symbols.Method;
	import de.fzi.delphi.symbols.MethodComposite;
	import de.fzi.delphi.symbols.Scope;
	import de.fzi.delphi.symbols.ScopingEngine;
	import de.fzi.delphi.symbols.ScopingException;
	import de.fzi.delphi.symbols.ScopeNotFoundException;
	import de.fzi.delphi.symbols.SubScoped;
	import de.fzi.delphi.symbols.Symbol;
	import de.fzi.delphi.symbols.TypedSymbol;
	import de.fzi.delphi.symbols.types.NilType;
	import de.fzi.delphi.symbols.types.Typed;
	import de.fzi.delphi.symbols.types.UnknownClassType;
	import de.fzi.delphi.types.Type;
	
	import de.fzi.sissy.metamod.Statement;
	import de.fzi.sissy.metamod.SimpleStatement;
	import de.fzi.sissy.metamod.BranchStatement;
	import de.fzi.sissy.metamod.BlockStatement;
	import de.fzi.sissy.metamod.JumpStatement;
	import de.fzi.sissy.metamod.LoopStatement;
	import de.fzi.sissy.metamod.ExceptionHandler;
	import de.fzi.sissy.metamod.ModelElementList;
	import de.fzi.sissy.metamod.CatchBlock;
import de.fzi.sissy.util.Debug;
}
class OPReferencesParser extends TreeParser;

options {
	buildAST=true;
	ASTLabelType= "de.fzi.delphi.CommonASTWithLineNumber";
	importVocab=OPAnalyzer;
}

{
//	public
	// Some Debugging Options
	static final boolean DEBUG_ALL = false;
	static final boolean DEBUG_RULENAMES = DEBUG_ALL | false;
//	static final boolean DEBUG_SCOPE = DEBUG_ALL | true;
	static final boolean DEBUG_RESOLVE  = DEBUG_ALL | false;
	static final boolean DEBUG_EXPRESSIONS  = DEBUG_ALL | false;
	
	static final boolean USE_STACK = false;
	String s; 		// used for rule return values	

	private static Statement currentStatement = null;

	public static Statement getCurrentStatement() {
		return currentStatement;
	}

	ScopingEngine scopingEngine;
	private boolean isInterfaceSection = false;
	private Stack expressionLValue = new Stack();
	
	// for DOT in SimpleExpression (for StaticTypeAccess)
	private static boolean examiningLeftExpression = false;
	private static boolean examiningRightExpression = false;
	
	
	private Scope currentStatementScope = null;

	// output class
	IOPOutput output = null;
		
	UnknownClassType createDummyType(String name) {
		// dummy typ 
		UnknownClassType dummyType = new UnknownClassType(name);
		
		// in unresolved Scope ablegen
		Symbol tmpDummySym = OPProjectManager.getUnresolvedScope().addSymbol(dummyType);
		if (tmpDummySym == dummyType) {							
			// create a scope for the dummy 
			try {
				scopingEngine.changeScope(OPProjectManager.getUnresolvedScope());
				scopingEngine.createNewScope(dummyType.getName()).setCorrespondingSymbol(dummyType); 					
				scopingEngine.prevScope();
				scopingEngine.prevScope();
			} catch (ScopingException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}
		else
			dummyType = (UnknownClassType)tmpDummySym;
		return dummyType;
	}

	/** is called, if a reference is found
	 */
	private void markReference( TypedSymbol sym ){
	// FIXME HG: Wer hat das auskommentiert?
//		if( sym.getName().compareToIgnoreCase(scopingEngine.getCurrentScope().getName()) == 0 )
//			return; // Funktionswert-Rckgabe ber zuweisung
			
		if( (sym != null) && sym.isInstanceOf("Attribute") )
			output.markAttributeReference( scopingEngine.getCurrentScope(), (Attribute)sym );
		else
			output.printCommentLine("Reference to unresolved Symbol "+sym.getName()+" ("+sym.getClass()+")");
	}

	/** is called, if a reference is found
	 */
	private void markTypeReference( Scope source, Type type ){
		Symbol resolvedSym = null;
		if( type != null ){
			output.markTypeReference( source ,type );
		}
	}

	private void markTypeReference( Type type ){
		markTypeReference(scopingEngine.getCurrentScope(),  type );
	}
	
	/** is called, if a typecast is found
	 */
	private void markTypeCast( Type type ){
		markTypeCast( scopingEngine.getCurrentScope() ,type );
	}

	private void markTypeCast( Scope source, Type type ){
		if( type != null && source != null )
			output.markTypeCast( source ,type );
	}

	private void markMethodReference(Method method){
		markMethodReference(scopingEngine.getCurrentScope(), method);
	}
	
	private void markSelfAccess(Scope source, Symbol inheritedSymbol) {
		System.out.println("SelfAccess marked!");
			   output.markSelfAccess(source, inheritedSymbol);
	}
	
private void markStaticTypeAccess(Scope source, Symbol typeSymbol) {
				System.out.println("StaticTypeAccess marked!");
			   if (typeSymbol instanceof de.fzi.delphi.symbols.types.ClassType) {
   	System.out.println("StaticTypeAccess: LeftExpression: "+ examiningLeftExpression + " RightExpression: "+ examiningRightExpression);
      	if (examiningLeftExpression) // DOT is following class name (if false ==> no DOT is following !!!)
				      output.markStaticTypeAccess(source, typeSymbol);
	   } 
	}
	
	private void markRuntimeTypeAccess(Scope source, Symbol typeSymbol) {
			   Debug.warning("RuntimeTypeAccess marked for "+typeSymbol.toString());
			   output.markRuntimeTypeAccess(source, typeSymbol);
	}
	
	private void markCompositeAccess(Scope source, Symbol typeSymbol) {
		// TODO compositeAccess
			   //output.markSelfAccess(source, inheritedSymbol);
	}
	
	/*
	private void nextStatement() {
		statementCounter++;
  if (OPProjectManager.getStatementMapper().getInstance(statementCounter)!=null) {
	     System.out.println("SimpleStatement war noch gemappt!!");
	    		currentStatement = (Statement)OPProjectManager.getStatementMapper().getInstance(statementCounter);		
	  } else {
		    	System.out.println("SimpleStatement war NICHT MEHR gemappt!!");		
	  };
		}
	*/
	
	private void markMethodReference(Scope source, Method method){
		if( method != null ){
			String nameOfMethodScope = method.isOverloaded() ? method.getNameWithParameters() : method.getName();

			// FIXME kann NPE verursachen
			try {
				if( source == method.getScope().getParent().getSubScope(nameOfMethodScope) )
					output.printCommentLine("recursive method call");
				output.markMethodReference(source,method);
			} catch (NullPointerException npe) 
			{ System.out.println("NullPointerException in op_reference.g in markMethodReference catched!!!");}
			// increment reference counter
			// f.incrementReferenceCounter();
		}
	}
	/**
	 * Convert a Vector into a String containing a qualified identifier
	 * e.g.: ["aaa","bbb","ccc"] => "aaa.bbb.ccc" 
	 */
	private String vectorToQualifiedIdentifier(Vector qualIdent){
		if( qualIdent == null || qualIdent.size() == 0 )
			return "";
		else{
			StringBuffer sb = new StringBuffer();
			
			assert qualIdent != null;
			assert qualIdent.size() > 0;
			
			for(int i=0;i<qualIdent.size();i++){
				if( i > 0 )
					sb.append("."+qualIdent.elementAt(i));
				else
					sb.append(qualIdent.elementAt(i));
			}
			return sb.toString();
		}
	}

	private Type getSuperType(Type t1, Type t2){
		if( t1 == t2 )
			return t1;
			// wenn zuweisungskompatibel, dann kann auch fr berechnung
			// automatisch konvertiert werden.
		else if( t1.isAssignmentCompatible(t2) ){
			return t2;
		} else if( t2.isAssignmentCompatible(t1) ){
			return t1;
		}else
			return Type.NULL; // incompatible
	}
	
	// wrapper Methods for printing out expressions
	void expressionPrint( Object output ){
		if( !DEBUG_EXPRESSIONS ) 
			return;
		println();
		print("> "+output);
	}
	void expressionPrintln( Object output ){
		if( !DEBUG_EXPRESSIONS ) 
			return;
		println();
		println("> "+output);
	}

	// display a (sub)ast
	void showAst(AST t){
		if( t instanceof CommonASTWithLineNumber )
			((CommonASTWithLineNumber)t).showTreeFrame(getTokenNames(),new java.awt.Point(10,10),null);
	}
	// Output helper functions
	void print(Object output){
		System.err.print(output);
		System.err.flush();
	}

	void println(Object output){
		print(output);
		System.err.println();
		System.err.flush();
	}

	void println(){
		println( "" );
	}
	void printRuleName(String rulename){
		if( !DEBUG_RULENAMES ) 
			return;
		println(rulename);
	}

	void showSubAst(de.fzi.delphi.CommonASTWithLineNumber ast) {
		String title ="";
		if( scopingEngine != null )
			if( scopingEngine.getCurrentScope() != null )
				if( scopingEngine.getCurrentScope().getCompilationUnit() != null )
					if( scopingEngine.getCurrentScope().getCompilationUnit().getName() != null )
						title = scopingEngine.getCurrentScope().getCompilationUnit().getName();
						
		de.fzi.delphi.parser.debug.CommonASTFrame.show(
			getTokenNames(),
			ast,
			title,
			new java.awt.Point(100, 100));
	}
}
goal {
	output = OPProjectManager.getOutput();
	scopingEngine = new ScopingEngine(OPProjectManager.getProjectScope());

	// check some assertions
	assert scopingEngine.getCurrentScope() != null;
	assert scopingEngine.getCurrentScope().isRootScope();
}
:(		program
			{
				try {
					// program ...
					scopingEngine.prevScope();
				} catch (ScopingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} 
			}
		|	package_
		{
				try{
					// library ...
					scopingEngine.prevScope(); 
				} catch (ScopingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} 
			}		
		|	library_
			{
				try{
					// library ...
					scopingEngine.prevScope(); 
				} catch (ScopingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} 
			}		
		|	unit
			{
				try{
					// unit ...
					scopingEngine.prevScope(); 
				} catch (ScopingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} 
			}
	)
    ;

programHeading { if( DEBUG_RULENAMES ) println("OPReferences."+"programHeading"); 
	}
:#(PROGRAM  id:IDENT 
		{	
			try {
				scopingEngine.changeScope(
					Scope.calculateFullPath(
						scopingEngine.getCurrentScope().getFullName(),
						id.getText()
					)
				);
			} catch (ScopeNotFoundException e) {
				e.printStackTrace();
			} catch (ScopingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
	
			if( output instanceof SRFOutput )
					((SRFOutput)output).setRootScopeName(scopingEngine.getCurrentScope().getFullName());
		}
		( #(IDLIST (IDENT)*)  )?
	)
	;

library_ { printRuleName("OPReferences."+"libary_"); }
:#(LIBRARY
			id:IDENT 
			{	
				// open Scope of compilationUnit
				try{
					scopingEngine.changeScope(
						Scope.calculateFullPath(
							scopingEngine.getCurrentScope()
								.getFullName(),
							id.getText()
						)
					);
				} catch (ScopeNotFoundException e) {
					e.printStackTrace();
				} catch (ScopingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				if( output instanceof SRFOutput )
						((SRFOutput)output).setRootScopeName(scopingEngine.getCurrentScope().getFullName());
			}
			programBlock
		)
	;

package_ { printRuleName("OPReferences."+"package_"); }
:#(PACKAGE
			id:IDENT 
			{	
				// open Scope of compilationUnit
				try{
					scopingEngine.changeScope(
						Scope.calculateFullPath(
							scopingEngine.getCurrentScope()
								.getFullName(),
							id.getText()
						)
					);
				} catch (ScopeNotFoundException e) {
					e.printStackTrace();
				} catch (ScopingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				if( output instanceof SRFOutput )
						((SRFOutput)output).setRootScopeName(scopingEngine.getCurrentScope().getFullName());
			}
			(containsClause)?
		)
	;

unit { printRuleName("OPReferences."+"unit"); }
:#(UNIT
			id:IDENT 
			{	
				// open Scope of compilationUnit
				try{
					scopingEngine.changeScope(
						Scope.calculateFullPath(
							scopingEngine.getCurrentScope()
								.getFullName(),
							id.getText()
						)
					);
				} catch (ScopeNotFoundException e) {
					e.printStackTrace();
				} catch (ScopingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				if( output instanceof SRFOutput )
						((SRFOutput)output).setRootScopeName(scopingEngine.getCurrentScope().getFullName());
			}
			( directive	)? 
			unitBody
		)
	;

interfaceSection { printRuleName("OPReferences."+"interfaceSection"); }
:#( INTERFACE  { 	isInterfaceSection = true; 
							scopingEngine.setInterface(true);
						}
			(usesClause)?
			{ printRuleName( "Skipping interface declarations ..." ); }
			( #( DECL_SECT  . ) )*
			{ 	isInterfaceSection = false; 
				scopingEngine.setInterface(false);
			}
		)
	;

usesClause { if( DEBUG_RULENAMES ) println("OPReferences."+"usesClause"); 
	}
:#(USES .)
	;

containsClause { if( DEBUG_RULENAMES ) println("OPReferences."+"containsClause"); 
	}
:#(CONTAINS .)
	;

mainProgram { if( DEBUG_RULENAMES ) println("OPReferences."+"mainProgram");
		CodeblockInfo ci = null;
	}
:#(MAIN_PROGRAM 
			{ 
				try {
					scopingEngine.changeScope(
						Scope.calculateFullPath(
							scopingEngine.getCurrentScope()
								.getFullName(),
								"[main]"
						)
					);
				} catch (ScopeNotFoundException e) {
					e.printStackTrace();
				} catch (ScopingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				output.printCommentLine("Main Method");
			}
			ci=compoundStatement			
			{ 
			 // Set codeblock info
//			 if( sym != null && sym.isInstanceOf("Method") ){
//			  	 	if( ((Method)sym).getCodeblockInfo() != null )
//				  	 	((Method)sym).getCodeblockInfo().add(ci);			  	 	
//			  	 	else
//				  	 	((Method)sym).setCodeblockInfo(ci);
//			  }
//				
				try {
					scopingEngine.prevScope();
				} catch (ScopingException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}
			}
		)
	;

simpleStatement returns [CodeblockInfo ci = new CodeblockInfo();]{ if( DEBUG_RULENAMES ) println("OPReferences."+"simpleStatement");
	  currentStatementScope = scopingEngine.getCurrentScope();
		ci = new CodeblockInfo();			
		ci.setStatements(1);
		currentStatement = (Statement)OPProjectManager.getStatementMapper().getInstance(#simpleStatement_in);
	}
://		#( FUNC_CALL expression )
//	|	
		{
		  expressionPrint("%% Func: "); 
		}
		expression		
		{ currentStatementScope = null; }
	|	#( ASSIGN 		{
						  expressionPrint("%% LHS: "); 
						  expressionLValue.push(new Boolean(true));
						}
						expression  
						{ 
							expressionLValue.pop();
							expressionPrintln(""); 
							expressionPrint("%% RHS: "); 
						}
						expression	
						{ expressionPrintln(""); }
							
		{ currentStatementScope = null; }
		)
	;

declSection[boolean isInnerDecl] { if( DEBUG_RULENAMES ) println("OPReferences."+"declSection"); }
:#( DECL_SECT 
			(	
				procedureDecl[isInnerDecl]
			| 	functionDecl[isInnerDecl]
	    	|	constructorDecl
			|	destructorDecl
			|	#( VAR_DECL (.) ) //basicDecl 
			|	#( CONST (.) ) 	//basicDecl 
			|	#( TYPE_DECL (.) ) //basicDecl 
			|	#( LABEL_DECL (.)? ) //basicDecl 
			)?
	   	)
	;

functionHeading returns [TypedSymbol function=null;]{ 	if( DEBUG_RULENAMES ) println("OPReferences."+"functionHeading"); 
		String t=null;
		TypedSymbol sym=null;
		List paramList = null;		
	}
:(CLASS)?
		sym=qualifiedIdentifier 
		( paramList=parameterList ) ?	
		( t=typeId! )?
		( directive! )*
		{ 
			if( !sym.isResolved() ){
				// jetzt sind auch die Parameter zugreifbar -> richtig auflsen
				Scope currentScope = scopingEngine.getCurrentScope();
				String name = sym.getName().substring(sym.getName().lastIndexOf(".")+1);
				
				String path = Scope.calculateFullPath(currentScope.getFullName(),sym.getFullName());
				
				// zuerst ohne Parameter probieren (nicht berladen)
				function = scopingEngine.getMethodDeclaration(path);
				
				// nicht geklappt? dann nochmal mit ...
				if( function == null ){
					String params = "";
					if( paramList != null ){
						ListIterator li = paramList.listIterator();
						while( li.hasNext() ){
							params += "/"+((Typed)li.next()).getType().getName();
						}
					}
					function = scopingEngine.getMethodDeclaration(path + params);
				}

				if( function == null ){
					// FIXME: versuchen, aufzulsen
					function = new Method(sym.getName());
					function.setType(sym.getType());
					function.setScope(scopingEngine.getCurrentScope());
				}
			}
			else			
				function=sym; 

			assert function!= null;
		}
  	;

functionDecl[boolean isInnerDecl] { if( DEBUG_RULENAMES ) println("OPReferences."+"functionDecl"+(isInnerDecl?" INNER FUNCTION":"")); 
		TypedSymbol sym = null;
		Method func=null;
		Scope newScope=null;
		CodeblockInfo ci=null;
		Scope entryScope = scopingEngine.getCurrentScope();
	}
:#(FUNC_DECL
	  		sym=functionHeading 
			{ 	
				assert (sym != null) : ("functionHeading returned TypedSymbol sym == null");
				Scope tempScope =sym.getScope();

				assert (tempScope != null) : ("Scope tempScope == null");
				String scopeName = tempScope.getFullName();

				if( scopeName.length() > 0 )
					scopeName += "."+sym.getName();
				else
					scopeName = sym.getName();

				if( scopingEngine.getRootScope().getScope(scopeName) == null )
					scopeName=Scope.calculateFullPath(scopingEngine.getCurrentScope().getFullName(),sym.getFullName());

				// Falls berladen, Parameter anhngen
				if( sym != null && sym.isInstanceOf("Method") 
					&& ((Method)sym).getParameters() != null  
					&& ((Method)sym).getParameters().size() > 0 )
					scopeName += "/"+((Method)sym).parameterListToString();

				
				newScope = scopingEngine.getRootScope().getScope(scopeName); 
				
				if( newScope == null ) { // bis zum letzten Punkt vergleichen
					newScope = scopingEngine.getCurrentScope().findSubScope(scopeName.substring(scopeName.lastIndexOf(".")+1)); 
					if( newScope != null ) 
						scopeName = newScope.getFullName();
				}
					
				// FIXME: Wird Scope fr inner-Function richtig berechnet?
				try {
					if( newScope == null )
						newScope = scopingEngine.changeScope(scopeName); 
					else
						newScope = scopingEngine.changeScope(newScope); 
				} catch (ScopeNotFoundException e) {
					newScope=scopingEngine.createNewScope(scopeName);
					newScope.setCorrespondingSymbol(sym);
//					e.printStackTrace();
				} catch (ScopingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			// scope-wechsel muss hier erledigt sein
  			( declSection[true] )*
			( ci=compoundStatement
			  { // Set codeblock info
			  	if( sym != null && sym.isInstanceOf("Method") ){
			  	 	if( ((Method)sym).getCodeblockInfo() != null )
				  	 	((Method)sym).getCodeblockInfo().add(ci);			  	 	
			  	 	else
				  	 	((Method)sym).setCodeblockInfo(ci);
			    }
			  }
			)?
			{ if( newScope != null )
				try {
					scopingEngine.prevScope();
				} catch (ScopingException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				} 
			}
		)
		{
			if( scopingEngine.getCurrentScope() != entryScope ){
				System.err.println("Scoping Error:");
				System.err.println(" - expected: "+entryScope);
				System.err.println(" - current: "+scopingEngine.getCurrentScope());
			}
		}
	;

procedureHeading returns [TypedSymbol procedure=null;]{	if( DEBUG_RULENAMES ) println("OPReferences."+"procedureHeading");	
		TypedSymbol sym=null;
		List paramList = null;
	}
:(CLASS)?
		sym=qualifiedIdentifier  
		( paramList=parameterList ) ?	
		( directive )*
		{   
			if( !sym.isResolved() ){
				// jetzt sind auch die Parameter zugreifbar -> richtig auflsen
				Scope currentScope = scopingEngine.getCurrentScope();
				String name = sym.getName().substring(sym.getName().lastIndexOf(".")+1);
				
				String path = Scope.calculateFullPath(currentScope.getFullName(),sym.getFullName());
				
				// zuerst ohne Parameter probieren (nicht berladen)
				procedure = scopingEngine.getMethodDeclaration(path);
				
				// nicht geklappt? dann nochmal mit ...
				if( procedure == null ){
					String params = "";
					if( paramList != null ){
						ListIterator li = paramList.listIterator();
						while( li.hasNext() ){
							params += "/"+((Typed)li.next()).getType().getName();
						}
					}
					procedure = scopingEngine.getMethodDeclaration(path + params);
				}
	
				if( procedure == null ){
					procedure = new Method(sym.getName());
					procedure.setType(sym.getType());
					procedure.setScope(scopingEngine.getCurrentScope());
				}				
			}
			else			
				procedure=sym; 

			assert procedure!=null;
		}
	// returns procedure
  	;

procedureDecl[boolean isInnerDecl] { if( DEBUG_RULENAMES ) println("OPReferences."+"procedureDecl"+(isInnerDecl?" INNER PROCEDURE":"")); 
		Method func=null;
		TypedSymbol sym=null;
		CodeblockInfo ci = null;
		Scope newScope=null; // used to avoid unneccessary scope changes
		Scope entryScope = scopingEngine.getCurrentScope();
	}
:#(PROC_DECL
	  		sym=procedureHeading 
			{ 	// func = (Method)sym; 	
				assert sym != null;
				assert sym.getScope() != null;
				
				String scopeName = sym.getScope().getFullName();

				if( scopeName.length() > 0 )
					scopeName += "."+sym.getName();
				else
					scopeName = sym.getName();

				if( scopingEngine.getRootScope().getScope(scopeName) == null )
					scopeName=Scope.calculateFullPath(scopingEngine.getCurrentScope().getFullName(),sym.getFullName());

				// Falls berladen, Parameter anhngen
				// if( sym instanceof Method && ((Method)sym).isOverloaded() )
				// Falls Parameter da -> anhngen
				if( sym != null && sym.isInstanceOf("Method") 
					&& ((Method)sym).getParameters() != null  
					&& ((Method)sym).getParameters().size() > 0 )
					scopeName += "/"+((Method)sym).parameterListToString();


				newScope = scopingEngine.getRootScope().getScope(scopeName); 
				
				if( newScope == null ) { // bis zum letzten Punkt vergleichen
					newScope = scopingEngine.getCurrentScope().findSubScope(scopeName.substring(scopeName.lastIndexOf(".")+1)); 
					if( newScope != null ) 
						scopeName = newScope.getFullName();
				}
								
				// FIXME: Wird Scope fr inner-Function richtig berechnet?
				try {
					if( newScope == null )
						newScope = scopingEngine.changeScope(scopeName); 
					else
						newScope = scopingEngine.changeScope(newScope); 
				} catch (ScopeNotFoundException e) {
					newScope=scopingEngine.createNewScope(scopeName);
					newScope.setCorrespondingSymbol(sym);
//					e.printStackTrace();
				} catch (ScopingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				
			}
  			( declSection[true] )*
			(	ci=compoundStatement
				{
					 // Set codeblock info
					 if( sym != null && sym.isInstanceOf("Method") ){
					  	 	if( ((Method)sym).getCodeblockInfo() != null )
						  	 	((Method)sym).getCodeblockInfo().add(ci);			  	 	
					  	 	else
						  	 	((Method)sym).setCodeblockInfo(ci);
					  }
				}
			)?
			{ if( newScope != null )
				try {
					scopingEngine.prevScope();
				} catch (ScopingException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				} 
			}
		)
		{
			if( scopingEngine.getCurrentScope() != entryScope ){
				System.err.println("Scoping Error:");
				System.err.println(" - expected: "+entryScope);
				System.err.println(" - current: "+scopingEngine.getCurrentScope());
			}
		// ((de.fzi.delphi.CommonASTWithLineNumber)currentAST.root).showTreeFrame(this.getTokenNames(),new java.awt.Point(100,100),"");
		}
	;

constructorHeading returns [TypedSymbol constructor=null;]{	if( DEBUG_RULENAMES ) println("OPReferences."+"constructorHeading");	
		TypedSymbol sym=null;
		List paramList = null;
	}
:sym=qualifiedIdentifier 
		( paramList=parameterList ) ?	
		( directive )*
		{   
			if( !sym.isResolved() ){
				// jetzt sind auch die Parameter zugreifbar -> richtig auflsen
				Scope currentScope = scopingEngine.getCurrentScope();
				String name = sym.getName().substring(sym.getName().lastIndexOf(".")+1);
				
				String path = Scope.calculateFullPath(currentScope.getFullName(),sym.getFullName());
				
				// zuerst ohne Parameter probieren (nicht berladen)
				constructor = scopingEngine.getMethodDeclaration(path);
				
				// nicht geklappt? dann nochmal mit ...
				if( constructor == null ){
					String params = "";
					if( paramList != null ){
						ListIterator li = paramList.listIterator();
						while( li.hasNext() ){
							params += "/"+((Typed)li.next()).getType().getName();
						}
					}
					constructor = scopingEngine.getMethodDeclaration(path + params);
				}
	
				if( constructor == null ){
					// FIXME: versuchen, aufzulsen
					constructor = new Method(sym.getName());
					constructor.setType(sym.getType());
					constructor.setScope(scopingEngine.getCurrentScope());
				}				
			}
			else			
				constructor=sym; 

			assert constructor!=null;
		}
	// returns constructor
  	;

constructorDecl { if( DEBUG_RULENAMES ) println("OPReferences."+"constructorDecl"); 
		Method func=null;
		TypedSymbol sym=null;
		CodeblockInfo ci = null;
		Scope newScope=null; // used to avoid unneccessary scope changes
		Scope entryScope = scopingEngine.getCurrentScope();
	}
:#(CONSTR_DECL
	  		sym=constructorHeading 
			{ 	// func = (Method)sym; 	
				assert sym != null;
				assert sym.getScope() != null;
				
				String scopeName = sym.getScope().getFullName();

				if( scopeName.length() > 0 )
					scopeName += "."+sym.getName();
				else
					scopeName = sym.getName();

				if( scopingEngine.getRootScope().getScope(scopeName) == null )
					scopeName=Scope.calculateFullPath(scopingEngine.getCurrentScope().getFullName(),sym.getFullName());

				// Falls berladen, Parameter anhngen
				// if( sym instanceof Method && ((Method)sym).isOverloaded() )
				// Falls Parameter da -> anhngen
				if( sym != null && sym.isInstanceOf("Method") 
					&& ((Method)sym).getParameters() != null  
					&& ((Method)sym).getParameters().size() > 0 )
					scopeName += "/"+((Method)sym).parameterListToString();

				newScope = scopingEngine.getRootScope().getScope(scopeName); 
				
				if( newScope == null ) { // bis zum letzten Punkt vergleichen
					newScope = scopingEngine.getCurrentScope().findSubScope(scopeName.substring(scopeName.lastIndexOf(".")+1)); 
					if( newScope != null ) 
						scopeName = newScope.getFullName();
				}
								
				// FIXME: Wird Scope fr inner-Function richtig berechnet?
				try {
					if( newScope == null )
						newScope = scopingEngine.changeScope(scopeName); 
					else
						newScope = scopingEngine.changeScope(newScope); 
				} catch (ScopeNotFoundException e) {
					newScope=scopingEngine.createNewScope(scopeName);
					newScope.setCorrespondingSymbol(sym);
//					e.printStackTrace();
				} catch (ScopingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				
			}
  			( declSection[true] )*
			(	ci=compoundStatement
				{
					 // Set codeblock info
					 if( sym != null && sym.isInstanceOf("Method") ){
					  	 	if( ((Method)sym).getCodeblockInfo() != null )
						  	 	((Method)sym).getCodeblockInfo().add(ci);			  	 	
					  	 	else
						  	 	((Method)sym).setCodeblockInfo(ci);
					  }
				}
			)?
			{ if( newScope != null )
				try {
					scopingEngine.prevScope();
				} catch (ScopingException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				} 
			}
		)
		{
			if( scopingEngine.getCurrentScope() != entryScope ){
				System.err.println("Scoping Error:");
				System.err.println(" - expected: "+entryScope);
				System.err.println(" - current: "+scopingEngine.getCurrentScope());
			}
		// ((de.fzi.delphi.CommonASTWithLineNumber)currentAST.root).showTreeFrame(this.getTokenNames(),new java.awt.Point(100,100),"");
		}
	;

destructorHeading returns [TypedSymbol destructor=null;]{	if( DEBUG_RULENAMES ) println("OPReferences."+"destructorHeading");	
		TypedSymbol sym=null;
		List paramList = null;
	}
:sym=qualifiedIdentifier 
		( paramList=parameterList ) ?	
		( directive )*
		{   
			if( !sym.isResolved() ){
				// jetzt sind auch die Parameter zugreifbar -> richtig auflsen
				Scope currentScope = scopingEngine.getCurrentScope();
				String name = sym.getName().substring(sym.getName().lastIndexOf(".")+1);
				
				String path = Scope.calculateFullPath(currentScope.getFullName(),sym.getFullName());
				
				// zuerst ohne Parameter probieren (nicht berladen)
				destructor = scopingEngine.getMethodDeclaration(path);
				
				// nicht geklappt? dann nochmal mit ...
				if( destructor == null ){
					String params = "";
					if( paramList != null ){
						ListIterator li = paramList.listIterator();
						while( li.hasNext() ){
							params += "/"+((Typed)li.next()).getType().getName();
						}
					}
					destructor = scopingEngine.getMethodDeclaration(path + params);
				}
	
				if( destructor == null ){
					// FIXME: versuchen, aufzulsen
					destructor = new Method(sym.getName());
					destructor.setType(sym.getType());
					destructor.setScope(scopingEngine.getCurrentScope());
				}				
			}
			else			
				destructor=sym; 

			assert destructor!=null;
		}
	// returns destructor
  	;

destructorDecl { if( DEBUG_RULENAMES ) println("OPReferences."+"destructorDecl"); 
		Method func=null;
		TypedSymbol sym=null;
		CodeblockInfo ci = null;
		Scope newScope=null; // used to avoid unneccessary scope changes
		Scope entryScope = scopingEngine.getCurrentScope();
	}
:#(DESTR_DECL
	  		sym=destructorHeading 
			{ 	// func = (Method)sym; 	
				assert sym != null;
				assert sym.getScope() != null;
				
				String scopeName = sym.getScope().getFullName();

				if( scopeName.length() > 0 )
					scopeName += "."+sym.getName();
				else
					scopeName = sym.getName();

				if( scopingEngine.getRootScope().getScope(scopeName) == null )
					scopeName=Scope.calculateFullPath(scopingEngine.getCurrentScope().getFullName(),sym.getFullName());

				// Falls berladen, Parameter anhngen
				// if( sym instanceof Method && ((Method)sym).isOverloaded() )
				// Falls Parameter da -> anhngen
				if( sym != null && sym.isInstanceOf("Method") 
					&& ((Method)sym).getParameters() != null  
					&& ((Method)sym).getParameters().size() > 0 )
					scopeName += "/"+((Method)sym).parameterListToString();

				newScope = scopingEngine.getRootScope().getScope(scopeName); 
				
				if( newScope == null ) { // bis zum letzten Punkt vergleichen
					newScope = scopingEngine.getCurrentScope().findSubScope(scopeName.substring(scopeName.lastIndexOf(".")+1)); 
					if( newScope != null ) 
						scopeName = newScope.getFullName();
				}
								
				// FIXME: Wird Scope fr inner-Function richtig berechnet?
				try {
					if( newScope == null )
						newScope = scopingEngine.changeScope(scopeName); 
					else
						newScope = scopingEngine.changeScope(newScope); 
				} catch (ScopeNotFoundException e) {
					newScope=scopingEngine.createNewScope(scopeName);
					newScope.setCorrespondingSymbol(sym);
//					e.printStackTrace();
				} catch (ScopingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				
			}
  			( declSection[true] )*
			(	ci=compoundStatement
				{
					 // Set codeblock info
					 if( sym != null && sym instanceof Method ){
					  	 	if( ((Method)sym).getCodeblockInfo() != null )
						  	 	((Method)sym).getCodeblockInfo().add(ci);			  	 	
					  	 	else
						  	 	((Method)sym).setCodeblockInfo(ci);
					  }
				}
			)?
			{ if( newScope != null )
				try {
					scopingEngine.prevScope();
				} catch (ScopingException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				} 
			}
		)
		{
			if( scopingEngine.getCurrentScope() != entryScope ){
				System.err.println("Scoping Error:");
				System.err.println(" - expected: "+entryScope);
				System.err.println(" - current: "+scopingEngine.getCurrentScope());
			}
		// ((de.fzi.delphi.CommonASTWithLineNumber)currentAST.root).showTreeFrame(this.getTokenNames(),new java.awt.Point(100,100),"");
		}
	;

simpleExpression returns [TypedSymbol finalRetSym=NilType.get(); ]{ if( DEBUG_RULENAMES ) println("OPReferences."+"expression");	
	TypedSymbol ret1=null,ret2=null;
	TypedSymbol retSym1=null;
	TypedSymbol retSym2=null;
	}
:(	 	#(EQUALS		ret1=simpleExpression ret2=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						&& ret2 != null
						&& ret2.getType() != null )
							finalRetSym = DelphiOperators.equality(((TypedSymbol)ret1).getType(),((TypedSymbol)ret2).getType() );
				}
			)
		|	#(NOT_EQUALS	ret1=simpleExpression ret2=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						&& ret2 != null
						&& ret2.getType() != null )
							finalRetSym = DelphiOperators.inEquality(((TypedSymbol)ret1).getType(),((TypedSymbol)ret2).getType() );
				}
			)
		|	#(LT			ret1=simpleExpression ret2=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						&& ret2 != null
						&& ret2.getType() != null )
							finalRetSym = DelphiOperators.lesser(((TypedSymbol)ret1).getType(),((TypedSymbol)ret2).getType() );
				}
			)
		|	#(LTE			ret1=simpleExpression ret2=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						&& ret2 != null
						&& ret2.getType() != null )
							finalRetSym = DelphiOperators.lesserOrEqual(((TypedSymbol)ret1).getType(),((TypedSymbol)ret2).getType() );
				}
			)
		|	#(GT 			ret1=simpleExpression ret2=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						&& ret2 != null
						&& ret2.getType() != null )
					finalRetSym = DelphiOperators.greater(((TypedSymbol)ret1).getType(),((TypedSymbol)ret2).getType() );
				}
			)
		|	#(GTE 			ret1=simpleExpression ret2=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						&& ret2 != null
						&& ret2.getType() != null )
							finalRetSym = DelphiOperators.greaterOrEqual(((TypedSymbol)ret1).getType(),((TypedSymbol)ret2).getType() );
				}
			)
		|	#(IN 			ret1=simpleExpression ret2=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						&& ret2 != null
						&& ret2.getType() != null )
							finalRetSym = DelphiOperators.inSet(((TypedSymbol)ret1).getType(),((TypedSymbol)ret2).getType() );
				}
			)
		|	#(PLUS			ret1=simpleExpression ret2=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						&& ret2 != null
						&& ret2.getType() != null )
							finalRetSym = DelphiOperators.plus(((TypedSymbol)ret1).getType(),((TypedSymbol)ret2).getType() );
				}
			)
		|	#(MINUS 		ret1=simpleExpression ret2=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						&& ret2 != null
						&& ret2.getType() != null )
							finalRetSym = DelphiOperators.minus(((TypedSymbol)ret1).getType(),((TypedSymbol)ret2).getType() );
				}
			)
	    |	#(TIMES 		ret1=simpleExpression ret2=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						&& ret2 != null
						&& ret2.getType() != null )
							finalRetSym = DelphiOperators.multiply(((TypedSymbol)ret1).getType(),((TypedSymbol)ret2).getType() );
				}
	    	)
		|	#(DIVIDE 		ret1=simpleExpression ret2=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						&& ret2 != null
						&& ret2.getType() != null )
							finalRetSym = DelphiOperators.divide(((TypedSymbol)ret1).getType(),((TypedSymbol)ret2).getType() );
				}
			)
		|	#(MOD 			ret1=simpleExpression ret2=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						&& ret2 != null
						&& ret2.getType() != null )
							finalRetSym = DelphiOperators.integer(((TypedSymbol)ret1).getType(),((TypedSymbol)ret2).getType() );
				}
			)
		|	#(DIV 			ret1=simpleExpression ret2=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						&& ret2 != null
						&& ret2.getType() != null )
							finalRetSym = DelphiOperators.integer(((TypedSymbol)ret1).getType(),((TypedSymbol)ret2).getType() );
				}
			)
		|	#(AND 			ret1=simpleExpression ret2=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						&& ret2 != null
						&& ret2.getType() != null )
							finalRetSym = DelphiOperators.and(((TypedSymbol)ret1).getType(),((TypedSymbol)ret2).getType() );
				}
			)
		|	#(OR 			ret1=simpleExpression ret2=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						&& ret2 != null
						&& ret2.getType() != null )
							finalRetSym = DelphiOperators.or(((TypedSymbol)ret1).getType(),((TypedSymbol)ret2).getType() );
				}
			)
		|	#(XOR 			ret1=simpleExpression ret2=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						&& ret2 != null
						&& ret2.getType() != null )
							finalRetSym = DelphiOperators.xor(((TypedSymbol)ret1).getType(),((TypedSymbol)ret2).getType() );
				}
			)
		|	#(SHL 			ret1=simpleExpression ret2=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						&& ret2 != null
						&& ret2.getType() != null )
							finalRetSym = DelphiOperators.shift(((TypedSymbol)ret1).getType(),((TypedSymbol)ret2).getType() );
				}
			)
		|	#(SHR 			ret1=simpleExpression ret2=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						&& ret2 != null
						&& ret2.getType() != null )
							finalRetSym = DelphiOperators.shift(((TypedSymbol)ret1).getType(),((TypedSymbol)ret2).getType() );
				}
			)
		|	#(IS 			ret1=simpleExpression ret2=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						&& ret2 != null
						&& ret2.getType() != null ) {
							finalRetSym = DelphiOperators.isA(((TypedSymbol)ret1).getType(),((TypedSymbol)ret2).getType() );
								markRuntimeTypeAccess(scopingEngine.getCurrentScope(), ret2);
						}
				}
			)
	 	|	#(AS 			ret1=simpleExpression ret2=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						&& ret2 != null
						&& ret2.getType() != null ) {
							finalRetSym = DelphiOperators.as(((TypedSymbol)ret1).getType(),((TypedSymbol)ret2).getType() );
							Scope scope = scopingEngine.getCurrentScope();
							if (scope != null) { 
								markTypeCast(scope, (Type)finalRetSym);
								markTypeReference(scope, (Type)finalRetSym);
							}
						}
				}
			)
	 	|	#(NOT			ret1=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						)
							finalRetSym = DelphiOperators.not(((TypedSymbol)ret1).getType() );
				}
			)
		|	#(UNARY_PLUS	ret1=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						)
							finalRetSym = DelphiOperators.unaryPlus(((TypedSymbol)ret1).getType() );
				}
			)
		|	#(UNARY_MINUS	ret1=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						)
							finalRetSym = DelphiOperators.unaryMinus(((TypedSymbol)ret1).getType() );
				}
			)
	 	|	#(ADDR_OP		ret1=simpleExpression
				{ 	
					if( ret1 != null
						&& ret1.getType() != null
						)
							finalRetSym = DelphiOperators.addressOp(((TypedSymbol)ret1).getType() );
				}
			)
		|	#(INHERITED  {	output.printCommentLine("inherited call"); }
				(  // spezialfall: wir wollen evtl. selber auflsen	// (ret1=simpleExpression)? 
					id:IDENT
					{ 	
						// identifier given 
						if( id != null ){
							Symbol inheritedSymbol = scopingEngine.resolveInheritedSymbol(
									#id.getText()
								);
	
							if( inheritedSymbol != null && inheritedSymbol.isInstanceOf("Method") )
								markMethodReference(scopingEngine.getCurrentScope() , (Method)inheritedSymbol);
	
							if( inheritedSymbol != null && inheritedSymbol.isInstanceOf("Attribute") )
								markReference((Attribute)inheritedSymbol);

							if( inheritedSymbol != null && inheritedSymbol.isInstanceOf("TypedSymbol") )
								ret1 = (TypedSymbol)inheritedSymbol;
						
						// TODO SelfAccess with target: Superclass 
						if(inheritedSymbol != null)
									markSelfAccess(scopingEngine.getCurrentScope(), inheritedSymbol);
						
						}
					}
				|	functionCallOrTypecast[true]
				| 	()
					{ // no identifier given 
						// get the name of the current Method
						Symbol inheritedSymbol = scopingEngine.resolveInheritedSymbol(scopingEngine.getCurrentScope().getName());
						
						if( inheritedSymbol != null && inheritedSymbol instanceof Method )
							markMethodReference(scopingEngine.getCurrentScope() , (Method)inheritedSymbol);
						
						if( inheritedSymbol instanceof TypedSymbol )
							ret1 = (TypedSymbol)inheritedSymbol;
							
													// SelfAccess with target: Superclass 
						if(inheritedSymbol != null)
									markSelfAccess(scopingEngine.getCurrentScope(), inheritedSymbol);
						
					}
				)
			)
	 	|   // evaluated from left to right
	 		#(DOT
	 			{
	 				expressionLValue.push(new Boolean(false));
	 			examiningLeftExpression = true;
	 			}
	 			ret1=simpleExpression 
	 			{
		 			examiningLeftExpression = false;
	 				expressionLValue.pop();
	 				Scope newScope=null;
	 				Scope ret1Scope = null;
	 				if( ret1 != null && ret1.isInstanceOf("TypedSymbol") ){
	 					Type ret1Type = ((TypedSymbol)ret1).getType();
						if( (ret1Type != null) && ret1Type.isInstanceOf("SubScoped") )
		 					ret1Scope = ((SubScoped)ret1Type).getSubScope();

	 					if( ret1Scope != null ){
	 						try {
								newScope = scopingEngine.changeScope(ret1Scope);
							} catch (ScopeNotFoundException e) {
								// FIXME: why did you comment me? Why??
//								newScope=scopingEngine.createNewScope(ret1Scope.getFullName());
								e.printStackTrace();
							} catch (ScopingException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
	 					}
	 					else
	 					{
	 						// Create dummy scope
	 						// the Scope-Path is incomplete, so we try to calculate one
	 						
	 						// get a subscope, specified by a relative path, starting from current-scope
	 						Scope temp = scopingEngine.getCurrentScope().getPartialSubScope(ret1.getFullName());
	 						
	 						if( temp == null ){
		 						// get a subscope, specified by a relative path, starting from scope of the compilation unit
		 						if( scopingEngine
										.getCurrentScope()
										.getCompilationUnitScope() == null ) // == root-scope
									temp = scopingEngine.getRootScope()
											.getPartialSubScope(
												ret1.getFullName()
											);
								else
									temp = scopingEngine
											.getCurrentScope()
											.getCompilationUnitScope()
											.getPartialSubScope(
												ret1.getFullName()
											);
	 						}
	 						
							if( temp != null )
								try {
									newScope = scopingEngine.changeScope(temp);
								} catch (ScopeNotFoundException e) {
								// FIXME: why did you comment me? Why??
								// Because we don't want to create artificial scopes
//									newScope=scopingEngine.createNewScope(temp.getFullName());
									e.printStackTrace();
								} catch (ScopingException e) {
									// TODO Auto-generated catch block
									e.printStackTrace();
								}
						}

	 				}
			 			examiningRightExpression = true;
	 			}
	 			ret2=simpleExpression	
	 			{
				 			examiningRightExpression = false;
	 				// FIXME Reicht Bedingung?
	 				if( ret1Scope != null 
	 					&& newScope != null
	 				){
	 					try {
							scopingEngine.prevScope();
						} catch (ScopingException e1) {
							// TODO Auto-generated catch block
							e1.printStackTrace();
						}
	 				}
	 			}
	 		)


			{ 	// Linker Teil
				if( ret1 != null ){
					if( ret1.isInstanceOf("Type") ){ // war sowieso schon Typ
						markTypeReference((Type)ret1);
// erste Zuweisung an retSym - wird spter evtl. berschrieben
						
						retSym1 = ret1;
					}
					else if ( ret1.isInstanceOf("Attribute")){
						
						// Ist Attribute
						// Referenzierung merken/ausgeben
						markReference( ret1 );
						// typ zurckgeben
						Attribute temp = (Attribute)ret1;
						
						print(", ");
						markTypeReference(temp.getType());
					}
					else {
						print(ret1.getClass());
					}
						
				}
				expressionPrint("<DOT>");
				// rechter Teil
				if( ret2 != null ){
					if( ret2.isInstanceOf("Type") ){ // war sowieso schon Typ
						markTypeReference((Type)ret2);
						retSym2 = ret2;
// wrde eine schon gettigte Zuweisung an retSym berschreiben
// (siehe oben ...)
					}
					else if( ret2.isInstanceOf("Attribute") ){ // Ist Attribute
						// Referenzierung merken/ausgeben
						markReference( ret2 );
						// typ zurckgeben
						Attribute temp = (Attribute)ret2;

						expressionPrint(", ");
						
						markTypeReference(temp.getType());
					}
				}
				
				// so, calculate the final return symbol
				finalRetSym = retSym1;
				finalRetSym = retSym2;				
			}
		|	ret1=primaryExpression
			{ 	
				if( ret1 != null ){
// 					FIXME ret1 ist doch immer Type, ist hier ein BUG???
					if( ret1.isInstanceOf("Type") ) // war sowieso schon Typ
						finalRetSym = ret1;
					else if( ret1.isInstanceOf("Attribute")) {
						// Ist Attribute
						// Referenzierung merken/ausgeben
						markReference( ret1 );
						// typ zurckgeben
						if( ret1.isInstanceOf("Attribute")) {
							Attribute temp = (Attribute)ret1;
							print(", ");
							markTypeReference(temp.getType());
							// TODO JS: changed (why did they return the type, not the attribute?)
//							finalRetSym = temp.getType();
													finalRetSym = temp;
						}
					}
				}else
					finalRetSym = Type.getNilType();
	
		}
	)
	{
		// FIXME warum wird finalRetSym == null?
		// fr alle Flle
		if( finalRetSym == null )
			finalRetSym = Type.getNilType();

		if( DEBUG_EXPRESSIONS && finalRetSym == null){
			 showSubAst(simpleExpression_AST_in);
			 // System.out.println( simpleExpression_AST_in.toStringTree() );
		}
			
		assert finalRetSym != null;
	}
	( 
		( DEREF 
			{ 
				if( (finalRetSym != null) && finalRetSym.isInstanceOf("Type") )
					finalRetSym = DelphiOperators.dereference((Type)finalRetSym);
				else if( finalRetSym != null )
					finalRetSym = DelphiOperators.dereference(finalRetSym.getType());
			}
		)+
	|	arrayDim 
	)*

	/* *********************** */
	/* "Default"-Typberechnung */
	/* *********************** */
	{
//		assert( ret1 != null ) : "ret1 == null";
		// zuerst prfen, ob Rckgabewert nicht schon berechnet wurde
		// fr schon berechnete Sonderflle
		if( false && finalRetSym == null ){
			if( ret1 != null && ret2 != null ){
				if( ret1.equals(ret2) )
					finalRetSym = ret1;
			}
			else if( ret1 != null && ret2 == null ){
					finalRetSym = ret1;
			}
			else if( ret1 == null && ret2 != null ){
				finalRetSym = Type.getNilType();
			}
			else if( ret1 == null && ret2 == null ){
				finalRetSym = Type.getNilType();
			}
		}
		if( finalRetSym == null )
			finalRetSym=Type.getNilType();		
		assert finalRetSym != null;
	}
 	;

expression returns [Type retType=null; ]{ if( DEBUG_RULENAMES ) println("OPReferences."+"expression");
		TypedSymbol sym = null;
	}
:#( EXPR sym=simpleExpression )
			{ 	
				if( sym != null )
				{
					Type tempType = null;

					if( !(sym.isInstanceOf("Type")) ) {
						Typed temp = (Typed)sym;
						tempType = temp.getType();				
//						println(temp.getType().getName()+"["+temp.getType()+"]");
					}
					else{
						tempType = (Type)sym;				
//						println(tempType.getName()+"["+tempType+"]");
					}	
					if( tempType != null ){
						expressionPrint("{EXPR-type: "+tempType.getName()+"}");
					}
					else
						expressionPrint("{EXPR-type: <null> }");
					
					retType = tempType;
				}
				else
					expressionPrint("{EXPR-type: <null> }");
			}	
	;

expressionList returns [Vector v]{ 	v = new Vector(); 
	Type retType = null;
}
:#(EXPR_LIST 
    		(
    			retType=expr:expression 
    			{ 
    				v.addElement(retType);
    			}
    		)+ 
    	) 
    ;

primaryExpression returns [Type retType=Type.NULL; ]{ 
		String str=null;
		if( DEBUG_RULENAMES ) println("OPReferences."+"primaryExpression");
	}
:(	retType=expression 			// geklammerte Expression
		|  	retType=unsignedConstant
		|	retType=functionCallOrTypecast[false] // ( DEREF )*
		|	{ 	TypedSymbol typedSym; }
				typedSym=identifier // ( DEREF )*
			{
				Scope currentScope = null;
				
				if( currentStatementScope != null )
					currentScope = currentStatementScope;
				else
					currentScope = scopingEngine.getCurrentScope();

				assert currentScope  != null;
				
				// Nur, wenn innerhalb einer Expression!!			
				// FIXME scope muss stimmen ...
				if( typedSym != null && typedSym.isMethod() ){
	
					// Methodenaufruf dem aktuellen Scope hinzufgen
					//scopingEngine.getCurrentScope().addMethodCall(sym.getFullName());
					currentScope.addMethodCall(typedSym.getFullName());
					
					// MB : Nicht einfach eine neue Methode konstruieren...
					// ... sondern das aufgelste Symbol verwenden
					// Method f = new Method(typedSym.getNameHash());
					Method f = (Method) typedSym;
					
					// FIXME: Was passiert, wenn Methode unbekannt ist?
					// -> Darf eigentlich nicht sein, da unaufgelste Symbole
					// hchstens vom Typ TypedSymbol sind...
					
					// f.setScope(typedSym.getScope());
					// stammel (27.6.05): category-setting introduced (default: procedure)
					// f.setCategory(Method.PROCEDURE);
					// f.setBody(((Method)typedSym).getBody()); 
						
					markMethodReference(currentScope ,f);
				}
				else
					// spezialfall: sym = "result" (Rckgabetype der Funktion)
					if( typedSym != null && typedSym.getName().equalsIgnoreCase("result") ){
						// wird zum typ der aktuellen Funktion aufgelst
						// Symbol sym1 = scopingEngine.resolve(currentScope.getName());
						Symbol sym1 = currentScope.getCorrespondingSymbol();

						if( (sym1 != null) && sym1.isInstanceOf("TypedSymbol") )
							retType = ((TypedSymbol)sym1).getType();
				}
				// stammel: 7.6.2005 (extention)
				else if (typedSym != null && typedSym.isAttribute()) {
					markReference(typedSym);
				}
			if (typedSym != null) {
			  	if (typedSym.isInstanceOf("Typed") ) {
					retType = ((Typed)typedSym).getType(); 
					  // StaticTypeAccess !!!
					   if (typedSym.isInstanceOf("Type")) // TODO We have to exclude case, when there is no DOT after the class name! 
				  	   					markStaticTypeAccess(scopingEngine.getCurrentScope(), retType);
			  	} else if( typedSym.isInstanceOf("Type") ) {
			  		// FIXME Reachable Branch ?????
				  	retType = (Type)typedSym;
				    }	
			    else
			  	    println("Error in rule 'primaryExpression' - unable to determine type of identifier '"+typedSym.getName()+"'.");
			    }
			else
			  	println("Error in rule 'primaryExpression' - unable to determine type of identifier '"+typedSym.getName()+"'.");


			}
		|	str=typeId
			{ //rckgabewert ist String
				retType = scopingEngine.getTypeDeclaration(str);
				// JS: here we found a type declaration ==> static type access
										// StaticTypeAccess !!!
//						markStaticTypeAccess(scopingEngine										.getCurrentScope(), retType);
						
			}
		|	retType=typeCast
		)
	;

functionCallOrTypecast[boolean inherited] returns [Type retType=null;]{ 	if( DEBUG_RULENAMES ) println("OPReferences."+"functionCallOrTypecast");
		TypedSymbol sym=null;
		String str=null;
		Scope callingScope = ( currentStatementScope != null ) ? 
									currentStatementScope
									: scopingEngine.getCurrentScope();
		Scope methodScope = null;
		Scope newScope = null;		
		List params=null;
		
		// DEBUG 
		// showSubAst(##_in);
	}
:#( DEREF	functionCallOrTypecast[inherited] )
	|	/* es gibt zwei mglichkeiten, den FQN zu erhalten
			 a) Kombination aus dem aufrufenden Scope und dem Funktionsnamen
			 b) Der Funktionsname ist schon voll qualifiziert
		*/
		#(FUNC_CALL 
			(	
				sym=qi:qualifiedIdentifier 
				{ 
					/* Scope des Funktionsaufrufs
					 * = der durch den qualIdent festgelegt wird
					 */
					methodScope = scopingEngine.getCurrentScope(); 
				}
			|	str=t:typeId
			|	typeCast
			)
			#( PARAM_LIST 
				(	{ 	// save current scope
						Scope tempScope = scopingEngine.getCurrentScope();
						
						/* currentStatementScope = Scope, in dem das aktuelle Stmnt
						 * ausgefhrt wird. (Calling Scope)
						 * Hier: Scope des Funktionsrumpfs
						 */
						 
						// Hier wird nicht der Scope der aufgerufnene Funktion 
						// bentigt, sondern der Scope des aktuellen Codeblocks
						// = currentStatementScope
						if(	currentStatementScope != null 
								&& currentStatementScope != scopingEngine.getCurrentScope() 
							){
								try {
									newScope = scopingEngine.changeScope(currentStatementScope);
								} catch (ScopeNotFoundException e) {
								// FIXME: why did you comment me? Why??
									// newScope=scopingEngine.createNewScope(currentStatementScope.getFullName());
									e.printStackTrace();
								} catch (ScopingException e) {
									// TODO Auto-generated catch block
									e.printStackTrace();
								}
						}
					}
					params=expressionList
					{
						// restore "current" scope
						if(newScope != null ) // wurde scope gewechselt?
							try {
								scopingEngine.prevScope();
							} catch (ScopingException e1) {
								// TODO Auto-generated catch block
								e1.printStackTrace();
							}
					}	
				)? 
			)
			( el2:expressionList )?
			b1:( dereference | arrayDim )*
		)
		{	
			// Action Code
			if( str != null ){
				retType = scopingEngine.getTypeDeclaration(str);
			}
			if( !sym.isResolved() && !inherited ){
				Symbol tempSym = scopingEngine.resolve(sym);

				if( tempSym == null || tempSym.isInstanceOf("MethodComposite")){
					Method tempMethod = new Method(sym);
					tempMethod.setParameters(params);
					tempSym = scopingEngine.resolveMethod(tempMethod);
				}
				
				if( tempSym == null )
					tempSym = scopingEngine.getCurrentScope().searchInSubscopes(sym);

				if( tempSym != null && tempSym.isInstanceOf("TypedSymbol") )
					sym = (TypedSymbol)tempSym;
				else if( tempSym != null && tempSym instanceof MethodComposite ){
					// FIXME what shall we do now ?
				}
				else
					; // FIXME what shall we do in case of an ERROR?
					
			} else if( inherited ){ // Spezialfall INHERITED
					Symbol inheritedSymbol = scopingEngine.resolveInheritedSymbol(
						sym.getName()
					);
//					if( inheritedSymbol != null && inheritedSymbol instanceof Method )
//						markMethodReference(scopingEngine.getCurrentScope() , (Method)inheritedSymbol);

					if( inheritedSymbol != null && inheritedSymbol instanceof TypedSymbol )
						sym = (TypedSymbol)inheritedSymbol;
			}
			
				
			if( sym != null) {
				if  (sym.isMethod() ){
					Method m = (Method)sym;
					if(  params != null && !params.contains(Type.getNilType()) ){  // ignore, if paramlist contains Niltype (which means, that a type-computation has failed)
						if( m.isOverloaded() && params != null ){
							Method dummyMethod = new Method(sym.getName(),sym.getType(),params);
							dummyMethod.setScope(sym.getScope());
		
							// Method concreteMethod = scopingEngine.getCompatibleMethod(dummyMethod);
							Method concreteMethod = scopingEngine.resolveMethod(dummyMethod);
							System.err.println();
							if( concreteMethod != null ){
								OPDebug.debugPrintln(3,"### calling: "+sym.getFullName()+" with Parameters "+Method.parameterListToString(params) );
								OPDebug.debugPrintln(3,"### target: "+concreteMethod.getFullName()+" with Parameters "+concreteMethod.parameterListToString() );
								// Methodenaufruf dem aktuellen Scope hinzufgen
								callingScope.addMethodCall(concreteMethod.getFullNameWithParameters());
		
								markMethodReference(callingScope,concreteMethod);
		
								retType = concreteMethod.getType();
							}
							else{
								OPDebug.debugPrintln(3,"### can't find compatible method for "+sym.getFullName()+" with Parameters "+Method.parameterListToString(params) );
	
								// create dummy entity
								if( dummyMethod.getScope() != null ){
									ListIterator li = 
										dummyMethod.getScope().getOverloadedMethods(dummyMethod).listIterator();
									while(li.hasNext()){
										Method currentSymbol = (Method)li.next();
										
										if( currentSymbol.getFullName().equalsIgnoreCase(dummyMethod.getFullName()) ){
											dummyMethod.setResolved(false);
											// Access dummy
											output.markMethodDeclaration(
												dummyMethod.getScope(),
												dummyMethod
											);
											dummyMethod.setResolved(true);
											break;
										}
									}
								}
								markMethodReference(callingScope,dummyMethod);
	
								retType = NilType.get();
							}
							OPDebug.debugPrintln(3,"## Warning! Resolving of overloaded methods may be incomplete. (Method: "+sym.getName()+")");
						}
						else { //Not overloaded
								markMethodReference(callingScope,m);
								retType = m.getType();
						}
					}else{ // nil-parameter
						markMethodReference(callingScope,m);
						retType = m.getType();
					}
					// Parameter
					if( params != null ){
						ListIterator li = params.listIterator();
						
						while( li.hasNext() ){
							Symbol currentParam = (Symbol)li.next();
							
							if( currentParam.isInstanceOf("Typed") )
								markTypeReference(callingScope,((Typed)currentParam).getType());
						}
					}
				}
				// Typecast?
				if (sym.isInstanceOf("Type")) { 
					// FIXME: This should be applied to other types as well...
					if (sym.isResolved()) {
						markTypeCast(callingScope,(Type)sym);
						markTypeReference(callingScope,(Type)sym);
						retType = (Type)sym;
					}
					else {
						output.printCommentLine("Unresolved, so I can't distinguish a method-call from a typecast: "+sym.getFullName() );
						markTypeCast(callingScope,(Type)sym);
						markTypeReference(callingScope,(Type)sym);
						retType = NilType.get();	
					}
				} 
			} 
			
			if (sym == null)
				retType = Type.getNilType();
			assert retType != null;
		}
	;

qualifiedIdentifier returns [TypedSymbol returnSymbol=null; ]{ if( DEBUG_RULENAMES ) print("OPReferences."+"qualifiedIdentifier"); 
	  String str=null;
	  Vector qualIdent = new Vector();
	}
:#(id:IDENT 
			{   if (DEBUG_RULENAMES) println(": " + id.getText()); 
				qualIdent.addElement(id.getText());
			}
			(	idn:IDENT
				{ 
					qualIdent.addElement(idn.getText());
				}
			)* 
		)
		{	
			
			// prfen, womit der qualIdent begeinnt (Unit, Klasse ...)
			str = vectorToQualifiedIdentifier(qualIdent);

			// Debugging
			expressionPrintln(str+", l."+id.getLine()); 

			////////////////////////////////
			// FIXME UNVOLLSTNDIG!!
			////////////////////////////////

			// auflsen: 
			// Attribute
			returnSymbol = scopingEngine.getAttributeDeclaration( str );

			// Function/Procedure/Method?
			if( returnSymbol == null ) {
				returnSymbol = scopingEngine.getMethodDeclaration(str);
			}
			// Type?
			if( returnSymbol == null ) 
				returnSymbol = scopingEngine.getTypeDeclaration(str);

			// result ?
			if( returnSymbol == null && str.equalsIgnoreCase("result") ){

			// do nothing for the time - old code follows
//				Scope currentMethodScope = scopingEngine.getCurrentScope();
//
//				while( currentMethodScope!=null && 
//					!currentMethodScope.isRootScope() 
//					&& !currentMethodScope.isScopeOfMethod() )								
//						currentMethodScope = currentMethodScope.getParent();
//				Symbol cmSym = currentMethodScope.getCorrespondingSymbol();
//				if( currentMethodScope.isScopeOfMethod() &&
//					(cmSym != null) && cmSym.isInstanceOf("TypedSymbol") )
//					returnSymbol = (TypedSymbol)currentMethodScope.getCorrespondingSymbol();
			}

			if( returnSymbol == null ) 
			{	
				returnSymbol = new TypedSymbol(str,Type.getNilType());
				returnSymbol.setResolved(false);
				returnSymbol.setLine(id.getLine());
				//markReference(returnSymbol);
				assert scopingEngine.getRootScope() != null : "qualifiedIdentifier rootScope == null";
			}
			assert returnSymbol != null : "qualifiedIdentifier will return null";
		}
	;

identifier returns [TypedSymbol ret=null; ]:ret=qualifiedIdentifier
	;

unsignedConstant returns [Type retType=null;]:unsignedInteger		{ retType = Type.getIntegerType(); }
    | 	unsignedReal		{ retType = Type.getRealType(); }
	|	booleanConstant		{ retType = Type.getBooleanType(); }
	|	charLiteral			{ retType = Type.getStringType(); }
	|	stringLiteral		{ retType = Type.getStringType(); }
	|	setConstructor		{ retType = scopingEngine.getTypeDeclaration("set"); }
    |	NIL					{ retType = Type.getNilType(); }
    ;

typeCast returns [Type retType=null;]{	if( DEBUG_RULENAMES ) 	println("OPReferences."+"typeCast"); 
	String str=null;
	TypedSymbol sym=null;
	}
:#( TYPE_CAST 	
			( sym=identifier
			| str=typeId ) 
			expressionList 
		)
		{ 	// bezeichner auflsen
			assert str != null;
			
			if( str != null ) {
				sym = scopingEngine.getTypeDeclaration(str);
				
				// should be != null, if it could be resolved
				if( sym == null ) { // we assume, it is a type
					retType = createDummyType(str);
					// add to unknown-scope					
					OPProjectManager.getUnresolvedScope().addSymbol(retType);
				}else{
					if( sym.isInstanceOf("Typed") )
						retType = ((Typed)sym).getType();	
					else
						retType = scopingEngine.getTypeDeclaration(sym.getName());
				}
				
				markTypeCast(retType);
			}
		}
	;

parameterList returns [List list=new Vector();]{	
	String t=null; 
}
:#(PARAM_LIST
			(
				#( PARAM_SPEC 
					id:identifier
						(	t=typeId )?	
							{ 
								Symbol currentParam;
								if( t != null ){
									Type type = scopingEngine.resolveType(t);
	
				  					if( type == null ){
				  						UnknownClassType unknownType = createDummyType(t);
				  						// tag as unknown
										currentParam=new Attribute(id.getText(),unknownType);				  					
										// add to unknown-scope					
										OPProjectManager.getUnresolvedScope().addSymbol(unknownType);
										// save reference
										unknownType.addReference(currentParam);
									}
				  					else // add to current scope
										currentParam=new Attribute(id.getText(),type); 
								}else{// no type 
									currentParam=new Attribute(id.getText(),Type.NULL); 
								}
								list.add(currentParam);
							} 
					(VAR|CONST|OUT)?
				)
			)+
		)
	;

compoundStatement returns [CodeblockInfo ci = null;]{		currentStatement = (Statement)OPProjectManager.getStatementMapper().getInstance(#compoundStatement_in);}
:ci = statementList
	|	ci = asmStatement 
		
	;

asmStatement returns [CodeblockInfo ci = null;]{
	int lines=0;
}
:#( a:ASM	
			#( META_INFO total:INT_LIT ) 
			#( META_INFO comment:INT_LIT ) 
			#( META_INFO branches:INT_LIT ) 
		)
		{
			ci=new CodeblockInfo();

			try{
				ci.setTotalLines(Integer.parseInt(total.getText()));
			}catch( NumberFormatException e ){
				ci.setTotalLines(0);
			}
			try{
				ci.setCommentLines(Integer.parseInt(comment.getText()));
			}catch( NumberFormatException e ){
				ci.setCommentLines(0);
			}
			try{
				ci.setBranches(Integer.parseInt(branches.getText()));
			}catch( NumberFormatException e ){
				ci.setBranches(0);
			}
			ci.setType(CodeblockInfo.ASM);
			
		}
	;

statementList returns [CodeblockInfo ci = null;]{	printRuleName("OPReferences."+"statementList");
	int branches = 0;
	int statements = 0;
	ci = new CodeblockInfo();
	CodeblockInfo currentCi = new CodeblockInfo();
}
:#( STMNT_LIST (
				( label )?	
				(	currentCi=simpleStatement
				|	currentCi=ifStatement
				|	currentCi=gotoStatement
				|	currentCi=caseStatement
				|	currentCi=forStatement
				|   currentCi=whileStatement
				|	currentCi=repeatStatement
				|	currentCi=tryStatement
				|	currentCi=raiseStatement
				|	currentCi=emptyStatement
				|	currentCi=withStatement
				|   currentCi=compoundStatement
				)
				{ 
					ci.add(currentCi); 
				}
			)* 
		)
	;

ifStatement returns [CodeblockInfo ci = null;]{
	printRuleName("OPReferences."+"ifStatement");
	CodeblockInfo ciIf = null;
	CodeblockInfo ciElse = null;
	currentStatement = (Statement)OPProjectManager.getStatementMapper().getInstance(#ifStatement_in);
}
:#(IF expression ciIf=statement (ciElse=elseBlock )? 
    	{
    		ci = new CodeblockInfo();

    		if( ciIf != null ) 
    			ci.add(ciIf);
    		if( ciElse != null ) 
    			ci.add(ciElse);
			
			// Count IF as branch 		
			ci.setBranches(ci.getBranches()+1);
		}
	)
    ;

elseBlock returns [CodeblockInfo ci = null;]:#(ELSE 			ci=statement 
			{	// add ELSE
				ci.setBranches(ci.getBranches()+1);
			}
		)
	;

statement returns [CodeblockInfo ci = null;]{ printRuleName("OPReferences."+"statement");}
:( label )?	
	(	ci=simpleStatement
	|	ci=ifStatement
	|   ci=compoundStatement
	|	ci=gotoStatement
	|   ci=emptyStatement
	|	ci=caseStatement
	|	ci=raiseStatement
	|	ci=withStatement
	|	ci=forStatement
	|   ci=whileStatement
	|	ci=repeatStatement
	|	ci=tryStatement
	)
	{
			ci.setStatements(ci.getStatements()+1);
	}
	;

emptyStatement returns [CodeblockInfo ci = null;]{ printRuleName("OPReferences."+"emptyStatement");}
:EMPTY_STMNT
		{
			ci = new CodeblockInfo();
			ci.setBranches(0);
		}
	;

gotoStatement returns [CodeblockInfo ci = null;]{currentStatement = (Statement)OPProjectManager.getStatementMapper().getInstance(#gotoStatement_in);
	}
:#(GOTO	identifier)
		{
			ci = new CodeblockInfo();
			ci.setBranches(1);
		}
	;

withStatement returns [CodeblockInfo ci = null;]{currentStatement = (Statement)OPProjectManager.getStatementMapper().getInstance(#withStatement_in);}
:#(WITH expressionList ci=statement 
			{
				ci.setBranches(ci.getBranches()+1);
			}
		)
	;

whileStatement returns [CodeblockInfo ci = null;]{		currentStatement = (Statement)OPProjectManager.getStatementMapper().getInstance(#whileStatement_in);}
:#(	WHILE  
	  		expression
	  		ci=statement
			{
				ci.setBranches(ci.getBranches()+1);
			}
  	)
  ;

forStatement returns [CodeblockInfo ci = null;]{		currentStatement = (Statement)OPProjectManager.getStatementMapper().getInstance(#forStatement_in);}
:#( FOR 
	  		#( ASSIGN identifier expression )
			(	#(TO expression )
			|	#(DOWNTO expression )
			)
			#( DO 		ci=statement 
				{
					ci.setBranches(ci.getBranches()+1);
				}
			)
		)
	;

repeatStatement returns [CodeblockInfo ci = null;]{currentStatement = (Statement)OPProjectManager.getStatementMapper().getInstance(#repeatStatement_in);
}
:#(REPEAT
  		ci=statementList
			{
				ci.setBranches(ci.getBranches()+1);
			}
  		expression
  	)
  ;

raiseStatement returns [CodeblockInfo ci = null]{		currentStatement = (Statement)OPProjectManager.getStatementMapper().getInstance(#raiseStatement_in);
}
:#(RAISE
			( expression (raiseAt)? )? 
			{
				ci = new CodeblockInfo();			
			}
		)
	;

caseStatement returns [CodeblockInfo ci = null]{
	ci = new CodeblockInfo();
	CodeblockInfo ciSelector = new CodeblockInfo();
	CodeblockInfo ciElse = null;
	currentStatement = (Statement)OPProjectManager.getStatementMapper().getInstance(#caseStatement_in);
}
:#(CASE
			expression
			( ciSelector=caseSelector 
				{
					ci.add(ciSelector);
				}
			)+
			( ciElse=caseElse 
			 { ci.add(ciElse); }
			)?
		)
	;

caseElse returns [CodeblockInfo ci = null]:#( ELSE ci=statementList 
			{
				ci.setBranches(ci.getBranches()+1);
			}
		)
	;

caseSelector returns [CodeblockInfo ci = null]:#( COLON 
			caseLabel ( COMMA caseLabel )* 
			ci=statement 
			{
				ci.setBranches(ci.getBranches()+1);
			}
		)
	;

tryStatement returns [CodeblockInfo ci = null]{
		currentStatement = (Statement)OPProjectManager.getStatementMapper().getInstance(#tryStatement_in);
		ci = new CodeblockInfo();
	}
:#( TRY statementList {//		nextStatement();
							}
			(	tryExceptStatement
			|	tryFinallyStatement
				{		//nextStatement();
				}
			)
		)
	;

tryExceptStatement returns [CodeblockInfo ci = null]{currentStatement = (Statement)OPProjectManager.getStatementMapper().getInstance(#tryExceptStatement_in);}
:#( EXCEPT exceptionBlock )
	;

tryFinallyStatement returns [CodeblockInfo ci = null]{currentStatement = (Statement)OPProjectManager.getStatementMapper().getInstance(#tryFinallyStatement_in);}
:#(FINALLY ci=statementList )
	;

exceptionBlock returns [CodeblockInfo ci = null]:ci=statementList
			{		//nextStatement();
			}
	|	(
			{	
				ci = new CodeblockInfo();
				CodeblockInfo ciOn=new CodeblockInfo(); 
				CodeblockInfo ciElse=new CodeblockInfo(); 
			}
			(
				ciOn=exceptionOn
				{
					ci.add(ciOn);
					//nextStatement();
				}
			)+
        	( ciElse=exceptionElse
	        	{ ci.add(ciElse); 
					//	nextStatement();
				}
        	)?
		)
	;

exceptionOn returns [CodeblockInfo ci = null]:#(ON
			( identifier COLON )? 
			typeId 
			ci=exceptionDo
			{
				ci.setBranches(ci.getBranches()+1);
			}
		)
	;

exceptionElse returns [CodeblockInfo ci = null]:#( ELSE ci=statementList 
			{
				ci.setBranches(ci.getBranches()+1);
			}
		)
    ;

exceptionDo returns [CodeblockInfo ci = null]:#( DO ci=statement )
	;

// inherited from grammar OPAnalyzer
varDecl { 
		if( DEBUG_RULENAMES ) println("OPAnalyzer."+"varDecl"); 
		String t=null;
	}
:#(VAR_DECL
	  		#( id:IDENT 
	  			(	
	  				t=typeId	
	  			|	range
	  			) 
	  		)
  		) 
  	;

// inherited from grammar OPAnalyzer
range { if( DEBUG_RULENAMES ) println("OPAnalyzer."+"Range"); }
:#( EXPR #(RANGE ordinalType ordinalType) )
	;

// inherited from grammar OPAnalyzer
constDeclSection {
		if( DEBUG_RULENAMES ) println("OPAnalyzer."+"constDecl");
		String t=null; 
	}
:#( CONST 
			(	
				#( ASSIGN	
						identifier 
						(typeId)? 
						(	expression
						|	objectInitialization
						)
				)
			 )+
		)
	;

// inherited from grammar OPAnalyzer
formalParameters :parameterList
	;

// inherited from grammar OPAnalyzer
typeDecl {	if( DEBUG_RULENAMES ) println("OPAnalyzer."+"typeDecl"); }
:#( TYPE_DECL id:IDENT	{ String t; }
			// tauschen mit deref aus Recorddecl.: ( DEREF )?
		   	(	
		   		t=typeId 
			|	arrayDecl
		    	//	(PACKED)? arrayDecl (PACKED)?
		   	|	( DEREF	)? 
				#( RECORD_DECL 
					(varDecl)* 
					( variantSection )?
					( directive )?
				)
	  		|	
	  			#( ENUM_DECL 
						{ Vector v; }
						v=identList 
				)
		   	|	
		   		#(CLASS
		   			{
		   				Vector superTypes=null; 
		   			}
	   				( 	 
						#( EXTENDS
							( superTypes=identList )?
						)
					)?
	   				( classVisibilityDecl )*
	   			)
	   		|	#( INTERFACE
	   				#(	EXTENDS	( IDENT )* )
					( comGuid )?
  					(classMethodDecl|propertyDecl)*
	   			)
	   		|	#( DISPINTERFACE
	   				#(	EXTENDS	( IDENT )* )
	   				( comGuid )?
  					(classMethodDecl|dispinterfacePropertyDecl)*
	   			)
	   		|   range
	//   	|	proceduralType
			)
	)
	;

// inherited from grammar OPAnalyzer
labelDecl {	if( DEBUG_RULENAMES ) println("OPAnalyzer."+"labelDecl"); }
:LABEL_DECL
//		#( LABEL_DECL
//			#(IDLIST
//				(	
//					id:IDENT
//				)+ 
//			)
//		)
	;

// inherited from grammar OPAnalyzer
classMethodDecl {	if( DEBUG_RULENAMES ) println("OPAnalyzer."+"classMethodDecl"); }
:#(PROC_DECL procedureHeading ( (EQUALS qualifiedIdentifier))? )
	|	#(FUNC_DECL functionHeading ( (EQUALS qualifiedIdentifier) )? )
	|	#(CONSTR_DECL constructorHeading (EQUALS qualifiedIdentifier)? ) 
	| 	#(DESTR_DECL destructorHeading (EQUALS qualifiedIdentifier)? )
	;

// inherited from grammar OPAnalyzer
interfaceSectionDecl :#( d:DECL_SECT 
			(	basicDecl 
			|	#(PROC_DECL procedureHeading) //procedureDecl  
			| 	#(FUNC_DECL functionHeading) // functionDecl
			)
	   	)
	;

// inherited from grammar OPAnalyzer
typeId returns [String str=null;]{ 
		if( DEBUG_RULENAMES ) println("OPAnalyzer."+"typeId");
	 }
:#(TYPE_NODE 
		  (	
		  		#(p:PREDEF_TYPE s=predefinedType)
		  		 	{ str = s; }
			|	id:IDENT 	{ str = id.getText(); } 
							(unitIdent)? 
			|	str=structuredType
			|	enumDecl { str = "<enum>"; }
			|	proceduralType { str = "<delegate>"; }
		  )
		) 
	;

// inherited from grammar OPAnalyzer
enumDecl :#(ENUM_DECL expressionList)	
	;

// inherited from grammar OPAnalyzer
structuredType returns [String str=null;]{ if( DEBUG_RULENAMES ) println("OPAnalyzer."+"structuredType");}
:(PACKED)?
		(	arrayDecl 
			{ str= "<array>"; } 
		|	str=fileType 
			{ 	if( str != null ) 
					str = "<file of "+str+">";
				else
					str = "<file>";
//				println("###"+str);
			}
		|	{ if( DEBUG_RULENAMES ) println("OPAnalyzer."+"structuredType.record");}
			recordDecl { str= "<record>"; } 
				( PACKED { str= "<record_packed>"; } )?
		|	setType { str= "<set>"; }
		)
		{ assert str != null; }
	;

// inherited from grammar OPAnalyzer
arrayDecl :#(ARRAY_DECL 
			(expressionRange)? // MB
			typeId) 
	;

// inherited from grammar OPTransformer
program :(programHeading)?
		programBlock
	;

// inherited from grammar OPTransformer
programBlock { printRuleName("OPTransformer."+"programBlock"); }
:( usesClause )*
		subprogramBody
	;

// inherited from grammar OPTransformer
unitBody ://		{ System.err.println("---- INTERFACE Section----"); }
		interfaceSection
//		{ System.err.println("---- IMPLEMENTATION Section----"); }
		implementationSection
 		(
 //			{ System.err.println("---- INITIALIZATION Section ----"); }
 			initSection	
 		)?
	;

// inherited from grammar OPTransformer
implementationSection { printRuleName("OPTransformer."+"implementationSection"+" #################################");  }
:#( IMPLEMENTATION
			(usesClause)?
			(declSection[false])*
			(exportsStatement)*
		)
		
		{		
//			ListIterator li = getIn
//			##.addChild(); 
		
		}
		
	;

// inherited from grammar OPTransformer
exportsStatement :#(EXPORTS
			(
				identifier 
				(	(NAME|INDEX) constExpression 
					(
						(NAME|INDEX)  constExpression 
					)?
				)?
			
			)*
		)
	;

// inherited from grammar OPTransformer
initSection { printRuleName("OPTransformer."+"initSection"); }
:#(INITIALIZATION (statementList) 
			( finalization )?
		)
//	| 	compoundStatement
	;

// inherited from grammar OPTransformer
finalization { printRuleName("OPTransformer."+"finalization"); }
:#(FINALIZATION (statementList) )	
	;

// inherited from grammar OPTransformer
identList returns [Vector v]{ 	printRuleName("OPTransformer."+"identList"); 
		v = new Vector(); }
:#( IDLIST 
    		( id:identifier
    			{ v.addElement(getASTFactory().dup(id));}
    		)*
    	)
    ;

// inherited from grammar OPTransformer
subprogramBody { printRuleName("OPTransformer."+"subprogramBody "); }
:( declSection[false] )*
  	(exportsStatement)?
	  	( mainProgram )?	//Optional main program "begin ... end"
  ;

// inherited from grammar OPTransformer
basicDecl { printRuleName("OPTransformer."+"basicDecl"); }
:varDeclSection
	|	constDeclSection
	|	typeDeclSection
	|	labelDecl
	;

// inherited from grammar OPTransformer
typeDeclSection { printRuleName("OPTransformer."+"typeDeclSection"); }
:( typeDecl )+
	;

// inherited from grammar OPTransformer
comGuid :#( COM_GUID (STRING_LIT)? )
	;

// inherited from grammar OPTransformer
dispinterfacePropertyDecl :#( PRPTY_DECL
			id:IDENT
			(propertyParameterList)?
			s=typeId
			(propertySpecifiers|directive)*
		)
	;

// inherited from grammar OPTransformer
varDeclSection { printRuleName("OPTransformer."+"varDeclSection"); }
:// #( v:VAR_DECL 
			 ( varDecl )+ 
		//)
	;

// inherited from grammar OPTransformer
ordinalType :expressionRange //range
	|	integerConstant
	|	enumDecl
	|	booleanConstant
	|	qualifiedIdentifier //identifier
	|	s=predefinedType // DEBUG: eigentlich OrdIdent
	;

// inherited from grammar OPTransformer
charConstant :charLiteral
	;

// inherited from grammar OPTransformer
constDecl { printRuleName("OPTransformer."+"constDecl");	}
:#( ASSIGN 
			identifier 
			( 	{ String temp; } 
				temp=typeId
			)? 
			(	expression
			|	objectInitialization
			)
		)
	;

// inherited from grammar OPTransformer
objectInitialization :#(OBJ_INIT
			(
				(recordConstant)+
			|	(expression)+
			|	(objectInitialization)+
			)
		)
	;

// inherited from grammar OPTransformer
recordConstant :#(ASSIGN identifier expression)
	;

// inherited from grammar OPTransformer
unitIdent :#( UNIT_IDENT IDENT )
	;

// inherited from grammar OPTransformer
proceduralType :#(PROCEDURE
  			(formalParameters)?
  			(s=typeId)?
 			( directive )*
			( OF OBJECT )?
		)
	|	#(FUNCTION
  			(formalParameters)?
	  		(s=typeId)?
 			( directive )*
			( OF OBJECT )?
		)
	;

// inherited from grammar OPTransformer
predefinedType returns [String tok]{ tok = ""; }
:real48:REAL48 				{ tok = #real48.getText(); }
		|	single:SINGLE 				{ tok = #single.getText(); }
		|	double_:DOUBLE 				{ tok = #double_.getText(); }
		| 	real:REAL 					{ tok = #real.getText(); }
		|	boolean_:BOOLEAN 			{ tok = #boolean_.getText(); }
		|	integer:INTEGER 			{ tok = #integer.getText(); } 
		|	cardinal:CARDINAL 			{ tok = #cardinal.getText(); }
		|	shortint:SHORTINT 			{ tok = #shortint.getText(); }
		|	smallint:SMALLINT 			{ tok = #smallint.getText(); }
		|	longint:LONGINT 			{ tok = #longint.getText(); }
		|	int64:INT64 				{ tok = #int64.getText(); }
		|	byte_:BYTE 					{ tok = #byte_.getText(); }
		|	word:WORD 					{ tok = #word.getText(); }
		|	longword:LONGWORD 			{ tok = #longword.getText(); }
		|	ansistring:ANSISTRING 		{ tok = #ansistring.getText(); }
		|	widestring:WIDESTRING 		{ tok = #widestring.getText(); }
		|	variant:VARIANT 			{ tok = #variant.getText(); }
		|	olevariant:OLEVARIANT 		{ tok = #olevariant.getText(); }
		|	#(string:STRING 			{ tok = #string.getText(); }
				(constValue)?
			)
	;

// inherited from grammar OPTransformer
constValue ://	#( CONST_EXPR
		(	integerConstant
		|	unsignedReal
		|	booleanConstant
		|	charLiteral
		|	stringLiteral
		|	identifier 
	    |	NIL			
	   	) 
//   	)
	;

// inherited from grammar OPTransformer
constExpression :expression
	;

// inherited from grammar OPTransformer
integerConstant :#( UNARY_PLUS unsignedInteger )
  | #( UNARY_MINUS unsignedInteger )
  |	unsignedInteger
  ;

// inherited from grammar OPTransformer
unsignedInteger :INT_LIT
    |		HEX_CONST
 	;

// inherited from grammar OPTransformer
realConstant :#( UNARY_PLUS unsignedInteger )
  | #( UNARY_MINUS unsignedInteger )
  |	unsignedReal
  ;

// inherited from grammar OPTransformer
unsignedReal :REAL_LIT
	;

// inherited from grammar OPTransformer
booleanConstant :( TRUE | FALSE )
	;

// inherited from grammar OPTransformer
stringLiteral :STRING_LIT  							
    ;

// inherited from grammar OPTransformer
charLiteral :CHAR_LIT						
	| 	#(CHR INT_LIT)
	;

// inherited from grammar OPTransformer
label :#( LABEL ( identifier | INT_LIT ) )
	;

// inherited from grammar OPTransformer
raiseAt :#(AT expression)
	;

// inherited from grammar OPTransformer
caseLabel :constExpression (DOTDOT constExpression )?
	;

// inherited from grammar OPTransformer
dereference :( DEREF )+
	;

// inherited from grammar OPTransformer
arrayDim { printRuleName("OPTransformer."+"arrayDim");
	}
:( options{greedy=true;}
			: 
			#( ARRAY_INDEX (arrayDim)? expression	)
		)+
	;

// inherited from grammar OPTransformer
setConstructor { printRuleName("OPTransformer."+"setConstructor");}
:#(SET_CONSTR
			(	(expressionRange)+
			|	() // EMPTY_SET
			)
		)
	;

// inherited from grammar OPTransformer
directive :{ printRuleName("OPTransformer."+"directive"); }
	#( DIRECTIVE
		(	#(MESSAGE constValue)
		| 	directiveExternal
		|	#(DISPID integerConstant)
		|	CDECL	
		|	ABSTRACT
		|	DYNAMIC
		|	EXPORT
		|	FAR
		|	FORWARD		
		|	LOCAL
		|	NEAR
		|	OVERLOAD
		|	OVERRIDE
		|	PASCAL
		|	REGISTER
		|	REINTRODUCE
		|	SAFECALL
		|	STDCALL
		|	VARARGS
		|	VIRTUAL
		|	ASSEMBLER
		|	READONLY 
		|	WRITEONLY	
		)+
	)
	;

// inherited from grammar OPTransformer
directiveName :#(NAME
			(	(stringLiteral|IDENT)
				( PLUS (stringLiteral|IDENT) )* 
			)? 
		)
	;

// inherited from grammar OPTransformer
directiveIndex :#( INDEX INT_LIT )
	;

// inherited from grammar OPTransformer
directiveExternal :#(EXTERNAL 
			(	(stringLiteral|IDENT)
				( PLUS (stringLiteral|IDENT) )* 
			)? 
			( directiveName		
			|	directiveIndex )*
		)
	;

// inherited from grammar OPTransformer
parameterSpec! returns [Vector params]{	printRuleName("OPTransformer."+"parameterSpec"); 
		Vector il;
		params = new Vector(); 
	}
:#( ps:PARAM_SPEC 
  			(var_:VAR|const_:CONST|out_:OUT)? 
  			il=identList
  			( s=t:typeId )?
 			( EQUALS constExpression )?
 		)
  		{	CommonASTWithLineNumber subAst;
			CommonASTWithLineNumber ruleAst=new CommonASTWithLineNumber(new Token(PARAM_SPEC));

			for(int i=0;i<il.size();i++){
	  			subAst = new CommonASTWithLineNumber();
	  			subAst.setType(PARAM_SPEC);
	  			subAst.setText("PARAM_SPEC");
				subAst.addChild(((CommonASTWithLineNumber)il.elementAt(i)));
				if ( t != null) 
					subAst.addChild(getASTFactory().dupTree(t));
				/* if( var_ != null ) 
					subAst.addChild(getASTFactory().dupTree(var_));
				if( const_ != null )
					subAst.addChild(getASTFactory().dupTree(const_));
				if( out_ != null )
					subAst.addChild(getASTFactory().dupTree(out_));
				*/	

				ruleAst.addChild(subAst);
				params.addElement(getASTFactory().dupTree(subAst));
			}
			##=ruleAst;
  		}
	;

// inherited from grammar OPTransformer
setType :#( SET ordinalType (directive)? )
	;

// inherited from grammar OPTransformer
fileType returns [String t=null;]{	printRuleName("OPTransformer."+"fileType"); 
		}
:#( FILE_TYPE 
			(
				t=typeId
			)? 
		)
	;

// inherited from grammar OPTransformer
recordDecl {	printRuleName("OPTransformer."+"recordDecl"); }
:#( RECORD_DECL 
			(varDecl)*
			( variantSection )?
			( directive )?
		)
	;

// inherited from grammar OPTransformer
variantSection {	printRuleName("OPTransformer."+"variantSection"); 
		Vector temp=null;
	}
:#(VARIANT_SECT
			 // switch
			#(VAR_DECL 
				//temp=identList
				#(IDLIST (identifier)? )  
				s=typeId
			) // only type possible

			(
				#(COLON 
					// #(EXPR constValue)
					( #(EXPR constValue) )+
					(varDecl)*
				)
			)+
		)
	;

// inherited from grammar OPTransformer
expressionRange {	printRuleName("OPTransformer."+"expressionRange");  }
:#(EXPR 
			(	simpleExpression 
			|	#(RANGE expression expression) 
			)
		)
	;

// inherited from grammar OPTransformer
classVisibilityDecl {	printRuleName("OPTransformer."+"classVisibilityDecl"); 
	}
:#(PUBLIC    (classElementDecl)* )
	|	#(AUTOMATED	(classElementDecl)* )
	|	#(PUBLISHED	(classElementDecl)* )
	|	#(PRIVATE	(classElementDecl)* )
	|	#(PROTECTED	(classElementDecl)* )
	;

// inherited from grammar OPTransformer
classElementDecl {	printRuleName("OPTransformer."+"classElementDecl"); }
:varDecl 
	|	classMethodDecl
	|	propertyDecl
	|	recordDecl
	|	arrayDecl
	;

// inherited from grammar OPTransformer
propertyDecl :#( PRPTY_DECL
			id:IDENT
			(propertyParameterList)?
			( s=typeId )?
			(propertySpecifiers)*
		)
	;

// inherited from grammar OPTransformer
propertyParameterList { printRuleName("OPTransformer."+"propertyParameterList"); }
:parameterList
	
	;

// inherited from grammar OPTransformer
propertySpecifiers :#( READ id_read:IDENT )
	|	#( WRITE id_write:IDENT )
	| 	#( INDEX
			(	constValue
		//	|	enumDecl
		//	|	setConstructor 
			)? 
		)
	| 	#( STORED propertySpecifiersValue
				//id_store:IDENT 
			)
	|	( #(DEFAULT propertySpecifiersValue)
		|	NODEFAULT 
		)
	| 	IMPLEMENTS 
	;

// inherited from grammar OPTransformer
propertySpecifiersValue :(	constValue
	|	enumDecl
	|	setConstructor 
	)
	;

// inherited from grammar OPTransformer
propertyInterface :(propertyParameterList)? 
		s=typeId
	;


