header {	
	package de.fzi.delphi.parser;
	
	// Imports
	import java.util.Vector;
	import java.util.Enumeration;
	import java.util.Stack;	
//	import antlr.CommonAST;
	import de.fzi.delphi.CommonASTWithLineNumber;

	import antlr.collections.AST;	
	import de.fzi.delphi.symbols.Scope;
	// HG: Wozu?
//    import de.fzi.sissy.metamod.Statement;
//	import de.fzi.sissy.metamod.SimpleStatement;
//	import de.fzi.sissy.metamod.BranchStatement;
//	import de.fzi.sissy.metamod.BlockStatement;
//	import de.fzi.sissy.metamod.JumpStatement;
//	import de.fzi.sissy.metamod.LoopStatement;
//	import de.fzi.sissy.metamod.ExceptionHandler;
//	import de.fzi.sissy.metamod.ModelElementList;
//	import de.fzi.sissy.metamod.CatchBlock;
}
class OPAnalyzer extends TreeParser;

options {
	buildAST=true;
	ASTLabelType= "de.fzi.delphi.CommonASTWithLineNumber";
	importVocab=OPTransformer;
}

{
	// Some Debugging Options
	static final boolean DEBUG_ALL = false;
	static final boolean DEBUG_RULENAMES = DEBUG_ALL | false;
	static final boolean DEBUG_PRINT_IDENT_WITH_LINE = DEBUG_ALL | false;
	String s; // return values
	
	void print(Object output){
		System.err.print(output);
		System.err.flush();
	}

	void println(Object output){
		print(output);
		System.err.println();
		System.err.flush();
	}

	void println(){
		println( "" );
	}

	void printRuleName(String rulename){
		if( !DEBUG_RULENAMES ) 
			return;
		println(rulename);
	}

}
goal :(		program
		|	package_
		|	library_
		|	unit
	)
    ;

varDecl { 
		if( DEBUG_RULENAMES ) println("OPAnalyzer."+"varDecl"); 
		String t=null;
	}
:#(VAR_DECL
	  		#( id:IDENT 
	  			(	
	  				t=typeId	
	  			|	range
	  			) 
	  		)
  		) 
  	;

range { if( DEBUG_RULENAMES ) println("OPAnalyzer."+"Range"); }
:#( EXPR #(RANGE ordinalType ordinalType) )
	;

constDeclSection {
		if( DEBUG_RULENAMES ) println("OPAnalyzer."+"constDecl");
		String t=null; 
	}
:#( CONST 
			(	
				#( ASSIGN	
						identifier 
						(typeId)? 
						(	expression
						|	objectInitialization
						)
				)
			 )+
		)
	;

procedureDecl[boolean isInnerDecl] { if( DEBUG_RULENAMES ) println("OPAnalyzer."+"procedureDecl"); }
:#(PROC_DECL
	  		procedureHeading 
  			declSection[true]
			compoundStatement
		)
	;

procedureHeading {	if( DEBUG_RULENAMES ) println("OPAnalyzer."+"procedureHeading");	}
:(id:IDENT
			( formalParameters ) ?
			( directive )*
		)
  	;

functionDecl[boolean isInnerDecl] { if( DEBUG_RULENAMES ) println("OPAnalyzer."+"functionDecl"); }
:#(FUNC_DECL
	  		functionHeading 
  			declSection[true]
			compoundStatement
		)
	;

functionHeading { 	if( DEBUG_RULENAMES ) println("OPAnalyzer."+"functionHeading"); 
		String t;
	}
:(CLASS)?
		qualifiedIdentifier 
		(formalParameters)? 
  		(t=typeId )?
		( directive )*
	;

formalParameters :parameterList
	;

parameterList :#(PARAM_LIST
			(
				#( PARAM_SPEC 
					identifier
					typeId 
					(VAR|CONST|OUT)?
				)
			)+
		)
	;

typeDecl {	if( DEBUG_RULENAMES ) println("OPAnalyzer."+"typeDecl"); }
:#( TYPE_DECL id:IDENT	{ String t; }
			// tauschen mit deref aus Recorddecl.: ( DEREF )?
		   	(	
		   		t=typeId 
			|	arrayDecl
		    	//	(PACKED)? arrayDecl (PACKED)?
		   	|	( DEREF	)? 
				#( RECORD_DECL 
					(varDecl)* 
					( variantSection )?
					( directive )?
				)
	  		|	
	  			#( ENUM_DECL 
						{ Vector v; }
						v=identList 
				)
		   	|	
		   		#(CLASS
		   			{
		   				Vector superTypes=null; 
		   			}
	   				( 	 
						#( EXTENDS
							( superTypes=identList )?
						)
					)?
	   				( classVisibilityDecl )*
	   			)
	   		|	#( INTERFACE
	   				#(	EXTENDS	( IDENT )* )
					( comGuid )?
  					(classMethodDecl|propertyDecl)*
	   			)
	   		|	#( DISPINTERFACE
	   				#(	EXTENDS	( IDENT )* )
	   				( comGuid )?
  					(classMethodDecl|dispinterfacePropertyDecl)*
	   			)
	   		|   range
	//   	|	proceduralType
			)
	)
	;

labelDecl {	if( DEBUG_RULENAMES ) println("OPAnalyzer."+"labelDecl"); }
:LABEL_DECL
//		#( LABEL_DECL
//			#(IDLIST
//				(	
//					id:IDENT
//				)+ 
//			)
//		)
	;

classMethodDecl {	if( DEBUG_RULENAMES ) println("OPAnalyzer."+"classMethodDecl"); }
:#(PROC_DECL procedureHeading ( (EQUALS qualifiedIdentifier))? )
	|	#(FUNC_DECL functionHeading ( (EQUALS qualifiedIdentifier) )? )
	|	#(CONSTR_DECL constructorHeading (EQUALS qualifiedIdentifier)? ) 
	| 	#(DESTR_DECL destructorHeading (EQUALS qualifiedIdentifier)? )
	;

interfaceSectionDecl :#( d:DECL_SECT 
			(	basicDecl 
			|	#(PROC_DECL procedureHeading) //procedureDecl  
			| 	#(FUNC_DECL functionHeading) // functionDecl
			)
	   	)
	;

typeId returns [String str=null;]{ 
		if( DEBUG_RULENAMES ) println("OPAnalyzer."+"typeId");
	 }
:#(TYPE_NODE 
		  (	
		  		#(p:PREDEF_TYPE s=predefinedType)
		  		 	{ str = s; }
			|	id:IDENT 	{ str = id.getText(); } 
							(unitIdent)? 
			|	str=structuredType
			|	enumDecl { str = "<enum>"; }
			|	proceduralType { str = "<delegate>"; }
		  )
		) 
	;

enumDecl :#(ENUM_DECL expressionList)	
	;

structuredType returns [String str=null;]{ if( DEBUG_RULENAMES ) println("OPAnalyzer."+"structuredType");}
:(PACKED)?
		(	arrayDecl 
			{ str= "<array>"; } 
		|	str=fileType 
			{ 	if( str != null ) 
					str = "<file of "+str+">";
				else
					str = "<file>";
//				println("###"+str);
			}
		|	{ if( DEBUG_RULENAMES ) println("OPAnalyzer."+"structuredType.record");}
			recordDecl { str= "<record>"; } 
				( PACKED { str= "<record_packed>"; } )?
		|	setType { str= "<set>"; }
		)
		{ assert str != null; }
	;

arrayDecl :#(ARRAY_DECL 
			(expressionRange)? // MB
			typeId) 
	;

functionCallOrTypecast returns [CommonASTWithLineNumber b]{ if( DEBUG_RULENAMES ) println("OPAnalyzer."+"functionCallOrTypecast");
		b = null;
	}
:#( DEREF	functionCallOrTypecast )
		| #(FUNC_CALL 
			(	qi:qualifiedIdentifier 
			|	s=t:typeId
			|	typeCast
			)
			#( PARAM_LIST (el1:expressionList)? )
			( el2:expressionList )?
			b1: (dereference | arrayDim )*
		)
	;

typeCast {	 if( DEBUG_RULENAMES ) println("OPAnalyzer."+"typeCast"); }
:#( TYPE_CAST (identifier|typeId) expressionList )
	;

primaryExpression { CommonASTWithLineNumber dn=null; }
:expression 			// geklammerte Expression
		|  	unsignedConstant
		|	dn=fc:functionCallOrTypecast // ( DEREF )*
		|	identifier // ( DEREF )*
		|	s=typeId
		|	typeCast
	;

// inherited from grammar OPTransformer
program :(programHeading)?
		programBlock
	;

// inherited from grammar OPTransformer
programHeading {   printRuleName("OPTransformer."+"programHeading"); 
		Vector temp;
	}
:#(PROGRAM  IDENT (temp=identList)? )
	;

// inherited from grammar OPTransformer
programBlock { printRuleName("OPTransformer."+"programBlock"); }
:( usesClause )*
		subprogramBody
	;

// inherited from grammar OPTransformer
package_ { printRuleName("OPTransformer."+"package_"); }
:#(PACKAGE 							
			IDENT
			(containsClause)?
		 )
	;

// inherited from grammar OPTransformer
library_ { printRuleName("OPTransformer."+"library_"); }
:#(LIBRARY
			IDENT 
			programBlock
		)
	;

// inherited from grammar OPTransformer
unit { printRuleName("OPTransformer."+"unit"); }
:#(UNIT
			IDENT 
			( directive	)? 
			unitBody
		)
	;

// inherited from grammar OPTransformer
unitBody ://		{ System.err.println("---- INTERFACE Section----"); }
		interfaceSection
//		{ System.err.println("---- IMPLEMENTATION Section----"); }
		implementationSection
 		(
 //			{ System.err.println("---- INITIALIZATION Section ----"); }
 			initSection	
 		)?
	;

// inherited from grammar OPTransformer
interfaceSection { printRuleName("OPTransformer."+"interfaceSection"+" #################################");  }
:#( INTERFACE
			(usesClause)?
			(interfaceSectionDecl)*
		)
	;

// inherited from grammar OPTransformer
implementationSection { printRuleName("OPTransformer."+"implementationSection"+" #################################");  }
:#( IMPLEMENTATION
			(usesClause)?
			(declSection[false])*
			(exportsStatement)*
		)
		
		{		
//			ListIterator li = getIn
//			##.addChild(); 
		
		}
		
	;

// inherited from grammar OPTransformer
exportsStatement :#(EXPORTS
			(
				identifier 
				(	(NAME|INDEX) constExpression 
					(
						(NAME|INDEX)  constExpression 
					)?
				)?
			
			)*
		)
	;

// inherited from grammar OPTransformer
initSection { printRuleName("OPTransformer."+"initSection"); }
:#(INITIALIZATION (statementList) 
			( finalization )?
		)
//	| 	compoundStatement
	;

// inherited from grammar OPTransformer
finalization { printRuleName("OPTransformer."+"finalization"); }
:#(FINALIZATION (statementList) )	
	;

// inherited from grammar OPTransformer
containsClause { printRuleName("OPTransformer."+"containsClause"); 
		Vector temp;
	}
:#(CONTAINS 
			temp=identList
		)
	;

// inherited from grammar OPTransformer
usesClause { printRuleName("OPTransformer."+"usesClause"); 
		Vector temp;
	}
:#(USES 
			temp=identList
		)
	;

// inherited from grammar OPTransformer
identList returns [Vector v]{ 	printRuleName("OPTransformer."+"identList"); 
		v = new Vector(); }
:#( IDLIST 
    		( id:identifier
    			{ v.addElement(getASTFactory().dup(id));}
    		)*
    	)
    ;

// inherited from grammar OPTransformer
identifier { printRuleName("OPTransformer."+"identifier"); }
:id:IDENT	
		{ 
			if( DEBUG_PRINT_IDENT_WITH_LINE )
				System.err.println(" $${"+#id.getText()+", "+#id.getLine()+"}"); 
		}
	;

// inherited from grammar OPTransformer
subprogramBody { printRuleName("OPTransformer."+"subprogramBody "); }
:( declSection[false] )*
  	(exportsStatement)?
	  	( mainProgram )?	//Optional main program "begin ... end"
  ;

// inherited from grammar OPTransformer
declSection[boolean isInnerDecl] { printRuleName("OPTransformer."+"declSection"); }
:#( DECL_SECT 
			(
				basicDecl 
			|	procedureDecl[isInnerDecl]
			| 	functionDecl[isInnerDecl]
	    	|	constructorDecl
    		|	destructorDecl
			)?
	   	)
	;

// inherited from grammar OPTransformer
basicDecl { printRuleName("OPTransformer."+"basicDecl"); }
:varDeclSection
	|	constDeclSection
	|	typeDeclSection
	|	labelDecl
	;

// inherited from grammar OPTransformer
typeDeclSection { printRuleName("OPTransformer."+"typeDeclSection"); }
:( typeDecl )+
	;

// inherited from grammar OPTransformer
comGuid :#( COM_GUID (STRING_LIT)? )
	;

// inherited from grammar OPTransformer
dispinterfacePropertyDecl :#( PRPTY_DECL
			id:IDENT
			(propertyParameterList)?
			s=typeId
			(propertySpecifiers|directive)*
		)
	;

// inherited from grammar OPTransformer
varDeclSection { printRuleName("OPTransformer."+"varDeclSection"); }
:// #( v:VAR_DECL 
			 ( varDecl )+ 
		//)
	;

// inherited from grammar OPTransformer
ordinalType :expressionRange //range
	|	integerConstant
	|	enumDecl
	|	booleanConstant
	|	qualifiedIdentifier //identifier
	|	s=predefinedType // DEBUG: eigentlich OrdIdent
	;

// inherited from grammar OPTransformer
charConstant :charLiteral
	;

// inherited from grammar OPTransformer
constDecl { printRuleName("OPTransformer."+"constDecl");	}
:#( ASSIGN 
			identifier 
			( 	{ String temp; } 
				temp=typeId
			)? 
			(	expression
			|	objectInitialization
			)
		)
	;

// inherited from grammar OPTransformer
objectInitialization :#(OBJ_INIT
			(
				(recordConstant)+
			|	(expression)+
			|	(objectInitialization)+
			)
		)
	;

// inherited from grammar OPTransformer
recordConstant :#(ASSIGN identifier expression)
	;

// inherited from grammar OPTransformer
unitIdent :#( UNIT_IDENT IDENT )
	;

// inherited from grammar OPTransformer
proceduralType :#(PROCEDURE
  			(formalParameters)?
  			(s=typeId)?
 			( directive )*
			( OF OBJECT )?
		)
	|	#(FUNCTION
  			(formalParameters)?
	  		(s=typeId)?
 			( directive )*
			( OF OBJECT )?
		)
	;

// inherited from grammar OPTransformer
predefinedType returns [String tok]{ tok = ""; }
:real48:REAL48 				{ tok = #real48.getText(); }
		|	single:SINGLE 				{ tok = #single.getText(); }
		|	double_:DOUBLE 				{ tok = #double_.getText(); }
		| 	real:REAL 					{ tok = #real.getText(); }
		|	boolean_:BOOLEAN 			{ tok = #boolean_.getText(); }
		|	integer:INTEGER 			{ tok = #integer.getText(); } 
		|	cardinal:CARDINAL 			{ tok = #cardinal.getText(); }
		|	shortint:SHORTINT 			{ tok = #shortint.getText(); }
		|	smallint:SMALLINT 			{ tok = #smallint.getText(); }
		|	longint:LONGINT 			{ tok = #longint.getText(); }
		|	int64:INT64 				{ tok = #int64.getText(); }
		|	byte_:BYTE 					{ tok = #byte_.getText(); }
		|	word:WORD 					{ tok = #word.getText(); }
		|	longword:LONGWORD 			{ tok = #longword.getText(); }
		|	ansistring:ANSISTRING 		{ tok = #ansistring.getText(); }
		|	widestring:WIDESTRING 		{ tok = #widestring.getText(); }
		|	variant:VARIANT 			{ tok = #variant.getText(); }
		|	olevariant:OLEVARIANT 		{ tok = #olevariant.getText(); }
		|	#(string:STRING 			{ tok = #string.getText(); }
				(constValue)?
			)
	;

// inherited from grammar OPTransformer
constValue ://	#( CONST_EXPR
		(	integerConstant
		|	unsignedReal
		|	booleanConstant
		|	charLiteral
		|	stringLiteral
		|	identifier 
	    |	NIL			
	   	) 
//   	)
	;

// inherited from grammar OPTransformer
constExpression :expression
	;

// inherited from grammar OPTransformer
integerConstant :#( UNARY_PLUS unsignedInteger )
  | #( UNARY_MINUS unsignedInteger )
  |	unsignedInteger
  ;

// inherited from grammar OPTransformer
unsignedInteger :INT_LIT
    |		HEX_CONST
 	;

// inherited from grammar OPTransformer
realConstant :#( UNARY_PLUS unsignedInteger )
  | #( UNARY_MINUS unsignedInteger )
  |	unsignedReal
  ;

// inherited from grammar OPTransformer
unsignedReal :REAL_LIT
	;

// inherited from grammar OPTransformer
booleanConstant :( TRUE | FALSE )
	;

// inherited from grammar OPTransformer
stringLiteral :STRING_LIT  							
    ;

// inherited from grammar OPTransformer
charLiteral :CHAR_LIT						
	| 	#(CHR INT_LIT)
	;

// inherited from grammar OPTransformer
mainProgram { printRuleName("OPTransformer."+"mainProgram");}
:#(MAIN_PROGRAM 
			{ printRuleName("OPTransformer."+"===================================");}
			compoundStatement 
		)
	;

// inherited from grammar OPTransformer
compoundStatement { printRuleName("OPTransformer."+"compundStatement");}
:statementList
	|	asmStatement
	;

// inherited from grammar OPTransformer
statementList { printRuleName("OPTransformer."+"statementList");}
:#( STMNT_LIST (statement)* )
	;

// inherited from grammar OPTransformer
statement { printRuleName("OPTransformer."+"statement");}
:( label )?	
	(	simpleStatement
	|	ifStatement
	|   compoundStatement
	|	tryStatement
	|	gotoStatement
	|	caseStatement
	|	raiseStatement
	|	emptyStatement
	|	withStatement
	|	forStatement
	|   whileStatement
	|	repeatStatement
	)
	;

// inherited from grammar OPTransformer
asmStatement :#( ASM	( #( META_INFO INT_LIT) )* )
	;

// inherited from grammar OPTransformer
whileStatement :#(	WHILE  
	  		expression
	  		statement
  	)
  ;

// inherited from grammar OPTransformer
repeatStatement :#(REPEAT
  		statementList
  		expression
  	)
  ;

// inherited from grammar OPTransformer
forStatement :#( FOR 
	  		#( ASSIGN identifier expression )
			(	#(TO expression )
			|	#(DOWNTO expression )
			)
			#( DO 		statement )
		)
	;

// inherited from grammar OPTransformer
withStatement :#(WITH expressionList statement )
	;

// inherited from grammar OPTransformer
emptyStatement :EMPTY_STMNT
	;

// inherited from grammar OPTransformer
label :#( LABEL ( identifier | INT_LIT ) )
	;

// inherited from grammar OPTransformer
ifStatement :#(IF expression statement (elseBlock )? )
    ;

// inherited from grammar OPTransformer
elseBlock :#(ELSE 			statement )
    	
	;

// inherited from grammar OPTransformer
gotoStatement :#(GOTO	identifier)
	;

// inherited from grammar OPTransformer
raiseStatement :#(RAISE
			( expression (raiseAt)? )? 
		)
	;

// inherited from grammar OPTransformer
raiseAt :#(AT expression)
	;

// inherited from grammar OPTransformer
caseStatement :#(CASE
			expression
			( caseSelector )+
			( caseElse	)?
		)
	;

// inherited from grammar OPTransformer
caseElse :#( ELSE statementList )
	;

// inherited from grammar OPTransformer
caseSelector :#( COLON 
			caseLabel ( COMMA caseLabel )* 
			statement 
		)
	;

// inherited from grammar OPTransformer
caseLabel :constExpression (DOTDOT constExpression )?
	;

// inherited from grammar OPTransformer
tryStatement :#( TRY statementList
			(	tryExceptStatement
			|	tryFinallyStatement
			)
		)
	;

// inherited from grammar OPTransformer
tryExceptStatement :#( EXCEPT exceptionBlock )
	;

// inherited from grammar OPTransformer
tryFinallyStatement :#(FINALLY statementList )
	;

// inherited from grammar OPTransformer
exceptionBlock :statementList
	|	(
			(exceptionOn)+
        	(exceptionElse)?
		)
	;

// inherited from grammar OPTransformer
exceptionOn :#(ON
			( identifier COLON )? 
			s=typeId 
			exceptionDo
		)
	;

// inherited from grammar OPTransformer
exceptionElse :#( ELSE statementList )
    ;

// inherited from grammar OPTransformer
exceptionDo :#( DO statement )
	;

// inherited from grammar OPTransformer
simpleStatement { printRuleName("OPTransformer."+"simpleStatement");}
:expr:
		expression 
//		{ if( ##.getFirstChild().getType() != FUNC_CALL ){
//				##.setType(FUNC_CALL);
//				##.setText("FUNC_CALL");
//				## = #([EXPR,"EXPR"],##); 
//			}
//		}
//		{ ## = #([FUNC_CALL],ex1); }
	|	#(ASSIGN expression  expression
		)
		
	;

// inherited from grammar OPTransformer
expressionList returns [Vector v]{ v = new Vector(); }
:#(EXPR_LIST 
    		(
    			expr:expression 
    			{ v.addElement(getASTFactory().dupTree(expr));}
    		)+ 
    	) 
    ;

// inherited from grammar OPTransformer
expression { printRuleName("OPTransformer."+"expression");
	}
:#( EXPR 	
			simpleExpression  // (exprTail)* 
//			( dereference )?
		)
	;

// inherited from grammar OPTransformer
simpleExpression { printRuleName("OPTransformer."+"expression");
	}
:(	 	#(EQUALS		simpleExpression simpleExpression)
		|	#(NOT_EQUALS	simpleExpression simpleExpression)
		|	#(LT			simpleExpression simpleExpression)
		|	#(LTE			simpleExpression simpleExpression)
		|	#(GT 			simpleExpression simpleExpression)
		|	#(GTE 			simpleExpression simpleExpression)
		|	#(IN 			simpleExpression simpleExpression)
	
		|	#(PLUS			simpleExpression simpleExpression)
		|	#(MINUS 		simpleExpression simpleExpression)
		|	#(OR 			simpleExpression simpleExpression)
		|	#(XOR 			simpleExpression simpleExpression)
	
	    |	#(TIMES 		simpleExpression simpleExpression)
		|	#(DIVIDE 		simpleExpression simpleExpression)
		|	#(MOD 			simpleExpression simpleExpression)
		|	#(DIV 			simpleExpression simpleExpression)
		|	#(AND 			simpleExpression simpleExpression)
		|	#(SHL 			simpleExpression simpleExpression)
		|	#(SHR 			simpleExpression simpleExpression)
		|	#(IS 			simpleExpression simpleExpression)
	 	|	#(AS 			simpleExpression simpleExpression
//	 						{ String temp;}
//	 						temp=typeId 
	 						)
	 	|	#(NOT			simpleExpression)
	 	|	#(ADDR_OP		simpleExpression)
		|	#(UNARY_PLUS	simpleExpression)
		|	#(UNARY_MINUS	simpleExpression)
		|	#(INHERITED 	(simpleExpression)? )
	 	|   #(DOT 			simpleExpression simpleExpression)
		|	primaryExpression
	)
	( dereference
		|	arrayDim
		 )*
 	;

// inherited from grammar OPTransformer
dereference :( DEREF )+
	;

// inherited from grammar OPTransformer
arrayDim { printRuleName("OPTransformer."+"arrayDim");
	}
:( options{greedy=true;}
			: 
			#( ARRAY_INDEX (arrayDim)? expression	)
		)+
	;

// inherited from grammar OPTransformer
unsignedConstant :unsignedInteger
    | 	unsignedReal
	|	booleanConstant
	|	charLiteral
	|	stringLiteral
	|	setConstructor
    |	NIL
    ;

// inherited from grammar OPTransformer
setConstructor { printRuleName("OPTransformer."+"setConstructor");}
:#(SET_CONSTR
			(	(expressionRange)+
			|	() // EMPTY_SET
			)
		)
	;

// inherited from grammar OPTransformer
qualifiedIdentifier returns [String str]{ printRuleName("OPTransformer."+"qualifiedIdentifier"); 
	  String temp=new String();
		str=new String();
	}
:#( id:IDENT 
			{   
//				System.err.println("$$ "+#id.getText()+", "+#id.getLine()); 
				str = id.getText();
			}
			(
				temp=qualifiedIdentifier
				{ str = str+"."+temp; }
			)* 
		)
	;

// inherited from grammar OPTransformer
directive :{ printRuleName("OPTransformer."+"directive"); }
	#( DIRECTIVE
		(	#(MESSAGE constValue)
		| 	directiveExternal
		|	#(DISPID integerConstant)
		|	CDECL	
		|	ABSTRACT
		|	DYNAMIC
		|	EXPORT
		|	FAR
		|	FORWARD		
		|	LOCAL
		|	NEAR
		|	OVERLOAD
		|	OVERRIDE
		|	PASCAL
		|	REGISTER
		|	REINTRODUCE
		|	SAFECALL
		|	STDCALL
		|	VARARGS
		|	VIRTUAL
		|	ASSEMBLER
		|	READONLY 
		|	WRITEONLY	
		)+
	)
	;

// inherited from grammar OPTransformer
directiveName :#(NAME
			(	(stringLiteral|IDENT)
				( PLUS (stringLiteral|IDENT) )* 
			)? 
		)
	;

// inherited from grammar OPTransformer
directiveIndex :#( INDEX INT_LIT )
	;

// inherited from grammar OPTransformer
directiveExternal :#(EXTERNAL 
			(	(stringLiteral|IDENT)
				( PLUS (stringLiteral|IDENT) )* 
			)? 
			( directiveName		
			|	directiveIndex )*
		)
	;

// inherited from grammar OPTransformer
parameterSpec! returns [Vector params]{	printRuleName("OPTransformer."+"parameterSpec"); 
		Vector il;
		params = new Vector(); 
	}
:#( ps:PARAM_SPEC 
  			(var_:VAR|const_:CONST|out_:OUT)? 
  			il=identList
  			( s=t:typeId )?
 			( EQUALS constExpression )?
 		)
  		{	CommonASTWithLineNumber subAst;
			CommonASTWithLineNumber ruleAst=new CommonASTWithLineNumber(new Token(PARAM_SPEC));

			for(int i=0;i<il.size();i++){
	  			subAst = new CommonASTWithLineNumber();
	  			subAst.setType(PARAM_SPEC);
	  			subAst.setText("PARAM_SPEC");
				subAst.addChild(((CommonASTWithLineNumber)il.elementAt(i)));
				if ( t != null) 
					subAst.addChild(getASTFactory().dupTree(t));
				/* if( var_ != null ) 
					subAst.addChild(getASTFactory().dupTree(var_));
				if( const_ != null )
					subAst.addChild(getASTFactory().dupTree(const_));
				if( out_ != null )
					subAst.addChild(getASTFactory().dupTree(out_));
				*/	

				ruleAst.addChild(subAst);
				params.addElement(getASTFactory().dupTree(subAst));
			}
			##=ruleAst;
  		}
	;

// inherited from grammar OPTransformer
setType :#( SET ordinalType (directive)? )
	;

// inherited from grammar OPTransformer
fileType returns [String t=null;]{	printRuleName("OPTransformer."+"fileType"); 
		}
:#( FILE_TYPE 
			(
				t=typeId
			)? 
		)
	;

// inherited from grammar OPTransformer
recordDecl {	printRuleName("OPTransformer."+"recordDecl"); }
:#( RECORD_DECL 
			(varDecl)*
			( variantSection )?
			( directive )?
		)
	;

// inherited from grammar OPTransformer
variantSection {	printRuleName("OPTransformer."+"variantSection"); 
		Vector temp=null;
	}
:#(VARIANT_SECT
			 // switch
			#(VAR_DECL 
				//temp=identList
				#(IDLIST (identifier)? )  
				s=typeId
			) // only type possible

			(
				#(COLON 
					// #(EXPR constValue)
					( #(EXPR constValue) )+
					(varDecl)*
				)
			)+
		)
	;

// inherited from grammar OPTransformer
expressionRange {	printRuleName("OPTransformer."+"expressionRange");  }
:#(EXPR 
			(	simpleExpression 
			|	#(RANGE expression expression) 
			)
		)
	;

// inherited from grammar OPTransformer
classVisibilityDecl {	printRuleName("OPTransformer."+"classVisibilityDecl"); 
	}
:#(PUBLIC    (classElementDecl)* )
	|	#(AUTOMATED	(classElementDecl)* )
	|	#(PUBLISHED	(classElementDecl)* )
	|	#(PRIVATE	(classElementDecl)* )
	|	#(PROTECTED	(classElementDecl)* )
	;

// inherited from grammar OPTransformer
classElementDecl {	printRuleName("OPTransformer."+"classElementDecl"); }
:varDecl 
	|	classMethodDecl
	|	propertyDecl
	|	recordDecl
	|	arrayDecl
	;

// inherited from grammar OPTransformer
propertyDecl :#( PRPTY_DECL
			id:IDENT
			(propertyParameterList)?
			( s=typeId )?
			(propertySpecifiers)*
		)
	;

// inherited from grammar OPTransformer
propertyParameterList { printRuleName("OPTransformer."+"propertyParameterList"); }
:parameterList
	
	;

// inherited from grammar OPTransformer
propertySpecifiers :#( READ id_read:IDENT )
	|	#( WRITE id_write:IDENT )
	| 	#( INDEX
			(	constValue
		//	|	enumDecl
		//	|	setConstructor 
			)? 
		)
	| 	#( STORED propertySpecifiersValue
				//id_store:IDENT 
			)
	|	( #(DEFAULT propertySpecifiersValue)
		|	NODEFAULT 
		)
	| 	IMPLEMENTS 
	;

// inherited from grammar OPTransformer
propertySpecifiersValue :(	constValue
	|	enumDecl
	|	setConstructor 
	)
	;

// inherited from grammar OPTransformer
propertyInterface :(propertyParameterList)? 
		s=typeId
	;

// inherited from grammar OPTransformer
constructorDecl { printRuleName("OPTransformer."+"constructorDecl");}
:#( CONSTR_DECL
	  		constructorHeading // procedureHeading 
  			(declSection[false])+
			compoundStatement
		)
		
	;

// inherited from grammar OPTransformer
constructorHeading :qualifiedIdentifier //IDENT ( DOT^ identifier )*
			( formalParameters )? 
			( directive )*
  	;

// inherited from grammar OPTransformer
destructorDecl { printRuleName("OPTransformer."+"destructorDecl");}
:#(DESTR_DECL
	  		destructorHeading // procedureHeading 
  			(declSection[false])+
			compoundStatement
		)
	;

// inherited from grammar OPTransformer
destructorHeading :qualifiedIdentifier //IDENT ( DOT^ identifier )*
			( formalParameters )? 
			( directive )*
  	;


