/*
 * Copyright (c) 2004-2005 CAS Software AG, 
 * 10 Wilhelm-Schickard Street, 76131 Karlsruhe, Germany
 * 
 * Copyright (c) 2004-2006 FZI Forschungszentrum Informatik, 
 * 10-14 Haid-und-Neu Street, 76131 Karlsruhe, Germany
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/*
	$Header: /cvsroot/sissy/SISSy/src/de/fzi/delphi/parser/dpr_tree_srf.g,v 1.3 2008/04/23 18:49:34 mtrifu Exp $
*/


/*
	set MAIN_JAR=Dpr2Srf-20040921.jar
	FOR %%i IN ( *.dpr) DO (
			java -jar c:\eclipse\workspace\OPParser\dist\%MAIN_JAR%.jar %%~ni.dpr %%~ni.srf
	        )
	        
	copy header.srf all_dprs.srf
	FOR %%i IN ( *.srf ) DO (
			copy all_dprs.srf + %%i temp.srf
			copy temp.srf all_dprs.srf
	        )
	del temp.srf
*/


header{	
	// Package
	package de.fzi.delphi.parser;
	// Imports
    import java.io.PrintStream;

import antlr.ASTPair;
import antlr.CommonAST;
import antlr.NoViableAltException;
import antlr.RecognitionException;
import antlr.collections.AST;


}
class DPRTree2SRF extends TreeParser;
options {
	buildAST=true;
	ASTLabelType = "CommonAST";
	importVocab = DPRParser;
}
{
	String projectName = "";
	PrintStream outStream = System.out;
	
}
goal [PrintStream out]
{
	if( out != null )
		outStream = out;	
}
	:	
		( 	libraryClause
		|	programClause )
		( usesClause )?
		( exportsClause )?
	;

libraryClause
	:	#( LIBRARY 
			id:IDENT 
			{ projectName = id.getText(); 
				outStream.println("Subsystem\t"+projectName);
			}
		)
	;

programClause
	:	#( PROGRAM 
			id:IDENT 
			{ projectName = id.getText(); 
				outStream.println("Subsystem\t"+projectName);
			}
		)
	;
		
usesClause
{	String unitName; } 
	:	#( USES
			( unitName=unitEntry 
			
				{ 
					outStream.println("Unit\t"+unitName); 
					outStream.println("containsUnit\t"+projectName+"\t"+unitName); 
				}
			)+
		)
	;

unitEntry returns [String s = null]

	:	#( id:IDENT 
			{ s = id.getText(); }
			( unitInFile )?
		)
	;

unitInFile
	:
		#( IN 
			STRING_LIT
		)
	;
exportsClause
	:	#( EXPORTS
			( IDENT )+
		)
	;
	