/*
 * Copyright (c) 2004-2005 CAS Software AG, 
 * 10 Wilhelm-Schickard Street, 76131 Karlsruhe, Germany
 * 
 * Copyright (c) 2004-2006 FZI Forschungszentrum Informatik, 
 * 10-14 Haid-und-Neu Street, 76131 Karlsruhe, Germany
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/*
	$Header: /cvsroot/sissy/SISSy/src/de/fzi/delphi/parser/dpr_parser.g,v 1.3 2008/04/23 18:49:34 mtrifu Exp $
*/

header{	// Package
	package de.fzi.delphi.parser;
	// Imports
    import java.util.List;
    import java.util.Vector;
    import antlr.*;
}
class DPRParser extends Parser;
options {
	buildAST=true;
	ASTLabelType = "CommonAST";
	k = 1; 
	importVocab=OPLexer;	
	exportVocab=DPRParser;	
	defaultErrorHandler=false;
}

goal returns [List l=null]
{ l = new Vector(); }
	:	( 	libraryClause
		|	programClause 
		)
		( l=usesClause )?
		
		/* we need to exit now, because
		   we don't want to parse the crap 
		   that could follow from now on. */
{
	// Skip rest of file
	if( LA(0) != EOF ){
		goal_AST = (CommonAST)currentAST.root;
		returnAST = goal_AST;
		return l;
	}
}		
		( exportsClause )?
	//	{	consumeUntil(BEGIN); }
		BEGIN! 		
		{ consumeUntil(END); }
		END! 
		DOT!
	;

libraryClause
	:	LIBRARY^ IDENT SEMI!
	;

programClause
	:	PROGRAM^ IDENT SEMI!
	;
		
usesClause returns [List l]
{ l = new Vector(); 
	String temp;
}
	:	USES^
	
		temp = unitEntry
		{ l.add(temp); }
		( COMMA! temp=unitEntry
			{ l.add(temp); }
		)*
		SEMI!
	;

unitEntry! returns [String s]
{	String file=null; }
	:	unit:IDENT ( file=t:unitInFile )?
		{
			if( file != null )
				s = file;
			else
				s = unit.getText();		
			
			## = #( #unit ,#t); 
		}
	;

unitInFile returns [String s]
	:
		IN^ file:STRING_LIT
		{ s = file.getText(); }
	;
exportsClause
	:	EXPORTS^
		IDENT 
		( COMMA! IDENT )*
		SEMI!
	;
	