/*
 * Copyright (c) 2004-2005 CAS Software AG, 
 * 10 Wilhelm-Schickard Street, 76131 Karlsruhe, Germany
 * 
 * Copyright (c) 2004-2006 FZI Forschungszentrum Informatik, 
 * 10-14 Haid-und-Neu Street, 76131 Karlsruhe, Germany
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
header{	// Package
	package de.fzi.delphi.parser;
	// Imports
	import de.fzi.delphi.parser.debug.*;
	import de.fzi.delphi.CodeblockInfo;
	import java.awt.Point;
    import antlr.*;
	import java.io.FileInputStream;
	import java.io.FileNotFoundException;
}

class AsmParser extends Parser;
options{
	importVocab=Asm;
	k=2;
	buildAST=true;
	//ASTLabelType = "de.fzi.delphi.CommonASTWithLineNumber";
}

tokens{
	ASM_LABEL;
	PREFIX;
	OPCODE;
	ADDRESS;
	OPERAND;
}
{
	int branches=0;

	public static void main(String args[]){
//		de.fzi.delphi.parser.debug.LexerFrame lf = new de.fzi.delphi.parser.debug.LexerFrame(AsmLexer.class, AsmParserTokenTypes.class);
// 		lf.show();

		AsmLexer lexer=null;
		try {
			lexer = new AsmLexer(new FileInputStream("z:\\test1.asm"));
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		AsmParser parser = new AsmParser(lexer);
		
		try {
			parser.goal();
		} catch (RecognitionException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (TokenStreamException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		
		CommonASTFrame.show(parser,(CommonAST)parser.getAST(),
				   "titel",
				   new Point(600,24)		);		
	}
	
}

goal
	:	( asmBlock
			( NEWLINE! )*
		)+
	;
	
asmBlock
	:	ASM^ 
		( asmBody )?
		END! SEMI!
	;
	

asmBody returns [CodeblockInfo ci = new CodeblockInfo()]
	:	( 
//			{LA(2) == COLON}? label
//	    	|   () 
    	)
    	(
    	 	label (operation)? NEWLINE!
		| operation NEWLINE!
		|	NEWLINE!
		)+
		
		{ 	ci.setType(CodeblockInfo.ASM);
			ci.setBranches(branches); 
		}
	;

operation
{ 	
	java.util.Vector branchOps = new java.util.Vector();
	branchOps.addElement("call");
	branchOps.addElement("callw");
	branchOps.addElement("loop");
	branchOps.addElement("loope");
	branchOps.addElement("loopne");
	branchOps.addElement("loopnz");
	branchOps.addElement("loopz");
	branchOps.addElement("ja");
	branchOps.addElement("jae");
	branchOps.addElement("jb");
	branchOps.addElement("jbe");
	branchOps.addElement("jc");
	branchOps.addElement("jcxz");
	branchOps.addElement("je");
	branchOps.addElement("jecxz");
	branchOps.addElement("jg");
	branchOps.addElement("jge");
	branchOps.addElement("jl");
	branchOps.addElement("jle");
	branchOps.addElement("jmp");
	branchOps.addElement("jna");
	branchOps.addElement("jnae");
	branchOps.addElement("jnb");
	branchOps.addElement("jnbe");
	branchOps.addElement("jnc");
	branchOps.addElement("jne");
	branchOps.addElement("jng");
	branchOps.addElement("jnge");
	branchOps.addElement("jnl");
	branchOps.addElement("jnle");
	branchOps.addElement("jno");
	branchOps.addElement("jnp");
	branchOps.addElement("jns");
	branchOps.addElement("jnz");
	branchOps.addElement("jo");
	branchOps.addElement("jp");
	branchOps.addElement("jpe");
	branchOps.addElement("jpo");
	branchOps.addElement("js");
	branchOps.addElement("jz");
}
	:	// Prefix
		id:IDENT^ { #id.setType(OPCODE); }
		{ 
			if( branchOps.contains(#id.getText().toLowerCase()) )
				branches++;
		}
		(operands)?
	;

operands
	:		operand ( COMMA! operand )* 
	;
	
expression
	:	simpleExpression
	;
	
simpleExpression
	:	term(
			( ( PLUS^ | MINUS^ )  term )*
		)
	;
	
term
	:	factor (
			( ( TIMES^ | DIVIDE^ | DOT^ )  factor )*
		)
	;
	
factor 
	:	id1:IDENT {id1.setType(OPERAND); }
		(factor)?
	|	a:LBRACKET^ 
		{ #a.setType(ADDRESS); }
		expression 
		RBRACKET! 
	|	LPAREN^ expression RPAREN!
	|	INT_LIT
	|	STRING_LIT
	|	HEX_CONST
	|	PTR factor
	;
	
operand 
	:	factor	( DOT^ factor )*
	|	LOCAL_LABEL
	;
	
 
label
	:	a:IDENT^ COLON! { a.setType(ASM_LABEL); }
	|	b:LOCAL_LABEL^ COLON! { b.setText(b.getText().substring(1)); }
	;

