/*
 * Copyright (c) 2004-2005 CAS Software AG, 
 * 10 Wilhelm-Schickard Street, 76131 Karlsruhe, Germany
 * 
 * Copyright (c) 2004-2006 FZI Forschungszentrum Informatik, 
 * 10-14 Haid-und-Neu Street, 76131 Karlsruhe, Germany
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
header{	// Package
	package de.fzi.delphi.parser;
	// Imports
	import de.fzi.delphi.OPDebug;
	import de.fzi.delphi.parser.debug.*;
    import antlr.*;
}

class AsmLexer extends Lexer;
options {
            charVocabulary = '\0'..'\377';
            testLiterals=false;    			// don't automatically test for literals
			caseSensitive=false;
            caseSensitiveLiterals=false;
       		importVocab=Common;
       		exportVocab=Asm;
		    k=3;
  }
tokens{
	ASM_REAL;
}
{
	static boolean SKIP_TOKENS = true;
	static int lines=0;
	
	int getLines(){
		return lines;
	}
	public void newline(){
		lines++;
		super.newline();
	}
}

END	:	"end" 
		{	
  			String str = ""+(getLines()-1); // ohne "end"
   			$setText(str);
			
			OPLexer.selector.pop();
			OPDebug.debugPrintln(3,"Switching back from ASM Lexer"); 
		} 
	;

PTR : "ptr"
	{ if (SKIP_TOKENS) $setType(Token.SKIP); }
	;

DOT : '.'
	{ if (SKIP_TOKENS) $setType(Token.SKIP); }
	;
COMMA : ','
	{ if (SKIP_TOKENS) $setType(Token.SKIP); }
	;
COLON : ':'
	{ if (SKIP_TOKENS) $setType(Token.SKIP); }
	;
SEMI : ';'
	{ if (SKIP_TOKENS) $setType(Token.SKIP); }
	;
LPAREN     : '('  
	{ if (SKIP_TOKENS) $setType(Token.SKIP); }
	;
RPAREN     : ')'  
	{ if (SKIP_TOKENS) $setType(Token.SKIP); }
	;
LBRACKET : '['
	{ if (SKIP_TOKENS) $setType(Token.SKIP); }
	;
RBRACKET : ']'
	{ if (SKIP_TOKENS) $setType(Token.SKIP); }
	;
PLUS:	'+'
	{ if (SKIP_TOKENS) $setType(Token.SKIP); }
	;
MINUS:	'-'	
	{ if (SKIP_TOKENS) $setType(Token.SKIP); }
	;
TIMES:	'*'
	{ if (SKIP_TOKENS) $setType(Token.SKIP); }
	;
DIVIDE:	'/'
	{ if (SKIP_TOKENS) $setType(Token.SKIP); }
	;

// Literals
INT_LIT
{ 	boolean isHex = false; }
	:	('0'..'9')+ 
		(	(	{(LA(2)!='.')&&(LA(2)!=')')}?
				'.' {$setType(ASM_REAL);}	
				('0'..'9')+ (EXPONENT)?
			)?
		|	EXPONENT {$setType(ASM_REAL);}
		|	( 'a'..'f' {isHex = true; } 
			| WS )+ 
		)
		( (WS)* 'h' {isHex = true;} )?
		
		{ if( isHex ) $setType(HEX_CONST); }
		{ if (SKIP_TOKENS) $setType(Token.SKIP); }
	;

// a couple protected methods to assist in matching floating point numbers
protected
EXPONENT
	:	('e') ('+'|'-')? ('0'..'9')+
	{ if (SKIP_TOKENS) $setType(Token.SKIP); }

;
	
HEX_CONST
	:	'$' ('0'..'9'|'a'..'f')+ 
	{ if (SKIP_TOKENS) $setType(Token.SKIP); }
	;
	
// Comments
// Single-line comments
COMMENT
  : "//" ( ~('\n'|'\r') )* 
  	{ $setType(Token.SKIP);  	}
  ;  
// multiple-line comments
ML_COMMENT1 // { }
    : '{'
   // 	~('$')
	    (   /*  '\r' '\n' can be matched in one alternative or by matching
	                '\r' in one iteration and '\n' in another.  I am trying to
	                handle any flavor of newline that comes in, but the language
	                that allows both "\r\n" and "\r" and "\n" to all be valid
	                newline is ambiguous.  Consequently, the resulting grammar
	                must be ambiguous.  I'm shutting this warning off.
	             */
	        options { generateAmbigWarnings=false; }
	    	:	'\r' '\n'{	newline();
	    				}
	        |	'\r'	{	newline();
	        				}
	        |	'\n'	{	newline();
	        				}
	        |	~('}'|'\n'|'\r')
	    )*
    '}'
    { $setType(Token.SKIP); }
;

ML_COMMENT2 // (* *)
    : "(*"
        (   /*  '\r' '\n' can be matched in one alternative or by matching
                '\r' in one iteration and '\n' in another.  I am trying to
                handle any flavor of newline that comes in, but the language
                that allows both "\r\n" and "\r" and "\n" to all be valid
                newline is ambiguous.  Consequently, the resulting grammar
                must be ambiguous.  I'm shutting this warning off.
             */
        options { generateAmbigWarnings=false; }
    : { LA(2)!=')' }? '*'
        |'\r' '\n'{newline();
			        }
        |'\r'{newline();
        }
        |'\n'{newline();
        }
        |~('*'|'\n'|'\r')
        )*
        "*)"
	{$setType(Token.SKIP);}
;

WS  :   (        options { generateAmbigWarnings=false; }
		:
		   ' '
        |   '\t'
        )
        {$setType(Token.SKIP);} //ignore this token
    ;

NEWLINE
	:(	'\r' '\n' { newline(); } // DOS
	|   '\n'      { newline(); } // Unix
	|   '\r'      { newline(); } // Mac
	)
	{ if (SKIP_TOKENS) $setType(Token.SKIP); }
	;

LOCAL_LABEL
	:	('@')+ ( 'a'..'z' | '0'..'9' | '_' )+
	{ if (SKIP_TOKENS) $setType(Token.SKIP); }
	;

//ADDRESS
//	:	LBRACKET! IDENT RBRACKET!
//	;
	
IDENT  
options { 
	testLiterals=true;
        } 
    :   ( 'a'..'z' | '_' )( 'a'..'z' | '0'..'9' | '_' )*
	{ if (SKIP_TOKENS) $setType(Token.SKIP); }
    ;
    
  
STRING_LIT
		{ int length=0; }
	:
	(
		( // String in Anfhrungszeichen '
			'\''!
	   		( 	'\'' '\''!
			|	~('\''|'\n'|'\r')
	    			{ length++;}
	    	)*
	    	(	'\''!
	    	|	// nothing -- write error message (illegal, so we'll assume it ends the string)
	    	)
		)
		|	{ StringBuffer tempString = new StringBuffer(); 
			  int l;
			}
			( '#'! 
				( '0'..'9' { l=1; } ) 			    			{ length++;}
				(('0'..'9' { l=2; } ) 			    			{ length++;}
				 ('0'..'9' { l=3; } )? 			    			{ length++;}
				 )?
			  { 
			  	tempString.append((char)Integer.parseInt($getText.substring($getText.length()-l))); 
			  }
			 (' ')*
			)+
			
			{ 
				$setText(tempString.toString()); 
			}
		|	( '#' HEX_CONST )
    )
    { if (SKIP_TOKENS) $setType(Token.SKIP); }
    ;
