/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.delphi.types;

import de.fzi.delphi.symbols.Method;
import de.fzi.delphi.symbols.Scope;
import de.fzi.delphi.symbols.Symbol;
import de.fzi.delphi.symbols.TypedSymbol;
import de.fzi.delphi.symbols.types.CharacterType;
import de.fzi.delphi.symbols.types.ClassType;
import de.fzi.delphi.symbols.types.EnumeratedType;
import de.fzi.delphi.symbols.types.IntegerType;
import de.fzi.delphi.symbols.types.NilType;
import de.fzi.delphi.symbols.types.OrdinalType;
import de.fzi.delphi.symbols.types.PointerType;
import de.fzi.delphi.symbols.types.ProceduralType;
import de.fzi.delphi.symbols.types.Range;
import de.fzi.delphi.symbols.types.RangedType;
import de.fzi.delphi.symbols.types.RealType;
import de.fzi.delphi.symbols.types.SetType;
import de.fzi.delphi.symbols.types.SimpleType;
import de.fzi.delphi.symbols.types.StringType;
import de.fzi.delphi.symbols.types.SubrangeType;
import de.fzi.delphi.symbols.types.UserDefinedType;
import java.util.Iterator;
import java.util.ListIterator;

public abstract class Type
extends TypedSymbol {
    protected static final boolean DEBUG = false;
    public static Type NULL = NilType.get();
    private static StringType stringType = null;
    private static IntegerType integerType = null;
    private static IntegerType int64Type = null;
    private static RealType realType = null;
    private static RealType extendedType = null;
    private static EnumeratedType booleanType = null;
    private static CharacterType characterType = null;

    public Type(int hash) {
        super(hash);
    }

    public Type(Type t) {
        this.line = t.getLine();
        this.nameHash = t.getNameHash();
        this.resolved = t.isResolved();
        this.scope = t.getScope();
        this.type = t.getType();
    }

    public Type(String typeId) {
        if (typeId == null) {
            throw new NullPointerException();
        }
        this.setName(typeId);
    }

    @Override
    public String toString() {
        String path = "";
        String ret = "";
        if (this.getScope() != null) {
            path = this.getScope().getFullName();
            path = String.valueOf(path) + ".";
        }
        ret = String.valueOf(path) + this.getName();
        return ret;
    }

    public boolean isAssignmentCompatible(Type otherType) {
        Type t1 = otherType;
        Type t2 = this;
        if (t2 == null || t1 == null) {
            return false;
        }
        if ((t2.isInstanceOf("RangedType") || t2.isRealType()) && (t1.isInstanceOf("RangedType") || t1.isRealType())) {
            if (t2.isInstanceOf("RangedType") && t1.isInstanceOf("RangedType") && ((RangedType)((Object)t2)).getRange() != null && ((RangedType)((Object)t1)).getRange() != null) {
                if (!t2.isSubrangeOf(t1)) {
                    return false;
                }
            } else {
                if (t2.isRealType() && t1.isInstanceOf("RangedType")) {
                    return false;
                }
                if (!(t2.isInstanceOf("RangedType") && t1.isRealType() || !t2.isRealType() || !t1.isRealType() || ((RealType)t2).isAssignmentCompatibleWithRealType((RealType)t1))) {
                    return false;
                }
            }
        }
        if (t1.equals(t2) && !t2.isFileType()) {
            return true;
        }
        if (t1.isOrdinalType() && t2.isOrdinalType() && t2.isTypeCompatible(t1)) {
            return true;
        }
        if (t1.isRealType() && t2.isRealType()) {
            return true;
        }
        if (t1.isRealType() && t2.isIntegerType()) {
            return true;
        }
        if (t1.isStringType() && t2.isStringType()) {
            return true;
        }
        if (t1.isStringType() && (t2.isCharacterType() || t2.isPackedStringType())) {
            return true;
        }
        if (t1.isPackedStringType() && t2.isPackedStringType() && t2.isTypeCompatible(t1)) {
            return true;
        }
        if (t1.isSetType() && t2.isSetType() && t2.isTypeCompatible(t1)) {
            return true;
        }
        if (t1.isPointerType() && t2.isPointerType() && t2.isTypeCompatible(t1)) {
            return true;
        }
        if (t1.isProceduralType() && t2.isProceduralType() && t2.isTypeCompatible(t1)) {
            return true;
        }
        if ((t1.isInterface() || t1.isClassType()) && (t2.isInterface() || t2.isClassType()) && t2.isDerivedFrom((ClassType)t1)) {
            return true;
        }
        if (t1.isInterface() && t2.isClassType() && ((ClassType)t2).instanceOf((ClassType)t1)) {
            return true;
        }
        if (t1.isVariantType() && (t2.isIntegerType() || t2.isRealType() || t2.isStringType() || t2.isCharacterType() || t2.isBoolean() || t2.isInterface() || t2.isOleVariant())) {
            return true;
        }
        if (t1.isOleVariant() && (t2.isIntegerType() || t2.isRealType() || t2.isStringType() || t2.isCharacterType() || t2.isBoolean() || t2.isInterface() || t2.isVariantType())) {
            return true;
        }
        if ((t2.isIntegerType() || t2.isRealType() || t2.isStringType() || t2.isCharacterType() || t2.isBoolean()) && (t2.isVariantType() || t2.isOleVariant())) {
            return true;
        }
        if (t1.isInterface() && (t1.getName().equalsIgnoreCase("IUnknown") || t1.getName().equalsIgnoreCase("IDispatch")) && (t2.isVariantType() || t2.isOleVariant())) {
            return true;
        }
        return t1.isStringType() && t1.getName().equalsIgnoreCase("ANSIString") && (t2.getName().equalsIgnoreCase("PChar") || t2.getName().equalsIgnoreCase("PWideChar"));
    }

    protected boolean isAssignmentCompatibleWithRealType(RealType otherType) {
        if (otherType.getName().equalsIgnoreCase(this.getName())) {
            return true;
        }
        if (otherType.getName().equalsIgnoreCase("extended")) {
            return true;
        }
        if (otherType.getName().equalsIgnoreCase("double") || otherType.getName().equalsIgnoreCase("real")) {
            if (this.getName().equalsIgnoreCase("real")) {
                return true;
            }
            if (this.getName().equalsIgnoreCase("double")) {
                return true;
            }
            if (this.getName().equalsIgnoreCase("real48")) {
                return true;
            }
            if (this.getName().equalsIgnoreCase("single")) {
                return true;
            }
        }
        return false;
    }

    private static boolean realAssignmentCompatibilityTests() {
        RealType extended = new RealType("extended");
        RealType currency = new RealType("currency");
        RealType double_ = new RealType("double");
        RealType real = new RealType("real");
        RealType real48 = new RealType("real48");
        RealType single = new RealType("single");
        boolean result = true;
        assert (result &= extended.isAssignmentCompatibleWithRealType(extended));
        assert (result &= !extended.isAssignmentCompatibleWithRealType(currency));
        assert (result &= !extended.isAssignmentCompatibleWithRealType(double_));
        assert (result &= !extended.isAssignmentCompatibleWithRealType(real));
        assert (result &= !extended.isAssignmentCompatibleWithRealType(real48));
        assert (result &= !extended.isAssignmentCompatibleWithRealType(single));
        assert (result &= currency.isAssignmentCompatibleWithRealType(extended));
        assert (result &= currency.isAssignmentCompatibleWithRealType(currency));
        assert (result &= !currency.isAssignmentCompatibleWithRealType(double_));
        assert (result &= !currency.isAssignmentCompatibleWithRealType(real));
        assert (result &= !currency.isAssignmentCompatibleWithRealType(real48));
        assert (result &= !currency.isAssignmentCompatibleWithRealType(single));
        assert (result &= double_.isAssignmentCompatibleWithRealType(extended));
        assert (result &= !double_.isAssignmentCompatibleWithRealType(currency));
        assert (result &= double_.isAssignmentCompatibleWithRealType(double_));
        assert (result &= double_.isAssignmentCompatibleWithRealType(real));
        assert (result &= !double_.isAssignmentCompatibleWithRealType(real48));
        assert (result &= !double_.isAssignmentCompatibleWithRealType(single));
        assert (result &= real.isAssignmentCompatibleWithRealType(extended));
        assert (result &= !real.isAssignmentCompatibleWithRealType(currency));
        assert (result &= real.isAssignmentCompatibleWithRealType(double_));
        assert (result &= real.isAssignmentCompatibleWithRealType(real));
        assert (result &= !real.isAssignmentCompatibleWithRealType(real48));
        assert (result &= !real.isAssignmentCompatibleWithRealType(single));
        assert (result &= real48.isAssignmentCompatibleWithRealType(extended));
        assert (result &= !real48.isAssignmentCompatibleWithRealType(currency));
        assert (result &= real48.isAssignmentCompatibleWithRealType(double_));
        assert (result &= real48.isAssignmentCompatibleWithRealType(real));
        assert (result &= real48.isAssignmentCompatibleWithRealType(real48));
        assert (result &= !real48.isAssignmentCompatibleWithRealType(single));
        assert (result &= single.isAssignmentCompatibleWithRealType(extended));
        assert (result &= !single.isAssignmentCompatibleWithRealType(currency));
        assert (result &= single.isAssignmentCompatibleWithRealType(double_));
        assert (result &= single.isAssignmentCompatibleWithRealType(real));
        assert (result &= !single.isAssignmentCompatibleWithRealType(real48));
        assert (result &= single.isAssignmentCompatibleWithRealType(single));
        return true;
    }

    private boolean isOleVariant() {
        return this.isVariantType() && this.getName().equalsIgnoreCase("OleVariant");
    }

    public boolean isPackedStringType() {
        return this.isStringType() && ((StringType)this).isPacked();
    }

    public boolean isNilType() {
        return this == Type.getNilType();
    }

    @Override
    public Type getType() {
        return this;
    }

    public Scope getCorrespondingScope() {
        if (this.getScope() == null) {
            return null;
        }
        return this.getScope().getSubScope(this.getName());
    }

    public boolean isRealType() {
        return this.isInstanceOf("RealType");
    }

    public boolean isIntegerType() {
        return this.isInstanceOf("IntegerType");
    }

    public boolean isInt64() {
        return this.isInstanceOf("IntegerType") && this.getName().equalsIgnoreCase("int64");
    }

    public boolean isCharacterType() {
        return this.isInstanceOf("CharacterType");
    }

    public boolean isVariantType() {
        return this.isInstanceOf("VariantType");
    }

    public boolean isNumber() {
        return this.isInstanceOf("RealType") || this.isInstanceOf("IntegerType");
    }

    public boolean isBoolean() {
        return this.isInstanceOf("EnumeratedType") && (this.getName().equalsIgnoreCase("boolean") || this.getName().equalsIgnoreCase("bytebool") || this.getName().equalsIgnoreCase("wordbool") || this.getName().equalsIgnoreCase("longbool"));
    }

    public boolean isFileType() {
        return this.isInstanceOf("FileType");
    }

    public boolean isOrdinalType() {
        return this.isInstanceOf("OrdinalType");
    }

    public boolean isSubrangeType() {
        return this.isInstanceOf("SubrangeType");
    }

    public boolean isRangedType() {
        return this.isInstanceOf("RangedType");
    }

    public boolean isSetType() {
        return this.isInstanceOf("SetType");
    }

    public boolean isClassType() {
        return this.isInstanceOf("ClassType");
    }

    public boolean isInterface() {
        return this.isInstanceOf("ClassType") && ((ClassType)this).isInterface();
    }

    public boolean isDerivedFrom(ClassType t) {
        return this.isInstanceOf("ClassType") && ((ClassType)this).instanceOf(t);
    }

    public boolean isProceduralType() {
        return this.isInstanceOf("ProceduralType");
    }

    public boolean isPointerType() {
        return this.isInstanceOf("PointerType");
    }

    public boolean isStringType() {
        return this.isInstanceOf("StringType");
    }

    public boolean isSubrangeOf(Type otherType) {
        Range othersRange;
        Range thisRange;
        Type othersBaseType;
        Type thisBaseType;
        if (this.isSubrangeType()) {
            thisBaseType = ((SubrangeType)this).getBaseType();
        } else if (this.isRangedType()) {
            thisBaseType = this;
        } else {
            return false;
        }
        if (otherType.isSubrangeType()) {
            othersBaseType = ((SubrangeType)otherType).getBaseType();
        } else if (otherType.isRangedType()) {
            othersBaseType = otherType;
        } else {
            return false;
        }
        if (this.isSubrangeType() && otherType.isSubrangeType() && !thisBaseType.equals(othersBaseType)) {
            return false;
        }
        if (this.isSubrangeType() && ((SubrangeType)this).getBaseType().isRangedType()) {
            thisRange = ((RangedType)((Object)this)).getRange();
            if (thisRange == null) {
                thisRange = ((RangedType)((Object)((SubrangeType)this).getBaseType())).getRange();
            }
        } else if (this.isRangedType()) {
            thisRange = ((RangedType)((Object)this)).getRange();
        } else {
            return false;
        }
        if (otherType.isSubrangeType() && ((SubrangeType)otherType).getBaseType().isRangedType()) {
            othersRange = ((RangedType)((Object)otherType)).getRange();
            if (othersRange == null) {
                othersRange = ((RangedType)((Object)((SubrangeType)otherType).getBaseType())).getRange();
            }
        } else if (otherType.isRangedType()) {
            othersRange = ((RangedType)((Object)otherType)).getRange();
        } else {
            return false;
        }
        return thisRange != null && othersRange != null && thisRange.getMin().compareTo(othersRange.getMin()) >= 0 && thisRange.getMax().compareTo(othersRange.getMax()) <= 0;
    }

    public boolean isTypeCompatible(Type otherType) {
        if (this == otherType) {
            return true;
        }
        if (this.isRealType() && otherType.isRealType()) {
            return true;
        }
        if (this.isIntegerType() && otherType.isIntegerType()) {
            return ((IntegerType)this).getRange().isSubrangeOf(((IntegerType)otherType).getRange());
        }
        if (this.isSubrangeOf(otherType)) {
            return true;
        }
        if (this.isSubrangeType() && otherType.isSubrangeType() && ((SubrangeType)this).getBaseType().equals(((SubrangeType)otherType).getBaseType())) {
            return true;
        }
        if (this.isSetType() && otherType.isSetType() && ((SetType)this).getBaseType().isTypeCompatible(((SetType)otherType).getBaseType())) {
            return true;
        }
        if (this.isStringType() && otherType.isStringType() && ((StringType)this).isPacked() && ((StringType)otherType).isPacked()) {
            return true;
        }
        if (this.isStringType() && (otherType.isStringType() || otherType.isCharacterType()) || otherType.isStringType() && (this.isStringType() || this.isCharacterType())) {
            return true;
        }
        if (this.isVariantType() && (otherType.isIntegerType() || otherType.isRealType() || otherType.isStringType() || otherType.isCharacterType() || otherType.isBoolean()) || otherType.isVariantType() && (this.isIntegerType() || this.isRealType() || this.isStringType() || this.isCharacterType() || this.isBoolean())) {
            return true;
        }
        if ((this.isInterface() || this.isClassType()) && (otherType.isInterface() || otherType.isClassType()) && (((ClassType)otherType).instanceOf((ClassType)this) || ((ClassType)this).instanceOf((ClassType)otherType))) {
            return true;
        }
        if (this.isPointerType() && ((PointerType)this).getBaseType().isNilType() && otherType.isPointerType() || otherType.isPointerType() && ((PointerType)otherType).getBaseType().isNilType() && this.isPointerType()) {
            return true;
        }
        if (this.isPointerType() && !((PointerType)this).getBaseType().isNilType() && otherType.isPointerType() && !((PointerType)otherType).getBaseType().isNilType() && ((PointerType)this).getBaseType().equals(((PointerType)otherType).getBaseType())) {
            return true;
        }
        if (this.isProceduralType() && otherType.isProceduralType()) {
            Method thisMethod = ((ProceduralType)this).getMethod();
            Method otherMethod = ((ProceduralType)otherType).getMethod();
            if (thisMethod.getType() == otherMethod.getType()) {
                if (thisMethod.getParameters().size() != otherMethod.getParameters().size()) {
                    return false;
                }
                ListIterator thisMethodsParameterList = thisMethod.getParameters().listIterator();
                ListIterator otherMethodsParameterList = otherMethod.getParameters().listIterator();
                while (thisMethodsParameterList.hasNext()) {
                    if (((Type)thisMethodsParameterList.next()).typeIdentity((Type)otherMethodsParameterList.next())) continue;
                    return false;
                }
            }
        }
        return false;
    }

    public boolean typeIdentity(Type otherType) {
        if (this.equals(otherType)) {
            return true;
        }
        if (otherType == null) {
            return false;
        }
        return this.isInstanceOf("UserDefinedType") && ((UserDefinedType)this).getRealBaseType().equals(otherType) || otherType.isInstanceOf("UserDefinedType") && ((UserDefinedType)otherType).getRealBaseType().equals(this) || otherType.isInstanceOf("UserDefinedType") && this.isInstanceOf("UserDefinedType") && ((UserDefinedType)this).getRealBaseType().equals(otherType) && ((UserDefinedType)otherType).getRealBaseType().equals(this);
    }

    public static void main(String[] argv) {
        if (!Type.test()) {
            System.out.println("Test failed!");
        } else {
            System.out.println("Test passed");
        }
    }

    public static boolean test() {
        boolean retVal = true;
        OrdinalType t1 = new SubrangeType("t1", new IntegerType("int"), new Range("5", "10"));
        SimpleType t2 = new SubrangeType("t2", new IntegerType("int"), new Range("5", "111"));
        if (!(retVal &= t1.isTypeCompatible(t2))) {
            System.err.println("err");
            return retVal;
        }
        RealType real = new RealType("real");
        IntegerType integer = new IntegerType("Integer");
        integer.setRange(new Range("-2147483648", "2147483647"));
        IntegerType longword = new IntegerType("longword");
        longword.setRange(new Range("0", "4294967295"));
        IntegerType cardinal = new IntegerType("cardinal");
        cardinal.setRange(new Range("0", "4294967295"));
        IntegerType longint = new IntegerType("LongInt");
        longint.setRange(new Range("-2147483648", "2147483647"));
        retVal = integer.isTypeCompatible(integer);
        if (!retVal) {
            System.err.println("err");
            return retVal;
        }
        retVal = integer.isAssignmentCompatible(real);
        if (!retVal) {
            System.err.println("err");
            return retVal;
        }
        boolean bl = retVal = !real.isAssignmentCompatible(integer);
        if (!retVal) {
            System.err.println("err");
            return retVal;
        }
        boolean bl2 = retVal = !cardinal.isAssignmentCompatible(integer);
        if (!retVal) {
            System.err.println("err");
            return retVal;
        }
        retVal = longint.isAssignmentCompatible(integer);
        if (!retVal) {
            System.err.println("err");
            return retVal;
        }
        t1 = integer;
        t2 = real;
        boolean bl3 = retVal = !t1.isTypeCompatible(t2);
        if (!retVal) {
            System.err.println("err: " + t2 + " and " + t1 + " are not type-compatible.");
            return retVal;
        }
        boolean bl4 = retVal = !t2.isTypeCompatible(t1);
        if (!retVal) {
            System.err.println("err: " + t1 + " and " + t2 + " are not type-compatible.");
            return retVal;
        }
        RealType extended = new RealType("extended");
        RealType currency = new RealType("currency");
        RealType double_ = new RealType("double");
        RealType real48 = new RealType("real48");
        RealType single = new RealType("single");
        assert (retVal &= extended.isAssignmentCompatible(extended));
        assert (retVal &= !extended.isAssignmentCompatible(currency));
        assert (retVal &= !extended.isAssignmentCompatible(double_));
        assert (retVal &= !extended.isAssignmentCompatible(real));
        assert (retVal &= !extended.isAssignmentCompatible(real48));
        assert (retVal &= !extended.isAssignmentCompatible(single));
        assert (retVal &= currency.isAssignmentCompatible(extended));
        assert (retVal &= currency.isAssignmentCompatible(currency));
        assert (retVal &= !currency.isAssignmentCompatible(double_));
        assert (retVal &= !currency.isAssignmentCompatible(real));
        assert (retVal &= !currency.isAssignmentCompatible(real48));
        assert (retVal &= !currency.isAssignmentCompatible(single));
        assert (retVal &= double_.isAssignmentCompatible(extended));
        assert (retVal &= !double_.isAssignmentCompatible(currency));
        assert (retVal &= double_.isAssignmentCompatible(double_));
        assert (retVal &= double_.isAssignmentCompatible(real));
        assert (retVal &= !double_.isAssignmentCompatible(real48));
        assert (retVal &= !double_.isAssignmentCompatible(single));
        assert (retVal &= real.isAssignmentCompatible(extended));
        assert (retVal &= !real.isAssignmentCompatible(currency));
        assert (retVal &= real.isAssignmentCompatible(double_));
        assert (retVal &= real.isAssignmentCompatible(real));
        assert (retVal &= !real.isAssignmentCompatible(real48));
        assert (retVal &= !real.isAssignmentCompatible(single));
        assert (retVal &= real48.isAssignmentCompatible(extended));
        assert (retVal &= !real48.isAssignmentCompatible(currency));
        assert (retVal &= real48.isAssignmentCompatible(double_));
        assert (retVal &= real48.isAssignmentCompatible(real));
        assert (retVal &= real48.isAssignmentCompatible(real48));
        assert (retVal &= !real48.isAssignmentCompatible(single));
        assert (retVal &= single.isAssignmentCompatible(extended));
        assert (retVal &= !single.isAssignmentCompatible(currency));
        assert (retVal &= single.isAssignmentCompatible(double_));
        assert (retVal &= single.isAssignmentCompatible(real));
        assert (retVal &= !single.isAssignmentCompatible(real48));
        assert (retVal &= single.isAssignmentCompatible(single));
        return retVal;
    }

    @Override
    public String getHtmlInfoString() {
        StringBuffer returnString = new StringBuffer();
        returnString.append(super.getHtmlInfoString());
        if (this.isInstanceOf("ClassType") && ((ClassType)this).getSuperClasses() != null) {
            returnString.append("<tr><th>Superclasses:</th>");
            returnString.append("<td>");
            Iterator scopeListIterator = ((ClassType)this).getSuperClasses().listIterator();
            while (scopeListIterator.hasNext()) {
                Symbol current = (Symbol)scopeListIterator.next();
                returnString.append(current.getFullName());
                returnString.append("<br>");
            }
            returnString.append("</td>");
            returnString.append("</tr>");
            if (((ClassType)this).getCorrespondingScope() != null) {
                scopeListIterator = ((ClassType)this).getCorrespondingScope().getSymbols().iterator();
                int attributeCount = 0;
                int methodCount = 0;
                while (scopeListIterator.hasNext()) {
                    Symbol current = (Symbol)scopeListIterator.next();
                    if (current.isInstanceOf("Attribute")) {
                        ++attributeCount;
                    }
                    if (!current.isInstanceOf("Method")) continue;
                    ++methodCount;
                }
                returnString.append("<tr><th>Number of Attributes:</th><td>" + attributeCount + "</td></tr>");
                returnString.append("<tr><th>Number of Methods:</th><td>" + methodCount + "</td></tr>");
            }
        }
        return returnString.toString();
    }

    public static EnumeratedType getBooleanType() {
        return booleanType;
    }

    public static IntegerType getIntegerType() {
        return integerType;
    }

    public static RealType getRealType() {
        return realType;
    }

    public static NilType getNilType() {
        return NilType.get();
    }

    public static StringType getStringType() {
        return stringType;
    }

    public static void setBooleanType(EnumeratedType type) {
        booleanType = type;
    }

    public static void setIntegerType(IntegerType type) {
        integerType = type;
    }

    public static void setRealType(RealType type) {
        realType = type;
    }

    public static void setStringType(StringType type) {
        stringType = type;
    }

    public static CharacterType getCharacterType() {
        return characterType;
    }

    public static void setCharacterType(CharacterType type) {
        characterType = type;
    }

    public static void setExtendedType(RealType extendedType) {
        Type.extendedType = extendedType;
    }

    public static RealType getExtendedType() {
        return extendedType;
    }

    public static void setInt64Type(IntegerType bigIntType) {
        int64Type = bigIntType;
    }

    public static IntegerType getInt64Type() {
        return int64Type;
    }

    @Override
    public String getSymbolTypeCheckerIdentifier() {
        return String.valueOf(super.getSymbolTypeCheckerIdentifier()) + "/Type/";
    }
}

