/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.delphi.symbols.types;

import de.fzi.delphi.OPDebug;
import de.fzi.delphi.symbols.Attribute;
import de.fzi.delphi.symbols.Method;
import de.fzi.delphi.symbols.types.StructuredType;
import de.fzi.delphi.types.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ClassType
extends StructuredType {
    private List fields;
    private List methods;
    private List superClasses = new Vector();
    boolean flag_interface = false;
    boolean flag_dispinterface = false;

    public ClassType(String typeId) {
        super(typeId);
        this.fields = new Vector();
        this.methods = new Vector();
    }

    public ClassType(int hash) {
        super(hash);
    }

    public ClassType(Type t) {
        super(t);
        if (t != null && t.isInstanceOf("ClassType")) {
            this.setDispinterface(((ClassType)t).isDispinterface());
            this.setInterface(((ClassType)t).isInterface());
            this.methods = ((ClassType)t).getMethods();
            if (this.superClasses == null) {
                this.superClasses = new Vector();
            }
            this.superClasses.addAll(((ClassType)t).getSuperClasses());
        }
    }

    public ClassType(String typeId, ClassType superType) {
        super(typeId);
        this.fields = new Vector();
        this.methods = new Vector();
        this.superClasses = new Vector();
        this.superClasses.add(superType);
    }

    public void addField(Attribute f) {
        if (this.fields == null) {
            this.fields = new Vector();
        }
        this.fields.add(f);
    }

    public void addMethod(Method m) {
        if (this.methods == null) {
            this.methods = new Vector();
        }
        this.methods.add(m);
    }

    public boolean extendsClass(ClassType c) {
        return this.getSuperClasses().contains(c);
    }

    public boolean hasAncestor(ClassType c) {
        if (c == null) {
            return false;
        }
        if (this.superClasses.contains(c)) {
            return true;
        }
        Iterator it = this.superClasses.iterator();
        while (it.hasNext()) {
            if (!((ClassType)it.next()).hasAncestor(c)) continue;
            return true;
        }
        return false;
    }

    public List getSuperClasses() {
        if (this.superClasses == null) {
            return new Vector();
        }
        return this.superClasses;
    }

    public void addSuperClass(ClassType c) {
        if (this.superClasses == null) {
            this.superClasses = new Vector();
        }
        if (c != null) {
            this.superClasses.add(c);
        }
    }

    public void replaceSuperClass(ClassType oldClass, ClassType newClass) {
        OPDebug.debugPrintln(1, "Replacing Superclass of class '" + this.getFullName() + "': " + oldClass.getFullName() + " -> " + newClass.getFullName());
        int idx = this.superClasses.indexOf(oldClass);
        if (idx != -1) {
            this.superClasses.set(idx, newClass);
        }
    }

    public boolean instanceOf(ClassType instance) {
        if (instance != null && instance.isInstanceOf("ClassType")) {
            return this.extendsClass(instance);
        }
        return false;
    }

    public List getFields() {
        if (this.fields == null) {
            return new Vector();
        }
        return this.fields;
    }

    public List getMethods() {
        if (this.methods == null) {
            return new Vector();
        }
        return this.methods;
    }

    public boolean isDispinterface() {
        return this.flag_dispinterface;
    }

    @Override
    public boolean isInterface() {
        return this.flag_interface;
    }

    public void setDispinterface(boolean b) {
        this.flag_dispinterface = b;
    }

    public void setInterface(boolean b) {
        this.flag_interface = b;
    }

    @Override
    public String getSymbolTypeCheckerIdentifier() {
        return String.valueOf(super.getSymbolTypeCheckerIdentifier()) + "/ClassType/";
    }
}

