/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.delphi.symbols.types;

import de.fzi.delphi.symbols.types.BasedType;
import de.fzi.delphi.symbols.types.Packed;
import de.fzi.delphi.symbols.types.Range;
import de.fzi.delphi.types.Type;
import java.util.List;
import java.util.Vector;

public class ArrayType
extends Type
implements Packed,
BasedType {
    boolean packed = false;
    private Type baseType;
    List dimensions;
    private static int identCount = 0;

    public ArrayType(Type baseType) {
        super("{array" + ++identCount + "}");
        this.setBaseType(baseType);
        this.dimensions = new Vector();
    }

    public void addDimension(Range r) {
        this.dimensions.add(r);
    }

    @Override
    public boolean isPacked() {
        return this.packed;
    }

    @Override
    public boolean setPacked(boolean packed) {
        this.packed = packed;
        return packed;
    }

    public List getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(List dimensions) {
        this.dimensions = dimensions;
    }

    @Override
    public String getSymbolTypeCheckerIdentifier() {
        return String.valueOf(super.getSymbolTypeCheckerIdentifier()) + "/Packed//ArrayType/";
    }

    @Override
    public Type getRealBaseType() {
        if (this.getBaseType() != null && this.getBaseType().isInstanceOf("BasedType")) {
            return ((BasedType)((Object)this.getBaseType())).getRealBaseType();
        }
        return this.getBaseType();
    }

    @Override
    public Type getBaseType() {
        return this.baseType;
    }

    public Type getArrayType() {
        return this.getBaseType();
    }

    @Override
    public void setBaseType(Type baseType) {
        this.baseType = baseType;
    }

    @Override
    public String getHtmlInfoString() {
        StringBuffer returnString = new StringBuffer();
        returnString.append(super.getHtmlInfoString());
        returnString.append("<tr><th>isPacked:</th><td>" + this.isPacked() + "</td></tr>");
        if (this.getDimensions().size() > 0) {
            returnString.append("<tr><th>Dimensions:</th><td>" + this.getDimensions() + "</td></tr>");
        }
        returnString.append("<tr><th>Base-type:</th><td>" + this.getBaseType() + "</td></tr>");
        returnString.append("<tr><th>Real Basetype:</th><td>" + this.getRealBaseType() + "</td></tr>");
        return returnString.toString();
    }
}

