/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.delphi.symbols;

import de.fzi.delphi.symbols.Scope;
import de.fzi.delphi.symbols.SimpleSymbol;
import de.fzi.delphi.symbols.types.Typed;
import de.fzi.delphi.types.Type;

public class TypedSymbol
extends SimpleSymbol
implements Typed {
    protected Type type = null;

    public TypedSymbol() {
        this.scope = null;
    }

    public TypedSymbol(int hash) {
        this.nameHash = hash;
        this.scope = null;
    }

    public TypedSymbol(int nameHash, Type type) {
        this.nameHash = nameHash;
        this.type = type;
    }

    public TypedSymbol(String name) {
        this.setName(name);
        this.scope = null;
    }

    public TypedSymbol(String name, Type type) {
        super(name);
        this.type = type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void setType(Type t) {
        this.type = t;
    }

    @Override
    public String getHtmlInfoString() {
        StringBuffer returnString = new StringBuffer();
        returnString.append(super.getHtmlInfoString());
        if (this.getType() != null) {
            returnString.append("<tr><th>Type:</th>");
            returnString.append("<td>");
            returnString.append(this.getType().getFullName());
            if (this.getType().isResolved() && this.getType().getScope() != null) {
                String scopeName = this.getType().getScope().getFullName();
                if (scopeName.length() == 0 || scopeName.equalsIgnoreCase(Scope.ROOT_SCOPE_NAME)) {
                    scopeName = Scope.ROOT_SCOPE_NAME;
                }
                returnString.append(" (declared in " + scopeName + ")");
            } else {
                returnString.append(" (unresolved)");
            }
            returnString.append("</td>");
            returnString.append("</tr>");
        } else {
            returnString.append("<tr><th>Type:</th>");
            returnString.append("<td>");
            returnString.append("(none)");
            returnString.append("</td>");
            returnString.append("</tr>");
        }
        return returnString.toString();
    }

    @Override
    public String getSymbolTypeCheckerIdentifier() {
        return String.valueOf(super.getSymbolTypeCheckerIdentifier()) + "/Typed//TypedSymbol/";
    }
}

