/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.delphi.symbols;

import de.fzi.delphi.PositionElement;
import de.fzi.delphi.symbols.Scope;
import de.fzi.delphi.symbols.StringTabelle;
import de.fzi.delphi.symbols.SymbolTypeChecker;
import java.io.Serializable;

public abstract class Symbol
implements Serializable {
    protected static final boolean DEBUG = false;
    protected int nameHash;
    private boolean interfaceDeclaration = false;
    protected Scope scope;
    protected boolean resolved = true;
    protected int line = -1;
    protected PositionElement positionElement;

    public int getNameHash() {
        return this.nameHash;
    }

    protected void setName(String id) {
        this.nameHash = StringTabelle.findOrCreate(id);
    }

    public String getName() {
        return StringTabelle.getText(this.getNameHash());
    }

    public String getFullName() {
        String name = StringTabelle.getText(this.getNameHash());
        Scope scope = this.getScope();
        if (scope == null) {
            return name;
        }
        if (scope.isRootScope()) {
            return "[root]." + name;
        }
        return String.valueOf(scope.getFullName()) + "." + name;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public boolean isType() {
        return this.isInstanceOf("Type");
    }

    public boolean isAttribute() {
        return this.isInstanceOf("Attribute");
    }

    public boolean isMethod() {
        return this.isInstanceOf("Method");
    }

    public boolean isProperty() {
        return this.isInstanceOf("Property");
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolved(boolean b) {
        this.resolved = b;
    }

    public String getHtmlInfoString() {
        StringBuffer returnString = new StringBuffer();
        returnString.append("<tr><th colspan=\"2\" align=\"center\">");
        if (this.isAttribute()) {
            if (this.isProperty()) {
                returnString.append("Property");
            } else {
                returnString.append("Attribute");
            }
        } else if (this.isMethod()) {
            returnString.append("Method");
        } else if (this.isType()) {
            returnString.append("Type");
        } else if (this.isInstanceOf("CompilationUnit")) {
            returnString.append("CompilationUnit");
        } else {
            returnString.append("Symbol");
        }
        returnString.append("</th></tr>");
        returnString.append("<tr><th>Name:</th>");
        returnString.append("<td>" + this.getName() + "</td></tr>");
        returnString.append("<tr><th>Class:</th>");
        returnString.append("<td>" + this.getClass().getName() + "</td></tr>");
        if (this.getLine() != -1) {
            returnString.append("<tr><th>Line:</th>");
            returnString.append("<td>" + this.getLine() + "</td></tr>");
        }
        returnString.append("<tr><th>Scope:</th>");
        if (this.getScope() != null) {
            returnString.append("<td>" + this.getScope().getFullName() + "</td></tr>");
        } else {
            returnString.append("<td><b><i>null</i></b></td></tr>");
        }
        returnString.append("<tr><th>Resolved:</th>");
        returnString.append("<td>" + this.isResolved() + "</td></tr>");
        returnString.append("<tr><th>isInterfaceDeclaration()</th>");
        returnString.append("<td>" + this.isInterfaceDeclaration() + "</td></tr>");
        returnString.append("<tr><th>isAttribute()</th>");
        returnString.append("<td>" + this.isAttribute() + "</td></tr>");
        returnString.append("<tr><th>isType()</th>");
        returnString.append("<td>" + this.isType() + "</td></tr>");
        returnString.append("<tr><th>isMethod()</th>");
        returnString.append("<td>" + this.isMethod() + "</td></tr>");
        return returnString.toString();
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int i) {
        this.line = i;
    }

    public String toString() {
        return String.valueOf(this.getFullName()) + ", l." + this.getLine();
    }

    public boolean isInterfaceDeclaration() {
        return this.interfaceDeclaration;
    }

    public void setInterfaceDeclaration(boolean b) {
        this.interfaceDeclaration = b;
    }

    public String getSymbolTypeCheckerIdentifier() {
        return "/Symbol/";
    }

    public boolean isInstanceOf(String className) {
        return SymbolTypeChecker.isInstanceOf(this, className);
    }

    public PositionElement getPositionElement() {
        return this.positionElement;
    }

    public void setPositionElement(PositionElement positionElement) {
        this.positionElement = positionElement;
    }
}

