/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.delphi.symbols;

import de.fzi.delphi.OPDebug;
import de.fzi.delphi.OPProjectManager;
import de.fzi.delphi.symbols.Attribute;
import de.fzi.delphi.symbols.CompilationUnit;
import de.fzi.delphi.symbols.Method;
import de.fzi.delphi.symbols.MethodComposite;
import de.fzi.delphi.symbols.ModifiedSymbol;
import de.fzi.delphi.symbols.Scope;
import de.fzi.delphi.symbols.ScopeNotFoundException;
import de.fzi.delphi.symbols.ScopePath;
import de.fzi.delphi.symbols.ScopingException;
import de.fzi.delphi.symbols.SimpleSymbol;
import de.fzi.delphi.symbols.Symbol;
import de.fzi.delphi.symbols.types.ClassType;
import de.fzi.delphi.types.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class ScopingEngine {
    static boolean DEBUG_SCOPE;
    static final boolean CACHE_SCOPES;
    private Scope rootScope = null;
    private Scope currentScope = null;
    private boolean isInterface = false;
    public Stack scopeStack = new Stack();
    public static final int QUALIFIED = 1;
    public static final int LOCAL = 2;
    public static final int PARENT = 4;
    public static final int INHERITED = 8;
    public static final int INTERFACEUSES = 16;
    public static final int IMPLEMENTATIONUSES = 32;
    public static final int UNRESOLVED = 64;
    public static final int ALL = 127;

    static {
        CACHE_SCOPES = DEBUG_SCOPE = false;
    }

    public ScopingEngine() {
        this.newRootScope();
    }

    public ScopingEngine(Scope rootScope) {
        this.scopeStack.push(rootScope);
        if (CACHE_SCOPES) {
            this.rootScope = rootScope;
            this.currentScope = rootScope;
        }
    }

    public ScopingEngine(Scope rootScope, Scope currentScope) throws ScopingException {
        this.scopeStack.push(rootScope);
        if (CACHE_SCOPES) {
            this.rootScope = rootScope;
            this.currentScope = rootScope;
        }
        if (!currentScope.isRootScope()) {
            this.changeScope(currentScope);
        }
    }

    public Scope getCurrentScope() {
        if (CACHE_SCOPES && this.currentScope != null) {
            assert ((Scope)this.scopeStack.peek() == this.currentScope);
            return this.currentScope;
        }
        if (!this.scopeStack.isEmpty()) {
            return (Scope)this.scopeStack.peek();
        }
        return null;
    }

    public Scope getRootScope() {
        if (CACHE_SCOPES && this.rootScope != null) {
            return this.rootScope;
        }
        return (Scope)this.scopeStack.firstElement();
    }

    private Scope newRootScope() {
        if (this.scopeStack == null || this.scopeStack.isEmpty()) {
            Scope newScope = new Scope(null, Scope.ROOT_SCOPE_NAME);
            this.scopeStack = new Stack();
            this.scopeStack.push(newScope);
            if (CACHE_SCOPES) {
                this.rootScope = newScope;
                this.currentScope = newScope;
            }
            if (DEBUG_SCOPE) {
                OPDebug.debugPrintln(3, "# " + newScope.getName() + " (newRootScope) ---");
            }
            return newScope;
        }
        return this.getRootScope();
    }

    public Scope createNewScope(String name, int line) {
        Scope temp = this.createNewScope(name);
        temp.setSourceLine(line);
        return temp;
    }

    public Scope createNewScope(String name) {
        String fullname = Scope.calculateFullPath(this.getCurrentScope().getFullName(), name);
        return this.createNewScopeAbs(fullname);
    }

    public Scope createNewScopeAbs(String fullname) {
        Scope newScope = this.getRootScope().getScope(fullname);
        if (newScope == null) {
            String currentToken;
            StringTokenizer st = new StringTokenizer(fullname, ".");
            String tempPath = "";
            Scope tempScope = this.getRootScope();
            Scope previousScope = null;
            tempPath = currentToken = st.nextToken();
            while (st.hasMoreTokens()) {
                currentToken = st.nextToken();
                tempPath = tempPath.length() == 0 ? currentToken : String.valueOf(tempPath) + "." + currentToken;
                previousScope = tempScope;
                tempScope = this.getRootScope().getScope(tempPath);
                if (tempScope != null) continue;
                tempScope = new Scope(previousScope, currentToken);
                if (!st.hasMoreTokens()) continue;
                OPDebug.debugPrintln(1, "createNewScope: intermidiate scope created " + tempPath);
            }
            newScope = tempScope;
        } else {
            this.scopeDebugPrint("# Scope exists");
        }
        this.scopeDebugPrint("# new Scope is: " + this.getCurrentScope().getFullName());
        assert (newScope != null);
        try {
            this.changeScope(newScope);
        }
        catch (ScopingException e) {
            e.printStackTrace();
        }
        return this.getCurrentScope();
    }

    public Scope changeScope(Scope newScope) throws ScopingException {
        if (newScope != null && newScope != this.getCurrentScope()) {
            if (new Throwable().getStackTrace()[1].getMethodName().equalsIgnoreCase("changeScope")) {
                this.scopeDebugPrint("# change Scope FROM: " + this.getCurrentScope().getFullName() + " [invoked by method: " + new Throwable().getStackTrace()[2].getMethodName() + "]");
            } else {
                this.scopeDebugPrint("# change Scope FROM: " + this.getCurrentScope().getFullName() + " [invoked by method: " + new Throwable().getStackTrace()[1].getMethodName() + "]");
            }
            this.scopeStack.push(newScope);
            if (CACHE_SCOPES) {
                this.currentScope = newScope;
            }
        } else {
            if (newScope == null) {
                throw new ScopingException("# can't change to scope 'null'");
            }
            throw new ScopingException("# unnecessary scope-change");
        }
        this.scopeDebugPrint("#                TO: " + this.getCurrentScope().getFullName());
        return newScope;
    }

    public Scope changeScope(String scopeName) throws ScopingException {
        Scope scope = null;
        this.getCurrentScope();
        assert (scopeName != null);
        if (scopeName == null || scopeName.length() == 0) {
            throw new ScopingException("# failed to change scope (empty name)");
        }
        Scope newScope = this.getRootScope().getScope(scopeName);
        if (newScope == null) {
            newScope = this.getCurrentScope().getSubScope(scopeName);
        }
        if (newScope == null) {
            throw new ScopeNotFoundException("Can't find scope '" + scopeName + "'");
        }
        scope = this.changeScope(newScope);
        return scope;
    }

    public Scope prevScope() throws ScopingException {
        String oldScopeName = "";
        if (DEBUG_SCOPE) {
            oldScopeName = this.getCurrentScope().getFullName();
            if (this.getCurrentScope().getParent() == this.getCurrentScope().getCompilationUnitScope()) {
                this.scopeDebugPrint("# returning      TO: scope of compilation-unit [invoked by method: " + new Throwable().getStackTrace()[1].getMethodName() + "]");
            } else {
                this.scopeDebugPrint("#              FROM: " + oldScopeName + " [invoked by method: " + new Throwable().getStackTrace()[1].getMethodName() + "]");
            }
        }
        assert (this.getCurrentScope() != null) : "%%% SCOPING ERROR: Current Scope = null";
        if (DEBUG_SCOPE && this.getCurrentScope().getParent() == null) {
            this.getRootScope().show();
        }
        assert (this.getCurrentScope().isRootScope() || this.getCurrentScope().getParent() != null) : "%%% SCOPING ERROR: Parent Scope = null";
        assert (!this.scopeStack.empty()) : "%%% SCOPING ERROR: Scopestack is empty";
        if (this.scopeStack != null && !this.scopeStack.empty()) {
            this.scopeStack.pop();
            if (CACHE_SCOPES) {
                this.currentScope = (Scope)this.scopeStack.peek();
            }
        } else {
            throw new ScopingException("Already in root-scope");
        }
        if (DEBUG_SCOPE) {
            this.scopeDebugPrint("# returning      TO: " + this.getCurrentScope().getFullName());
            this.scopeDebugPrint("");
        }
        return this.getCurrentScope();
    }

    public Method resolveMethod(Method met) {
        if (met == null) {
            return null;
        }
        Symbol sym = this.resolve(met.getName());
        if (sym != null) {
            if (sym.isInstanceOf("Method")) {
                return (Method)sym;
            }
            if (sym.isInstanceOf("MethodComposite")) {
                return met.getMethodForThisCall(this);
            }
        }
        return null;
    }

    public Attribute resolveAttribute(String name) {
        if (name == null) {
            return null;
        }
        Symbol sym = this.resolve(name);
        if (sym != null && sym.isInstanceOf("Attribute")) {
            return (Attribute)sym;
        }
        return null;
    }

    public Type resolveType(String name) {
        if (name == null) {
            return null;
        }
        Symbol sym = this.resolve(name);
        if (sym != null && sym.isInstanceOf("Type")) {
            return (Type)sym;
        }
        return null;
    }

    public Attribute getAttributeDeclaration(String ident) {
        String qualIdent = ident;
        String path = null;
        String name = null;
        String DOT = ".";
        if (ident == null || ident.length() == 0) {
            return null;
        }
        if (qualIdent.indexOf(DOT) == -1) {
            name = qualIdent;
            path = this.getCurrentScope().getFullName();
            if (path.length() > 0) {
                qualIdent = String.valueOf(path) + DOT + qualIdent;
            } else {
                path = "";
            }
        } else {
            name = ident.substring(ident.lastIndexOf(DOT) + 1, ident.length());
            path = ident.substring(0, ident.lastIndexOf(DOT));
        }
        Scope declScope = this.getRootScope();
        if (declScope == null) {
            OPDebug.debugPrintln(6, "can't get declarations-scope");
        }
        Scope pathScope = null;
        String tempPath = path;
        if (path.length() > 0) {
            if (!path.startsWith(this.getCurrentScope().getFullName())) {
                tempPath = String.valueOf(this.getCurrentScope().getFullName()) + "." + path;
            }
            pathScope = declScope.getScope(tempPath);
        } else {
            pathScope = declScope;
        }
        if (pathScope == null) {
            OPDebug.debugPrintln(6, "AttributeDecl: can't get scope for path '" + tempPath + "'");
        }
        Symbol sym = null;
        if (pathScope != null) {
            try {
                sym = new ScopingEngine(this.getRootScope(), pathScope).resolve(name);
            }
            catch (ScopingException e) {
                e.printStackTrace();
            }
        }
        if (sym != null && sym.isInstanceOf("Attribute")) {
            return (Attribute)sym;
        }
        return null;
    }

    public Method getMethodDeclaration(String ident) {
        String qualIdent = ident;
        String path = null;
        String name = null;
        String DOT = ".";
        if (ident == null || ident.length() == 0) {
            return null;
        }
        if (qualIdent.indexOf(DOT) == -1) {
            name = qualIdent;
            path = this.getCurrentScope().getFullName();
            if (path.length() > 0) {
                qualIdent = String.valueOf(path) + DOT + qualIdent;
            } else {
                path = "";
            }
        } else {
            name = ident.substring(ident.lastIndexOf(DOT) + 1, ident.length());
            path = ident.substring(0, ident.lastIndexOf(DOT));
        }
        Scope declScope = this.getRootScope();
        if (declScope == null) {
            OPDebug.debugPrintln(6, "can't get declarations-scope");
        }
        Scope pathScope = null;
        String tempPath = path;
        if (path.length() > 0) {
            if (!path.startsWith(this.getCurrentScope().getFullName())) {
                tempPath = String.valueOf(this.getCurrentScope().getFullName()) + "." + path;
            }
            pathScope = declScope.getScope(tempPath);
        } else {
            pathScope = declScope;
        }
        if (pathScope == null) {
            OPDebug.debugPrintln(6, "MethodDecl: can't get scope for path '" + tempPath + "'");
        }
        Symbol sym = null;
        if (pathScope != null) {
            List methods;
            try {
                sym = new ScopingEngine(this.getRootScope(), pathScope).resolve(name);
            }
            catch (ScopingException e) {
                e.printStackTrace();
            }
            if (sym == null && !(methods = pathScope.getOverloadedMethods(new SimpleSymbol(name))).isEmpty()) {
                sym = (Method)methods.get(0);
            }
            if (sym == null) {
                sym = this.getCurrentScope().searchInSubscopes(new SimpleSymbol(name));
            }
            if (sym == null) {
                try {
                    sym = new ScopingEngine(this.getRootScope(), pathScope).resolve(name);
                }
                catch (ScopingException e) {
                    e.printStackTrace();
                }
            }
        } else {
            return null;
        }
        if (sym != null && sym.isInstanceOf("Method")) {
            return (Method)sym;
        }
        return null;
    }

    public Method getCompatibleMethod(Method m) {
        List overloadedMethods = this.getCurrentScope().getOverloadedMethods(m);
        if (!overloadedMethods.isEmpty()) {
            ListIterator candidates = overloadedMethods.listIterator();
            while (candidates.hasNext()) {
                Method current = (Method)candidates.next();
                if (!current.isCompatible(m)) continue;
                return current;
            }
            return null;
        }
        return null;
    }

    public Type getTypeDeclaration(String ident) {
        String qualIdent = ident;
        String path = null;
        String name = null;
        String DOT = ".";
        if (ident == null || ident.length() == 0) {
            return null;
        }
        if (qualIdent.indexOf(DOT) == -1) {
            name = qualIdent;
            path = this.getCurrentScope().getFullName();
            if (path.length() > 0) {
                qualIdent = String.valueOf(path) + DOT + qualIdent;
            } else {
                path = "";
            }
        } else {
            name = ident.substring(ident.lastIndexOf(DOT) + 1, ident.length());
            path = ident.substring(0, ident.lastIndexOf(DOT));
        }
        Scope declScope = this.getRootScope();
        if (declScope == null) {
            OPDebug.debugPrintln(6, "can't get declarations-scope");
        }
        Scope pathScope = null;
        String tempPath = path;
        if (path.length() > 0) {
            if (!path.startsWith(this.getCurrentScope().getFullName())) {
                tempPath = String.valueOf(this.getCurrentScope().getFullName()) + "." + path;
            }
            pathScope = declScope.getScope(tempPath);
        } else {
            pathScope = declScope;
        }
        if (pathScope == null) {
            OPDebug.debugPrintln(6, "TypeDecl:can't get scope for path '" + tempPath + "'");
        }
        Symbol sym = null;
        if (pathScope != null) {
            try {
                sym = new ScopingEngine(this.getRootScope(), pathScope).resolve(name);
            }
            catch (ScopingException e) {
                e.printStackTrace();
            }
        }
        if (sym != null && sym.isInstanceOf("Type")) {
            return (Type)sym;
        }
        return null;
    }

    public void scopeDebugPrint(String message) {
        if (DEBUG_SCOPE) {
            StringBuffer indent = new StringBuffer();
            int i = 0;
            while (i < this.scopeStack.size()) {
                indent.append(" + ");
                ++i;
            }
            OPDebug.debugPrint(3, String.valueOf(indent.toString()) + message);
            OPDebug.debugPrintln(3, "");
        }
    }

    public static void setScopeDebugging(boolean b) {
        DEBUG_SCOPE = b;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Symbol internalResolveSymbol(String name, int where) {
        Symbol currentSymbol;
        Scope scope = null;
        Symbol res = null;
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<String> signatures = new ArrayList<String>();
        if ((where & 1) != 0 && name.indexOf(".") != -1) {
            scope = this.findScopeByName(name.substring(0, name.lastIndexOf(".")));
            if (scope != null) {
                return scope.findSymbolByName(name.substring(name.lastIndexOf(".") + 1));
            }
            OPDebug.debugPrintln(1, "internalResolveSymbol: findScopeByName() returned null for qualified symbol " + name);
            return null;
        }
        scope = this.getCurrentScope();
        if (scope != null) {
            if ((where & 2) != 0) {
                res = scope.findSymbolByName(name);
            }
        } else {
            OPDebug.debugPrintln(1, "internalResolveSymbol: getCurrentScope() returned null for unqualified symbol " + name);
            return null;
        }
        if (res != null) {
            if (!res.isInstanceOf("MethodComposite")) {
                return res;
            }
            for (Method met : ((MethodComposite)res).getOverloadedMethods()) {
                methods.add(met);
                signatures.add(met.getNameWithParameters());
            }
        }
        if ((currentSymbol = scope.getCorrespondingSymbol()) != null) {
            if (currentSymbol.isInstanceOf("ClassType") && (where & 8) != 0) {
                ArrayList tmpList = new ArrayList(((ClassType)currentSymbol).getSuperClasses());
                int i = 0;
                while (i < tmpList.size()) {
                    ClassType tmpCls = (ClassType)tmpList.get(i);
                    tmpList.addAll(tmpCls.getSuperClasses());
                    Scope tmpScope = tmpCls.getCorrespondingScope();
                    if (tmpScope != null) {
                        Symbol tmpRes = tmpScope.findSymbolByName(name);
                        if (tmpRes != null) {
                            if (!tmpRes.isInstanceOf("MethodComposite")) {
                                if (res == null) {
                                    if (!tmpRes.isInstanceOf("ModifiedSymbol")) return tmpRes;
                                    if (((ModifiedSymbol)tmpRes).isVisibleFrom((ClassType)currentSymbol)) {
                                        return tmpRes;
                                    }
                                } else {
                                    OPDebug.debugPrintln(1, "internalResolveSymbol: superclass " + tmpCls.getFullName() + " contains a conflicting symbol type for " + name);
                                }
                            } else {
                                for (Method tmpMet : ((MethodComposite)tmpRes).getOverloadedMethods()) {
                                    if (!tmpMet.isVisibleFrom((ClassType)currentSymbol) || signatures.contains(tmpMet.getNameWithParameters())) continue;
                                    methods.add(tmpMet);
                                    signatures.add(tmpMet.getNameWithParameters());
                                }
                            }
                        }
                    } else {
                        OPDebug.debugPrintln(1, "internalResolveSymbol: getCorrespondingScope() on class " + tmpCls.getFullName() + " returned null");
                    }
                    ++i;
                }
            } else if (currentSymbol.isInstanceOf("CompilationUnit")) {
                Symbol tmpRes;
                if ((where & 0x10) != 0) {
                    for (Scope tmpScope : ((CompilationUnit)currentSymbol).getInterfaceUsesList()) {
                        tmpRes = tmpScope.findSymbolByName(name);
                        if (tmpRes == null) continue;
                        if (!tmpRes.isInstanceOf("MethodComposite")) {
                            if (res == null) {
                                if (!tmpRes.isInterfaceDeclaration()) continue;
                                return tmpRes;
                            }
                            OPDebug.debugPrintln(1, "internalResolveSymbol: unit " + tmpScope.getFullName() + " contains a conflicting symbol type for " + name);
                            continue;
                        }
                        for (Method tmpMet : ((MethodComposite)tmpRes).getOverloadedMethods()) {
                            if (!tmpMet.isInterfaceDeclaration() || signatures.contains(tmpMet.getNameWithParameters())) continue;
                            methods.add(tmpMet);
                            signatures.add(tmpMet.getNameWithParameters());
                        }
                    }
                }
                if (!this.isInterface() && (where & 0x20) != 0) {
                    for (Scope tmpScope : ((CompilationUnit)currentSymbol).getImplementationUsesList()) {
                        tmpRes = tmpScope.findSymbolByName(name);
                        if (tmpRes == null) continue;
                        if (!tmpRes.isInstanceOf("MethodComposite")) {
                            if (res == null) {
                                if (!tmpRes.isInterfaceDeclaration()) continue;
                                return tmpRes;
                            }
                            OPDebug.debugPrintln(1, "internalResolveSymbol: unit " + tmpScope.getFullName() + " contains a conflicting symbol type for " + name);
                            continue;
                        }
                        for (Method tmpMet : ((MethodComposite)tmpRes).getOverloadedMethods()) {
                            if (!tmpMet.isInterfaceDeclaration() || signatures.contains(tmpMet.getNameWithParameters())) continue;
                            methods.add(tmpMet);
                            signatures.add(tmpMet.getNameWithParameters());
                        }
                    }
                }
            }
        } else if (!scope.isRootScope() && !scope.isUnresolvedScope()) {
            OPDebug.debugPrintln(1, "internalResolveSymbol: Scope.getCorrespondingSymbol() returned null for scope " + scope.getFullName());
        }
        if (methods.size() > 0) {
            MethodComposite tmpComp = new MethodComposite(name);
            tmpComp.addOverloadedMethods(methods);
            return tmpComp;
        }
        if ((where & 4) != 0 && (scope = scope.getParent()) != null) {
            try {
                ScopingEngine se = new ScopingEngine(this.getRootScope(), scope);
                return se.internalResolveSymbol(name, where);
            }
            catch (ScopingException scopingException) {}
        }
        if ((where & 0x40) == 0 || (scope = OPProjectManager.getUnresolvedScope()) == null) return null;
        return scope.findSymbolByName(name);
    }

    public Symbol resolveInheritedSymbol(String name) {
        Iterator it;
        Symbol res = this.internalResolveSymbol(name, 77);
        if (res == null || !res.isInstanceOf("MethodComposite")) {
            return res;
        }
        if (((MethodComposite)res).getOverloadedMethods().size() == 1 && (it = ((MethodComposite)res).getOverloadedMethods().iterator()).hasNext()) {
            return (Symbol)it.next();
        }
        return res;
    }

    public Symbol resolve(String name) {
        Symbol res = this.internalResolveSymbol(name, 127);
        if (res == null || !res.isInstanceOf("MethodComposite")) {
            return res;
        }
        if (((MethodComposite)res).getOverloadedMethods().size() <= 1) {
            Iterator it = ((MethodComposite)res).getOverloadedMethods().iterator();
            if (it.hasNext()) {
                return (Symbol)it.next();
            }
            return null;
        }
        return res;
    }

    public Symbol resolve(Symbol sym) {
        if (sym == null) {
            return null;
        }
        Symbol res = this.resolve(sym.getName());
        if (res == null && sym.isInstanceOf("Method")) {
            res = this.resolveMethod((Method)sym);
        }
        return res;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void setInterface(boolean b) {
        this.isInterface = b;
    }

    public Scope findScopeByName(String scopePath) {
        Scope baseScope = this.getCurrentScope();
        Vector scopePathVector = ScopePath.parsePath(scopePath);
        if (scopePathVector.size() == 0) {
            return null;
        }
        if (((String)scopePathVector.firstElement()).equalsIgnoreCase(Scope.ROOT_SCOPE_NAME)) {
            if (scopePathVector.size() < 2) {
                return null;
            }
            String relativePath = (String)scopePathVector.elementAt(1);
            int i = 2;
            while (i < scopePathVector.size()) {
                relativePath = String.valueOf(relativePath) + "." + (String)scopePathVector.elementAt(i);
                ++i;
            }
            return this.findSubScopeByName(this.getRootScope(), relativePath);
        }
        if (scopePathVector.size() > 1) {
            Vector baseScopePathVector = ScopePath.parsePath(baseScope.getFullName());
            int i = 0;
            Scope currentLoopScope = baseScope;
            do {
                currentLoopScope = this.findSubScopeByName(currentLoopScope, (String)scopePathVector.elementAt(i));
            } while (++i < scopePathVector.size() && currentLoopScope != null);
            if (currentLoopScope != null) {
                return currentLoopScope;
            }
            int shiftPos = baseScopePathVector.lastIndexOf(scopePathVector.elementAt(0));
            boolean matches = true;
            if (shiftPos < baseScopePathVector.size() - 1) {
                while (i < baseScopePathVector.size() - shiftPos) {
                    if (!baseScopePathVector.elementAt(shiftPos + i).equals(scopePathVector.elementAt(i))) {
                        matches = false;
                    }
                    ++i;
                }
            }
            if (!matches) {
                return null;
            }
            String mergedPath = baseScope.getFullName();
            int j = baseScopePathVector.size() - shiftPos;
            while (j < scopePathVector.size()) {
                mergedPath = String.valueOf(mergedPath) + "." + (String)scopePathVector.elementAt(j);
                ++j;
            }
            return this.findScopeByName(mergedPath);
        }
        return this.findSubScopeByName(this.getCurrentScope(), (String)scopePathVector.elementAt(0));
    }

    private Scope findSubScopeByName(Scope baseScope, String relativeScopePath) {
        Vector scopePathVector = ScopePath.parsePath(relativeScopePath);
        if (scopePathVector.size() == 0) {
            return null;
        }
        Scope currentLoopScope = baseScope;
        int i = 0;
        while (i < scopePathVector.size()) {
            if ((currentLoopScope = currentLoopScope.getSubScope((String)scopePathVector.elementAt(i))) == null) {
                return null;
            }
            ++i;
        }
        return currentLoopScope;
    }
}

