/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.delphi.symbols;

import java.util.StringTokenizer;
import java.util.Vector;

public class ScopePath {
    private Vector path = null;
    public static String DELIM = ".";

    public ScopePath(String pathString) {
        this.path = ScopePath.parsePath(pathString);
    }

    public ScopePath(ScopePath otherPath) {
        this.setPath(otherPath.getPath());
    }

    public ScopePath(Vector pathVector) {
        this.path = pathVector;
    }

    public static Vector parsePath(String pathString) {
        Vector<String> pathVector = new Vector<String>();
        StringTokenizer st = new StringTokenizer(pathString, DELIM);
        while (st.hasMoreTokens()) {
            pathVector.addElement(st.nextToken());
        }
        return pathVector;
    }

    public String toString() {
        StringBuffer temp = new StringBuffer();
        int i = 0;
        while (this.path != null && i < this.path.size()) {
            temp.append(this.path.elementAt(i));
            if (++i >= this.path.size()) continue;
            temp.append(".");
        }
        return temp.toString();
    }

    public Vector getPath() {
        return this.path;
    }

    private void setPath(Vector vector) {
        this.path = vector;
    }

    public int compareTo(ScopePath otherPath) {
        Vector thisPathVector = this.getPath();
        Vector otherPathVector = otherPath.getPath();
        if (otherPathVector.size() < thisPathVector.size()) {
            return 1;
        }
        if (thisPathVector.size() < otherPathVector.size()) {
            return -1;
        }
        int i = 0;
        while (i < this.path.size()) {
            if (!((String)thisPathVector.elementAt(i)).equalsIgnoreCase((String)otherPathVector.elementAt(i))) {
                return i + 2;
            }
            ++i;
        }
        return 0;
    }

    public boolean isPartOf(ScopePath otherPath) {
        Vector thisPathVector = this.getPath();
        Vector otherPathVector = otherPath.getPath();
        if (otherPathVector.size() < thisPathVector.size()) {
            return false;
        }
        int i = 0;
        while (i < this.path.size()) {
            if (!((String)thisPathVector.elementAt(i)).equalsIgnoreCase((String)otherPathVector.elementAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void main(String[] argv) {
        ScopePath.test();
        System.out.println("done");
    }

    private static void test() {
        ScopePath sp1 = new ScopePath("root.test5");
        ScopePath sp2 = new ScopePath("root.test5.TForm");
        assert (sp1.isPartOf(sp2));
        assert (!sp2.isPartOf(sp1));
        assert (sp1.compareTo(sp2) == -1) : sp1.compareTo(sp2);
        assert (sp2.compareTo(sp1) == 1) : sp2.compareTo(sp1);
        sp1 = new ScopePath("root.test5.TForm");
        sp2 = new ScopePath("root.test5");
        assert (sp2.isPartOf(sp1));
        assert (!sp1.isPartOf(sp2));
        assert (sp2.compareTo(sp1) == -1) : sp2.compareTo(sp1);
        assert (sp1.compareTo(sp2) == 1) : sp1.compareTo(sp2);
        sp1 = new ScopePath("root.test5.TForm");
        sp2 = new ScopePath("root.test5.TForm1");
        assert (!sp1.isPartOf(sp2));
        assert (!sp2.isPartOf(sp1));
        assert (sp1.compareTo(sp2) > 1) : sp1.compareTo(sp2);
        assert (sp2.compareTo(sp1) > 1) : sp2.compareTo(sp1);
        sp1 = new ScopePath("root.test5.TForm");
        sp2 = new ScopePath("root.test5.TForm");
        assert (sp1.isPartOf(sp2));
        assert (sp2.isPartOf(sp1));
        assert (sp1.compareTo(sp2) == 0) : sp1.compareTo(sp2);
        assert (sp2.compareTo(sp1) == 0) : sp2.compareTo(sp1);
    }
}

